/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0001}4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0005O!)\u0001\u0007\u0001C\u0001c!)!\t\u0001C\u0001c!)A\t\u0001C\u0001c!)a\t\u0001C\u0001c!)\u0001\n\u0001C\u0001c!)!\n\u0001C\u0001c!)A\n\u0001C\u0001c!)a\n\u0001C\u0001c!)\u0001\u000b\u0001C\u0001c!)!\u000b\u0001C\u0001c!)A\u000b\u0001C\u0001c!)a\u000b\u0001C\u0001c!)\u0001\f\u0001C\u0001c\u0019!!\f\u0001\u0001\\\u0011!)\u0007C!A!\u0002\u00131\u0007\"\u0002\u0012\u0011\t\u0003\t\b\"B;\u0001\t\u0003\t\u0004\"B<\u0001\t\u0003\t$aD*u_J\fw-\u001a+p_2$Vm\u001d;\u000b\u0005]A\u0012!\u0002;p_2\u001c(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012\u0001\u00078foN+GNZ'b]\u0006<W\r\u001a)s_B,'\u000f^5fgR\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!Q\u000f^5m\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u000euKN$8i\u001c8gS\u001e$v\u000eT8h\t&\u0014Xm\u0019;pe&,7\u000fF\u00013!\ti2'\u0003\u00025=\t!QK\\5uQ\t\u0019a\u0007\u0005\u00028\u00016\t\u0001H\u0003\u0002:u\u0005\u0019\u0011\r]5\u000b\u0005mb\u0014a\u00026va&$XM\u001d\u0006\u0003{y\nQA[;oSRT\u0011aP\u0001\u0004_J<\u0017BA!9\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f^\"p]\u001aLw\rV8M_\u001e$\u0015N]3di>\u0014\u0018.Z:XSRDW*\u001a;b\u0019><G)\u001b:)\u0005\u00111\u0014a\b;fgRLeNZ8D_6l\u0017M\u001c3P]\u0016k\u0007\u000f^=ESJ,7\r^8ss\"\u0012QAN\u0001\"i\u0016\u001cH/\u00138g_\u000e{W.\\1oI>sW*[:tS:<G)\u001b:fGR|'/\u001f\u0015\u0003\rY\n\u0001\u0005^3ti&sgm\\\"p[6\fg\u000eZ(o\t&\u0014Xm\u0019;pef\f5OR5mK\"\u0012qAN\u0001(i\u0016\u001cH/\u00138g_^KG\u000f['jg6\fGo\u00195fI2+w-Y2z\u0017\u000647.Y\"p]\u001aLw\r\u000b\u0002\tm\u0005aC/Z:u\u0013:4wnV5uQ6K7/\\1uG\",GmU3mM6\u000bg.Y4fI.\u000bgm[1D_:4\u0017n\u001a\u0015\u0003\u0013Y\n\u0001\u0004^3ti\u001a{'/\\1u\u000b6\u0004H/\u001f#je\u0016\u001cGo\u001c:zQ\tQa'\u0001\u0010uKN$hi\u001c:nCR<\u0016\u000e\u001e5J]Z\fG.\u001b3DYV\u001cH/\u001a:JI\"\u00121BN\u0001\u001bi\u0016\u001cH\u000fR3gCVdG/T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003\u0019Y\nQ\u0004^3ti\u000e{gNZ5hkJ,G-T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003\u001bY\n\u0001\u0004^3ti6+G/\u00193bi\u00064VM]:j_:4E.Y4tQ\tqa'\u0001\u0007uKN$\u0018\t\u001a3TGJ\fW\u000e\u000b\u0002\u0010m\tA2\u000b^8sC\u001e,Gk\\8m)\u0016\u001cH/\u0012=dKB$\u0018n\u001c8\u0014\u0005Aa\u0006CA/d\u001b\u0005q&BA0a\u0003\u0019\u0019w.\\7p]*\u0011\u0011$\u0019\u0006\u0003Ez\na!\u00199bG\",\u0017B\u00013_\u00059Y\u0015MZ6b\u000bb\u001cW\r\u001d;j_:\fq!\\3tg\u0006<W\r\u0005\u0002h]:\u0011\u0001\u000e\u001c\t\u0003Szi\u0011A\u001b\u0006\u0003Wj\ta\u0001\u0010:p_Rt\u0014BA7\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055tBC\u0001:u!\t\u0019\b#D\u0001\u0001\u0011\u0015)'\u00031\u0001g\u0003}!Xm\u001d;TGJ\fWnV5uQ\n\u000bG-T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003'Y\na\u0004^3ti:{7k\u0019:b[^KG\u000f['fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0005Q1\u0004\u0006\u0002\u0001{{z\u0004\"aN>\n\u0005qD$a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002Q\u0001")
public class StorageToolTest {
    /*
     * WARNING - void declaration
     */
    private Properties newSelfManagedProperties() {
        void var1_1;
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo,/tmp/bar");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        return var1_1;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils$.MODULE$.tempFile();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(235).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            MetaProperties metaProperties = new MetaProperties("XcZZOzUqS4yHOjhMQB6JLQ", 2);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latest(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latest(), false));
            Assertions.assertTrue((boolean)stream.toString().startsWith(new StringOps(Predef$.MODULE$.augmentString("Formatting %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempDir}))));
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latest(), false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(107).append("Log directory ").append(tempDir).append(" is already ").append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latest(), true));
            Assertions.assertEquals((Object)new StringOps(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n")).format((Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }

    @Test
    public void testDefaultMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
        Assertions.assertEquals((short)MetadataVersion.latest().featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be the latest version");
    }

    @Test
    public void testConfiguredMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)new Some((Object)MetadataVersion.IBP_3_3_IV2.toString()));
        Assertions.assertEquals((short)MetadataVersion.IBP_3_3_IV2.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be 3.3-IV2");
    }

    @Test
    public void testMetadataVersionFlags() {
        MetadataVersion mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0"}));
        Assertions.assertEquals((Object)"3.0", (Object)mv.shortVersion());
        mv = StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0-IV1"}));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)mv);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageToolTest.parseMetadataVersion$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "0.0"})));
    }

    @Test
    public void testAddScram() {
        Option scramRecords = StorageToolTest.parseAddScram$1((Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)scramRecords);
        scramRecords = StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]", "-S", "SCRAM-SHA-256=[name=george,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"}));
        Assertions.assertEquals((int)2, (int)((SeqLike)scramRecords.get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'name' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must only supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'salt' with 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice,iterations=4096]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16385]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be <= 16384 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16384]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4095]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be >= 4096 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4096]"})).get()).size());
        Assertions.assertEquals((int)1, (int)((SeqLike)StorageToolTest.parseAddScram$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice]"})).get()).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testScramWithBadMetadataVersion() {
        void setExitProcedure_exitProcedure;
        ObjectRef exitString = ObjectRef.create((Object)"");
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitStatus, message) -> this.exitProcedure$1(BoxesRunTime.unboxToInt((Object)exitStatus), message, exitString);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4", "-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=8192]"});
        try {
            try {
                Integer n = BoxesRunTime.boxToInteger((int)1);
                StorageTool$.MODULE$.main(args);
                Assertions.assertEquals((Object)n, (Object)BoxedUnit.UNIT);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"SCRAM is only supported in metadataVersion IBP_3_5_IV2 or later.", (Object)((String)exitString.elem));
            }
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoScramWithMetadataVersion() {
        void setExitProcedure_exitProcedure;
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, message) -> this.exitProcedure$2(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), TestUtils$.MODULE$.tempDir().toString());
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4"});
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
                Assertions.assertEquals((int)0, (int)exitStatus.elem);
            }
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private static final MetadataVersion parseMetadataVersion$1(Seq strings) {
        scala.collection.mutable.Seq args = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (scala.collection.mutable.Seq)args.$plus$plus((GenTraversableOnce)strings, Seq$.MODULE$.canBuildFrom());
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getMetadataVersion(namespace, (Option)None$.MODULE$);
    }

    private static final Option parseAddScram$1(Seq strings) {
        scala.collection.mutable.Seq args = (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (scala.collection.mutable.Seq)args.$plus$plus((GenTraversableOnce)strings, Seq$.MODULE$.canBuildFrom());
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getUserScramCredentialRecords(namespace);
    }

    private final Nothing$ exitProcedure$1(int exitStatus, Option message, ObjectRef exitString$1) {
        exitString$1.elem = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$1.elem);
    }

    private final Nothing$ exitProcedure$2(int status, Option message, IntRef exitStatus$1, ObjectRef exitString$2) {
        exitStatus$1.elem = status;
        exitString$2.elem = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$2.elem);
    }

    public class StorageToolTestException
    extends KafkaException {
        public /* synthetic */ StorageToolTest kafka$tools$StorageToolTest$StorageToolTestException$$$outer() {
            return StorageToolTest.this;
        }

        public StorageToolTestException(String message) {
            if (StorageToolTest.this == null) {
                throw null;
            }
            super(message);
        }
    }
}

