/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.MockTime;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\u0005\u0001C\u0001-\tiA\u000b\u001b:piRdWM\u001d+fgRT!AB\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0003!\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0017A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"A\u0003\u0002/Q,7\u000f\u001e+ie>$H\u000f\\3EKNL'/\u001a3SCR,G#A\f\u0011\u00051A\u0012BA\r\u000e\u0005\u0011)f.\u001b;)\u0005\tY\u0002C\u0001\u000f&\u001b\u0005i\"B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0003A\u0005\nqA[;qSR,'O\u0003\u0002#G\u0005)!.\u001e8ji*\tA%A\u0002pe\u001eL!AJ\u000f\u0003\tQ+7\u000f^\u0001\u001ei\u0016\u001cH/\u00169eCR,G\u000b\u001b:piRdW\rR3tSJ,GMU1uK\"\u00121a\u0007")
public class ThrottlerTest {
    @Test
    public void testThrottleDesiredRate() {
        int throttleCheckIntervalMs = 100;
        double desiredCountPerSec = 1000.0;
        double desiredCountPerInterval = desiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        MockTime mockTime = new MockTime();
        long x$2 = throttleCheckIntervalMs;
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        Throttler throttler = new Throttler(desiredCountPerSec, x$2, x$4, x$5, x$6, (Time)mockTime);
        long t1 = mockTime.milliseconds();
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t1, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t2 = mockTime.milliseconds();
        Assertions.assertTrue((t2 >= t1 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t2, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t3 = mockTime.milliseconds();
        Assertions.assertTrue((t3 >= t2 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        long elapsedTimeMs = t3 - t1;
        Assertions.assertTrue(((double)4 * desiredCountPerInterval * (double)1000 / (double)elapsedTimeMs <= desiredCountPerSec ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateThrottleDesiredRate() {
        int throttleCheckIntervalMs = 100;
        double desiredCountPerSec = 1000.0;
        double desiredCountPerInterval = desiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        double updatedDesiredCountPerSec = 1500.0;
        double updatedDesiredCountPerInterval = updatedDesiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        MockTime mockTime = new MockTime();
        long x$2 = throttleCheckIntervalMs;
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        Throttler throttler = new Throttler(desiredCountPerSec, x$2, x$4, x$5, x$6, (Time)mockTime);
        long t1 = mockTime.milliseconds();
        throttler.maybeThrottle(desiredCountPerInterval);
        Assertions.assertEquals((long)t1, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1);
        throttler.maybeThrottle(desiredCountPerInterval);
        long t2 = mockTime.milliseconds();
        Assertions.assertTrue((t2 >= t1 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        long elapsedTimeMs = t2 - t1;
        Assertions.assertTrue(((double)2 * desiredCountPerInterval * (double)1000 / (double)elapsedTimeMs <= desiredCountPerSec ? 1 : 0) != 0);
        throttler.updateDesiredRatePerSec(updatedDesiredCountPerSec);
        throttler.maybeThrottle(updatedDesiredCountPerInterval);
        Assertions.assertEquals((long)t2, (long)mockTime.milliseconds());
        mockTime.sleep(throttleCheckIntervalMs + 1);
        throttler.maybeThrottle(updatedDesiredCountPerInterval);
        long t3 = mockTime.milliseconds();
        Assertions.assertTrue((t3 >= t2 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        long updatedElapsedTimeMs = t3 - t2;
        Assertions.assertTrue(((double)2 * updatedDesiredCountPerInterval * (double)1000 / (double)updatedElapsedTimeMs <= updatedDesiredCountPerSec ? 1 : 0) != 0);
    }
}

