/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.server.QuorumTestHarness$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsRequest$;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclRequest$;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclRequest$;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019\t\u0007\u0001)A\u0005)\"I!\r\u0001a\u0001\u0002\u0004%Ia\u0019\u0005\nO\u0002\u0001\r\u00111A\u0005\n!D\u0011\"\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u00023\t\u000bI\u0004A\u0011I:\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0003\u0001\u0005\u0002\u0005-\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003\u0007\u0002A\u0011AA\u0006\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0017Aq!a\u0013\u0001\t\u0003\tY\u0001C\u0004\u0002P\u0001!\t!a\u0003\t\u000f\u0005M\u0003\u0001\"\u0001\u0002\f!9\u0011q\u000b\u0001\u0005\u0002\u0005-\u0001bBA.\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003?\u0002A\u0011AA\u0006\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003\u0017Aq!a\u001a\u0001\t\u0003\tY\u0001C\u0004\u0002l\u0001!\t!a\u0003\t\u000f\u0005=\u0004\u0001\"\u0001\u0002\f!9\u00111\u000f\u0001\u0005\u0002\u0005-\u0001bBA<\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003w\u0002A\u0011AA\u0006\u0011\u001d\ty\b\u0001C\u0001\u0003\u0017Aq!a!\u0001\t\u0003\tY\u0001C\u0004\u0002\b\u0002!\t!a\u0003\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\f!9\u0011q\u0012\u0001\u0005\u0002\u0005-\u0001bBAJ\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003/\u0003A\u0011AA\u0006\u0011\u001d\tY\n\u0001C\u0001\u0003\u0017Aq!a(\u0001\t\u0003\tY\u0001C\u0004\u0002$\u0002!\t!a\u0003\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002\f!9\u00111\u0016\u0001\u0005\u0002\u0005-\u0001bBAX\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003g\u0003A\u0011AA\u0006\u0011\u001d\t9\f\u0001C\u0001\u0003\u0017Aq!a/\u0001\t\u0003\tY\u0001C\u0004\u0002@\u0002!\t!!1\t\u000f\u0005%\b\u0001\"\u0001\u0002\f!9\u0011Q\u001e\u0001\u0005\u0002\u0005-\u0001bBAy\u0001\u0011%\u00111\u001f\u0005\n\u00053\u0001\u0011\u0013!C\u0005\u00057A\u0011B!\r\u0001#\u0003%IAa\r\t\u0013\t]\u0002!%A\u0005\n\tM\u0002\"\u0003B\u001d\u0001E\u0005I\u0011\u0002B\u001e\u0011\u001d\u0011y\u0004\u0001C\u0005\u0003\u0017AqA!\u0011\u0001\t\u0013\u0011\u0019EA\n[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u00029s\u0005I!p\\8lK\u0016\u0004XM\u001d\u0006\u0002u\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001\u0015(\u0001\u0004tKJ4XM]\u0005\u0003\u0005~\u0012\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tQ\t\u0005\u0002G\u00015\tq'\u0001\u0005n_\u000e\\\u0007+\u0019;i+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0011a\u0017M\\4\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u00135|7m\u001b)bi\"\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u0016\t\u0003+~k\u0011A\u0016\u0006\u0003/b\u000bQ!\u001e;jYNT!!\u0017.\u0002\r\r|W.\\8o\u0015\tQ4L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011W\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fi|wnS3fa\u0016\u00148\t\\5f]R,\u0012\u0001\u001a\t\u0003\r\u0016L!AZ\u001c\u0003\u001fi{wnS3fa\u0016\u00148\t\\5f]R\f1C_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e^0%KF$\"![8\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\tUs\u0017\u000e\u001e\u0005\ba\u001e\t\t\u00111\u0001e\u0003\rAH%M\u0001\u0011u>|7*Z3qKJ\u001cE.[3oi\u0002\nQa]3u+B$\"!\u001b;\t\u000bUL\u0001\u0019\u0001<\u0002\u0011Q,7\u000f^%oM>\u0004\"a\u001e@\u000e\u0003aT!!\u001f>\u0002\u0007\u0005\u0004\u0018N\u0003\u0002|y\u00069!.\u001e9ji\u0016\u0014(BA?^\u0003\u0015QWO\\5u\u0013\ty\bP\u0001\u0005UKN$\u0018J\u001c4pQ\rI\u00111\u0001\t\u0004o\u0006\u0015\u0011bAA\u0004q\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u001b\u0015\u0004\u0015\u0005=\u0001cA<\u0002\u0012%\u0019\u00111\u0003=\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\b;fgR,fN]3t_24\u0018M\u00197f\u0007>tg.Z2u'R\u0014\u0018N\\4)\u0007-\tI\u0002E\u0002x\u00037I1!!\by\u0005\u0011!Vm\u001d;\u0002)I,hN\\5oOj[7+\u001a8e)\"\u0014X-\u00193t+\t\t\u0019\u0003\u0005\u0004\u0002&\u0005-\u0012qF\u0007\u0003\u0003OQ1!!\u000bl\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\t9CA\u0002TKR\u0004B!!\r\u0002@9!\u00111GA\u001e!\r\t)d[\u0007\u0003\u0003oQ1!!\u000f<\u0003\u0019a$o\\8u}%\u0019\u0011QH6\u0002\rA\u0013X\rZ3g\u0013\r\u0001\u0016\u0011\t\u0006\u0004\u0003{Y\u0017!\u0006;fgR\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004\u001b\u0005e\u0011A\u0004;fgR\u001cuN\u001c8fGRLwN\u001c\u0015\u0004\u001d\u0005e\u0011\u0001\b;fgR\u001cuN\u001c8fGRLwN\u001c,jC:+G\u000f^=DY&,g\u000e\u001e\u0015\u0004\u001f\u0005e\u0011A\u0007;fgR$U\r\\3uK:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007f\u0001\t\u0002\u001a\u00059B/Z:u\t\u0016dW\r^3Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0004#\u0005e\u0011A\u0007;fgR,\u00050[:ug:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007f\u0001\n\u0002\u001a\u00059B/Z:u\u000bbL7\u000f^:Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0004'\u0005e\u0011a\u0007;fgR<U\r\u001e#bi\u0006tuN\\#ySN$XM\u001c;[\u001d>$W\rK\u0002\u0015\u00033\t\u0001\u0004^3ti\u001e+G\u000fR1uC\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\r)\u0012\u0011D\u0001\u001ci\u0016\u001cHoU3u\t\u0006$\u0018MT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0007Y\tI\"\u0001\ruKN$8+\u001a;ECR\fW\t_5ti&twM\u0017(pI\u0016D3aFA\r\u0003i!Xm\u001d;HKR\f5\r\u001c(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\rA\u0012\u0011D\u0001\u0018i\u0016\u001cHoR3u\u0003\u000edW\t_5ti&twM\u0017(pI\u0016D3!GA\r\u0003i!Xm\u001d;TKR\f5\r\u001c(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\rQ\u0012\u0011D\u0001 i\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007fA\u000e\u0002\u001a\u0005aB/Z:u\u000f\u0016$8\t[5mIJ,g.\u0012=jgRLgn\u001a.O_\u0012,\u0007f\u0001\u000f\u0002\u001a\u0005AC/Z:u\u000f\u0016$8\t[5mIJ,g.\u0012=jgRLgn\u001a.O_\u0012,w+\u001b;i\u0007\"LG\u000e\u001a:f]\"\u001aQ$!\u0007\u0002)Q,7\u000f\u001e)ja\u0016d\u0017N\\3e\u000f\u0016$H)\u0019;bQ\rq\u0012\u0011D\u0001\u0012i\u0016\u001cH/T5yK\u0012\u0004\u0016\u000e]3mS:,\u0007fA\u0010\u0002\u001a\u0005\tC/Z:u5:{G-Z\"iC:<W\rS1oI2,'OR8s\u0007J,\u0017\r^5p]\"\u001a\u0001%!\u0007\u0002CQ,7\u000f\u001e.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ4uN\u001d#fY\u0016$\u0018n\u001c8)\u0007\u0005\nI\"A\u0012uKN$(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u0014H)\u0019;b\u0007\"\fgnZ3)\u0007\t\nI\"\u0001\u001auKN$(\t\\8dW>s'+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8Ge>l7\u000b^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sQ\r\u0019\u0013\u0011D\u0001)i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8J]\n+gm\u001c:f\u0013:LG/[1mSjLgnZ*fgNLwN\u001c\u0015\u0004I\u0005e\u0011!\u000b;fgRTfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'OR8s\u0007\"LG\u000eZ\"iC:<W\rK\u0002&\u00033\tQ\u0007^3tijsu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:DQ&dGm\u00115b]\u001e,gj\u001c;Ue&<w-\u001a:fI\"\u001aa%!\u0007\u0002IQ,7\u000f^*uCR,7\t[1oO\u0016D\u0015M\u001c3mKJ4uN]!vi\"4\u0015-\u001b7ve\u0016D3aJA\r\u0003\u0011\"Xm\u001d;D_:tWm\u0019;j_:dun]:SKF,Xm\u001d;UKJl\u0017N\\1uS>t\u0007f\u0001\u0015\u0002\u001a\u0005\tB/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=)\u0007%\nI\"\u0001\u000fuKN$8+Z:tS>tW\t\u001f9jef$UO]5oO\u000ecwn]3)\u0007)\nI\"\u0001\u0011uKN$(+Z5oSRL\u0017\r\\5{K\u00063G/\u001a:BkRDg)Y5mkJ,\u0007fA\u0016\u0002\u001a\u0005!\u0012n]#ya\u0016\u001cG/\u001a3NKR\u0014\u0018n\u0019(b[\u0016$b!a1\u0002J\u0006\u0015\bc\u00016\u0002F&\u0019\u0011qY6\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u001a\u0017A\u0002\u00055\u0017AC7fiJL7MT1nKB!\u0011qZAq\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017\u0001B2pe\u0016TA!a6\u0002Z\u00069Q.\u001a;sS\u000e\u001c(\u0002BAn\u0003;\fa!_1n[\u0016\u0014(BAAp\u0003\r\u0019w.\\\u0005\u0005\u0003G\f\tN\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016Dq!a:-\u0001\u0004\ty#\u0001\u0003oC6,\u0017a\t;fgRTvn\\&fKB,'o\u0015;bi\u0016\u001c\u0005.\u00198hKJ\u000bG/Z'fiJL7m\u001d\u0015\u0004[\u0005e\u0011a\b;fgRTvn\\&fKB,'oU3tg&|gn\u0015;bi\u0016lU\r\u001e:jG\"\u001aa&!\u0007\u0002%9,wOW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u000b\nI\u0006U\u0018\u0011 B\u0002\u0005\u000fA\u0011\"a>0!\u0003\u0005\r!a\f\u0002!\r|gN\\3di&|gn\u0015;sS:<\u0007\"CA~_A\u0005\t\u0019AA\u007f\u0003M\u0019wN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^'t!\rQ\u0017q`\u0005\u0004\u0005\u0003Y'aA%oi\"I!QA\u0018\u0011\u0002\u0003\u0007\u0011Q`\u0001\f[\u0006D\u0018J\u001c$mS\u001eDG\u000fC\u0005\u0003\n=\u0002\n\u00111\u0001\u0003\f\u0005a1\r\\5f]R\u001cuN\u001c4jOB!!Q\u0002B\u000b\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011AB2mS\u0016tGO\u0003\u000297&!!q\u0003B\b\u00059Q6j\u00117jK:$8i\u001c8gS\u001e\fAD\\3x5>|7*Z3qKJ\u001cE.[3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001e)\"\u0011q\u0006B\u0010W\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0016W\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=\"Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b8foj{wnS3fa\u0016\u00148\t\\5f]R$C-\u001a4bk2$HEM\u000b\u0003\u0005kQC!!@\u0003 \u0005ab.Z<[_>\\U-\u001a9fe\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\b8foj{wnS3fa\u0016\u00148\t\\5f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005{QCAa\u0003\u0003 \u0005!2\r\\3b]6+GO]5dgJ+w-[:uef\fQAY=uKN,\"A!\u0012\u0011\u000b)\u00149Ea\u0013\n\u0007\t%3NA\u0003BeJ\f\u0017\u0010E\u0002k\u0005\u001bJ1Aa\u0014l\u0005\u0011\u0011\u0015\u0010^3")
public class ZooKeeperClientTest
extends QuorumTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeEach");
        this.cleanMetricsRegistry();
        super.setUp(testInfo);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.newZooKeeperClient$default$1(), this.newZooKeeperClient$default$2(), this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterEach");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            this.newZooKeeperClient("some.invalid.hostname.foo.bar.local", 10, this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4());
            return;
        }
        catch (ZooKeeperClientTimeoutException zooKeeperClientTimeoutException) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.runningZkSendThreads(), (String)"ZooKeeper client threads still running");
            return;
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((TraversableLike)((SetLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAlive()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        Assertions.assertThrows(ZooKeeperClientTimeoutException.class, () -> {
            int x$1 = 10;
            String x$2 = this.newZooKeeperClient$default$1();
            int x$3 = this.newZooKeeperClient$default$3();
            ZKClientConfig x$4 = this.newZooKeeperClient$default$4();
            this.newZooKeeperClient(x$2, x$1, x$3, x$4).close();
        });
    }

    @Test
    public void testConnection() {
        try (ZooKeeperClient client = this.newZooKeeperClient(this.newZooKeeperClient$default$1(), this.newZooKeeperClient$default$2(), this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4());){
            scala.collection.mutable.Set threads = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Set$.MODULE$.canBuildFrom());
            Assertions.assertTrue((boolean)threads.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix()))), (String)new StringBuilder(48).append("ZooKeeperClient event thread not found, threads=").append(threads).toString());
        }
    }

    @Test
    public void testConnectionViaNettyClient() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String propKey = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        String propVal = "org.apache.zookeeper.ClientCnxnSocketNetty";
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, propKey, (Object)propVal);
        String x$2 = this.newZooKeeperClient$default$1();
        int x$3 = this.newZooKeeperClient$default$2();
        int x$4 = this.newZooKeeperClient$default$3();
        try (ZooKeeperClient client = this.newZooKeeperClient(x$2, x$3, x$4, clientConfig);){
            Assertions.assertEquals((Object)new Some((Object)propVal), (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(client.clientConfig(), propKey));
            ZKClientConfig badClientConfig = new ZKClientConfig();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(badClientConfig, propKey, (Object)new StringBuilder(12).append(propVal).append("BadClassName").toString());
            Assertions.assertThrows(Exception.class, () -> {
                String x$6 = this.newZooKeeperClient$default$1();
                int x$7 = this.newZooKeeperClient$default$2();
                int x$8 = this.newZooKeeperClient$default$3();
                this.newZooKeeperClient(x$6, x$7, x$8, badClientConfig);
            });
        }
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode(), (String)"Response code should be NONODE");
        Assertions.assertThrows(KeeperException.NoNodeException.class, () -> deleteResponse.maybeThrow());
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)existsResponse.resultCode(), (String)"Response code for exists should be OK");
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match created znode data");
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match setData's data");
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode(), (String)"Response code for getAcl should be OK");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl(), (String)new StringBuilder(14).append("ACL should be ").append(CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, SetAclRequest$.MODULE$.apply$default$4()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)getChildrenResponse.children(), (String)"getChildren should return no children");
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode(), (String)"Response code for create child2 should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)new .colon.colon((Object)child1, (List)new .colon.colon((Object)child2, (List)Nil$.MODULE$)), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$), (String)"getChildren should return two children");
    }

    @Test
    public void testPipelinedGetData() {
        ((IndexedSeq)((IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).map(arg_0 -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$2(this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient(), arg_0), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        IndexedSeq getDataRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)getDataResponses.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2());
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)getDataRequest, (List)new .colon.colon((Object)setDataRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data(), (String)"Data for getData should be empty");
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for setData should be NONODE");
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)existsRequest, (List)new .colon.colon((Object)createRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be NONODE");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive create notification");
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive delete notification");
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive data change notification");
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.newZooKeeperClient$default$1(), this.newZooKeeperClient$default$2(), this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4()));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                try {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread reinitializeThread = new Thread(this){
            private final /* synthetic */ ZooKeeperClientTest $outer;

            public void run() {
                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        AtomicInteger goodCalls = new AtomicInteger(0);
        StateChangeHandler goodHandler = new StateChangeHandler(null, goodCalls){
            private final String name;
            private final AtomicInteger goodCalls$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.goodCalls$1.incrementAndGet();
            }
            {
                this.goodCalls$1 = goodCalls$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.newZooKeeperClient$default$1(), this.newZooKeeperClient$default$2(), this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4()));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(faultyHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(goodHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
        Assertions.assertEquals((int)1, (int)goodCalls.get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                ZNodeChildChangeHandler.$init$((ZNodeChildChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, GetChildrenRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertTrue((boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive child change notification");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChangeNotTriggered() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$2;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$2 = zNodeChildChangeHandlerCountDownLatch$2;
                ZNodeChildChangeHandler.$init$((ZNodeChildChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), false, GetChildrenRequest$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertFalse((boolean)zNodeChildChangeHandlerCountDownLatch.await(100L, TimeUnit.MILLISECONDS), (String)"Child change notification received");
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = this.newZooKeeperClient(this.newZooKeeperClient$default$1(), this.newZooKeeperClient$default$2(), this.newZooKeeperClient$default$3(), this.newZooKeeperClient$default$4());){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assertions.assertTrue((boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive auth failed notification");
        }
    }

    @Test
    public void testConnectionLossRequestTermination() {
        int batchSize = 10;
        int x$1 = 2;
        String x$2 = this.newZooKeeperClient$default$1();
        int x$3 = this.newZooKeeperClient$default$2();
        ZKClientConfig x$4 = this.newZooKeeperClient$default$4();
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = this.newZooKeeperClient(x$2, x$3, x$1, x$4);){
            IndexedSeq requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), batchSize).map((Function1 & Serializable & scala.Serializable)i -> ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, running, zooKeeperClient, requests, unexpectedResponses, countDownLatch){
                private final AtomicBoolean running$1;
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final ArrayBlockingQueue unexpectedResponses$1;
                private final CountDownLatch countDownLatch$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$12 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.running$1 = running$1;
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                    this.countDownLatch$1 = countDownLatch$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$12 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            if (!countDownLatch.await(30L, TimeUnit.SECONDS)) {
                running.set(false);
                requestThread.join(5000L);
                Assertions.fail((String)"Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.");
            } else if (!unexpectedResponses.isEmpty()) {
                Assertions.fail((String)new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString());
            }
        }
    }

    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendCompleteSemaphore, sendSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendCompleteSemaphore$1;
            public final Semaphore sendSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable & scala.Serializable)response -> {
                    $this.responseExecutor$1.submit(new Runnable(this, (Function1)processResponse, (AsyncResponse)response){
                        private final /* synthetic */ $anon$13 $outer;
                        private final Function1 processResponse$1;
                        private final AsyncResponse response$1;

                        public void run() {
                            this.$outer.sendCompleteSemaphore$1.release();
                            this.$outer.sendSemaphore$1.acquire();
                            this.processResponse$1.apply((Object)this.response$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.processResponse$1 = processResponse$1;
                            this.response$1 = response$1;
                        }
                    });
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$13 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new /* invalid duplicate definition of identical inner class */);
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName", new ZKClientConfig(), "ZooKeeperClientTest");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$13 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, stateChanges, sendSemaphore, sendSize, zooKeeperClient){
                private final String name;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assertions.assertTrue((boolean)threadName.startsWith(this.zooKeeperClient$2.reinitializeScheduler().threadNamePrefix()), (String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString());
                }
                {
                    this.stateChanges$1 = stateChanges$1;
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    StateChangeHandler.$init$((StateChangeHandler)this);
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void run() {
                    IndexedSeq requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.sendSize$1).map((Function1 & Serializable & scala.Serializable)i -> $anon$16.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.resultCode(), Seq$.MODULE$.canBuildFrom());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2());
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4$adapted(java.lang.Object ), $anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                Assertions.fail((String)"Request thread did not complete");
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)"beforeInitializingSession", (List)new .colon.colon((Object)"afterInitializingSession", (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(stateChanges).asScala()).toSeq());
            Assertions.assertEquals((int)((Seq)resultCodes.elem).size(), (int)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$6)));
            Assertions.assertTrue((connectionLostCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString());
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$7)));
            Assertions.assertTrue((expiredCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertTrue((connectionLostCount + expiredCount > 0 ? 1 : 0) != 0, (String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Assertions.assertTrue((boolean)((Seq)resultCodes.elem).forall(arg_0 -> ZooKeeperClientTest.$anonfun$testSessionExpiry$3$adapted((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS})), arg_0)), (String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assertions.assertFalse((boolean)zooKeeperClient.reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().scheduleOnce("test", () -> semaphore.acquireUninterruptibly());
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleReinitialize("session-expired", "Session expired.", 0L);
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assertions.assertFalse((boolean)closeFuture.isDone(), (String)"Close completed without shutting down expiry scheduler gracefully");
            Assertions.assertTrue((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().currentZooKeeper().getState().isAlive());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    @Test
    public void testReinitializeAfterAuthFailure() {
        CountDownLatch sessionInitializedCountDownLatch = new CountDownLatch(1);
        StateChangeHandler changeHandler = new StateChangeHandler(null, sessionInitializedCountDownLatch){
            private final String name;
            private final CountDownLatch sessionInitializedCountDownLatch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.sessionInitializedCountDownLatch$1.countDown();
            }
            {
                this.sessionInitializedCountDownLatch$1 = sessionInitializedCountDownLatch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        VolatileObjectRef connectionStateOverride = VolatileObjectRef.create((Object)None$.MODULE$);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this, connectionStateOverride){
            private final VolatileObjectRef connectionStateOverride$1;

            private /* synthetic */ ZooKeeper.States super$connectionState() {
                return super.connectionState();
            }

            public ZooKeeper.States connectionState() {
                return (ZooKeeper.States)((Option)this.connectionStateOverride$1.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$connectionState());
            }
            {
                this.connectionStateOverride$1 = connectionStateOverride$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), $outer.zkMaxInFlightRequests(), $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", new ZKClientConfig(), "ZooKeeperClientTest");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$connectionState$1(kafka.zookeeper.ZooKeeperClientTest$$anon$19 )}, serializedLambda);
            }
        });
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(changeHandler);
        connectionStateOverride.elem = new Some((Object)ZooKeeper.States.CONNECTED);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
        Assertions.assertFalse((boolean)sessionInitializedCountDownLatch.await(1200L, TimeUnit.MILLISECONDS), (String)"Unexpected session initialization when connection is alive");
        connectionStateOverride.elem = new Some((Object)ZooKeeper.States.AUTH_FAILED);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
        Assertions.assertTrue((boolean)sessionInitializedCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive session initializing notification");
    }

    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(name) : name != null)) {
            String string2 = metricName.getGroup();
            String string3 = "testMetricGroup";
            if (string2 != null && string2.equals(string3)) {
                String string4 = metricName.getType();
                String string5 = "testMetricType";
                if (string4 != null && string4.equals(string5)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assertions.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private ZooKeeperClient newZooKeeperClient(String connectionString, int connectionTimeoutMs, int maxInFlight, ZKClientConfig clientConfig) {
        return new ZooKeeperClient(connectionString, this.zkSessionTimeout(), connectionTimeoutMs, maxInFlight, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", clientConfig, "ZooKeeperClientTest");
    }

    private String newZooKeeperClient$default$1() {
        return this.zkConnect();
    }

    private int newZooKeeperClient$default$2() {
        return this.zkConnectionTimeout();
    }

    private int newZooKeeperClient$default$3() {
        return this.zkMaxInFlightRequests();
    }

    private ZKClientConfig newZooKeeperClient$default$4() {
        return new ZKClientConfig();
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = KafkaYammerMetrics.defaultRegistry();
        metrics.allMetrics().keySet().forEach(x$1 -> metrics.removeMetric(x$1));
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), Integer.toString(x * 2).getBytes(), (Seq)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ CreateResponse $anonfun$testPipelinedGetData$2(ZooKeeperClient eta$0$1$1, CreateRequest request) {
        return (CreateResponse)eta$0$1$1.handleRequest((AsyncRequest)request);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), GetDataRequest$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            GetDataResponse getDataResponse = (GetDataResponse)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
            Assertions.assertEquals((int)((i + 1) * 2), (Integer)Integer.valueOf(new String(getDataResponse.data())), (String)"Data for getData should match");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$6) {
        KeeperException.Code code = x$6;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$7) {
        KeeperException.Code code = x$7;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Meter meter = (Meter)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric meter = (Metric)x1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(31).append("Unable to find meter with name ").append(name).toString()));
        Assertions.assertEquals((long)expected, (long)meter.count(), (String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString());
    }

    private final Option gaugeValue$1(String name) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric gauge = (Metric)x1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }

    public static final /* synthetic */ Object $anonfun$testSessionExpiry$3$adapted(scala.collection.immutable.Set eta$0$1$2, KeeperException.Code elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$2.contains((Object)elem));
    }
}

