/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Optional;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LazyIndex;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001db\u0001B-[\u0001}C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005[\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\u0014\u0001\u0011\t\u0011)A\u0005{\"Q\u0011Q\u0003\u0001\u0003\u0006\u0004%\t!a\u0006\t\u0015\u0005\u0005\u0002A!A!\u0002\u0013\tI\u0002\u0003\u0006\u0002$\u0001\u0011)\u0019!C\u0001\u0003KA!\"!\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\ty\u0003\u0001BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003s\u0001!\u0011!Q\u0001\n\u0005M\u0002BCA\u001e\u0001\t\u0015\r\u0011\"\u0001\u0002>!Q\u0011Q\t\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005\u001d\u0003A!b\u0001\n\u0003\t\t\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003gA!\"a\u0013\u0001\u0005\u000b\u0007I\u0011AA'\u0011)\tI\u0006\u0001B\u0001B\u0003%\u0011q\n\u0005\t\u00037\u0002A\u0011\u0001.\u0002^!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!(\u0001\t\u0003\ty\nC\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u00022!I\u0011q\u0015\u0001A\u0002\u0013%\u0011\u0011\u0016\u0005\t\u0003_\u0003\u0001\u0015)\u0003\u00024!I\u0011\u0011\u0017\u0001A\u0002\u0013%\u0011Q\b\u0005\n\u0003g\u0003\u0001\u0019!C\u0005\u0003kC\u0001\"!/\u0001A\u0003&\u0011q\b\u0005\n\u0003w\u0003\u0001\u0019!C\u0005\u0003{C\u0011\"!2\u0001\u0001\u0004%I!a2\t\u0011\u0005-\u0007\u0001)Q\u0005\u0003\u007fC\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\b\u0002CAs\u0001\u0001\u0006K!!7\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005]\u0007bBAz\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003k\u0004A\u0011AA\u0019\u0011\u001d\tY\n\u0001C\u0001\u0003{Aq!a>\u0001\t\u0003\tI\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003$!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u001e\u0001\u0011\u0005!Q\b\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057B\u0001B!\u001d\u0001\t\u0003Q&1\u000f\u0005\u000b\u0005W\u0003\u0011\u0013!C\u00015\n5\u0006b\u0002Bb\u0001\u0011\u0005!Q\u0019\u0005\n\u0005?\u0004\u0011\u0013!C\u0001\u0005CD\u0011B!:\u0001#\u0003%\tAa:\t\u000f\t-\b\u0001\"\u0001\u0003n\"91Q\u0002\u0001\u0005\u0002\r=\u0001\"CB\u0014\u0001E\u0005I\u0011AB\u0015\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_Aqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u00046\u0001!\taa\u000e\t\u000f\r\u001d\u0003\u0001\"\u0011\u0004J!911\f\u0001\u0005\u0002\ru\u0003bBB2\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0007O\u0002A\u0011AB\u0018\u0011\u001d\u0019Y\u0007\u0001C\u0001\u0007[Bqaa \u0001\t\u0003\u0019\t\tC\u0004\u0004\f\u0002!\ta!$\t\u000f\rM\u0005\u0001\"\u0001\u00040!91Q\u0013\u0001\u0005\n\r=\u0002bBBL\u0001\u0011\u00051\u0011\u0014\u0005\b\u0007G\u0003A\u0011ABS\u0011\u001d\u00199\u000b\u0001C\u0001\u0007SC\u0011ba/\u0001#\u0003%\tA!9\t\u000f\ru\u0006\u0001\"\u0001\u00040!91q\u0018\u0001\u0005\u0002\r=\u0002bBBa\u0001\u0011\u00051q\u0006\u0005\b\u0007\u0007\u0004A\u0011ABc\u0011\u001d\u00199\r\u0001C\u0001\u0003cAqa!3\u0001\t\u0003\ti\fC\u0004\u0003\n\u0001!\t!!\r\t\u000f\r-\u0007\u0001\"\u0001\u0004N\u001e91Q\u001d.\t\u0002\r\u001dhAB-[\u0011\u0003\u0019I\u000fC\u0004\u0002\\A#\taa;\t\u000f\r5\b\u000b\"\u0001\u0004p\"IA\u0011\u0003)\u0012\u0002\u0013\u0005!q\u001d\u0005\n\t'\u0001\u0016\u0013!C\u0001\u0005[C\u0011\u0002\"\u0006Q#\u0003%\tAa:\t\u0013\u0011]\u0001+%A\u0005\u0002\u0011e\u0001bBBa!\u0012\u0005AQ\u0004\u0005\n\tK\u0001\u0016\u0013!C\u0001\t3\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\tYF,A\u0002m_\u001eT\u0011!X\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001M\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0016!B;uS2\u001c\u0018BA6i\u0005\u001daunZ4j]\u001e,\u0012!\u001c\t\u0003]bl\u0011a\u001c\u0006\u0003aF\faA]3d_J$'B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011Q\f\u001e\u0006\u0003kZ\fa!\u00199bG\",'\"A<\u0002\u0007=\u0014x-\u0003\u0002z_\nYa)\u001b7f%\u0016\u001cwN\u001d3t\u0003\u0011awn\u001a\u0011\u0002\u001f1\f'0_(gMN,G/\u00138eKb,\u0012! \t\u0006}\u0006%\u0011QB\u0007\u0002\u007f*\u00191,!\u0001\u000b\t\u0005\r\u0011QA\u0001\nS:$XM\u001d8bYNT1!a\u0002t\u0003\u001d\u0019Ho\u001c:bO\u0016L1!a\u0003\u0000\u0005%a\u0015M_=J]\u0012,\u0007\u0010E\u0002\u007f\u0003\u001fI1!!\u0005\u0000\u0005-yeMZ:fi&sG-\u001a=\u0002!1\f'0_(gMN,G/\u00138eKb\u0004\u0013!\u00047buf$\u0016.\\3J]\u0012,\u00070\u0006\u0002\u0002\u001aA)a0!\u0003\u0002\u001cA\u0019a0!\b\n\u0007\u0005}qPA\u0005US6,\u0017J\u001c3fq\u0006qA.\u0019>z)&lW-\u00138eKb\u0004\u0013\u0001\u0003;y]&sG-\u001a=\u0016\u0005\u0005\u001d\u0002c\u0001@\u0002*%\u0019\u00111F@\u0003!Q\u0013\u0018M\\:bGRLwN\\%oI\u0016D\u0018!\u0003;y]&sG-\u001a=!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0003\u0003g\u00012!YA\u001b\u0013\r\t9D\u0019\u0002\u0005\u0019>tw-A\u0006cCN,wJ\u001a4tKR\u0004\u0013AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN,\"!a\u0010\u0011\u0007\u0005\f\t%C\u0002\u0002D\t\u00141!\u00138u\u0003MIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:!\u00031\u0011x\u000e\u001c7KSR$XM]'t\u00035\u0011x\u000e\u001c7KSR$XM]'tA\u0005!A/[7f+\t\ty\u0005\u0005\u0003\u0002R\u0005USBAA*\u0015\tI\u0017/\u0003\u0003\u0002X\u0005M#\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001P5oSRtDCEA0\u0003G\n)'a\u001a\u0002j\u0005-\u0014QNA8\u0003c\u00022!!\u0019\u0001\u001b\u0005Q\u0006\"B.\u0012\u0001\u0004i\u0007\"B>\u0012\u0001\u0004i\bbBA\u000b#\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003G\t\u0002\u0019AA\u0014\u0011\u001d\ty#\u0005a\u0001\u0003gAq!a\u000f\u0012\u0001\u0004\ty\u0004C\u0004\u0002HE\u0001\r!a\r\t\u000f\u0005-\u0013\u00031\u0001\u0002P\u0005YqN\u001a4tKRLe\u000eZ3y+\t\ti!A\u0005uS6,\u0017J\u001c3fqV\u0011\u00111D\u0001\u000bg\"|W\u000f\u001c3S_2dG\u0003BA@\u0003\u000b\u00032!YAA\u0013\r\t\u0019I\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\t\u0006a\u0001\u0003\u0013\u000b!B]8mYB\u000b'/Y7t!\rq\u00181R\u0005\u0004\u0003\u001b{(A\u0003*pY2\u0004\u0016M]1ng\u0006i!/Z:ju\u0016Le\u000eZ3yKN$B!a%\u0002\u001aB\u0019\u0011-!&\n\u0007\u0005]%M\u0001\u0003V]&$\bbBAN+\u0001\u0007\u0011qH\u0001\u0005g&TX-A\u0006tC:LG/_\"iK\u000e\\G\u0003BAJ\u0003CCq!a)\u0017\u0001\u0004\ty(A\ruS6,\u0017J\u001c3fq\u001aKG.\u001a(fo2L8I]3bi\u0016$\u0017aB2sK\u0006$X\rZ\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0006-\u0006\"CAW1\u0005\u0005\t\u0019AA\u001a\u0003\rAH%M\u0001\tGJ,\u0017\r^3eA\u0005A\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=\u00029\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018p\u0018\u0013fcR!\u00111SA\\\u0011%\tikGA\u0001\u0002\u0004\ty$A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003\u007f\u0003R!YAa\u0003gI1!a1c\u0005\u0019y\u0005\u000f^5p]\u0006I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\t\u0019*!3\t\u0013\u00055f$!AA\u0002\u0005}\u0016A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011)\u0007}\ty\rE\u0002b\u0003#L1!a5c\u0005!1x\u000e\\1uS2,\u0017aG0nCb$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;T_\u001a\u000b'/\u0006\u0002\u0002ZB\u0019a0a7\n\u0007\u0005uwPA\bUS6,7\u000f^1na>3gm]3u\u0003}yV.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003'\u000b\u0019\u000fC\u0005\u0002.\u0006\n\t\u00111\u0001\u0002Z\u0006ar,\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\u0004\u0003f\u0001\u0012\u0002P\u0006qR.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003'\u000bi\u000fC\u0004\u0002p\u000e\u0002\r!!7\u0002\u001fQLW.Z:uC6\u0004xJ\u001a4tKR\f!$\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\f\u0011#\\1y)&lWm\u001d;b[B\u001cvNR1s\u0003eygMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u00025\r\fgnQ8om\u0016\u0014H\u000fV8SK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\t\u0005}\u00141 \u0005\b\u0003{D\u0003\u0019AA\u001a\u0003\u0019ygMZ:fi\u00061\u0011\r\u001d9f]\u0012$\"\"a%\u0003\u0004\t\u001d!1\u0002B\b\u0011\u001d\u0011)!\u000ba\u0001\u0003g\tQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bb\u0002B\u0005S\u0001\u0007\u00111G\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDqA!\u0004*\u0001\u0004\t\u0019$A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\b\u0005#I\u0003\u0019\u0001B\n\u0003\u001d\u0011XmY8sIN\u00042A\u001cB\u000b\u0013\r\u00119b\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u0007%\u0012Y\u0002E\u0002h\u0005;I1Aa\bi\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u00111\u0013B\u0013\u0011\u001d\tiP\u000ba\u0001\u0003g\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"a\u0010\u0003,\t5\"\u0011\u0007\u0005\u0007\u0005#Y\u0003\u0019A7\t\u000f\t=2\u00061\u0001\u0002@\u0005A\u0001o\\:ji&|g\u000eC\u0004\u00034-\u0002\rA!\u000e\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB!\u0011\u0011\u000bB\u001c\u0013\u0011\u0011I$a\u0015\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\u0006q\u0011\r\u001d9f]\u00124%o\\7GS2,GCBA \u0005\u007f\u0011\t\u0005\u0003\u0004\u0003\u00121\u0002\r!\u001c\u0005\b\u0005\u0007b\u0003\u0019AA \u0003\u0015\u0019H/\u0019:u\u00039)\b\u000fZ1uKRCh.\u00138eKb$b!a%\u0003J\tM\u0003b\u0002B&[\u0001\u0007!QJ\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004}\n=\u0013b\u0001B)\u007f\na1i\\7qY\u0016$X\r\u001a+y]\"9!QK\u0017A\u0002\u0005M\u0012\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\ri#1D\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0007\u0003'\u0013iFa\u001a\t\u000f\t}c\u00061\u0001\u0003b\u0005!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042A B2\u0013\r\u0011)g \u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000f\t%d\u00061\u0001\u0003l\u0005)!-\u0019;dQB\u0019aN!\u001c\n\u0007\t=tNA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0017a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\tU$Q\u0014BP!\u0011\u00119Ha&\u000f\t\te$1\u0013\b\u0005\u0005w\u0012\tJ\u0004\u0003\u0003~\t=e\u0002\u0002B@\u0005\u001bsAA!!\u0003\f:!!1\u0011BE\u001b\t\u0011)IC\u0002\u0003\bz\u000ba\u0001\u0010:p_Rt\u0014\"A<\n\u0005U4\u0018BA/u\u0013\t\u00118/\u0003\u0002qc&\u0019!QS8\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u00053\u0013YJA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1A!&p\u0011\u001d\tip\fa\u0001\u0003gA\u0011B!)0!\u0003\u0005\r!a\u0010\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\ry#Q\u0015\t\u0004O\n\u001d\u0016b\u0001BUQ\nQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0005_SC!a\u0010\u00032.\u0012!1\u0017\t\u0005\u0005k\u0013y,\u0004\u0002\u00038*!!\u0011\u0018B^\u0003%)hn\u00195fG.,GMC\u0002\u0003>\n\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tMa.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003sK\u0006$GC\u0003Bd\u0005\u001b\u0014\tN!6\u0003ZB\u0019aP!3\n\u0007\t-wPA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\b\u0005\u001f\f\u0004\u0019AA\u001a\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\tM\u0017\u00071\u0001\u0002@\u00059Q.\u0019=TSj,\u0007\"\u0003BlcA\u0005\t\u0019AA\u001a\u0003-i\u0017\r\u001f)pg&$\u0018n\u001c8\t\u0013\tm\u0017\u0007%AA\u0002\u0005}\u0014!D7j]>sW-T3tg\u0006<W\rK\u00022\u0005K\u000baB]3bI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003d*\"\u00111\u0007BY\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"A!;+\t\u0005}$\u0011W\u0001\u0016M\u0016$8\r[+qa\u0016\u0014(i\\;oI>3gm]3u)\u0019\u0011yOa@\u0004\nA1!\u0011\u001fB~\u0003gi!Aa=\u000b\t\tU(q_\u0001\u0005kRLGN\u0003\u0002\u0003z\u0006!!.\u0019<b\u0013\u0011\u0011iPa=\u0003\u0011=\u0003H/[8oC2Dqa!\u00015\u0001\u0004\u0019\u0019!A\nti\u0006\u0014Ho\u00144gg\u0016$\bk\\:ji&|g\u000eE\u0002\u007f\u0007\u000bI1aa\u0002\u0000\u00059yeMZ:fiB{7/\u001b;j_:Dqaa\u00035\u0001\u0004\ty$A\u0005gKR\u001c\u0007nU5{K\u00069!/Z2pm\u0016\u0014HCBA \u0007#\u0019\u0019\u0002C\u0004\u0003`U\u0002\rA!\u0019\t\u0013\rUQ\u0007%AA\u0002\r]\u0011\u0001\u00057fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f!\u0015\t\u0017\u0011YB\r!\u0011\u0019Yb!\t\u000e\u0005\ru!\u0002BB\u0010\u0003\u0003\tQ!\u001a9pG\"LAaa\t\u0004\u001e\t!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016D3!\u000eB\u000e\u0003E\u0011XmY8wKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007WQCaa\u0006\u00032\u0006!Bn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B$\"!a%\u0002\u0017!\f7o\u0014<fe\u001adwn^\u000b\u0003\u0003\u007f\n!cY8mY\u0016\u001cG/\u00112peR,G\r\u0016=ogR11\u0011HB \u0007\u0007\u00022A`B\u001e\u0013\r\u0019id \u0002\u0015)bt\u0017J\u001c3fqN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\r\u0005\u0013\b1\u0001\u00024\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\u0019)%\u000fa\u0001\u0003g\t\u0001#\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0013\u0011\t\r53Q\u000b\b\u0005\u0007\u001f\u001a\t\u0006E\u0002\u0003\u0004\nL1aa\u0015c\u0003\u0019\u0001&/\u001a3fM&!1qKB-\u0005\u0019\u0019FO]5oO*\u001911\u000b2\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u0002@\r}\u0003bBA\u007fw\u0001\u0007\u00111\u0007\u0015\u0004w\tm\u0011A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0004y\t\u0015\u0016!\u00024mkND\u0007fA\u001f\u0003&\u0006yQ\u000f\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u0006\u0003\u0002\u0014\u000e=\u0004bBB9}\u0001\u000711O\u0001\u0004I&\u0014\b\u0003BB;\u0007wj!aa\u001e\u000b\t\re$q_\u0001\u0003S>LAa! \u0004x\t!a)\u001b7f\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\r\u0005M51QBD\u0011\u001d\u0019)i\u0010a\u0001\u0007\u0017\n\u0011b\u001c7e'V4g-\u001b=\t\u000f\r%u\b1\u0001\u0004L\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\nQ\u0006\u001c8+\u001e4gSb$B!a \u0004\u0010\"91\u0011\u0013!A\u0002\r-\u0013AB:vM\u001aL\u00070A\fp]\n+7m\\7f\u0013:\f7\r^5wKN+w-\\3oi\u00069Bn\\1e\r&\u00148\u000f\u001e\"bi\u000eDG+[7fgR\fW\u000e]\u0001\u0012i&lWmV1ji\u0016$gi\u001c:S_2dGCBA\u001a\u00077\u001by\nC\u0004\u0004\u001e\u000e\u0003\r!a\r\u0002\u00079|w\u000fC\u0004\u0004\"\u000e\u0003\r!a\r\u0002!5,7o]1hKRKW.Z:uC6\u0004\u0018AF4fi\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0015\u0005\u0005M\u0012!\u00064j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u000b\u0007\u0007W\u001b\u0019la.\u0011\u000b\u0005\f\tm!,\u0011\t\t]4qV\u0005\u0005\u0007c\u0013YJ\u0001\nUS6,7\u000f^1na\u0006sGm\u00144gg\u0016$\bbBB[\u000b\u0002\u0007\u00111G\u0001\ni&lWm\u001d;b[BD\u0011b!/F!\u0003\u0005\r!a\r\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\u0006yb-\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002\u000b\rdwn]3\u0002\u001b\rdwn]3IC:$G.\u001a:t\u00039!W\r\\3uK&3W\t_5tiN\fq\u0001Z3mKR,G\r\u0006\u0002\u0002\u0000\u0005aA.Y:u\u001b>$\u0017NZ5fI\u00061B.\u0019:hKN$(+Z2pe\u0012$\u0016.\\3ti\u0006l\u0007/\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!1qZBp!\u0011\u0019\tna7\u000e\u0005\rM'\u0002BBk\u0007/\fAAZ5mK*!1\u0011\u001cB|\u0003\rq\u0017n\\\u0005\u0005\u0007;\u001c\u0019N\u0001\u0003QCRD\u0007bBBq\u001d\u0002\u0007\u00111G\u0001\u0003[ND3\u0001\u0001B\u000e\u0003)aunZ*fO6,g\u000e\u001e\t\u0004\u0003C\u00026C\u0001)a)\t\u00199/\u0001\u0003pa\u0016tGCEA0\u0007c\u001c\u0019p!>\u0004\u0000\u0012\u0005AQ\u0001C\u0005\t\u001bAqa!\u001dS\u0001\u0004\u0019\u0019\bC\u0004\u00020I\u0003\r!a\r\t\u000f\r](\u000b1\u0001\u0004z\u000611m\u001c8gS\u001e\u00042A`B~\u0013\r\u0019ip \u0002\n\u0019><7i\u001c8gS\u001eDq!a\u0013S\u0001\u0004\ty\u0005C\u0005\u0005\u0004I\u0003\n\u00111\u0001\u0002\u0000\u0005\tb-\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:\t\u0013\u0011\u001d!\u000b%AA\u0002\u0005}\u0012\u0001D5oSR4\u0015\u000e\\3TSj,\u0007\"\u0003C\u0006%B\u0005\t\u0019AA@\u0003-\u0001(/Z1mY>\u001c\u0017\r^3\t\u0013\u0011=!\u000b%AA\u0002\r-\u0013A\u00034jY\u0016\u001cVO\u001a4jq\u0006qq\u000e]3oI\u0011,g-Y;mi\u0012*\u0014AD8qK:$C-\u001a4bk2$HEN\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00138\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIa*\"\u0001b\u0007+\t\r-#\u0011\u0017\u000b\t\u0003'#y\u0002\"\t\u0005$!91\u0011O,A\u0002\rM\u0004bBA\u0018/\u0002\u0007\u00111\u0007\u0005\n\t\u001f9\u0006\u0013!a\u0001\u0007\u0017\n\u0001\u0004Z3mKR,\u0017JZ#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return (OffsetIndex)this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return (TimeIndex)this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now, rollParams.maxTimestampInMessages) > rollParams.maxSegmentMs - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes - rollParams.messagesSize || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages);
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset.UNKNOWN;
        if (!(timestampOffset != null ? !timestampOffset.equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp;
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(largestTimestamp, shallowOffsetOfMaxTimestamp));
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin.REPLICATION);
            Optional maybeCompletedTxn = appendInfo.append(batch, Optional.empty());
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.ifPresent(completedTxn -> {
                long lastStableOffset = producerStateManager.lastStableOffset(completedTxn);
                this.updateTxnIndex((CompletedTxn)completedTxn, lastStableOffset);
                producerStateManager.completeTxn(completedTxn);
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position, startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY);
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, Optional.empty());
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Optional<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map(x$1 -> BoxesRunTime.boxToLong((long)x$1.offset));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset.UNKNOWN);
        try {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset);
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position);
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records.batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(() -> {
            LogSegment.$anonfun$flush$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(Utils.replaceSuffix((String)this.log().file().getPath(), (String)oldSuffix, (String)newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(Utils.replaceSuffix((String)this.lazyOffsetIndex().file().getPath(), (String)oldSuffix, (String)newSuffix)));
        this.lazyTimeIndex().renameTo(new File(Utils.replaceSuffix((String)this.lazyTimeIndex().file().getPath(), (String)oldSuffix, (String)newSuffix)));
        this.txnIndex().renameTo(new File(Utils.replaceSuffix((String)this.txnIndex().file().getPath(), (String)oldSuffix, (String)newSuffix)));
    }

    public boolean hasSuffix(String suffix) {
        return this.log().file().getName().endsWith(suffix) && this.lazyOffsetIndex().file().getName().endsWith(suffix) && this.lazyTimeIndex().file().getName().endsWith(suffix) && this.txnIndex().file().getName().endsWith(suffix);
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup((long)package$.MODULE$.max((long)timestampOffset.offset, (long)startingOffset)).position;
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset.UNKNOWN;
        if (timestampOffset == null ? timestampOffset2 != null : !timestampOffset.equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)Nil$.MODULE$)))));
    }

    public boolean deleted() {
        return !this.log().file().exists() && !this.lazyOffsetIndex().file().exists() && !this.lazyTimeIndex().file().exists() && !this.txnIndex().file().exists();
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && OptionConverters.RichOptionalInt$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalInt(cache.latestEpoch())).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batch.maxTimestamp(), batch.lastOffset()));
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar());
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    public static final /* synthetic */ void $anonfun$flush$1(LogSegment $this) {
        $this.log().flush();
        $this.offsetIndex().flush();
        $this.timeIndex().flush();
        $this.txnIndex().flush();
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset.UNKNOWN;
    }
}

