/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u000f\u0001\u0004!\u0019!C\u0005-\"1\u0011\r\u0001Q\u0001\n]CqA\u0019\u0001A\u0002\u0013%1\rC\u0004s\u0001\u0001\u0007I\u0011B:\t\re\u0004\u0001\u0015)\u0003e\u0011\u001dQ\bA1A\u0005BmDaa \u0001!\u0002\u0013a\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u000b\u0001A\u0011IA\u0002\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u00111\f\u0001\u0005B\u0005u\u0003bBA2\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002f\u0002!I!a:\t\u000f\u0005-\b\u0001\"\u0011\u0002n\n\u0019Bj\\2bY2+\u0017\rZ3s\u000b:$\u0007k\\5oi*\u0011\u0001%I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001K-z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\tq$\u0003\u0002/?\tqA*Z1eKJ,e\u000e\u001a)pS:$\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\"\u0003\u0015)H/\u001b7t\u0013\t!\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\n\u0013aB2mkN$XM]\u0005\u0003wa\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002-}%\u0011qh\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u00051\u0012\u0015BA\" \u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u0004\"\u0001\f$\n\u0005\u001d{\"\u0001\u0004*fa2L7-Y)v_R\f\u0017A\u0002\u001fj]&$h\bF\u0003K\u00172ke\n\u0005\u0002-\u0001!)Q'\u0002a\u0001m!)A(\u0002a\u0001{!)\u0001)\u0002a\u0001\u0003\")A)\u0002a\u0001\u000b\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002#B\u0011aEU\u0005\u0003'\u001e\u00121!\u00138u\u0003)\u0011X\r\u001d7jG\u0006LE\rI\u0001\t[\u0006D()\u001f;fgV\tq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!A.\u00198h\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\u000f%sG/Z4fe\u0006IQ.\u0019=CsR,7\u000fI\u0001\nM\u0016$8\r[*ju\u0016\f!BZ3uG\"\u001c\u0016N_3!\u0003MIg\u000e\u0015:pOJ,7o\u001d)beRLG/[8o+\u0005!\u0007c\u0001\u0014fO&\u0011am\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005!\u0004X\"A5\u000b\u0005)\\\u0017AB2p[6|gN\u0003\u0002#Y*\u0011QN\\\u0001\u0007CB\f7\r[3\u000b\u0003=\f1a\u001c:h\u0013\t\t\u0018N\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002/%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8`I\u0015\fHC\u0001;x!\t1S/\u0003\u0002wO\t!QK\\5u\u0011\u001dAX\"!AA\u0002\u0011\f1\u0001\u001f\u00132\u0003QIg\u000e\u0015:pOJ,7o\u001d)beRLG/[8oA\u0005a\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$W#\u0001?\u0011\u0005\u0019j\u0018B\u0001@(\u0005\u001d\u0011un\u001c7fC:\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u000eS:LG/[1uK\u000ecwn]3\u0015\u0003Q\fQa\u00197pg\u0016\faB\u0019:pW\u0016\u0014XI\u001c3Q_&tG\u000fF\u00017\u0003\u00151W\r^2i)\u0011\ty!a\t\u0011\u000f\u0005E\u0011qC4\u0002\u001c5\u0011\u00111\u0003\u0006\u0004\u0003+9\u0013AC2pY2,7\r^5p]&!\u0011\u0011DA\n\u0005\ri\u0015\r\u001d\t\u0005\u0003;\ty\"D\u0001\u0001\u0013\r\t\t#\f\u0002\n\r\u0016$8\r\u001b#bi\u0006Dq!!\n\u0015\u0001\u0004\t9#\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0002*\u0005Ub\u0002BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0012.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019$!\f\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005]\u0012\u0011\b\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\t\u0019$!\f\u0002'\u0019,Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;\u0015\r\u0005}\u00121JA(!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#b\u00016\u0002F)\u0011\u0001e[\u0005\u0005\u0003\u0013\n\u0019E\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\r\u00055S\u00031\u0001h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!\u0015\u0016\u0001\u0004\t\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\ty$a\u0016\u0002Z!1\u0011Q\n\fA\u0002\u001dDa!!\u0015\u0017\u0001\u0004\t\u0016\u0001\u00074fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fiR1\u0011qHA0\u0003CBa!!\u0014\u0018\u0001\u00049\u0007BBA)/\u0001\u0007\u0011+\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003O\n)\nE\u0004\u0002\u0012\u0005]q-!\u001b\u0011\t\u0005-\u0014q\u0012\b\u0005\u0003[\nII\u0004\u0003\u0002p\u0005\u0015e\u0002BA9\u0003\u0007sA!a\u001d\u0002\u0002:!\u0011QOA@\u001d\u0011\t9(! \u000e\u0005\u0005e$bAA>G\u00051AH]8pizJ\u0011a\\\u0005\u0003[:L!A\t7\n\u0005)\\\u0017bAADS\u00069Q.Z:tC\u001e,\u0017\u0002BAF\u0003\u001b\u000b\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC*\u0019\u0011qQ5\n\t\u0005E\u00151\u0013\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\tY)!$\t\u000f\u0005]\u0005\u00041\u0001\u0002\u001a\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000f\u0005E\u0011qC4\u0002\u001cB!\u0011QDAO\u0013\r\ty*\f\u0002\n\u000bB|7\r\u001b#bi\u0006\f!BY;jY\u00124U\r^2i)\u0011\t)+a1\u0011\r\u0005\u001d\u0016QWA^\u001d\u0011\tI+!-\u000f\t\u0005-\u0016q\u0016\b\u0005\u0003o\ni+C\u0001#\u0013\t\u0001\u0013%C\u0002\u00024~\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u00028\u0006e&\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u00024~\u0001BAJ3\u0002>B!\u0011qUA`\u0013\u0011\t\t-!/\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\u0005]\u0015\u00041\u0001\u0002FB9\u0011\u0011CA\fO\u0006\u001d\u0007c\u0001\u0017\u0002J&\u0019\u00111Z\u0010\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002-M,G.Z2u!\u0006\u0014H/\u001b;j_:$vNR3uG\"$B!!5\u0002ZB!a%ZAj!\u00191\u0013Q[4\u0002H&\u0019\u0011q[\u0014\u0003\rQ+\b\u000f\\33\u0011\u001d\t9J\u0007a\u0001\u0003\u000b\faCY;jY\u00124U\r^2i\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0007\u0003K\u000by.!9\t\r\u000553\u00041\u0001h\u0011\u001d\t\u0019o\u0007a\u0001\u0003\u000f\f!BZ3uG\"\u001cF/\u0019;f\u0003IqW\r\u001f;SK\u0006$\u0017\u0010U1si&$\u0018n\u001c8\u0015\t\u0005E\u0017\u0011\u001e\u0005\b\u0003/c\u0002\u0019AAc\u0003!!xn\u0015;sS:<GCAAx!\u0011\t\t0!?\u000f\t\u0005M\u0018Q\u001f\t\u0004\u0003o:\u0013bAA|O\u00051\u0001K]3eK\u001aLA!a?\u0002~\n11\u000b\u001e:j]\u001eT1!a>(\u0001")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isTruncationOnFetchSupported;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        java.util.Map fetchData = request.fetchData((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)topicNames).asJava());
        FetchParams fetchParams = new FetchParams(request.version(), -3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(fetchData).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        });
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(fetchData.keySet().toArray())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = ((LeaderEpochFileCache)partition.localLogOrException().leaderEpochCache().get()).epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElse(0));
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = ((LeaderEpochFileCache)partition.localLogOrException().leaderEpochCache().get()).epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElse(0));
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long localLogStartOffset = partition.localLogOrException().localLogStartOffset();
        OptionalInt epoch = ((LeaderEpochFileCache)partition.localLogOrException().leaderEpochCache().get()).epochForOffset(localLogStartOffset);
        return new OffsetAndEpoch(localLogStartOffset, epoch.orElse(0));
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitions, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitions);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitions, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition topicPartition, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(topicPartition).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$2 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$2))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
            requestMap.put(topicPartition, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)topicPartition);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)(fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion()), (int)this.replicaId(), (long)-1L, (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitions) {
        return ((TraversableOnce)partitions.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = data.abortedTransactions.orElse(null);
            long lastStableOffset = data.lastStableOffset.orElse(-1L);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitions$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitions$1.get((Object)tp).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitions$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$2) {
        return BoxesRunTime.boxToInteger((int)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isTruncationOnFetchSupported = false;
    }
}

