/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.UnifiedLog$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mt!B\u0010!\u0011\u0003)c!B\u0014!\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007m\u0005\u0001\u000b\u0011B\u001a\t\u000f]\n!\u0019!C\u0001q!1A)\u0001Q\u0001\neBq!R\u0001C\u0002\u0013\u0005a\t\u0003\u0004K\u0003\u0001\u0006Ia\u0012\u0004\u0005O\u0001\u00021\nC\u00030\u0013\u0011\u0005A\nC\u0004O\u0013\t\u0007I\u0011A(\t\rYK\u0001\u0015!\u0003Q\u0011%9\u0016\u00021AA\u0002\u0013\u0005\u0001\fC\u0005]\u0013\u0001\u0007\t\u0019!C\u0001;\"I1-\u0003a\u0001\u0002\u0003\u0006K!\u0017\u0005\u0006I&!\t!\u001a\u0005\u0006c&!IA\u001d\u0005\n\u0003\u000bI\u0011\u0013!C\u0005\u0003\u000fAq!!\b\n\t\u0003\ty\u0002C\u0004\u0002,%!I!!\f\t\u000f\u0005m\u0012\u0002\"\u0003\u0002>!9\u0011qJ\u0005\u0005\n\u0005E\u0003BBA+\u0013\u0011\u0005Q\r\u0003\u0004\u0002`%!\t!\u001a\u0005\u0007\u0003GJA\u0011A3\t\r\u0005\u001d\u0014\u0002\"\u0001f\u0011\u0019\tY'\u0003C\u0001K\"1\u0011qN\u0005\u0005\u0002\u0015Da!a\u001d\n\t\u0003)\u0007BBA<\u0013\u0011\u0005Q-A\u0006SKBd\u0017nY1UKN$(BA\u0011#\u0003\u001d\u0019G.^:uKJT\u0011aI\u0001\u0006W\u000647.Y\u0002\u0001!\t1\u0013!D\u0001!\u0005-\u0011V\r\u001d7jG\u0006$Vm\u001d;\u0014\u0005\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002K\u0005A!I]8lKJLE-F\u00014!\tQC'\u0003\u00026W\t\u0019\u0011J\u001c;\u0002\u0013\t\u0013xn[3s\u0013\u0012\u0004\u0013!\u0003)beRLG/[8o+\u0005I\u0004C\u0001\u001eC\u001b\u0005Y$B\u0001\u001f>\u0003\u0019\u0019w.\\7p]*\u00111E\u0010\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014x-\u0003\u0002Dw\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0003)beRLG/[8oA\u0005\u0019\"+\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\tq\t\u0005\u0002+\u0011&\u0011\u0011j\u000b\u0002\u0005\u0019>tw-\u0001\u000bSKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\n\u0003\u0013%\"\u0012!\u0014\t\u0003M%\tA\u0001^5nKV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002TE\u0005)Q\u000f^5mg&\u0011QK\u0015\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!/\u001a9mS\u000e\fW#A-\u0011\u0005\u0019R\u0016BA.!\u0005\u001d\u0011V\r\u001d7jG\u0006\f1B]3qY&\u001c\u0017m\u0018\u0013fcR\u0011a,\u0019\t\u0003U}K!\u0001Y\u0016\u0003\tUs\u0017\u000e\u001e\u0005\bE:\t\t\u00111\u0001Z\u0003\rAH%M\u0001\te\u0016\u0004H.[2bA\u0005)1/\u001a;vaR\ta\f\u000b\u0002\u0011OB\u0011\u0001n\\\u0007\u0002S*\u0011!n[\u0001\u0004CBL'B\u00017n\u0003\u001dQW\u000f]5uKJT!A\u001c!\u0002\u000b),h.\u001b;\n\u0005AL'A\u0003\"fM>\u0014X-R1dQ\u0006\u0011\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u001dq6/^<zwvDQ\u0001^\tA\u0002\u001d\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0003w#\u0001\u0007q)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0003y#\u0001\u0007q)\u0001\nmCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\b\"\u0002>\u0012\u0001\u00049\u0015a\u00077bgR4U\r^2i\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fC\u0003}#\u0001\u0007q)A\bmCN$h)\u001a;dQRKW.Z't\u0011\u001dq\u0018\u0003%AA\u0002}\f1B\u0019:pW\u0016\u0014X\t]8dQB!!&!\u0001H\u0013\r\t\u0019a\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u00029\u0005\u001c8/\u001a:u%\u0016\u0004H.[2b'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011\u0011\u0002\u0016\u0004\u007f\u0006-1FAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]1&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0007\u0002\u0012\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002?\u0005\u001c8/\u001a:u%\u0016\u0004H.[2b'R\fG/\u001a#pKNtu\u000e^\"iC:<W\rF\u0002_\u0003CA\u0001\"a\t\u0014\t\u0003\u0007\u0011QE\u0001\u0003_B\u0004BAKA\u0014=&\u0019\u0011\u0011F\u0016\u0003\u0011q\u0012\u0017P\\1nKz\n\u0001#\u001e9eCR,g)\u001a;dQN#\u0018\r^3\u0015\u000f\u001d\u000by#a\r\u00028!1\u0011\u0011\u0007\u000bA\u0002\u001d\u000b1CZ8mY><XM\u001d$fi\u000eDwJ\u001a4tKRDa!!\u000e\u0015\u0001\u00049\u0015a\u00054pY2|w/\u001a:Ti\u0006\u0014Ho\u00144gg\u0016$\bBBA\u001d)\u0001\u0007q)A\bmK\u0006$WM]#oI>3gm]3u\u0003E\u0011Xm]3u%\u0016\u0004H.[2b'R\fG/\u001a\u000b\b\u000f\u0006}\u0012\u0011IA&\u0011\u0019\tI$\u0006a\u0001\u000f\"9\u00111I\u000bA\u0002\u0005\u0015\u0013aC5t\u001d\u0016<H*Z1eKJ\u00042AKA$\u0013\r\tIe\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\ti%\u0006a\u0001\u0003\u000b\n\u0001#[:G_2dwn^3s\u0013:\u001c\u0016P\\2\u0002\u0015%\u001c8)Y;hQR,\u0006\u000f\u0006\u0003\u0002F\u0005M\u0003BBA\u001d-\u0001\u0007q)\u0001\tuKN$\u0018J\\5uS\u0006d7\u000b^1uK\"\u001aq#!\u0017\u0011\u0007!\fY&C\u0002\u0002^%\u0014A\u0001V3ti\u0006!B/Z:u+B$\u0017\r^3GKR\u001c\u0007n\u0015;bi\u0016D3\u0001GA-\u0003q\"Xm\u001d;SKN,GOU3qY&\u001c\u0017m\u0015;bi\u0016<\u0006.\u001a8MK\u0006$WM]%t%\u0016,G.Z2uK\u0012\fe\u000e\u001a*fa2L7-Y%t\u0013:\u001c\u0016P\\2)\u0007e\tI&A uKN$(+Z:fiJ+\u0007\u000f\\5dCN#\u0018\r^3XQ\u0016tG*Z1eKJL5OU3fY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5OT8u\u0013:\u001c\u0016P\\2)\u0007i\tI&A\u001fuKN$(+Z:fiJ+\u0007\u000f\\5dCN#\u0018\r^3XQ\u0016tg*Z<MK\u0006$WM]%t\u000b2,7\r^3e\u0003:$'+\u001a9mS\u000e\f\u0017j]%o'ft7\rK\u0002\u001c\u00033\n\u0001\t^3tiJ+7/\u001a;SKBd\u0017nY1Ti\u0006$Xm\u00165f]:+w\u000fT3bI\u0016\u0014\u0018j]#mK\u000e$X\rZ!oIJ+\u0007\u000f\\5dC&\u001bhj\u001c;J]NKhn\u0019\u0015\u00049\u0005e\u0013a\u000b;fgRL5oQ1vO\"$X\u000b],iK:\u0014V\r\u001d7jG\u0006L5oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0007u\tI&\u0001\u0018uKN$\u0018j]\"bk\u001eDG/\u00169XQ\u0016t'+\u001a9mS\u000e\f\u0017j\u001d(pi\u000e\u000bWo\u001a5u+B$v\u000eT8h\u000b:$\u0007f\u0001\u0010\u0002Z\u0001")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition()));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, Option<Object> brokerEpoch) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
        Assertions.assertEquals(brokerEpoch, (Object)replicaState.brokerEpoch(), (String)"Broker Epoch Mismatch");
    }

    private Option<Object> assertReplicaState$default$6() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs(), this.assertReplicaState$default$6());
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchState(new LogOffsetMetadata(followerFetchOffset), followerStartOffset, currentTimeMs, leaderEndOffset, 1L);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1, this.assertReplicaState$default$6());
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2, this.assertReplicaState$default$6());
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L, this.assertReplicaState$default$6());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), resetTimeMs1, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }
}

