/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import kafka.log.BrokerCompressionTest$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001#\u0011\u0019i\u0003\u0001)A\u0005G!9a\u0006\u0001b\u0001\n\u0003y\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\r\u001d\u0003\u0001\u0015!\u0003:\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015A\u0006\u0001\"\u0001Z\u000f\u0015Y\u0018\u0003#\u0001}\r\u0015\u0001\u0012\u0003#\u0001~\u0011\u0015iR\u0002\"\u0001\u007f\u0011\u0015)X\u0002\"\u0001\u0000\u0005U\u0011%o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgRT!AE\n\u0002\u00071|wMC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011#\u0001\u0004u[B$\u0015N]\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003S>T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u0005i&lW-F\u00011!\t\tD'D\u00013\u0015\t\u00194#A\u0003vi&d7/\u0003\u00026e\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0005m_\u001e\u001cuN\u001c4jOV\t\u0011\b\u0005\u0002;\u000b6\t1H\u0003\u0002\u0013y)\u0011QHP\u0001\nS:$XM\u001d8bYNT!a\u0010!\u0002\u000fM$xN]1hK*\u0011A#\u0011\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002Gw\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003)\u0003\"\u0001G&\n\u00051K\"\u0001B+oSRD#A\u0003(\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016aA1qS*\u00111\u000bV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)6)A\u0003kk:LG/\u0003\u0002X!\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001ai\u0016\u001cHO\u0011:pW\u0016\u00148+\u001b3f\u0007>l\u0007O]3tg&|g\u000eF\u0002K5\u001eDQaW\u0006A\u0002q\u000b!#\\3tg\u0006<WmQ8naJ,7o]5p]B\u0011Q\f\u001a\b\u0003=\n\u0004\"aX\r\u000e\u0003\u0001T!!Y\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u001a\u0011\u0015A7\u00021\u0001]\u0003E\u0011'o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0005\u0017)\u00148\u000f\u0005\u0002la6\tAN\u0003\u0002n]\u0006A\u0001O]8wS\u0012,'O\u0003\u0002p%\u00061\u0001/\u0019:b[NL!!\u001d7\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003Q\f\u0013!^\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bFA\u0006x!\tA\u00180D\u0001o\u0013\tQhNA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fQC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cH\u000f\u0005\u0002!\u001bM\u0011Qb\u0006\u000b\u0002yV\u0011\u0011\u0011\u0001\t\u0007\u0003\u0007\ti!!\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\taa\u001d;sK\u0006l'bAA\u0006O\u0005!Q\u000f^5m\u0013\u0011\ty!!\u0002\u0003\rM#(/Z1n!\rY\u00171C\u0005\u0004\u0003+a'!C!sOVlWM\u001c;t\u0001")
public class BrokerCompressionTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime(0L, 0L);
    private final LogConfig logConfig = new LogConfig((Map)new Properties());

    public static Stream<Arguments> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testBrokerSideCompression(String messageCompression, String brokerCompression) {
        CompressionType messageCompressionType = CompressionType.forName((String)messageCompression);
        Properties logProps = new Properties();
        logProps.put("compression.type", brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        Option x$17 = UnifiedLog$.MODULE$.apply$default$17();
        LogOffsetsListener x$18 = UnifiedLog$.MODULE$.apply$default$18();
        UnifiedLog log = UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17, x$18);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)messageCompressionType, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        if (!brokerCompression.equals("producer")) {
            CompressionType brokerCompressionType = BrokerCompressionType.forName((String)brokerCompression).targetCompressionType(null);
            Assertions.assertEquals((Object)brokerCompressionType, (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionType).toString());
            return;
        }
        Assertions.assertEquals((Object)messageCompressionType, (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionType).toString());
    }

    private static final RecordBatch readBatch$1(int offset, UnifiedLog log$1) {
        return (RecordBatch)log$1.read((long)((long)offset), (int)4096, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.batches().iterator().next();
    }
}

