/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013i\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA(\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005E\u0003\"CA3\u0001\t\u0007I\u0011AA4\u0011!\t)\b\u0001Q\u0001\n\u0005%\u0004\u0002\u00037\u0001\u0005\u0004%\t!a\u001e\t\u0011\u0005}\u0004\u0001)A\u0005\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u001c\u0002!\t!a!\u0007\r\u0005\u0015\u0006\u0001QAT\u0011)\t)l\u0005BK\u0002\u0013\u0005\u0011q\u0017\u0005\u000b\u0003\u001f\u001c\"\u0011#Q\u0001\n\u0005e\u0006BCAi'\tU\r\u0011\"\u0001\u00028\"Q\u00111[\n\u0003\u0012\u0003\u0006I!!/\t\r]\u001cB\u0011AAk\u0011\u001d\tyn\u0005C\u0001\u0003CD\u0011\"a@\u0014#\u0003%\tA!\u0001\t\u0013\t]1#!A\u0005\u0002\te\u0001\"\u0003B\u0010'E\u0005I\u0011\u0001B\u0011\u0011%\u0011)cEI\u0001\n\u0003\u0011\t\u0003C\u0005\u0003(M\t\t\u0011\"\u0011\u0003*!I!QG\n\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u007f\u0019\u0012\u0011!C\u0001\u0005\u0003B\u0011Ba\u0013\u0014\u0003\u0003%\tE!\u0014\t\u0013\tm3#!A\u0005\u0002\tu\u0003\"\u0003B4'\u0005\u0005I\u0011\tB5\u0011%\u0011YgEA\u0001\n\u0003\u0012i\u0007C\u0005\u0003pM\t\t\u0011\"\u0011\u0003r\u001d9!Q\u000f\u0001\t\u0002\t]daBAS\u0001!\u0005!\u0011\u0010\u0005\u0007o\u001e\"\tAa\u001f\t\u000f\tut\u0005\"\u0001\u0003\u0000!I!\u0011R\u0014\u0002\u0002\u0013\u0005%1\u0012\u0005\n\u0005#;\u0013\u0011!CA\u0005'CqA!*\u0001\t\u0013\u00119\u000bC\u0004\u0003B\u0002!IAa1\t\u000f\t-\u0007\u0001\"\u0003\u0003N\"I!q\u001b\u0001\u0012\u0002\u0013%!\u0011\u001c\u0005\n\u0005;\u0004\u0011\u0013!C\u0005\u0005\u0003AqAa8\u0001\t\u0013\u0011\t\u000fC\u0005\u0004\n\u0001\t\n\u0011\"\u0003\u0003Z\"I11\u0002\u0001\u0012\u0002\u0013%!\u0011\u0001\u0005\n\u0007\u001b\u0001\u0011\u0013!C\u0005\u0007\u001fA\u0011ba\u0005\u0001#\u0003%Ia!\u0006\t\u0013\re\u0001!%A\u0005\n\rm\u0001\"CB\u0010\u0001E\u0005I\u0011BB\u000b\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0003\u0007Cqaa\u000b\u0001\t\u0003\t\u0019\tC\u0004\u00040\u0001!\t!a!\t\u000f\rM\u0002\u0001\"\u0001\u0002\u0004\"91q\u0007\u0001\u0005\u0002\u0005\r\u0005bBB\u001e\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0001A\u0011AAB\u0011\u001d\u0019\u0019\u0005\u0001C\u0001\u0003\u0007Cqaa\u0012\u0001\t\u0003\t\u0019\tC\u0004\u0004L\u0001!\t!a!\t\u000f\r=\u0003\u0001\"\u0001\u0002\u0004\"911\u000b\u0001\u0005\u0002\u0005\r\u0005bBB,\u0001\u0011\u0005\u00111\u0011\u0005\b\u00077\u0002A\u0011BB/\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0003\u0007Cqaa\u001a\u0001\t\u0003\t\u0019\tC\u0004\u0004l\u0001!Ia!\u001c\t\u000f\rE\u0004\u0001\"\u0001\u0002\u0004\"91Q\u000f\u0001\u0005\u0002\u0005\r\u0005bBB=\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007{\u0002A\u0011AAB\u0011\u001d\u0019\t\t\u0001C\u0001\u0003\u0007Cqa!\"\u0001\t\u0003\t\u0019\tC\u0004\u0004\n\u0002!\t!a!\t\u000f\r5\u0005\u0001\"\u0001\u0002\u0004\"91\u0011\u0013\u0001\u0005\n\rM\u0005bBBO\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007C\u0003A\u0011AAB\u0011\u001d\u0019)\u000b\u0001C\u0001\u0003\u0007Cqa!+\u0001\t\u0003\t\u0019\tC\u0004\u0004.\u0002!\t!a!\t\u000f\rE\u0006\u0001\"\u0001\u0002\u0004\"91Q\u0017\u0001\u0005\u0002\u0005\r\u0005bBB]\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007{\u0003A\u0011AAB\u0011\u001d\u0019\t\r\u0001C\u0001\u0003\u0007Cqa!2\u0001\t\u0003\t\u0019\tC\u0004\u0004J\u0002!\t!a!\t\u000f\r5\u0007\u0001\"\u0001\u0002\u0004\"91\u0011\u001b\u0001\u0005\u0002\u0005\r\u0005bBBk\u0001\u0011\u0005\u00111\u0011\u0005\b\u00073\u0004A\u0011BBn\u0011%!y\u0002AI\u0001\n\u0013!\t\u0003C\u0005\u0005&\u0001\t\n\u0011\"\u0003\u0005(!IA1\u0006\u0001\u0012\u0002\u0013%!\u0011\u0001\u0005\n\t[\u0001\u0011\u0013!C\u0005\u00077A\u0011\u0002b\f\u0001#\u0003%I\u0001\"\r\t\u0013\u0011U\u0002!%A\u0005\n\u0011]\u0002\"\u0003C\u001e\u0001E\u0005I\u0011\u0002C\u001f\u0011%!\t\u0005AI\u0001\n\u0013!\u0019E\u0001\u0007M_\u000e\fG\u000eT8h)\u0016\u001cHO\u0003\u0002m[\u0006\u0019An\\4\u000b\u00039\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A=\u0011\u0005i\u0004Q\"A6\u0002\r\r|gNZ5h+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u00025\faa]3sm\u0016\u0014\u0018bAA\u0003\u007f\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002s\u0003\u001bI1!a\u0004t\u0005\u0011)f.\u001b;\t\u0011\u0005M1!!AA\u0002u\f1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001^7q\t&\u0014XCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!![8\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\t\t)\u0004\u0005\u0003\u00028\u0005\u001dSBAA\u001d\u0015\u0011\tY$!\u0010\u0002\r\r|W.\\8o\u0015\rq\u0017q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\n1a\u001c:h\u0013\u0011\tI%!\u000f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0003\u0003#\u0002B!a\u0015\u0002`5\u0011\u0011Q\u000b\u0006\u0004Y\u0006]#\u0002BA-\u00037\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005u\u0013QH\u0001\bgR|'/Y4f\u0013\u0011\t\t'!\u0016\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0003\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_j\u0017!B;uS2\u001c\u0018\u0002BA:\u0003[\u0012\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002*\"!!\u001f\u0011\u0007i\fY(C\u0002\u0002~-\u0014\u0001\u0002T8dC2dunZ\u0001\u0005Y><\u0007%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\f!\u001a\u0011#a\"\u0011\t\u0005%\u0015qS\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006\u0019\u0011\r]5\u000b\t\u0005E\u00151S\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t)*a\u0011\u0002\u000b),h.\u001b;\n\t\u0005e\u00151\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007I\ty\n\u0005\u0003\u0002\n\u0006\u0005\u0016\u0002BAR\u0003\u0017\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0003\u0011-+\u0017PV1mk\u0016\u001cbaE9\u0002*\u0006=\u0006c\u0001:\u0002,&\u0019\u0011QV:\u0003\u000fA\u0013x\u000eZ;diB\u0019!/!-\n\u0007\u0005M6O\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0002lKf,\"!!/\u0011\t\u0005m\u0016\u0011\u001a\b\u0005\u0003{\u000b)\rE\u0002\u0002@Nl!!!1\u000b\u0007\u0005\rw.\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000f\u001c\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002L\u00065'AB*ue&twMC\u0002\u0002HN\fAa[3zA\u0005)a/\u00197vK\u00061a/\u00197vK\u0002\"b!a6\u0002\\\u0006u\u0007cAAm'5\t\u0001\u0001C\u0004\u00026b\u0001\r!!/\t\u000f\u0005E\u0007\u00041\u0001\u0002:\u0006AAo\u001c*fG>\u0014H\r\u0006\u0003\u0002d\u0006=\b\u0003BAs\u0003Wl!!a:\u000b\t\u0005%\u0018\u0011H\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u00055\u0018q\u001d\u0002\r'&l\u0007\u000f\\3SK\u000e|'\u000f\u001a\u0005\n\u0003cL\u0002\u0013\"a\u0001\u0003g\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u000bI\f)0!?\n\u0007\u0005]8O\u0001\u0005=Eft\u0017-\\3?!\r\u0011\u00181`\u0005\u0004\u0003{\u001c(\u0001\u0002'p]\u001e\f!\u0003^8SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0001\u0016\u0005\u0003s\u0014)a\u000b\u0002\u0003\bA!!\u0011\u0002B\n\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C;oG\",7m[3e\u0015\r\u0011\tb]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u000b\u0005\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0011\u0019w\u000e]=\u0015\r\u0005]'1\u0004B\u000f\u0011%\t)l\u0007I\u0001\u0002\u0004\tI\fC\u0005\u0002Rn\u0001\n\u00111\u0001\u0002:\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0012U\u0011\tIL!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u000b\u0011\t\t5\"1G\u0007\u0003\u0005_QAA!\r\u0002$\u0005!A.\u00198h\u0013\u0011\tYMa\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\te\u0002c\u0001:\u0003<%\u0019!QH:\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\r#\u0011\n\t\u0004e\n\u0015\u0013b\u0001B$g\n\u0019\u0011I\\=\t\u0013\u0005M\u0001%!AA\u0002\te\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0003C\u0002B)\u0005/\u0012\u0019%\u0004\u0002\u0003T)\u0019!QK:\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003Z\tM#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0018\u0003fA\u0019!O!\u0019\n\u0007\t\r4OA\u0004C_>dW-\u00198\t\u0013\u0005M!%!AA\u0002\t\r\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\te\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003`\tM\u0004\"CA\nK\u0005\u0005\t\u0019\u0001B\"\u0003!YU-\u001f,bYV,\u0007cAAmOM!q%]AX)\t\u00119(\u0001\u0006ge>l'+Z2pe\u0012$B!a6\u0003\u0002\"9\u0011\u0011^\u0015A\u0002\t\r\u0005\u0003BAs\u0005\u000bKAAa\"\u0002h\n1!+Z2pe\u0012\fQ!\u00199qYf$b!a6\u0003\u000e\n=\u0005bBA[U\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003#T\u0003\u0019AA]\u0003\u001d)h.\u00199qYf$BA!&\u0003\"B)!Oa&\u0003\u001c&\u0019!\u0011T:\u0003\r=\u0003H/[8o!\u001d\u0011(QTA]\u0003sK1Aa(t\u0005\u0019!V\u000f\u001d7fe!I!1U\u0016\u0002\u0002\u0003\u0007\u0011q[\u0001\u0004q\u0012\u0002\u0014\u0001D6wgR{'+Z2pe\u0012\u001cH\u0003\u0002BU\u0005w\u0003bAa+\u00036\u0006\rh\u0002\u0002BW\u0005csA!a0\u00030&\tA/C\u0002\u00034N\fq\u0001]1dW\u0006<W-\u0003\u0003\u00038\ne&\u0001C%uKJ\f'\r\\3\u000b\u0007\tM6\u000fC\u0004\u0003>2\u0002\rAa0\u0002\u0013-,\u0017PV1mk\u0016\u001c\bC\u0002BV\u0005k\u000b9.\u0001\u0007sK\u000e|'\u000fZ:U_.38\u000f\u0006\u0003\u0003@\n\u0015\u0007b\u0002Bd[\u0001\u0007!\u0011Z\u0001\be\u0016\u001cwN\u001d3t!\u0019\u0011YK!.\u0003\u0004\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$\u0002\"a\u0003\u0003P\nE'1\u001b\u0005\b\u0005\u000ft\u0003\u0019\u0001BU\u0011!ag\u0006%AA\u0002\u0005e\u0004\"\u0003Bk]A\u0005\t\u0019AA}\u00035Ig.\u001b;jC2|eMZ:fi\u00069\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$HEM\u000b\u0003\u00057TC!!\u001f\u0003\u0006\u00059\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3d_J$7\u000f\u0006\b\u0003d\n%(1\u001eBx\u0005k\u0014Ip!\u0002\u0011\t\u0005M#Q]\u0005\u0005\u0005O\f)FA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\tYF\u0002\n\u00111\u0001\u0002z!I!Q^\u0019\u0011\u0002\u0003\u0007\u0011\u0011`\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0005\u0003rF\u0002J\u00111\u0001\u0003t\u0006IQ.\u0019=MK:<G\u000f\u001b\t\u0006e\u0006U(\u0011\b\u0005\n\u0005o\f\u0004\u0013!a\u0001\u0005?\nQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\"\u0003B~cA%\t\u0019\u0001B\u007f\u0003Ei\u0017\r_(gMN,G/T3uC\u0012\fG/\u0019\t\u0006e\u0006U(q \t\u0005\u0003'\u001a\t!\u0003\u0003\u0004\u0004\u0005U#!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I1qA\u0019\u0011\u0002\u0003\u0007!qL\u0001\u0013S:\u001cG.\u001e3f\u0003\n|'\u000f^3e)bt7/A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAB\tU\u0011\u0011ID!\u0002\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0003\u0016\u0005\u0005?\u0012)!A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\ru!\u0006\u0002B\u0000\u0005\u000b\tQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0001\u000fuKN$Hj\\4EK2,G/Z*fO6,g\u000e^:Tk\u000e\u001cWm]:)\u0007a\u001a)\u0003\u0005\u0003\u0002\n\u000e\u001d\u0012\u0002BB\u0015\u0003\u0017\u0013A\u0001V3ti\u0006QB/Z:u%>dG.R7qif\f5\r^5wKN+w-\\3oi\"\u001a\u0011h!\n\u0002mQ,7\u000f\u001e'pO\u0012+G.\u001a;f\t&\u00148+^2dKN\u001cx\u000b[3o\u000b6\u0004H/_!oI\u001a\u000b\u0017\u000e\\;sK^CWM\u001c(p]\u0016k\u0007\u000f^=)\u0007i\u001a)#\u0001\tuKN$X\u000b\u001d3bi\u0016\u001cuN\u001c4jO\"\u001a1h!\n\u00021Q,7\u000f\u001e'pO\u0012K'OU3oC6,Gk\u001c(fo\u0012K'\u000fK\u0002=\u0007K\tQ\u0004^3ti2{w\rR5s%\u0016t\u0017-\\3U_\u0016C\u0018n\u001d;j]\u001e$\u0015N\u001d\u0015\u0004{\r\u0015\u0012\u0001\u0004;fgRdun\u001a$mkND\u0007f\u0001 \u0004&\u0005iA/Z:u\u0019><\u0017\t\u001d9f]\u0012D3aPB\u0013\u0003M!Xm\u001d;M_\u001e\u001cEn\\:f'V\u001c7-Z:tQ\r\u00015QE\u0001\u0017i\u0016\u001cH\u000fT8h\u00072|7/Z%eK6\u0004x\u000e^3oi\"\u001a\u0011i!\n\u0002WQ,7\u000f\u001e'pO\u000ecwn]3GC&dWO]3XQ\u0016t\u0017J\\'f[>\u0014\u0018PQ;gM\u0016\u00148\t\\8tK\u0012D3AQB\u0013\u0003Q!Xm\u001d;M_\u001e\u001cEn\\:f\u0011\u0006tG\r\\3sg\"\u001a1i!\n\u0002=Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:t\u0013\u0012,W\u000e]8uK:$\bf\u0001#\u0004&\u0005YB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN$B!a\u0003\u0004`!91\u0011M#A\u0002\t}\u0013aC1ts:\u001cG)\u001a7fi\u0016\fq\u0004^3tiJ+Wn\u001c<f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]R\u001c8+\u001f8dQ\r15QE\u0001!i\u0016\u001cHOU3n_Z,\u0017I\u001c3EK2,G/Z*fO6,g\u000e^:Bgft7\rK\u0002H\u0007K\ta\u0003^3ti\u0012+G.\u001a;f'\u0016<W.\u001a8u\r&dWm\u001d\u000b\u0005\u0003\u0017\u0019y\u0007C\u0004\u0004b!\u0003\rAa\u0018\u00025Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN\u001c\u0016P\\2)\u0007%\u001b)#A\u000euKN$H)\u001a7fi\u0016\u001cVmZ7f]R4\u0015\u000e\\3t\u0003NLhn\u0019\u0015\u0004\u0015\u000e\u0015\u0012a\u0007;fgR$U\r\\3uC\ndWmU3h[\u0016tGo\u001d$jYR,'\u000fK\u0002L\u0007K\ta\u0004^3ti\u0012+G.\u001a;bE2,7+Z4nK:$8/\u0013;fe\u0006$\u0018n\u001c8)\u00071\u001b)#\u0001\u000euKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tG\u000fK\u0002N\u0007K\t1\u0004^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#\bf\u0001(\u0004&\u0005qA/Z:u)J,hnY1uKR{\u0007fA(\u0004&\u0005IB/Z:u\u001d>t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u001chI]8nQ\r\u00016QE\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\r\u0006\u0004\u0002:\u000eU5\u0011\u0014\u0005\b\u0007/\u000b\u0006\u0019AA]\u0003\u0015!x\u000e]5d\u0011\u001d\u0019Y*\u0015a\u0001\u0003s\u000b\u0011\u0002]1si&$\u0018n\u001c8\u00027Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7fQ\r\u00116QE\u00015i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3XSRD\u0007+\u001a:j_\u00124uN\u001d#fY\u0016$X\r\u001a+pa&\u001c\u0007fA*\u0004&\u00059C/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]#naRLh*Y7fQ\r!6QE\u0001#i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_JtU\u000f\u001c7)\u0007U\u001b)#\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe6K7o]5oON+\u0007/\u0019:bi>\u0014\bf\u0001,\u0004&\u0005QC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgn\u001a+pa&\u001c\u0007fA,\u0004&\u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgn\u001a)beRLG/[8oQ\rA6QE\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_JLeN^1mS\u0012\u0004\u0016M\u001d;ji&|g\u000eK\u0002Z\u0007K\t\u0001\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Fq&\u001cH/\u001b8h\u0013:4\u0018\r\\5e\t&\u0014\bf\u0001.\u0004&\u0005!B/Z:u\u0019><G)\u001a7fi\u0016$\u0015N\u001d(b[\u0016D3aWB\u0013\u0003I!Xm\u001d;PM\u001a\u001cX\r\u001e$s_64\u0015\u000e\\3)\u0007q\u001b)#\u0001\u0011uKN$(k\u001c7m'\u0016<W.\u001a8u)\"\fG/\u00117sK\u0006$\u00170\u0012=jgR\u001c\bfA/\u0004&\u0005AB/Z:u\u001d\u0016<8+Z4nK:$8/\u00114uKJ\u0014v\u000e\u001c7)\u0007y\u001b)#A\u0016uKN$(k\u001c7m'\u0016<W.\u001a8u\u000bJ\u0014xN],iK:tU\r\u001f;PM\u001a\u001cX\r^%t\u00132dWmZ1mQ\ry6QE\u0001\u001bi\u0016\u001cHO\u00127vg\"Lgn\u001a(p]\u0016C\u0018n\u001d;f]R$\u0015N\u001d\u0015\u0004A\u000e\u0015\u0012aH2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oiR!\u0012\u0011PBo\u0007C\u001cIoa=\u0004x\u000emHQ\u0002C\u000e\t;A\u0011ba8b!\u0003\u0005\r!a\u0007\u0002\u0007\u0011L'\u000f\u0003\u0004|C\u0002\u000711\u001d\t\u0005\u0003'\u001a)/\u0003\u0003\u0004h\u0006U#!\u0003'pO\u000e{gNZ5h\u0011%\u0019Y/\u0019I\u0001\u0002\u0004\u0019i/\u0001\u0005tK\u001elWM\u001c;t!\rQ8q^\u0005\u0004\u0007c\\'a\u0003'pON+w-\\3oiND\u0011b!>b!\u0003\u0005\r!!?\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011%\u0019I0\u0019I\u0001\u0002\u0004\u0011y0\u0001\noKb$xJ\u001a4tKRlU\r^1eCR\f\u0007\"CB\u007fCB\u0005\t\u0019AB\u0000\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0005\u0002\u0011%QB\u0001C\u0002\u0015\u0011!)\u0001b\u0002\u0002\tU$\u0018\u000e\u001c\u0006\u0005\u0003\u0003\ti$\u0003\u0003\u0005\f\u0011\r!!C*dQ\u0016$W\u000f\\3s\u0011%!y!\u0019I\u0001\u0002\u0004!\t\"\u0001\u0003uS6,\u0007\u0003\u0002C\n\t/i!\u0001\"\u0006\u000b\t\u0005=\u0014\u0011H\u0005\u0005\t3!)B\u0001\u0003US6,\u0007\"CA\u0019CB\u0005\t\u0019AA\u001b\u0011%\ti%\u0019I\u0001\u0002\u0004\t\t&A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%M\u000b\u0003\tGQC!a\u0007\u0003\u0006\u0005I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIM*\"\u0001\"\u000b+\t\r5(QA\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011A1\u0007\u0016\u0005\u0007\u007f\u0014)!A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$HeN\u000b\u0003\tsQC\u0001\"\u0005\u0003\u0006\u0005I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIa*\"\u0001b\u0010+\t\u0005U\"QA\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0011\u0015#\u0006BA)\u0005\u000b\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        boolean x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo2 = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo2.records.records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, x$1) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$1)));
        List expected = ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$2, x$3)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$52 = 9L;
        LocalLog x$6 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$6, x$52);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$4, x$5)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.readRecords$default$1();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LogFileUtils.logFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile = LogFileUtils.timeIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$2 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        long x$2 = 0L;
        int x$5 = config.initFileSize();
        boolean x$6 = config.preallocate;
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        segments.add(LogSegment$.MODULE$.open(dir, x$2, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$1) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$2, Option x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$4, Option x$5) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof KeyValue)) return false;
            if (((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() != this.kafka$log$LocalLogTest$KeyValue$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyValue keyValue = (KeyValue)x$1;
            String string = this.key();
            String string2 = keyValue.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.value();
            String string4 = keyValue.value();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!keyValue.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

