/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteIndexCache$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001\u0002\"D\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004\\\u0001\u0001\u0006I!\u0016\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0011\u0019\t\u0007\u0001)A\u0005=\"9!\r\u0001b\u0001\n\u0003i\u0006BB2\u0001A\u0003%a\fC\u0004e\u0001\t\u0007I\u0011A3\t\r9\u0004\u0001\u0015!\u0003g\u0011\u001dy\u0007A1A\u0005\u0002ADaa \u0001!\u0002\u0013\t\bbCA\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007A1\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014!Y\u0011q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0003\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%\t!a\t\t\u0017\u0005-\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0006\u0005\f\u0003c\u0001\u0001\u0019!A!B\u0013\t)\u0003C\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026!A\u00111\t\u0001!\u0002\u0013\t9\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002H!A\u0011q\n\u0001!\u0002\u0013\tI\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005-\u0004\u0001\"\u0001\u0002T!9\u0011Q\u000f\u0001\u0005\u0002\u0005M\u0003bBA@\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003\u0007\u0003A\u0011AA*\u0011\u001d\t9\t\u0001C\u0001\u0003'Bq!a#\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\u0010\u0002!\t!a\u0015\t\u000f\u0005M\u0005\u0001\"\u0001\u0002T!9\u0011q\u0013\u0001\u0005\u0002\u0005M\u0003bBAN\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003?\u0003A\u0011AA*\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a0\u0001\t\u0003\t\u0019\u0006C\u0004\u0002D\u0002!\t!a\u0015\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002T!9\u00111\u001a\u0001\u0005\u0002\u0005M\u0003bBAh\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003'\u0004A\u0011AA*\u0011\u001d\t9\u000e\u0001C\u0001\u0003'Bq!a7\u0001\t\u0013\ti\u000eC\u0004\u0003\u0006\u0001!IAa\u0002\t\u0013\t\u001d\u0002!%A\u0005\n\t%\u0002\"\u0003B \u0001E\u0005I\u0011\u0002B!\u0011%\u0011)\u0005AI\u0001\n\u0013\u00119\u0005C\u0004\u0003L\u0001!\t!a\u0015\t\u000f\t=\u0003\u0001\"\u0001\u0002T!9!1\u000b\u0001\u0005\u0002\u0005M\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\n\u0005c\u0002\u0011\u0013!C\u0005\u0005\u000fBqAa\u001d\u0001\t\u0003\t\u0019\u0006C\u0004\u0003x\u0001!\t!a\u0015\t\u000f\tm\u0004\u0001\"\u0001\u0002T!9!q\u0010\u0001\u0005\u0002\u0005M\u0003b\u0002BB\u0001\u0011\u0005\u00111\u000b\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005OCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003Z\u0002!IAa7\t\u000f\t}\u0007\u0001\"\u0001\u0002T!9!1\u001d\u0001\u0005\u0002\u0005M\u0003b\u0002Bt\u0001\u0011\u0005\u00111\u000b\u0005\b\u0005W\u0004A\u0011AA*\u0011\u001d\u0011y\u000f\u0001C\u0001\u0003'\u0012a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002E\u000b\u0006\u0019An\\4\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A)\u0011\u0005I\u0003Q\"A\"\u0002\tQLW.Z\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001,R\u0001\u0006kRLGn]\u0005\u00035^\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0010[\u0006D(k\u001c7m\u0013:$XM\u001d<bYV\ta\f\u0005\u0002K?&\u0011\u0001m\u0013\u0002\u0004\u0013:$\u0018\u0001E7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197!\u0003-i\u0017\r\u001f'pO\u0006;W-T:\u0002\u00195\f\u0007\u0010T8h\u0003\u001e,Wj\u001d\u0011\u0002\u00111|w\r\u0015:paN,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA!\u001e;jY*\t1.\u0001\u0003kCZ\f\u0017BA7i\u0005)\u0001&o\u001c9feRLWm]\u0001\nY><\u0007K]8qg\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003E\u0004\"A]?\u000e\u0003MT!\u0001\u0012;\u000b\u0005U4\u0018!C5oi\u0016\u0014h.\u00197t\u0015\t9\b0A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u0019K(B\u0001>|\u0003\u0019\t\u0007/Y2iK*\tA0A\u0002pe\u001eL!A`:\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u00051An\\4ESJ,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003k\u0003\tIw.\u0003\u0003\u0002\u0010\u0005%!\u0001\u0002$jY\u0016\f!\u0002\\8h\t&\u0014x\fJ3r)\u0011\t)\"a\u0007\u0011\u0007)\u000b9\"C\u0002\u0002\u001a-\u0013A!\u00168ji\"I\u0011QD\u0007\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u0013!\r\u0011\u0016qE\u0005\u0004\u0003S\u0019%A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fH\u0003BA\u000b\u0003_A\u0011\"!\b\u0011\u0003\u0003\u0005\r!!\n\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0005]\u0006lW-\u0006\u0002\u00028A!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>)\fA\u0001\\1oO&!\u0011\u0011IA\u001e\u0005\u0019\u0019FO]5oO\u0006)a.Y7fA\u0005Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\t\tI\u0005E\u0002K\u0003\u0017J1!!\u0014L\u0005\u0011auN\\4\u00025Y,'/\u001f'be\u001e,Gj\\4GYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005U\u0001f\u0001\f\u0002XA!\u0011\u0011LA4\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013aA1qS*!\u0011\u0011MA2\u0003\u001dQW\u000f]5uKJT1!!\u001a|\u0003\u0015QWO\\5u\u0013\u0011\tI'a\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r9\u0012q\u000e\t\u0005\u00033\n\t(\u0003\u0003\u0002t\u0005m#!C!gi\u0016\u0014X)Y2i\u00035!Xm\u001d;De\u0016\fG/\u001a'pO\"\u001a\u0001$!\u001f\u0011\t\u0005e\u00131P\u0005\u0005\u0003{\nYF\u0001\u0003UKN$\u0018\u0001\n;fgRD\u0015M\u001c3mS:<W\t_2faRLwN\\:EkJLgnZ*ikR$wn\u001e8)\u0007e\tI(\u0001\u001fuKN$8\t\\3b]NCW\u000f\u001e3po:4\u0015\u000e\\3XQ\u0016t7\u000b[;uI><hnQ1mY\u0016$')\u001a4pe\u0016\u001cF/\u0019:ukB\u001cu.\u001c9mKR,\u0007f\u0001\u000e\u0002z\u0005qB/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5J]Z\fG.\u001b3M_\u001e$\u0015N\u001d\u0015\u00047\u0005e\u0014a\b;fgR\u001c%/Z1uK2{wmV5uQ2{w\rR5s\r\u0006dGNY1dW\"\u001aA$!\u001f\u0002+Q,7\u000f^$fi:{g.\u0012=jgR,g\u000e\u001e'pO\"\u001aQ$!\u001f\u00025Q,7\u000f^\"mK\u0006tW\u000f]#ya&\u0014X\rZ*fO6,g\u000e^:)\u0007y\tI(A\u0011uKN$8\t\\3b]V\u00048+Z4nK:$8\u000fV8NC&tG/Y5o'&TX\rK\u0002 \u0003s\n!\u0006^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON<\u0016\u000e\u001e5D_6\u0004\u0018m\u0019;EK2,G/\u001a)pY&\u001c\u0017\u0010K\u0002!\u0003s\nA\u0005^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON<\u0016\u000e\u001e5D_6\u0004\u0018m\u0019;Q_2L7-\u001f\u0015\u0004C\u0005e\u0014a\u0005;fgR$u.Z:oi\u000ecW-\u00198M_\u001e\u001cH\u0003BA\u000b\u0003OCq!!+#\u0001\u0004\tY+\u0001\u0004q_2L7-\u001f\t\u0005\u0003[\u000bYL\u0004\u0003\u00020\u0006]\u0006cAAY\u00176\u0011\u00111\u0017\u0006\u0004\u0003k;\u0015A\u0002\u001fs_>$h(C\u0002\u0002:.\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003{S1!!/L\u0003I!Xm\u001d;US6,')Y:fI\u001acWo\u001d5)\u0007\r\nI(A\ruKN$H*Z1ti2{\u0017\rZ3e\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u0013\u0002z\u0005\u0001C/Z:u\u0019>\fG\rT8hgN[\u0017\u000e\u001d*f[>$X-\u00138eKb\u001c\u0015m\u00195fQ\r)\u0013\u0011P\u0001$i\u0016\u001cH\u000fV<p\u0019><W*\u00198bO\u0016\u00148/V:j]\u001e\u001c\u0016-\\3ESJ4\u0015-\u001b7tQ\r1\u0013\u0011P\u0001\u001di\u0016\u001cHo\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ssB{\u0017N\u001c;tQ\r9\u0013\u0011P\u0001.i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\b\u000e\u0016:bS2LgnZ*mCND\u0007f\u0001\u0015\u0002z\u0005\tD/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i%\u0016d\u0017\r^5wK\u0012K'/Z2u_JL\bfA\u0015\u0002z\u0005Ab/\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=\u0015\u0011\u0005U\u0011q\u001cB\u0001\u0005\u0007Aq!!9+\u0001\u0004\t\u0019/A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\t)/a<\u0002v:!\u0011q]Av\u001d\u0011\t\t,!;\n\u00031K1!!<L\u0003\u001d\u0001\u0018mY6bO\u0016LA!!=\u0002t\n\u00191+Z9\u000b\u0007\u000558\n\u0005\u0003\u0002x\u0006uXBAA}\u0015\r\tY\u0010_\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0018\u0011 \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\tC\u000ba\u0001\u0003KAq!!\u0001+\u0001\u0004\t)!\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feRA\u0011Q\u0005B\u0005\u0005\u001f\u0011\u0019\u0003C\u0005\u0003\f-\u0002\n\u00111\u0001\u0003\u000e\u00059An\\4ESJ\u001c\bCBAs\u0003_\f)\u0001C\u0005\u0003\u0012-\u0002\n\u00111\u0001\u0003\u0014\u0005\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\t\u0005\u0005+\u0011y\"\u0004\u0002\u0003\u0018)!!\u0011\u0004B\u000e\u0003!iW\r^1eCR\f'b\u0001B\u000f\u000b\u000611/\u001a:wKJLAA!\t\u0003\u0018\t\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\u0005\t\u0005KY\u0003\u0013!a\u0001=\u0006I\"/Z2pm\u0016\u0014\u0018\u0010\u00165sK\u0006$7\u000fU3s\t\u0006$\u0018\rR5s\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YC\u000b\u0003\u0003\u000e\t52F\u0001B\u0018!\u0011\u0011\tDa\u000f\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te2*\u0001\u0006b]:|G/\u0019;j_:LAA!\u0010\u00034\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\r#\u0006\u0002B\n\u0005[\t!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u0013+\u0007y\u0013i#\u0001\u0012uKN$h)\u001b7f%\u00164WM]3oG\u0016\u001c\u0018I\u001a;fe\u0006\u001b\u0018P\\2EK2,G/\u001a\u0015\u0004_\u0005e\u0014A\t;fgR\u001c%/Z1uK\u0006sG\rR3mKR,wJ^3sYfduN\\4U_BL7\rK\u00021\u0003s\n\u0011\u0005^3ti\u000eCWmY6q_&tGOR8s\u001f:d\u00170\u00114gK\u000e$X\r\u001a'pOND3!MA=\u0003\u001d\u0011X-\u00193M_\u001e$\u0002Ba\u0017\u0003b\t%$Q\u000e\t\u0004e\nu\u0013b\u0001B0g\nia)\u001a;dQ\u0012\u000bG/Y%oM>Da\u0001\u0012\u001aA\u0002\t\r\u0004c\u0001*\u0003f%\u0019!qM\"\u0003\u0015Us\u0017NZ5fI2{w\rC\u0004\u0003lI\u0002\r!!\u0013\u0002\r=4gm]3u\u0011!\u0011yG\rI\u0001\u0002\u0004q\u0016!C7bq2+gn\u001a;i\u0003E\u0011X-\u00193M_\u001e$C-\u001a4bk2$HeM\u0001&i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f+B$\u0017\r^3t\u0019><7i\u001c8gS\u001eD3\u0001NA=\u0003u!Xm\u001d;D_:4\u0017nZ\"iC:<WmR3ug\u000ecW-\u00198fIV\u0003\bfA\u001b\u0002z\u0005AC/Z:u\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\rR3mSZ,'/\u001a3U_\u0006cG\u000eT8hg\"\u001aa'!\u001f\u0002gQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKN#x\u000e]\"mK\u0006t\u0017N\\4JM\u000e{W\u000e]1di&\u001b(+Z7pm\u0016$\u0007fA\u001c\u0002z\u0005aC/Z:u\u0007>tg-[4DQ\u0006tw-Z:XSRDgj\u001c'pO\u001e+G\u000f^5oO&s\u0017\u000e^5bY&TX\r\u001a\u0015\u0004q\u0005e\u0014AE1qa\u0016tGMU3d_J$7\u000fV8M_\u001e$B\"!\u0006\u0003\f\n5%\u0011\u0013BK\u0005CCQaU\u001dA\u0002UCqAa$:\u0001\u0004\t)!\u0001\u0007qCJ,g\u000e\u001e'pO\u0012K'\u000f\u0003\u0004\u0003\u0014f\u0002\rAX\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0003\u0018f\u0002\rA!'\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b\u0003\u0002BN\u0005;k!Aa\u0007\n\t\t}%1\u0004\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biNDaAa):\u0001\u0004q\u0016AF3ya\u0016\u001cG/\u001a3TK\u001elWM\u001c;t!\u0016\u0014Hj\\4\u0002EY,'/\u001b4z%\u0016l\u0017-\u001b8j]\u001edunZ:U_J+7m\u001c<fe6+GO]5d)\u0019\t)B!+\u0003.\"9!1\u0016\u001eA\u0002\u0005\u0015\u0012!D:qs2{w-T1oC\u001e,'\u000fC\u0004\u00030j\u0002\rA!-\u0002\u001d\u0015D\b/Z2uK\u0012\u0004\u0016M]1ngB9!1\u0017B]\u0003WsVB\u0001B[\u0015\r\u00119lS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B^\u0005k\u00131!T1q\u0003\u00192XM]5gsJ+W.Y5oS:<7+Z4nK:$8\u000fV8SK\u000e|g/\u001a:NKR\u0014\u0018n\u0019\u000b\r\u0003+\u0011\tMa1\u0003F\n\u001d'q\u001b\u0005\b\u0005W[\u0004\u0019AA\u0013\u0011\u001d\u0011Ya\u000fa\u0001\u0005\u001bAaA!\n<\u0001\u0004q\u0006b\u0002Bew\u0001\u0007!1Z\u0001\b[>\u001c7.T1q!\u001d\u0011iMa5\u0002,zk!Aa4\u000b\u0007\tE\u0007.\u0001\u0006d_:\u001cWO\u001d:f]RLAA!6\u0003P\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\t\u000f\t=6\b1\u0001\u00032\u0006qb/\u001a:jMfdun\u001a*fG>4XM]'fiJL7m\u001d*f[>4X\r\u001a\u000b\u0005\u0003+\u0011i\u000eC\u0004\u0003,r\u0002\r!!\n\u0002-Q,7\u000f\u001e'pOJ+7m\u001c<feflU\r\u001e:jGND3!PA=\u0003Y\"Xm\u001d;M_\u001e\u0014VmY8wKJLX*\u001a;sS\u000e\u001c8\u000b[8vY\u0012\u0014UMU3n_Z,G-\u00114uKJdun\u001a*fG>4XM]3eQ\rq\u0014\u0011P\u00011i\u0016\u001cH/T3ue&\u001c7/\u0012=jgR<\u0006.\u001a8M_\u001eL5OU3de\u0016\fG/\u001a3CK\u001a|'/\u001a#fY\u0016$\u0018n\u001c8)\u0007}\nI(A\u0019uKN$X*\u001a;sS\u000e\u001c\u0018I]3SK6|g/\u001a3XQ\u0016tWj\u001c<j]\u001e\u001cUO\u001d:f]R$vNR;ukJ,Gj\\4)\u0007\u0001\u000bI(\u0001\ruKN$x+Y5u\r>\u0014\u0018\t\u001c7U_\u000e{W\u000e\u001d7fi\u0016D3!QA=\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        UnifiedLog log1 = qual$2.getOrCreateLog(topicPartition1, x$7, x$8, (Option)x$6);
        File logFile0 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        File logFile1 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-1").toString());
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        log1.takeProducerSnapshot();
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3())));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                this.$outer.logManager().startup((Set)Predef$.MODULE$.Set().empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(loadLogCalled)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.logManager().shutdown();
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$2, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        boolean x$22 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, x$22, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable & scala.Serializable containsLogFile = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$32, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$3)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((UnifiedLog)log, (long)(offset.elem + 1L), (int)this.readLog$default$3()).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset;
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((UnifiedLog)log, (long)(offset.elem + 1L), (int)this.readLog$default$3()).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        LogManager qual$1 = this.logManager();
        TopicPartition x$42 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$42, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size()), Iterable$.MODULE$.canBuildFrom());
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils$.MODULE$.tempDir();
        new File(logDir, RemoteIndexCache$.MODULE$.DirName()).mkdir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty());
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4(), TestUtils$.MODULE$.createLogManager$default$5(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$7 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$7, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = TestUtils$.MODULE$.createLogManager$default$4();
        MetadataVersion x$7 = TestUtils$.MODULE$.createLogManager$default$6();
        return TestUtils$.MODULE$.createLogManager(logDirs, x$1, configRepository, x$6, x$4, x$7, recoveryThreadsPerDataDir);
    }

    private Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$8)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$5, x$6, x$7).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach(arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        qual$2.asyncDelete(x$5, x$6, x$7);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$11, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, FetchIsolation.LOG_END, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = spyLogManager.getOrCreateLog$default$2();
        boolean x$7 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$6, x$7, (Option)x$5);
        log0.updateConfig(oldLogConfig);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = spyLogManager.getOrCreateLog$default$2();
        boolean x$11 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$10, x$11, (Option)x$9);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete);
        Assertions.assertTrue((boolean)log1.config().delete);
        Assertions.assertFalse((boolean)log0.config().compact);
        Assertions.assertFalse((boolean)log1.config().compact);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler(), (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs()), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17());
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Metric gauge = (Metric)x0$2._2();
            return var1_1;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)num -> num + 1, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> this.logConfig());
            long x$6 = 0L;
            long x$7 = 0L;
            int x$8 = 300000;
            ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(300000);
            int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$11 = mockTime.scheduler();
            LogDirFailureChannel x$14 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            boolean x$15 = false;
            None$ x$16 = None$.MODULE$;
            boolean x$17 = false;
            boolean x$19 = UnifiedLog$.MODULE$.apply$default$16();
            Option x$20 = UnifiedLog$.MODULE$.apply$default$17();
            LogOffsetsListener x$21 = UnifiedLog$.MODULE$.apply$default$18();
            return UnifiedLog$.MODULE$.apply(dir, config, x$6, x$7, (Scheduler)x$11, mockBrokerTopicStats, (Time)mockTime, x$8, x$9, x$10, x$14, x$15, (Option)x$16, x$17, (ConcurrentMap)mockMap, x$19, x$20, x$21);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$6, x$7).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$9 = None$.MODULE$;
        boolean x$10 = qual$3.getOrCreateLog$default$2();
        boolean x$11 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$10, x$11, (Option)x$9);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, x$6, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWaitForAllToComplete() {
        void waitForAllToComplete_callback;
        void waitForAllToComplete_jobs;
        void waitForAllToComplete_callback2;
        void waitForAllToComplete_jobs2;
        void waitForAllToComplete_callback3;
        void waitForAllToComplete_jobs3;
        void waitForAllToComplete_callback4;
        void waitForAllToComplete_jobs4;
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$12 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$12)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$13 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$14 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$14);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon2 = new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl = waitForAllToComplete_jobs4.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback4, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$15);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon3 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = waitForAllToComplete_jobs3.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback3, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$16 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$16);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon4 = new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl3 = waitForAllToComplete_jobs2.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback2, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$17 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$17);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon5 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl4 = waitForAllToComplete_jobs.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        UnifiedLog cfr_ignored_0 = (UnifiedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$3) {
        return x$3.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$8) {
        return x$8.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$9) {
        String string = x$9.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$9)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(logManagerClassName$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingLogsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metric = (MetricName)x0$1._1();
        String string = metric.getType();
        String string2 = String.valueOf(logManagerClassName$2);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metric.getName();
        String string4 = "remainingSegmentsToRecover";
        if (string3 == null) return false;
        if (!string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$12) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$14) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$15) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$16) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$17) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put("message.timestamp.difference.max.ms", Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

