/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.RequestLocal$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.RecordValidationException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r}f\u0001\u0002.\\\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nuD\u0011\"!\u0002\u0001\u0005\u0004%\t!a\u0002\t\u0011\u0005E\u0002\u0001)A\u0005\u0003\u0013A\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005E\u0003\u0001)A\u0005\u0003oAq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002t\u0001!\t!!\u0016\t\u000f\u0005]\u0004\u0001\"\u0001\u0002V!9\u00111\u0010\u0001\u0005\u0002\u0005U\u0003bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a/\u0001\t\u0013\ti\fC\u0004\u0002v\u0002!\t!!\u0016\t\u000f\u0005e\b\u0001\"\u0001\u0002V!9\u0011Q \u0001\u0005\n\u0005}\bb\u0002B\u0002\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003+BqAa\u0005\u0001\t\u0003\t)\u0006C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\tu\u0001\u0001\"\u0001\u0002V!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005w\u0001A\u0011AA+\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003+BqAa\u0011\u0001\t\u0013\u0011)\u0005C\u0004\u0003J\u0001!\t!!\u0016\t\u000f\t5\u0003\u0001\"\u0001\u0002V!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B,\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u00057\u0002A\u0011AA+\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqAa\u001a\u0001\t\u0003\t)\u0006C\u0004\u0003l\u0001!\t!!\u0016\t\u000f\t=\u0004\u0001\"\u0001\u0002V!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002B=\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005{\u0002A\u0011AA+\u0011\u001d\u0011\t\t\u0001C\u0001\u0003+BqA!\"\u0001\t\u0003\t)\u0006C\u0004\u0003\n\u0002!\t!!\u0016\t\u000f\t5\u0005\u0001\"\u0001\u0002V!9!\u0011\u0013\u0001\u0005\u0002\u0005U\u0003b\u0002BK\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u00053\u0003A\u0011AA+\u0011\u001d\u0011i\n\u0001C\u0001\u0003+BqA!)\u0001\t\u0003\t)\u0006C\u0004\u0003&\u0002!\t!!\u0016\t\u000f\t%\u0006\u0001\"\u0001\u0002V!9!Q\u0016\u0001\u0005\u0002\u0005U\u0003b\u0002BY\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005k\u0003A\u0011AA+\u0011\u001d\u0011I\f\u0001C\u0001\u0003+BqA!0\u0001\t\u0003\t)\u0006C\u0004\u0003B\u0002!\t!!\u0016\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002V!9!\u0011\u001a\u0001\u0005\u0002\u0005U\u0003b\u0002Bg\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005#\u0004A\u0011AA+\u0011\u001d\u0011)\u000e\u0001C\u0001\u0003+BqA!7\u0001\t\u0003\t)\u0006C\u0004\u0003^\u0002!\t!!\u0016\t\u000f\t\u0005\b\u0001\"\u0001\u0002V!9!Q\u001d\u0001\u0005\u0002\u0005U\u0003b\u0002Bu\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0005[\u0004A\u0011AA+\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003+BqA!>\u0001\t\u0003\t)\u0006C\u0004\u0003z\u0002!\t!!\u0016\t\u000f\tu\b\u0001\"\u0001\u0002V!91\u0011\u0001\u0001\u0005\u0002\u0005U\u0003bBB\u0003\u0001\u0011%1q\u0001\u0005\b\u0007#\u0001A\u0011BB\n\u0011%\u00199\u0003AI\u0001\n\u0013\u0019I\u0003C\u0004\u0004@\u0001!Ia!\u0011\t\u0013\r%\u0003!%A\u0005\n\r%\u0002\"CB&\u0001E\u0005I\u0011BB'\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'Bqaa\u0017\u0001\t\u0003\u0019i\u0006C\u0004\u0004f\u0001!Iaa\u001a\t\u000f\rM\u0004\u0001\"\u0003\u0004v!91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBJ\u0001\u0011\u00051Q\u0013\u0005\b\u0007C\u0003A\u0011ABR\u0005Aaun\u001a,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002];\u0006\u0019An\\4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A5\u0011\u0005)\u0004Q\"A.\u0002\tQLW.Z\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0006kRLGn\u001d\u0006\u0003eN\faaY8n[>t'B\u00010u\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001~!\tqx0D\u0001r\u0013\r\t\t!\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!D7fiJL7m]&fsN+G/\u0006\u0002\u0002\nA1\u00111BA\u000b\u00033i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019bY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\f\u0003\u001b\u00111aU3u!\u0011\tY\"!\f\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tAaY8sK*!\u00111EA\u0013\u0003\u001diW\r\u001e:jGNTA!a\n\u0002*\u00051\u00110Y7nKJT!!a\u000b\u0002\u0007\r|W.\u0003\u0003\u00020\u0005u!AC'fiJL7MT1nK\u0006qQ.\u001a;sS\u000e\u001c8*Z=TKR\u0004\u0013aD7fiJL7m\u001d*fG>\u0014H-\u001a:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0017rA!a\u000f\u0002H5\u0011\u0011Q\b\u0006\u00049\u0006}\"\u0002BA!\u0003\u0007\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005\u00153/A\u0004ti>\u0014\u0018mZ3\n\t\u0005%\u0013QH\u0001\r\u0019><g+\u00197jI\u0006$xN]\u0005\u0005\u0003\u001b\nyEA\bNKR\u0014\u0018nY:SK\u000e|'\u000fZ3s\u0015\u0011\tI%!\u0010\u0002!5,GO]5dgJ+7m\u001c:eKJ\u0004\u0013\u0001\u0005;fgR|e\u000e\\=P]\u0016\u0014\u0015\r^2i)\t\t9\u0006E\u0002c\u00033J1!a\u0017d\u0005\u0011)f.\u001b;)\u0007)\ty\u0006\u0005\u0003\u0002b\u0005=TBAA2\u0015\u0011\t)'a\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002j\u0005-\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003[2\u0018!\u00026v]&$\u0018\u0002BA9\u0003G\u0012A\u0001V3ti\u0006\u0019B/Z:u\u00032dwn^'vYRL')\u0019;dQ\"\u001a1\"a\u0018\u0002iQ,7\u000f\u001e,bY&$\u0017\r^5p]>3')\u0019;dQ\u0016\u001cx+\u001b;i\u001d>t7+Z9vK:$\u0018.\u00197J]:,'o\u00144gg\u0016$8\u000fK\u0002\r\u0003?\n\u0011\u0003^3ti6K7/T1uG\"l\u0015mZ5dQ\ri\u0011qL\u0001\u0012G\",7m[(oYf|e.\u001a\"bi\u000eDG\u0003CA,\u0003\u0007\u000bi)!(\t\u000f\u0005\u0015e\u00021\u0001\u0002\b\u0006)Q.Y4jGB\u0019!-!#\n\u0007\u0005-5M\u0001\u0003CsR,\u0007bBAH\u001d\u0001\u0007\u0011\u0011S\u0001\u0016g>,(oY3D_6\u0004(/Z:tS>tG+\u001f9f!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALc\u00061!/Z2pe\u0012LA!a'\u0002\u0016\ny1i\\7qe\u0016\u001c8/[8o)f\u0004X\rC\u0004\u0002 :\u0001\r!!%\u0002+Q\f'oZ3u\u0007>l\u0007O]3tg&|g\u000eV=qK\u0006!2\r[3dW\u0006cGn\\<Nk2$\u0018NQ1uG\"$\u0002\"a\u0016\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\b\u0003\u000b{\u0001\u0019AAD\u0011\u001d\tyi\u0004a\u0001\u0003#Cq!a(\u0010\u0001\u0004\t\t*\u0001\ndQ\u0016\u001c7.T5t[\u0006$8\r['bO&\u001cG\u0003CA,\u0003_\u000b\u0019,a.\t\u000f\u0005E\u0006\u00031\u0001\u0002\b\u0006Q!-\u0019;dQ6\u000bw-[2\t\u000f\u0005U\u0006\u00031\u0001\u0002\b\u0006Y!/Z2pe\u0012l\u0015mZ5d\u0011\u001d\tI\f\u0005a\u0001\u0003#\u000bqbY8naJ,7o]5p]RK\b/Z\u0001\u0011m\u0006d\u0017\u000eZ1uK6+7o]1hKN$\"\"a0\u0002f\u0006=\u0018\u0011_Az!\u0011\t\t-!9\u000f\t\u0005\r\u0017q\t\b\u0005\u0003\u000b\fyN\u0004\u0003\u0002H\u0006ug\u0002BAe\u00037tA!a3\u0002Z:!\u0011QZAl\u001d\u0011\ty-!6\u000e\u0005\u0005E'bAAj?\u00061AH]8pizJ\u0011a^\u0005\u0003kZL!A\u0018;\n\u0007\u0005\u00153/\u0003\u0003\u0002B\u0005\r\u0013b\u0001/\u0002@%!\u00111]A(\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdG\u000fC\u0004\u0002hF\u0001\r!!;\u0002\u000fI,7m\u001c:egB!\u00111SAv\u0013\u0011\ti/!&\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\t))\u0005a\u0001\u0003\u000fCq!a$\u0012\u0001\u0004\t\t\nC\u0004\u0002 F\u0001\r!!%\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004%\u0005}\u0013\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-JB3aEA0\u0003}\u0019\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003/\u0012\t\u0001C\u0004\u0002\u0006R\u0001\r!a\"\u0002IQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWmV5uQJ+7m\\7qe\u0016\u001c8/[8o-FB3!FA0\u0003\r\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:$B!a\u0016\u0003\f!9!Q\u0002\fA\u0002\u0005\u001d\u0015a\u0003;be\u001e,G/T1hS\u000e\fA\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tgK\r\u0015\u0004/\u0005}\u0013a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-FB3\u0001GA0\u0003\u0019\u001a\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRDw.\u001e;SK\u000e|W\u000e\u001d:fgNLwN\u001c\u000b\u0005\u0003/\u0012Y\u0002C\u0004\u0002\u0006f\u0001\r!a\"\u0002IQ,7\u000f^%om\u0006d\u0017\u000eZ(gMN,GOU1oO\u0016\fe\u000e\u001a*fG>\u0014HmQ8v]RD3AGA0\u0003\u0001\n7o]3si&sg/\u00197jI\n\u000bGo\u00195D_VtGo\u0014<feJLG-Z:\u0015\r\u0005]#Q\u0005B\u0018\u0011\u001d\u00119c\u0007a\u0001\u0005S\tq\u0002\\1ti>3gm]3u\t\u0016dG/\u0019\t\u0004E\n-\u0012b\u0001B\u0017G\n\u0019\u0011J\u001c;\t\u000f\tE2\u00041\u0001\u0003*\u0005)1m\\;oi\u0006)c/\u00197jI\u0006$XMU3d_J$')\u0019;dQ^KG\u000f[\"pk:$xJ^3se&$Wm\u001d\u000b\u0007\u0003/\u00129D!\u000f\t\u000f\t\u001dB\u00041\u0001\u0003*!9!\u0011\u0007\u000fA\u0002\t%\u0012a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-JB3!HA0\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\rq\u0012qL\u0001\u0013G\",7m\u001b(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002X\t\u001d\u0003bBAC?\u0001\u0007\u0011qQ\u0001\u0014i\u0016\u001cHOT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004A\u0005}\u0013a\u0005;fgR\u0014VmY8naJ,7o]5p]Z\u000b\u0004fA\u0011\u0002`\u0005\u00112\r[3dWJ+7m\\7qe\u0016\u001c8/[8o)\u0011\t9F!\u0016\t\u000f\u0005\u0015%\u00051\u0001\u0002\b\u0006\u0019B/Z:u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001a1%a\u0018\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{g+\r\u0015\u0004I\u0005}\u0013!I2iK\u000e\\7I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0012:p[Z\u0003D\u0003BA,\u0005GBqA!\u001a&\u0001\u0004\t9)A\u0004u_6\u000bw-[2\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gK\r\u0015\u0004M\u0005}\u0013\u0001\t;fgR\u001c%/Z1uKRKW.Z+q\u0007>tg/\u001a:tS>tg+\r+p-JB3aJA0\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002)\u0003?\nqb\u00195fG.\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003/\u00129\bC\u0004\u0002\u0006&\u0002\r!a\"\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0001\u0016\u0002`\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002,\u0003?\nA\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWMT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004Y\u0005}\u0013!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0017\u0002`\u0005\tC/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,7i\\7qe\u0016\u001c8/\u001a3We!\u001aa&a\u0018\u0002SQ,7\u000f^!cg>dW\u000f^3PM\u001a\u001cX\r^!tg&<g.\\3oi:{gnQ8naJ,7o]3eQ\ry\u0013qL\u0001'i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u0019\u0002`\u0005YC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u00022\u0003?\n1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004e\u0005}\u0013\u0001\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e^\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u001a\u0002`\u0005AC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3We!\u001aA'a\u0018\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-FruN\\\"p[B\u0014Xm]:fI\"\u001aQ'a\u0018\u0002qQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-JruN\\\"p[B\u0014Xm]:fI\"\u001aa'a\u0018\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-F\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004o\u0005}\u0013!\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-B\"vN\u0016\u001aD_6\u0004(/Z:tK\u0012D3\u0001OA0\u0003\u001d\"Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u00124%o\\7DY&,g\u000e^:)\u0007e\ny&A\u0010uKN$8i\u001c8ue>d'+Z2pe\u0012\u001chj\u001c;D_6\u0004(/Z:tK\u0012D3AOA0\u0003i\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WcQ{g\u000b\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002<\u0003?\nq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u000bDk\u001c,1\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001f\u0002`\u0005AD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,2)>4&GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA\u001f\u0002`\u0005)D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,2)>4&gQ8naJ,7o]3eQ\rq\u0014qL\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u000bdj\u001c8D_6\u0004(/Z:tK\u0012D3aPA0\u0003]\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g+M\"p[B\u0014Xm]:fI\"\u001a\u0001)a\u0018\u0002iQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\\(g)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\rK\u0002B\u0003?\n\u0011\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3\u0017\nZ3na>$XM\u001c;SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\rK\u0002C\u0003?\n!\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,1\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\r\u000by&A\u001cuKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tgK\r+p-B\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004\t\u0006}\u0013A\r;fgRtuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eS1t\u001b\u0016$(/[2t\u0019><w-\u001a3)\u0007\u0015\u000by&A\u0016uKN$8i\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\r1\u0015qL\u0001,i\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GmV5uQVs\u0017M^1jY\u0006\u0014G.Z%C!Z+'o]5p]\"\u001aq)a\u0018\u0002[Q,7\u000f^+oG>l\u0007O]3tg\u0016$')\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rK\u0002I\u0003?\nQ\u0006^3tiJ+7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\rI\u0015qL\u0001+i\u0016\u001cH/\u00138wC2LG\rV5nKN$\u0018-\u001c9Fq\u000e,\u0007\u000f^5p]\"\u000b7OQ1uG\"Le\u000eZ3yQ\rQ\u0015qL\u0001(i\u0016\u001cH/\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c%bg\n\u000bGo\u00195J]\u0012,\u0007\u0010K\u0002L\u0003?\na\u0006^3ti\n\u000bGo\u00195XSRD\u0017J\u001c<bY&$'+Z2pe\u0012\u001c\u0018I\u001c3J]Z\fG.\u001b3US6,7\u000f^1na\"\u001aA*a\u0018\u0002CQ,7\u000f\u001e\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3\u0015\r\u0005]3\u0011BB\u0007\u0011\u001d\u0019Y!\u0014a\u0001\u0003#\u000b\u0011c]8ve\u000e,7i\\7qe\u0016\u001c8/[8o\u0011\u001d\u0019y!\u0014a\u0001\u0003#\u000b\u0011\u0003^1sO\u0016$8i\\7qe\u0016\u001c8/[8o\u00035\u0019'/Z1uKJ+7m\u001c:egRA\u0011\u0011^B\u000b\u00073\u0019\u0019\u0003C\u0004\u0004\u00189\u0003\r!a\"\u0002\u00155\fw-[2WC2,X\rC\u0005\u0004\u001c9\u0003\n\u00111\u0001\u0004\u001e\u0005IA/[7fgR\fW\u000e\u001d\t\u0004E\u000e}\u0011bAB\u0011G\n!Aj\u001c8h\u0011\u001d\u0019)C\u0014a\u0001\u0003#\u000bQaY8eK\u000e\fqc\u0019:fCR,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r-\"\u0006BB\u000f\u0007[Y#aa\f\u0011\t\rE21H\u0007\u0003\u0007gQAa!\u000e\u00048\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007s\u0019\u0017AC1o]>$\u0018\r^5p]&!1QHB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001!GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\u0006\u0005\u0002j\u000e\r3QIB$\u0011\u001d\u00199\u0002\u0015a\u0001\u0003\u000fC\u0011ba\u0007Q!\u0003\u0005\ra!\b\t\u0013\r\u0015\u0002\u000b%AA\u0002\u0005E\u0015AK2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$C-\u001a4bk2$HEM\u0001+GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019yE\u000b\u0003\u0002\u0012\u000e5\u0012aF2sK\u0006$X\rV<p\u0005\u0006$8\r[3e%\u0016\u001cwN\u001d3t)!\tIo!\u0016\u0004X\re\u0003bBB\f'\u0002\u0007\u0011q\u0011\u0005\b\u00077\u0019\u0006\u0019AB\u000f\u0011\u001d\u0019)c\u0015a\u0001\u0003#\u000bAb\u00195fG.|eMZ:fiN$b!a\u0016\u0004`\r\u0005\u0004bBAt)\u0002\u0007\u0011\u0011\u001e\u0005\b\u0007G\"\u0006\u0019AB\u000f\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001%e\u0016\u001cwN\u001d3t/&$\bNT8o'\u0016\fX/\u001a8uS\u0006d\u0017J\u001c8fe>3gm]3ugRA\u0011\u0011^B5\u0007W\u001ay\u0007C\u0004\u0004\u0018U\u0003\r!a\"\t\u000f\r5T\u000b1\u0001\u0002\u0012\u0006Y1m\\7qe\u0016\u001c8/[8o\u0011\u001d\u0019\t(\u0016a\u0001\u0005S\t!B\\;n%\u0016\u001cwN\u001d3t\u0003q\u0011XmY8sIN<\u0016\u000e\u001e5J]Z\fG.\u001b3J]:,'/T1hS\u000e$\u0002\"!;\u0004x\rm4q\u0010\u0005\b\u0007s2\u0006\u0019AAD\u0003=\u0011\u0017\r^2i\u001b\u0006<\u0017n\u0019,bYV,\u0007bBB?-\u0002\u0007\u0011qQ\u0001\u0011e\u0016\u001cwN\u001d3NC\u001eL7MV1mk\u0016Dqa!\nW\u0001\u0004\t\t*A\fnCf\u0014Wm\u00115fG.\u0014\u0015m]3US6,7\u000f^1naR1\u0011qKBC\u0007\u0013Cqaa\"X\u0001\u0004\u0019i\"\u0001\u0005fqB,7\r^3e\u0011\u001d\u0019Yi\u0016a\u0001\u0007\u001b\u000bQAY1uG\"\u0004B!a%\u0004\u0010&!1\u0011SAK\u0005-\u0011VmY8sI\n\u000bGo\u00195\u0002+Y\fG.\u001b3bi\u0016dunZ!qa\u0016tG\rV5nKRA\u0011qKBL\u00077\u001by\nC\u0004\u0004\u001ab\u0003\ra!\b\u0002+\u0015D\b/Z2uK\u0012dunZ!qa\u0016tG\rV5nK\"91Q\u0014-A\u0002\ru\u0011!F3ya\u0016\u001cG/\u001a3CCN,G+[7fgR\fW\u000e\u001d\u0005\b\u0007\u0017C\u0006\u0019ABG\u0003m1XM]5gsJ+7m\u001c:e\u0007>tg/\u001a:tS>t7\u000b^1ugRQ\u0011qKBS\u0007_\u001b\u0019l!.\t\u000f\r\u001d\u0016\f1\u0001\u0004*\u0006)1\u000f^1ugB!\u00111SBV\u0013\u0011\u0019i+!&\u0003+I+7m\u001c:e\u0007>tg/\u001a:tS>t7\u000b^1ug\"91\u0011W-A\u0002\t%\u0012a\u00058v[\u000e{gN^3si\u0016$'+Z2pe\u0012\u001c\bbBAt3\u0002\u0007\u0011\u0011\u001e\u0005\b\u0007oK\u0006\u0019AB]\u0003)\u0019w.\u001c9sKN\u001cX\r\u001a\t\u0004E\u000em\u0016bAB_G\n9!i\\8mK\u0006t\u0007")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();
    private final LogValidator.MetricsRecorder metricsRecorder = UnifiedLog$.MODULE$.newValidatorMetricsRecorder(new BrokerTopicStats().allTopicsStats());

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    public LogValidator.MetricsRecorder metricsRecorder() {
        return this.metricsRecorder;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values())).foreach((Function1 & Serializable & scala.Serializable)version -> {
            this.testMessageValidation$1(version.value);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        MockTime mockTime = new MockTime(0L, 0L);
        return new LogValidator(records, this.topicPartition(), (Time)mockTime, sourceCompressionType, targetCompressionType, false, magic, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_3_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.NONE, CompressionType.NONE, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        Assertions.assertEquals((long)offsetCounter.value, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        int expectedMaxTimestampOffset = magic >= 2 ? 2 : 0;
        Assertions.assertEquals((long)expectedMaxTimestampOffset, (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(expectedMaxTimestampOffset).toString());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        MockTime mockTime = new MockTime();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, CompressionType.GZIP, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size may have been changed");
        RecordConversionStats stats = validatedResults.recordConversionStats;
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        MockTime mockTime = new MockTime();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), (Time)mockTime, CompressionType.GZIP, CompressionType.GZIP, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        long now = mockTime.milliseconds();
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        PrimitiveRef.LongRef offsetCounter = PrimitiveRef.ofLong((long)0L);
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, magic, TimestampType.CREATE_TIME, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(offsetCounter, this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, bl2, n3, i, arg_0));
        Assertions.assertEquals((long)i.elem, (long)offsetCounter.value);
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)1L, (long)validatingResults.shallowOffsetOfMaxTimestampMs, (String)"Offset of max timestamp should be 1");
        Assertions.assertFalse((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats, 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationResult validatingResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.GZIP, false, magic, TimestampType.CREATE_TIME, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatingResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestampMs, (String)"Offset of max timestamp should be 2");
        Assertions.assertTrue((boolean)validatingResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, toMagic, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)validatedResults.maxTimestampMs, (long)-1L, (String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        MemoryRecords records = this.createRecords(x$1, timestamp, x$2);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)timestamp, (long)validatedResults.maxTimestampMs);
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var5_8;
        int n;
        boolean bl;
        int n2;
        short s;
        long l;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        if (magic >= 2) {
            l = 1324L;
            s = (short)10;
            n2 = 984;
            bl = true;
            n = 40;
        } else {
            l = -1L;
            s = -1;
            n2 = -1;
            bl = false;
            n = -1;
        }
        int n3 = n;
        boolean bl2 = bl;
        int n4 = n2;
        short s2 = s;
        long producerId = l;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var5_8, (short)s2, (int)n4, (int)n3, (boolean)bl2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, magic, TimestampType.CREATE_TIME, 1000L, n3, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        MemoryRecords validatedRecords = validatedResults.validatedRecords;
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, s2, (long)var5_8, n4, n3, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatedResults.maxTimestampMs, (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestampMs, (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged, (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 1, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords;
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationResult validatedResults = new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier());
        this.checkOffsets(validatedResults.validatedRecords, offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats, 3, records, true);
    }

    @Test
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.NONE, false, 2, TimestampType.CREATE_TIME, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.SNAPPY, (boolean)false, (byte)2, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.COORDINATOR, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords.batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)2, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)1, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.NONE, (CompressionType)CompressionType.NONE, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(new LogValidator((MemoryRecords)records, (TopicPartition)this.topicPartition(), (Time)this.time(), (CompressionType)CompressionType.GZIP, (CompressionType)CompressionType.GZIP, (boolean)false, (byte)0, (TimestampType)TimestampType.CREATE_TIME, (long)5000L, (int)-1, (AppendOrigin)AppendOrigin.CLIENT, (MetadataVersion)MetadataVersion.latest()).validateMessagesAndAssignOffsets((PrimitiveRef.LongRef)PrimitiveRef.ofLong((long)((long)offset)), (LogValidator.MetricsRecorder)this.metricsRecorder(), (BufferSupplier)RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()).validatedRecords, offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 0, TimestampType.CREATE_TIME, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.GZIP, CompressionType.GZIP);
    }

    @Test
    public void testZStdCompressedWithUnavailableIBPVersion() {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        Assertions.assertThrows(UnsupportedCompressionTypeException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.NONE, CompressionType.ZSTD, false, 2, TimestampType.LOG_APPEND_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.IBP_2_0_IV1).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    @Test
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, CompressionType.NONE);
    }

    @Test
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed(CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), CompressionType.GZIP, CompressionType.GZIP, false, 1, TimestampType.CREATE_TIME, 1000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)0L), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)20);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(e.recordErrors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertFalse((boolean)e.recordErrors().isEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
    }

    /*
     * WARNING - void declaration
     */
    private void testBatchWithoutRecordsNotAllowed(CompressionType sourceCompression, CompressionType targetCompression) {
        void var4_8;
        int offset = 1234567;
        int n = 40;
        boolean bl = true;
        int n2 = 984;
        short s = (short)10;
        long producerId = 1324L;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)var4_8, (short)s, (int)n2, (long)0L, (long)5L, (int)n, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertThrows(InvalidRecordException.class, () -> new LogValidator(records, this.topicPartition(), this.time(), sourceCompression, targetCompression, false, 2, TimestampType.CREATE_TIME, 5000L, -1, AppendOrigin.CLIENT, MetadataVersion.latest()).validateMessagesAndAssignOffsets(PrimitiveRef.ofLong((long)offset), this.metricsRecorder(), RequestLocal$.MODULE$.withThreadConfinedCaching().bufferSupplier()));
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assertions.assertTrue((boolean)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty(), (String)"Message set should not be empty");
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType compression, int numRecords) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assertions.assertEquals((long)expected, (long)defaultRecordBatch.baseTimestamp(), (String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assertions.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((long)expectedLogAppendTime, (long)batch.maxTimestamp(), (String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assertions.assertNotNull((Object)stats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numConvertedRecords, (int)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assertions.assertTrue((stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString());
            Assertions.assertTrue((stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0, (String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString());
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assertions.assertTrue((tempBytes > (long)originalSize ? 1 : 0) != 0, (String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString());
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assertions.assertTrue((tempBytes > 0L ? 1 : 0) != 0, (String)"Temp bytes not updated");
            return;
        }
        Assertions.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP));
            return;
        }
        LogValidator.ValidationResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords), (Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(result.validatedRecords.records()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()), Iterable$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$1, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$1, (int)batch.baseSequence());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assertions.assertEquals((int)partitionLeaderEpoch$1, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$2, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$2, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$2, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$2, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assertions.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assertions.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$3, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$3, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$3, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$3, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assertions.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$4, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$4.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$4.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$6, Record entry) {
        Assertions.assertEquals((long)offset$6.elem, (long)entry.offset(), (String)"Unexpected offset in message set iterator");
        ++offset$6.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        return LegacyRecord.create((byte)recordMagicValue$1, (long)-1L, (byte[])Integer.toString(id).getBytes(), (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$3, IntRef offset$7, LegacyRecord record) {
        builder$3.appendUncheckedWithOffset((long)offset$7.elem, record);
        ++offset$7.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        record.ensureValid();
        Assertions.assertEquals((long)expectedLogAppendTime$1, (long)record.timestamp(), (String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString());
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

