/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001A\u0002\u0013E\u0001\bC\u0004F\u0001\u0001\u0007I\u0011\u0003$\t\r=\u0003\u0001\u0015)\u0003:\u0011\u0015\u0001\u0006\u0001\"\u00159\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0005_\"1\u0001\u0010\u0001Q\u0001\nADq!\u001f\u0001C\u0002\u0013%q\u000e\u0003\u0004{\u0001\u0001\u0006I\u0001\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"9Q\u0010\u0001b\u0001\n\u0013y\u0007B\u0002@\u0001A\u0003%\u0001\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!/\u0001\t\u0013\tY\fC\u0005\u0002f\u0002\t\n\u0011\"\u0003\u0002h\"9\u0011Q \u0001\u0005\n\u0005}\b\"\u0003B\t\u0001E\u0005I\u0011BAt\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003h\u0001!IA!\u001b\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013A%\u00117uKJ,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003W1\naa]3sm\u0016\u0014(\"A\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AK\u0005\u0003g)\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u0002'Q,7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003e\u0002\"AO\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\tYcH\u0003\u0002.\u007f)\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0013\t!5HA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003]!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n!QK\\5u\u0011\u001dq5!!AA\u0002e\n1\u0001\u001f\u00132\u0003Q!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g.A\u0003tKR,\u0006\u000f\u0006\u0002H'\")AK\u0002a\u0001+\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039\u0006\u000bQA[;oSRL!AX,\u0003\u0011Q+7\u000f^%oM>D#A\u00021\u0011\u0005Y\u000b\u0017B\u00012X\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0014g\u0006dG/\u001a3QCN\u001cxo\u001c:e\u0005f$Xm]\u000b\u0002KB\u0019\u0001J\u001a5\n\u0005\u001dL%!B!se\u0006L\bC\u0001%j\u0013\tQ\u0017J\u0001\u0003CsR,\u0017\u0001F:bYR,G\rU1tg^|'\u000f\u001a\"zi\u0016\u001c\b%A\u0005tC2$()\u001f;fg\u0006Q1/\u00197u\u0005f$Xm\u001d\u0011\u0002\u000bU\u001cXM]\u0019\u0016\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\t1\fgn\u001a\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(O\u0001\u0004TiJLgnZ\u0001\u0007kN,'/\r\u0011\u0002\u000bU\u001cXM\u001d\u001a\u0002\rU\u001cXM\u001d\u001a!\u0003\u0015)8/\u001a:4\u0003\u0019)8/\u001a:4A\u0005YQO\\6o_^tWk]3s\u00031)hn\u001b8po:,6/\u001a:!\u0003A!Xm\u001d;BYR,'OT8uQ&tw\rF\u0002H\u0003\u0007Aq!!\u0002\u0014\u0001\u0004\t9!\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007\u00136\u0011\u0011q\u0002\u0006\u0004\u0003#q\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016%\u000ba\u0001\u0015:fI\u00164\u0017bA<\u0002\u001a)\u0019\u0011QC%)\u000fM\ti\"!\f\u00020A!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\u001d\u0012,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\t\tCA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003c\t)$\t\u0002\u00024\u0005)1N]1gi\u0006\u0012\u0011qG\u0001\u0003u.DsaEA\u001e\u0003\u0007\n)\u0005\u0005\u0003\u0002>\u0005}RBAA\u0013\u0013\u0011\t\t%!\n\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA$\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001\u0018i\u0016\u001cH/\u00117uKJ\u001c\u0016-\\3UQ&tw\rV<jG\u0016$2aRA'\u0011\u001d\t)\u0001\u0006a\u0001\u0003\u000fAs\u0001FA\u000f\u0003[\t\t\u0006\f\u0003\u00022\u0005U\u0002f\u0002\u000b\u0002<\u0005\r\u0013QI\u0001\u0013i\u0016\u001cH/\u00117uKJ,U\u000e\u001d;z+N,'\u000fF\u0002H\u00033Bq!!\u0002\u0016\u0001\u0004\t9\u0001K\u0004\u0016\u0003;\ti#!\u0018-\t\u0005E\u0012Q\u0007\u0015\b+\u0005m\u00121IA#\u0003e!Xm\u001d;BYR,'/\u00168l]><h.T3dQ\u0006t\u0017n]7\u0015\u0007\u001d\u000b)\u0007C\u0004\u0002\u0006Y\u0001\r!a\u0002)\u000fY\ti\"!\f\u0002j1\"\u0011\u0011GA\u001bQ\u001d1\u00121HA\"\u0003\u000b\n\u0011\u0004^3ti\u0006cG/\u001a:U_>4Um^%uKJ\fG/[8ogR\u0019q)!\u001d\t\u000f\u0005\u0015q\u00031\u0001\u0002\b!:q#!\b\u0002.\u0005UD\u0006BA\u0019\u0003kAsaFA\u001e\u0003\u0007\n)%\u0001\u000euKN$\u0018\t\u001c;feR{w.T1os&#XM]1uS>t7\u000fF\u0002H\u0003{Bq!!\u0002\u0019\u0001\u0004\t9\u0001K\u0004\u0019\u0003;\ti#!!-\t\u0005E\u0012Q\u0007\u0015\b1\u0005m\u00121IA#\u0003\r\"Xm\u001d;EK2,G/Z*p[\u0016$\b.\u001b8h)\"\fG\u000fR8fg:{G/\u0012=jgR$2aRAE\u0011\u001d\t)!\u0007a\u0001\u0003\u000fAs!GA\u000f\u0003[\ti\t\f\u0003\u00022\u0005U\u0002fB\r\u0002<\u0005\r\u0013QI\u0001\u0017i\u0016\u001cH/\u00117uKJtu\u000e^\"p]R\u0014x\u000e\u001c7feR\tq\tK\u0002\u001b\u0003/\u00032AVAM\u0013\r\tYj\u0016\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$\u0018\t\u001c;fe\u0006sG\rR3tGJL'-\u001a\u000b\u0004\u000f\u0006\u0005\u0006bBA\u00037\u0001\u0007\u0011q\u0001\u0015\b7\u0005u\u0011QFASY\u0011\t\t$!\u000e)\u000fm\tY$a\u0011\u0002F\u0005IB/Z:u\u001b\u0016$\u0018\rZ1uCZ+'o]5p]R{w\u000eT8x)\r9\u0015Q\u0016\u0005\b\u0003\u000ba\u0002\u0019AA\u0004Q\u001da\u0012QDA\u0017\u0003cc#!a-\"\u0005\u0005U\u0016!D6sC\u001a$X&\u0013\"Q?NzF\u0007K\u0004\u001d\u0003w\t\u0019%!\u0012\u0002IM,g\u000eZ!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$b!!0\u0002L\u0006U\u0007\u0003BA`\u0003\u000fl!!!1\u000b\t\u0005\r\u0017QY\u0001\te\u0016\fX/Z:ug*\u0011AHP\u0005\u0005\u0003\u0013\f\tMA\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0004\u0002Nv\u0001\r!a4\u0002\u000fI,\u0017/^3tiB!\u0011qXAi\u0013\u0011\t\u0019.!1\u0003A\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0005\n\u0003/l\u0002\u0013!a\u0001\u00033\fAb]8dW\u0016$8+\u001a:wKJ\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?d\u0013a\u00028fi^|'o[\u0005\u0005\u0003G\fiN\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\u0018tK:$\u0017\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAAuU\u0011\tI.a;,\u0005\u00055\b\u0003BAx\u0003sl!!!=\u000b\t\u0005M\u0018Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a>J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\f\tPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqe]3oI\u0012+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR1!\u0011\u0001B\u0004\u0005\u001f\u0001B!a0\u0003\u0004%!!QAAa\u0005\u0011\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm\u001d9p]N,\u0007bBAg?\u0001\u0007!\u0011\u0002\t\u0005\u0003\u007f\u0013Y!\u0003\u0003\u0003\u000e\u0005\u0005'a\t#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0005\n\u0003/|\u0002\u0013!a\u0001\u00033\f\u0011g]3oI\u0012+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\u0012\"WMZ1vYR$#'A\u0011dQ\u0016\u001c7.\u00117m\u000bJ\u0014xN]:BYR,'/\u001b8h\u0007J,G-\u001a8uS\u0006d7\u000fF\u0004H\u0005/\u0011iE!\u0018\t\u000f\te\u0011\u00051\u0001\u0003\u001c\u0005q!/Z:vYR\u001cHk\\\"iK\u000e\\\u0007C\u0002B\u000f\u0005G\u00119#\u0004\u0002\u0003 )\u0019!\u0011\u0005;\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005K\u0011yB\u0001\u0003MSN$\b\u0003\u0002B\u0015\u0005\u000frAAa\u000b\u0003B9!!Q\u0006B\u001f\u001d\u0011\u0011yCa\u000f\u000f\t\tE\"\u0011\b\b\u0005\u0005g\u00119D\u0004\u0003\u0002\u000e\tU\u0012\"\u0001\"\n\u0005\u0001\u000b\u0015BA\u0017@\u0013\tad(\u0003\u0003\u0003@\u0005\u0015\u0017aB7fgN\fw-Z\u0005\u0005\u0005\u0007\u0012)%A\u0013BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rR1uC*!!qHAc\u0013\u0011\u0011IEa\u0013\u0003?\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgVdGO\u0003\u0003\u0003D\t\u0015\u0003b\u0002B(C\u0001\u0007!\u0011K\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0011\t\tM#\u0011L\u0007\u0003\u0005+RAAa\u0016\u0002F\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003\\\tU#AB#se>\u00148\u000fC\u0004\u0003`\u0005\u0002\r!a\u0002\u0002\u0015\r|g\u000e^3yi6\u001bx-\u0001\u0011dQ\u0016\u001c7NT8FeJ|'o]!mi\u0016\u0014\u0018N\\4De\u0016$WM\u001c;jC2\u001cHcA$\u0003f!9!\u0011\u0004\u0012A\u0002\tm\u0011AH2iK\u000e\\Wk]3s\u0003B\u0004X-\u0019:t\u0013:\fE\u000e^3s%\u0016\u001cX\u000f\u001c;t)\u00159%1\u000eB7\u0011\u001d\u0011Ib\ta\u0001\u00057AqAa\u001c$\u0001\u0004\t9!\u0001\u0003vg\u0016\u0014\u0018a\n3fg\u000e\u0014\u0018NY3BY2<\u0016\u000e\u001e5O_R{\u0007\u000fT3wK2,%O]8s\u0007>tg-\u001b:nK\u0012$\"A!\u0001\u0002S\rDWmY6O_R{\u0007\u000fT3wK2,%O]8s\t\u0016\u001c8M]5cS:<7I]3eK:$\u0018.\u00197t)\r9%\u0011\u0010\u0005\b\u0005w*\u0003\u0019\u0001B\u0001\u0003=\u0011Xm\u001d9p]N,Gk\\\"iK\u000e\\\u0017AG2iK\u000e\\Wk]3s\u0011\u0006\u001cHk^8De\u0016$WM\u001c;jC2\u001cH#B$\u0003\u0002\nM\u0005b\u0002B\rM\u0001\u0007!1\u0011\t\u0007\u0005;\u0011\u0019C!\"\u0011\t\t\u001d%Q\u0012\b\u0005\u0005W\u0011I)\u0003\u0003\u0003\f\n\u0015\u0013\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002BH\u0005#\u0013!\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3tk2$(\u0002\u0002BF\u0005\u000bBqAa\u001c'\u0001\u0004\t9!\u0001\u0017dQ\u0016\u001c7NR8s'&tw\r\\3TQ\u0006,\u0014GM%uKJ\fG/[8ogb\n\u0014HM\"sK\u0012,g\u000e^5bYR)qI!'\u0003\u001c\"9!\u0011D\u0014A\u0002\t\r\u0005b\u0002B8O\u0001\u0007\u0011qA\u0001\u0016G\",7m\u001b#fg\u000e\u0014\u0018NY3G_J,%O]8s)\u001d9%\u0011\u0015BR\u0005KCqA!\u0007)\u0001\u0004\u0011\u0019\tC\u0004\u0003p!\u0002\r!a\u0002\t\u000f\t=\u0003\u00061\u0001\u0003R\u0001")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latest();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String user3;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
            if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
                this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
            }
        } else {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        super.setUp(testInfo);
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String user3() {
        return this.user3;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion1})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion2, upsertion2}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletion1, deletion2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertion1, upsertion2}))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty})).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionEmpty, deletionEmpty})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionEmpty}))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user6 = "user6";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown6 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user6).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{deletionUnknown1, deletionValid1, deletionUnknown2})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionUnknown4, upsertionValid4, upsertionUnknown5, upsertionUnknown6}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(results).asScala()).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionTooFewIterations}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())}))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)3, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        this.checkUserAppearsInAlterResults(results1_1, this.user3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)3, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user3());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())}))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())}))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList((Object[])new DescribeUserScramCredentialsRequestData.UserName[]{new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())}))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user3());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user3()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        this.checkUserAppearsInAlterResults(results6, this.user3());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{upsertionMetadataVersionTooLow}))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IPB version");
        Assertions.assertEquals((Object)"The current metadata version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    /*
     * WARNING - void declaration
     */
    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        void var1_1;
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.sendDescribeUserScramCredentialsRequest$default$2());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return var1_1;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).exists((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 3 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.credentialInfos()).asScala()).exists((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.user3 = "user3@user3.com";
        this.unknownUser = "unknownUser";
    }
}

