/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.EOFException;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL, brokers=1)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0004\t\u00015A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\u0006\u0005\u00067\u0001!\t\u0001\b\u0005\u0006A\u0001!\t!\t\u0005\u0006Y\u0001!\t!\t\u0005\u0006u\u0001!\t!\t\u0005\u0006\u0001\u0002!I!\u0011\u0002\"\u0007>t7/^7fe\u001e\u0013x.\u001e9IK\u0006\u0014HOY3biJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0013)\taa]3sm\u0016\u0014(\"A\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011a#G\u0007\u0002/)\u0011\u0001DC\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001b/\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003;}\u0001\"A\b\u0001\u000e\u0003!AQ\u0001\u0006\u0002A\u0002U\tQ\u0006^3ti\u000e{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCRL5\u000fR5tC\ndW\r\u001a\"z\t\u00164\u0017-\u001e7u)\u0005\u0011\u0003CA\b$\u0013\t!\u0003C\u0001\u0003V]&$\bFA\u0002'!\t9#&D\u0001)\u0015\tIs#\u0001\u0006b]:|G/\u0019;j_:L!a\u000b\u0015\u0003\u0017\rcWo\u001d;feR+7\u000f^\u00012i\u0016\u001cHoQ8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r^%t\u0003\u000e\u001cWm]:jE2,w\u000b[3o\u000b:\f'\r\\3eQ\u0011!aEL\u0018\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cH&\u0001\u0019,\u000bE\"Tg\u000e\u001d\u0011\u0005\u001d\u0012\u0014BA\u001a)\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\u00051\u0014\u0001H;ogR\f'\r\\3/CBLgF^3sg&|gn\u001d\u0018f]\u0006\u0014G.Z\u0001\u0006m\u0006dW/Z\u0011\u0002s\u0005!AO];f\u0003\u0019#Xm\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u\u0013N\f5mY3tg&\u0014G.Z,iK:tUm^$s_V\u00048i\\8sI&t\u0017\r^8s\u0013N,e.\u00192mK\u0012DC!\u0002\u0014/y1\u0012\u0001'P\u0016\u0006cQrt\u0007O\u0011\u0002\u007f\u0005arM]8va:\u001awn\u001c:eS:\fGo\u001c:/]\u0016<h&\u001a8bE2,\u0017!E2p]:,7\r^!oIJ+7-Z5wKR\u0011!i\u0014\t\u0003\u00076k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u000f\"\u000baaY8n[>t'BA\u0006J\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\n\u00059#%AH\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;SKN\u0004xN\\:f\u0011\u0015\u0001f\u00011\u0001R\u0003\u001d\u0011X-];fgR\u0004\"a\u0011*\n\u0005M#%!H\"p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;SKF,Xm\u001d;)\t\u0001)vg\u0018\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000b1!\u00199j\u0015\tQ6,A\u0004kkBLG/\u001a:\u000b\u0005q[\u0015!\u00026v]&$\u0018B\u00010X\u0005\r!\u0016mZ\u0011\u0002A\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001!-\u001a4lYB\u0011qeY\u0005\u0003I\"\u00121c\u00117vgR,'\u000fV3ti\u0012+g-Y;miN\f1b\u00197vgR,'\u000fV=qK\u0012\nq-\u0003\u0002iS\u0006\u0019\u0011\t\u0014'\u000b\u0005)D\u0013\u0001\u0002+za\u0016\fqA\u0019:pW\u0016\u00148/H\u0001\u0002Q\u0011\u0001an\u000e;\u0011\u0005=\u0014X\"\u00019\u000b\u0005E<\u0016!C3yi\u0016t7/[8o\u0013\t\u0019\bO\u0001\u0006FqR,g\u000eZ,ji\"d\u0013!^\u0012\u0002mB\u0011q/_\u0007\u0002q*\u0011AlF\u0005\u0003ub\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f\u000b\u0003\u0001y^z\bC\u0001,~\u0013\tqxKA\u0004US6,w.\u001e;\u001f\u0003a\u0004")
public class ConsumerGroupHeartbeatRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testConsumerGroupHeartbeatIsDisabledByDefault() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        Assertions.assertThrows(EOFException.class, () -> this.connectAndReceive(consumerGroupHeartbeatRequest));
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})
    public void testConsumerGroupHeartbeatIsAccessibleWhenEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true"), @ClusterConfigProperty(key="group.coordinator.new.enable", value="true")})
    public void testConsumerGroupHeartbeatIsAccessibleWhenNewGroupCoordinatorIsEnabled() {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData()).build();
        ConsumerGroupHeartbeatResponse consumerGroupHeartbeatResponse = this.connectAndReceive(consumerGroupHeartbeatRequest);
        Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNSUPPORTED_VERSION.code()), (Object)consumerGroupHeartbeatResponse.data());
    }

    private ConsumerGroupHeartbeatResponse connectAndReceive(ConsumerGroupHeartbeatRequest request) {
        return (ConsumerGroupHeartbeatResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public ConsumerGroupHeartbeatRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

