/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I2Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u00013!)\u0001\u0007\u0001C\u00013\tIb)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",G+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011\u0001C\u0001\ni\u0016\u001cH/R7qif$\u0012A\u0007\t\u0003\u001fmI!\u0001\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0001\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002$I\u00059!.\u001e9ji\u0016\u0014(BA\u0013'\u0003\u0015QWO\\5u\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\t\u0002\u0005)\u0016\u001cH/\u0001\u0015uKN$X\u000b\u001d3bi\u0016|%\u000f\u00165s_^4\u0015-\u001b7fI\u0012+X\rV8J]Z\fG.\u001b3Fa>\u001c\u0007\u000e\u000b\u0002\u0004=\u0005YC/Z:u+B$\u0017\r^3PeRC'o\\<GC&dW\r\u001a#vKR{\u0017J\u001c<bY&$g)Z1ukJ,7\u000f\u000b\u0002\u0005=\u0005AB/Z:u+B$\u0017\r^3PeRC'o\\<Tk\u000e\u001cWm]:)\u0005\u0015q\u0012!\u0003;fgR\u001cE.Z1sQ\t1a\u0004")
public class FinalizedFeatureCacheTest {
    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, BrokerFeatures$.MODULE$.createDefault(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4()).getFeatureOption().isEmpty());
    }

    @Test
    public void testUpdateOrThrowFailedDueToInvalidEpoch() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        cache.updateFeaturesOrThrow(finalizedFeatures, 10L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).features());
        Assertions.assertEquals((long)10L, (long)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).epoch());
        Assertions.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateFeaturesOrThrow(finalizedFeatures, 9L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).features());
        Assertions.assertEquals((long)10L, (long)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).epoch());
    }

    @Test
    public void testUpdateOrThrowFailedDueToInvalidFeatures() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 1))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)2))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateFeaturesOrThrow(finalizedFeatures, 12L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }

    @Test
    public void testUpdateOrThrowSuccess() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        cache.updateFeaturesOrThrow(finalizedFeatures, 12L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).features());
        Assertions.assertEquals((long)12L, (long)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).epoch());
    }

    @Test
    public void testClear() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)supportedFeatures).asJava())));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, ZkMetadataCache$.MODULE$.$lessinit$greater$default$4());
        cache.updateFeaturesOrThrow(finalizedFeatures, 12L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals((Object)finalizedFeatures, (Object)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).features());
        Assertions.assertEquals((long)12L, (long)((FinalizedFeaturesAndEpoch)cache.getFeatureOption().get()).epoch());
        cache.clearFeatures();
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }
}

