/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.Mockito;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004>\u0001\u0001\u0006IA\r\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019\u0019\u0005\u0001)A\u0005\u0001\"9A\t\u0001b\u0001\n\u0003y\u0004BB#\u0001A\u0003%\u0001\tC\u0004G\u0001\t\u0007I\u0011A \t\r\u001d\u0003\u0001\u0015!\u0003A\u0011\u001dA\u0005A1A\u0005\u0002}Ba!\u0013\u0001!\u0002\u0013\u0001\u0005b\u0002&\u0001\u0005\u0004%\ta\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002'\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0003\t\u0006\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0001\\\u0011%\t\u0007\u00011A\u0001B\u0003&!\u000bC\u0005c\u0001\u0001\u0007\t\u0019!C\u0001G\"Iq\r\u0001a\u0001\u0002\u0004%\t\u0001\u001b\u0005\nU\u0002\u0001\r\u0011!Q!\n\u0011Dqa\u001b\u0001A\u0002\u0013\u0005A\u000eC\u0004q\u0001\u0001\u0007I\u0011A9\t\rM\u0004\u0001\u0015)\u0003n\u0011\u0015!\b\u0001\"\u0001v\u0011\u0019\t\u0019\u0001\u0001C\u0001k\"1\u0011Q\u0002\u0001\u0005\u0002UDa!!\u0005\u0001\t\u0003)\bBBA\u000b\u0001\u0011\u0005Q\u000f\u0003\u0004\u0002\u001a\u0001!\t!\u001e\u0005\u0007\u0003;\u0001A\u0011A;\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\tA\"+Z7pi\u0016dU-\u00193fe\u0016sG\rU8j]R$Vm\u001d;\u000b\u0005\u0005\u0012\u0013AB:feZ,'OC\u0001$\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t\u0001%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003I\u0002\"aM\u001e\u000e\u0003QR!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\t\u0019sG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f5\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.F\u0001A!\t9\u0013)\u0003\u0002CQ\t\u0019\u0011J\u001c;\u0002'\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u001d1|wm\u0015;beR|eMZ:fi\u0006yAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b%A\nm_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G/\u0001\u000bm_\u000e\fG\u000eT8h'R\f'\u000f^(gMN,G\u000fI\u0001\rY><WI\u001c3PM\u001a\u001cX\r^\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tA\n\u0005\u00020\u001b&\u0011a\n\t\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u00042m_\u000e\\\u0017N\\4TK:$W#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001B;uS2T!a\u0016\u0011\u0002\u000b\u0015\u0004xn\u00195\n\u0005e#&AE'pG.\u0014En\\2lS:<7+\u001a8eKJ\f\u0001C\u00197pG.LgnZ*f]\u0012|F%Z9\u0015\u0005q{\u0006CA\u0014^\u0013\tq\u0006F\u0001\u0003V]&$\bb\u00021\u0010\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014!\u00042m_\u000e\\\u0017N\\4TK:$\u0007%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005!\u0007CA\u0018f\u0013\t1\u0007E\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019\u0015tG\rU8j]R|F%Z9\u0015\u0005qK\u0007b\u00021\u0013\u0003\u0003\u0005\r\u0001Z\u0001\nK:$\u0007k\\5oi\u0002\n!cY;se\u0016tGO\u0011:pW\u0016\u0014X\t]8dQV\tQ\u000e\u0005\u0002(]&\u0011q\u000e\u000b\u0002\u0005\u0019>tw-\u0001\fdkJ\u0014XM\u001c;Ce>\\WM]#q_\u000eDw\fJ3r)\ta&\u000fC\u0004a+\u0005\u0005\t\u0019A7\u0002'\r,(O]3oi\n\u0013xn[3s\u000bB|7\r\u001b\u0011\u0002\u000bM,G/\u00169\u0015\u0003qC#aF<\u0011\u0005a|X\"A=\u000b\u0005i\\\u0018aA1qS*\u0011A0`\u0001\bUV\u0004\u0018\u000e^3s\u0015\tq\u0018(A\u0003kk:LG/C\u0002\u0002\u0002e\u0014!BQ3g_J,W)Y2i\u0003U!Xm\u001d;GKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKRD3\u0001GA\u0004!\rA\u0018\u0011B\u0005\u0004\u0003\u0017I(\u0001\u0002+fgR\fq\u0003^3ti\u001a+Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;)\u0007e\t9!\u0001\u000fuKN$h)\u001a;dQ\u0016\u000b'\u000f\\5fgRdunY1m\u001f\u001a47/\u001a;)\u0007i\t9!\u0001\ruKN$h)\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiND3aGA\u0004\u0003\u0011\"Xm\u001d;UQJ|wo\u001d$f]\u000e,G\rT3bI\u0016\u0014X\t]8dQ\u0016C8-\u001a9uS>t\u0007f\u0001\u000f\u0002\b\u0005)C/Z:u)\"\u0014xn^:V].twn\u001e8MK\u0006$WM]#q_\u000eDW\t_2faRLwN\u001c\u0015\u0004;\u0005\u001d\u0011a\u0006;fgR\u0014%o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s)\ra\u0016Q\u0005\u0005\b\u0003Oq\u0002\u0019AA\u0015\u0003\u001d1XM]:j_:\u00042aJA\u0016\u0013\r\ti\u0003\u000b\u0002\u0006'\"|'\u000f\u001e\u0015\b=\u0005E\u0012\u0011IA\"!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t!\"\u00198o_R\fG/[8o\u0015\r\tY\u0004N\u0001\u0006kRLGn]\u0005\u0005\u0003\u007f\t)D\u0001\u000bBa&\\U-\u001f,feNLwN\\:T_V\u00148-Z\u0001\u0007CBL7*Z=%\u0005\u0005\u0015\u0013\u0002BA$\u0003\u0013\nQAR#U\u0007\"SA!a\u0013\u0002N\u00059\u0011\t]5LKf\u001c(bAA(i\u0005A\u0001O]8u_\u000e|G\u000eK\u0002\u001f\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033Z\u0018A\u00029be\u0006l7/\u0003\u0003\u0002^\u0005]#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0002")
public class RemoteLeaderEndPointTest {
    private final TopicPartition topicPartition = new TopicPartition("test", 0);
    private final int currentLeaderEpoch;
    private final int logStartOffset;
    private final int localLogStartOffset;
    private final int logEndOffset;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private MockBlockingSender blockingSend;
    private LeaderEndPoint endPoint;
    private long currentBrokerEpoch = 1L;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    public int logStartOffset() {
        return this.logStartOffset;
    }

    public int localLogStartOffset() {
        return this.localLogStartOffset;
    }

    public int logEndOffset() {
        return this.logEndOffset;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public MockBlockingSender blockingSend() {
        return this.blockingSend;
    }

    public void blockingSend_$eq(MockBlockingSender x$1) {
        this.blockingSend = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public long currentBrokerEpoch() {
        return this.currentBrokerEpoch;
    }

    public void currentBrokerEpoch_$eq(long x$1) {
        this.currentBrokerEpoch = x$1;
    }

    @BeforeEach
    public void setUp() {
        MockTime time = new MockTime();
        String logPrefix = "remote-leader-endpoint";
        BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
        int x$1 = sourceBroker.id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = sourceBroker.port();
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(new LogContext(logPrefix), sourceBroker.id());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.blockingSend_$eq(new MockBlockingSender(new HashMap<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>(), sourceBroker, (Time)time));
        this.endPoint_$eq((LeaderEndPoint)new RemoteLeaderEndPoint(logPrefix, (BlockingSend)this.blockingSend(), fetchSessionHandler, config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.MINIMUM_KRAFT_VERSION, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentBrokerEpoch()));
    }

    @Test
    public void testFetchLatestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(7).setOffset((long)this.logEndOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logEndOffset(), 7), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(5).setOffset((long)this.logStartOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.logStartOffset(), 5), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setLeaderEpoch(6).setOffset((long)this.localLogStartOffset()))}))));
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)this.localLogStartOffset(), 6), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch()));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset((long)this.logEndOffset()))}));
        this.blockingSend().setOffsetsForNextResponse((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(expected).asJava());
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(this.currentLeaderEpoch()))})));
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testThrowsFencedLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.FENCED_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
        Assertions.assertThrows(FencedLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() - 1));
    }

    @Test
    public void testThrowsUnknownLeaderEpochException() {
        this.blockingSend().setListOffsetsDataForNextResponse((Map<TopicPartition, ListOffsetsResponseData.ListOffsetsPartitionResponse>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.UNKNOWN_LEADER_EPOCH.code()))}))));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchEarliestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
        Assertions.assertThrows(UnknownLeaderEpochException.class, () -> this.endPoint().fetchLatestOffset(this.topicPartition(), this.currentLeaderEpoch() + 1));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testBrokerEpochSupplier(short version) {
        void var12_12;
        void var11_11;
        void var8_8;
        void var7_7;
        TopicPartition tp = new TopicPartition("topic1", 0);
        Uuid topicId1 = Uuid.randomUuid();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Map partitionMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new PartitionFetchState((Option)new Some((Object)topicId1), 150L, (Option)None$.MODULE$, 0, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        Mockito.when((Object)this.replicaManager().localLogOrException(tp)).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)1L));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = this.endPoint().buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var7_7;
        Assertions.assertTrue((boolean)var8_8.isEmpty());
        Assertions.assertEquals((long)(version < 15 ? -1L : 1L), (long)((AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get()).fetchRequest().build(version).replicaEpoch());
        this.currentBrokerEpoch_$eq(2L);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = this.endPoint().buildFetch(partitionMap);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option newFetchRequestOpt = (Option)resultWithPartitions2.result();
        Set newPartitionsWithError = resultWithPartitions2.partitionsWithError();
        void newFetchRequestOpt2 = var11_11;
        Assertions.assertTrue((boolean)var12_12.isEmpty());
        Assertions.assertEquals((long)(version < 15 ? -1L : 2L), (long)((AbstractFetcherThread.ReplicaFetch)newFetchRequestOpt2.get()).fetchRequest().build(version).replicaEpoch());
    }

    public RemoteLeaderEndPointTest() {
        this.currentLeaderEpoch = 10;
        this.logStartOffset = 20;
        this.localLogStartOffset = 100;
        this.logEndOffset = 300;
    }
}

