/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AclAuthorizer$ {
    public static AclAuthorizer$ MODULE$;
    private final String configPrefix;
    private final String ZkUrlProp;
    private final String ZkConnectionTimeOutProp;
    private final String ZkSessionTimeOutProp;
    private final String ZkMaxInFlightRequests;
    private final String SuperUsersProp;
    private final String AllowEveryoneIfNoAclIsFoundProp;
    private final AclAuthorizer.VersionedAcls NoAcls;
    private final String WildcardHost;

    static {
        new AclAuthorizer$();
    }

    public String configPrefix() {
        return this.configPrefix;
    }

    public String ZkUrlProp() {
        return this.ZkUrlProp;
    }

    public String ZkConnectionTimeOutProp() {
        return this.ZkConnectionTimeOutProp;
    }

    public String ZkSessionTimeOutProp() {
        return this.ZkSessionTimeOutProp;
    }

    public String ZkMaxInFlightRequests() {
        return this.ZkMaxInFlightRequests;
    }

    public String SuperUsersProp() {
        return this.SuperUsersProp;
    }

    public String AllowEveryoneIfNoAclIsFoundProp() {
        return this.AllowEveryoneIfNoAclIsFoundProp;
    }

    public AclAuthorizer.VersionedAcls NoAcls() {
        return this.NoAcls;
    }

    public String WildcardHost() {
        return this.WildcardHost;
    }

    /*
     * WARNING - void declaration
     */
    public ZKClientConfig zkClientConfigFromKafkaConfigAndMap(KafkaConfig kafkaConfig, scala.collection.mutable.Map<String, ?> configMap) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        if (!new StringOps(Predef$.MODULE$.augmentString((String)configMap.get((Object)new StringBuilder(0).append(this.configPrefix()).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Boolean.toString(kafkaConfig.zkSslClientEnable())))).toBoolean()) {
            return new ZKClientConfig();
        }
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(kafkaConfig, true);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(kafkaProp, sysProp) -> {
            AclAuthorizer$.$anonfun$zkClientConfigFromKafkaConfigAndMap$3(configMap, zkClientConfig, kafkaProp, sysProp);
            return BoxedUnit.UNIT;
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    public void kafka$security$authorizer$AclAuthorizer$$validateAclBinding(AclBinding aclBinding) {
        if (aclBinding.isUnknown()) {
            throw new IllegalArgumentException("ACL binding contains unknown elements");
        }
        if (aclBinding.pattern().name().contains("/")) {
            throw new IllegalArgumentException(new StringBuilder(44).append("ACL binding contains invalid resource name: ").append(aclBinding.pattern().name()).toString());
        }
    }

    public void loadAllAcls(KafkaZkClient zkClient, Logging logger, Function2<ResourcePattern, AclAuthorizer.VersionedAcls, BoxedUnit> aclConsumer) {
        ZkAclStore$.MODULE$.stores().foreach((Function1 & Serializable & scala.Serializable)store -> {
            zkClient.getResourceTypes(store.patternType()).foreach((Function1 & Serializable & scala.Serializable)rType -> {
                Try $anonfun$loadAllAcls$2_resourceType = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SecurityUtils.resourceType((String)rType));
                if ($anonfun$loadAllAcls$2_resourceType instanceof Success) {
                    ResourceType $anonfun$loadAllAcls$2_resourceTypeObj = (ResourceType)((Success)$anonfun$loadAllAcls$2_resourceType).value();
                    zkClient.getResourceNames(store.patternType(), $anonfun$loadAllAcls$2_resourceTypeObj).foreach((Function1 & Serializable & scala.Serializable)resourceName -> {
                        ResourcePattern $anonfun$loadAllAcls$4_resource = new ResourcePattern(resourceTypeObj, resourceName, store.patternType());
                        AclAuthorizer.VersionedAcls $anonfun$loadAllAcls$4_versionedAcls = MODULE$.getAclsFromZk(zkClient, $anonfun$loadAllAcls$4_resource);
                        aclConsumer.apply((Object)$anonfun$loadAllAcls$4_resource, (Object)$anonfun$loadAllAcls$4_versionedAcls);
                        return BoxedUnit.UNIT;
                    });
                } else if ($anonfun$loadAllAcls$2_resourceType instanceof Failure) {
                    logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Ignoring unknown ResourceType: ").append((String)rType).toString());
                } else {
                    throw new MatchError((Object)$anonfun$loadAllAcls$2_resourceType);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public AclAuthorizer.VersionedAcls getAclsFromZk(KafkaZkClient zkClient, ResourcePattern resource) {
        return zkClient.getVersionedAclsForResource(resource);
    }

    public static final /* synthetic */ void $anonfun$zkClientConfigFromKafkaConfigAndMap$4(ZKClientConfig zkClientConfig$1, String sysProp$1, String kafkaProp$1, Object prefixedValue) {
        String string;
        String string2 = kafkaProp$1;
        String string3 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String string4 = prefixedValue.toString().toUpperCase();
            String string5 = "HTTPS";
            string = Boolean.toString(string4 != null && string4.equals(string5));
        } else {
            string = prefixedValue.toString();
        }
        zkClientConfig$1.setProperty(sysProp$1, string);
    }

    public static final /* synthetic */ void $anonfun$zkClientConfigFromKafkaConfigAndMap$3(scala.collection.mutable.Map configMap$1, ZKClientConfig zkClientConfig$1, String kafkaProp, String sysProp) {
        configMap$1.get((Object)new StringBuilder(0).append(MODULE$.configPrefix()).append(kafkaProp).toString()).foreach((Function1 & Serializable & scala.Serializable)prefixedValue -> {
            AclAuthorizer$.$anonfun$zkClientConfigFromKafkaConfigAndMap$4(zkClientConfig$1, sysProp, kafkaProp, prefixedValue);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$4(ResourceType resourceTypeObj$1, ZkAclStore store$1, KafkaZkClient zkClient$1, Function2 aclConsumer$1, String resourceName) {
        ResourcePattern resource = new ResourcePattern(resourceTypeObj$1, resourceName, store$1.patternType());
        AclAuthorizer.VersionedAcls versionedAcls = MODULE$.getAclsFromZk(zkClient$1, resource);
        aclConsumer$1.apply((Object)resource, (Object)versionedAcls);
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$2(KafkaZkClient zkClient$1, ZkAclStore store$1, Function2 aclConsumer$1, Logging logger$1, String rType) {
        Try resourceType = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SecurityUtils.resourceType((String)rType));
        if (resourceType instanceof Success) {
            ResourceType resourceTypeObj = (ResourceType)((Success)resourceType).value();
            zkClient$1.getResourceNames(store$1.patternType(), resourceTypeObj).foreach((Function1 & Serializable & scala.Serializable)resourceName -> {
                ResourcePattern $anonfun$loadAllAcls$4_resource = new ResourcePattern(resourceTypeObj, resourceName, store.patternType());
                AclAuthorizer.VersionedAcls $anonfun$loadAllAcls$4_versionedAcls = MODULE$.getAclsFromZk(zkClient, $anonfun$loadAllAcls$4_resource);
                aclConsumer.apply((Object)$anonfun$loadAllAcls$4_resource, (Object)$anonfun$loadAllAcls$4_versionedAcls);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (resourceType instanceof Failure) {
            logger$1.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Ignoring unknown ResourceType: ").append((String)rType).toString());
            return;
        }
        throw new MatchError((Object)resourceType);
    }

    public static final /* synthetic */ void $anonfun$loadAllAcls$1(KafkaZkClient zkClient$1, Function2 aclConsumer$1, Logging logger$1, ZkAclStore store) {
        zkClient$1.getResourceTypes(store.patternType()).foreach((Function1 & Serializable & scala.Serializable)rType -> {
            Try $anonfun$loadAllAcls$2_resourceType = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SecurityUtils.resourceType((String)rType));
            if ($anonfun$loadAllAcls$2_resourceType instanceof Success) {
                ResourceType $anonfun$loadAllAcls$2_resourceTypeObj = (ResourceType)((Success)$anonfun$loadAllAcls$2_resourceType).value();
                zkClient.getResourceNames(store.patternType(), $anonfun$loadAllAcls$2_resourceTypeObj).foreach((Function1 & Serializable & scala.Serializable)resourceName -> {
                    ResourcePattern $anonfun$loadAllAcls$4_resource = new ResourcePattern(resourceTypeObj, resourceName, store.patternType());
                    AclAuthorizer.VersionedAcls $anonfun$loadAllAcls$4_versionedAcls = MODULE$.getAclsFromZk(zkClient, $anonfun$loadAllAcls$4_resource);
                    aclConsumer.apply((Object)$anonfun$loadAllAcls$4_resource, (Object)$anonfun$loadAllAcls$4_versionedAcls);
                    return BoxedUnit.UNIT;
                });
            } else if ($anonfun$loadAllAcls$2_resourceType instanceof Failure) {
                logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Ignoring unknown ResourceType: ").append((String)rType).toString());
            } else {
                throw new MatchError((Object)$anonfun$loadAllAcls$2_resourceType);
            }
            return BoxedUnit.UNIT;
        });
    }

    private AclAuthorizer$() {
        MODULE$ = this;
        this.configPrefix = "authorizer.";
        this.ZkUrlProp = new StringBuilder(13).append(this.configPrefix()).append("zookeeper.url").toString();
        this.ZkConnectionTimeOutProp = new StringBuilder(31).append(this.configPrefix()).append("zookeeper.connection.timeout.ms").toString();
        this.ZkSessionTimeOutProp = new StringBuilder(28).append(this.configPrefix()).append("zookeeper.session.timeout.ms").toString();
        this.ZkMaxInFlightRequests = new StringBuilder(32).append(this.configPrefix()).append("zookeeper.max.in.flight.requests").toString();
        this.SuperUsersProp = "super.users";
        this.AllowEveryoneIfNoAclIsFoundProp = "allow.everyone.if.no.acl.found";
        this.NoAcls = new AclAuthorizer.VersionedAcls((Set<AclEntry>)Predef$.MODULE$.Set().empty(), ZkVersion$.MODULE$.UnknownVersion());
        this.WildcardHost = "*";
    }
}

