/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.FailedRegistrationResult;
import kafka.zk.KRaftRegistrationResult;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.SuccessfulRegistrationResult;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.zookeeper.KeeperException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}x!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007k\u0005\u0001\u000b\u0011\u0002\u001a\t\u000bY\nA\u0011A\u001c\t\u000f\u0005e\u0015\u0001\"\u0001\u0002\u001c\"9\u0011qZ\u0001\u0005\u0002\u0005Eg\u0001\u0002\u0014 \u0001eB\u0001\"\u0016\u0005\u0003\u0002\u0003\u0006IA\u0016\u0005\t3\"\u0011\t\u0011)A\u00055\"AQ\f\u0003B\u0001B\u0003%a\f\u0003\u0005b\u0011\t\u0005\t\u0015!\u0003c\u0011\u0015q\u0003\u0002\"\u0001f\u0011\u0015Q\u0007\u0002\"\u0011l\u0011\u0015\t\b\u0002\"\u0011s\u0011\u0015)\b\u0002\"\u0011w\u0011\u0015A\b\u0002\"\u0011z\u0011\u0015Y\b\u0002\"\u0001}\u0011\u001d\tI\u0004\u0003C\u0001\u0003wAq!!\u0011\t\t\u0003\t\u0019\u0005C\u0004\u0002H!!\t!!\u0013\t\u000f\u00055\u0003\u0002\"\u0001\u0002P!9\u00111\u000b\u0005\u0005B\u0005U\u0003bBA/\u0011\u0011\u0005\u0013q\f\u0005\b\u0003OBA\u0011IA5\u0011\u001d\t9\b\u0003C!\u0003sBa!\u0017\u0005\u0005B\u0005\u001d\u0005BB/\t\t\u0003\nI\t\u0003\u0004b\u0011\u0011\u0005\u00131R\u0001\u00125.l\u0015n\u001a:bi&|gn\u00117jK:$(B\u0001\u0011\"\u0003\tQ8NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!J\u0001\u000e\u0003}\u0011\u0011CW6NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\nA\"T1y\u0005\u0006$8\r[*ju\u0016,\u0012A\r\t\u0003SMJ!\u0001\u000e\u0016\u0003\u0007%sG/A\u0007NCb\u0014\u0015\r^2i'&TX\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0006q\u00055\u0015q\u0012\t\u0003K!\u0019B\u0001\u0003\u001eC\u001fB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005Y\u0006twMC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$AB(cU\u0016\u001cG\u000f\u0005\u0002D\u001b6\tAI\u0003\u0002F\r\u0006IQ.[4sCRLwN\u001c\u0006\u0003\u000f\"\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003E%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011a\n\u0012\u0002\u0010\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011\u0001kU\u0007\u0002#*\u0011!+I\u0001\u0006kRLGn]\u0005\u0003)F\u0013q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\t)s+\u0003\u0002Y?\ti1*\u00194lCj[7\t\\5f]R\f1\u0002^8qS\u000e\u001cE.[3oiB\u00111iW\u0005\u00039\u0012\u0013A\u0003V8qS\u000el\u0015n\u001a:bi&|gn\u00117jK:$\u0018\u0001D2p]\u001aLwm\u00117jK:$\bCA\"`\u0013\t\u0001GIA\u000bD_:4\u0017nZ'jOJ\fG/[8o\u00072LWM\u001c;\u0002\u0013\u0005\u001cGn\u00117jK:$\bCA\"d\u0013\t!GI\u0001\nBG2l\u0015n\u001a:bi&|gn\u00117jK:$H#\u0002\u001dgO\"L\u0007\"B+\u000e\u0001\u00041\u0006\"B-\u000e\u0001\u0004Q\u0006\"B/\u000e\u0001\u0004q\u0006\"B1\u000e\u0001\u0004\u0011\u0017!I4fi>\u00138I]3bi\u0016l\u0015n\u001a:bi&|gNU3d_Z,'/_*uCR,GC\u00017p!\t\u0019U.\u0003\u0002o\t\nQ\"l['jOJ\fG/[8o\u0019\u0016\fG-\u001a:tQ&\u00048\u000b^1uK\")\u0001O\u0004a\u0001Y\u0006a\u0011N\\5uS\u0006d7\u000b^1uK\u0006I2/\u001a;NS\u001e\u0014\u0018\r^5p]J+7m\u001c<fef\u001cF/\u0019;f)\ta7\u000fC\u0003u\u001f\u0001\u0007A.A\u0003ti\u0006$X-A\rdY\u0006LWnQ8oiJ|G\u000e\\3s\u0019\u0016\fG-\u001a:tQ&\u0004HC\u00017x\u0011\u0015!\b\u00031\u0001m\u0003m\u0011X\r\\3bg\u0016\u001cuN\u001c;s_2dWM\u001d'fC\u0012,'o\u001d5jaR\u0011AN\u001f\u0005\u0006iF\u0001\r\u0001\\\u0001\u000e[&<'/\u0019;f)>\u0004\u0018nY:\u0015\u000bu\f\t!!\f\u0011\u0005%r\u0018BA@+\u0005\u0011)f.\u001b;\t\u000f\u0005\r!\u00031\u0001\u0002\u0006\u0005q!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014\bCBA\u0004\u0003#\t)\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003!1WO\\2uS>t'bAA\b}\u0005!Q\u000f^5m\u0013\u0011\t\u0019\"!\u0003\u0003\u0011\r{gn];nKJ\u0004b!a\u0006\u0002\u001a\u0005uQBAA\u0007\u0013\u0011\tY\"!\u0004\u0003\t1K7\u000f\u001e\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0019\u0019w.\\7p]*\u0019\u0011q\u0005%\u0002\rM,'O^3s\u0013\u0011\tY#!\t\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0011\u001d\tyC\u0005a\u0001\u0003c\t\u0001C\u0019:pW\u0016\u0014\u0018\nZ\"p]N,X.\u001a:\u0011\r\u0005\u001d\u0011\u0011CA\u001a!\rY\u0014QG\u0005\u0004\u0003oa$aB%oi\u0016<WM]\u0001\u0015[&<'/\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u000bu\fi$a\u0010\t\u000f\u0005\r1\u00031\u0001\u0002\u0006!9\u0011qF\nA\u0002\u0005E\u0012aE7jOJ\fG/Z\"mS\u0016tG/U;pi\u0006\u001cHcA?\u0002F!9\u00111\u0001\u000bA\u0002\u0005\u0015\u0011!E7jOJ\fG/\u001a)s_\u0012,8-\u001a:JIR\u0019Q0a\u0013\t\u000f\u0005\rQ\u00031\u0001\u0002\u0006\u0005YQ.[4sCR,\u0017i\u00197t)\ri\u0018\u0011\u000b\u0005\b\u0003\u00071\u0002\u0019AA\u0003\u0003=\u0011X-\u00193BY2lU\r^1eCR\fG#B?\u0002X\u0005m\u0003bBA-/\u0001\u0007\u0011QA\u0001\u000eE\u0006$8\r[\"p]N,X.\u001a:\t\u000f\u0005=r\u00031\u0001\u00022\u0005i!/Z1e\u0005J|7.\u001a:JIN$\"!!\u0019\u0011\r\u0005]\u00111MA\u001a\u0013\u0011\t)'!\u0004\u0003\u0007M+G/\u0001\bsK\u0006$\u0007K]8ek\u000e,'/\u00133\u0015\u0005\u0005-\u0004CBA\f\u0003[\n\t(\u0003\u0003\u0002p\u00055!\u0001C(qi&|g.\u00197\u0011\t\u0005}\u00111O\u0005\u0005\u0003k\n\tC\u0001\tQe>$WoY3s\u0013\u0012\u001c(\t\\8dW\u0006yqO]5uKB\u0013x\u000eZ;dKJLE\rF\u0003m\u0003w\n)\tC\u0004\u0002~i\u0001\r!a \u0002\u001d9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JIB\u0019\u0011&!!\n\u0007\u0005\r%F\u0001\u0003M_:<\u0007\"\u0002;\u001b\u0001\u0004aG#\u0001.\u0015\u0003y#\u0012A\u0019\u0005\u0006+\u0016\u0001\rA\u0016\u0005\b\u0003#+\u0001\u0019AAJ\u0003=Q8nQ8oM&<WI\\2pI\u0016\u0014\bc\u0001)\u0002\u0016&\u0019\u0011qS)\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\fqb\u001e:baj[W\t_2faRLwN\\\u000b\u0005\u0003;\u000b\u0019\u000b\u0006\u0003\u0002 \u0006U\u0006\u0003BAQ\u0003Gc\u0001\u0001B\u0004\u0002&\u001a\u0011\r!a*\u0003\u0003Q\u000bB!!+\u00020B\u0019\u0011&a+\n\u0007\u00055&FA\u0004O_RD\u0017N\\4\u0011\u0007%\n\t,C\u0002\u00024*\u00121!\u00118z\u0011!\t9L\u0002CA\u0002\u0005e\u0016A\u00014o!\u0015I\u00131XAP\u0013\r\tiL\u000b\u0002\ty\tLh.Y7f}!*a!!1\u0002NB)\u0011&a1\u0002H&\u0019\u0011Q\u0019\u0016\u0003\rQD'o\\<t!\r\u0019\u0015\u0011Z\u0005\u0004\u0003\u0017$%\u0001G'jOJ\fG/[8o\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u000e\u0012\u0011qY\u0001\u000eY><\u0017I\u001c3SKRD'o\\<\u0016\t\u0005M\u0017\u0011\u001c\u000b\u0007\u0003+\fy.a9\u0015\t\u0005]\u00171\u001c\t\u0005\u0003C\u000bI\u000eB\u0004\u0002&\u001e\u0011\r!a*\t\u0011\u0005]v\u0001\"a\u0001\u0003;\u0004R!KA^\u0003/Da!!9\b\u0001\u0004y\u0015A\u00027pO\u001e,'\u000fC\u0004\u0002f\u001e\u0001\r!a:\u0002\u00075\u001cx\r\u0005\u0003\u0002j\u0006]h\u0002BAv\u0003g\u00042!!<+\u001b\t\tyOC\u0002\u0002r\u000e\na\u0001\u0010:p_Rt\u0014bAA{U\u00051\u0001K]3eK\u001aLA!!?\u0002|\n11\u000b\u001e:j]\u001eT1!!>+Q\u00159\u0011\u0011YAg\u0001")
public class ZkMigrationClient
implements MigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final TopicMigrationClient topicClient;
    public final ConfigMigrationClient kafka$zk$ZkMigrationClient$$configClient;
    private final AclMigrationClient aclClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> T logAndRethrow(Logging logging, String string, Function0<T> function0) throws MigrationClientException {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return (T)function0.apply();
        }
        catch (Throwable logAndRethrow_e) {
            logging.error((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(string)), (Function0<Throwable>)((Function0 & Serializable & scala.Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static <T> T wrapZkException(Function0<T> function0) throws MigrationClientException {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return (T)function0.apply();
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static ZkMigrationClient apply(KafkaZkClient kafkaZkClient, PasswordEncoder passwordEncoder) {
        return ZkMigrationClient$.MODULE$.apply(kafkaZkClient, passwordEncoder);
    }

    public static int MaxBatchSize() {
        return ZkMigrationClient$.MODULE$.MaxBatchSize();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkMigrationClient.$anonfun$getOrCreateMigrationRecoveryState$1(this, initialState);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return this.zkClient.updateMigrationState(state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkMigrationClient.$anonfun$claimControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkMigrationClient.$anonfun$releaseControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateTopics(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            ZkMigrationClient.$anonfun$migrateTopics$1(this, recordConsumer, brokerIdConsumer);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateBrokerConfigs(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateBrokerConfigs((broker, props) -> {
                if (new StringOps(Predef$.MODULE$.augmentString(broker)).nonEmpty()) {
                    brokerIdConsumer$2.accept(Integer.valueOf(broker));
                }
                ArrayList batch = new ArrayList();
                props.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0)));
                if (!batch.isEmpty()) {
                    recordConsumer$2.accept(batch);
                }
            });
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateClientQuotas(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateClientQuotas(new ConfigMigrationClient.ClientQuotaVisitor(null, recordConsumer){
                private final Consumer recordConsumer$3;

                public void visitClientQuota(java.util.List<ClientQuotaRecord.EntityData> entityDataList, Map<String, Double> quotas) {
                    ArrayList<E> batch = new ArrayList<E>();
                    quotas.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(entityDataList).setKey(key).setValue(Predef$.MODULE$.Double2double(value)), (short)0)));
                    this.recordConsumer$3.accept(batch);
                }

                public void visitScramCredential(String userName, ScramMechanism scramMechanism, ScramCredential scramCredential) {
                    ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
                    batch.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName(userName).setMechanism(scramMechanism.type()).setSalt(scramCredential.salt()).setStoredKey(scramCredential.storedKey()).setServerKey(scramCredential.serverKey()).setIterations(scramCredential.iterations()), (short)0));
                    this.recordConsumer$3.accept(batch);
                }
                {
                    this.recordConsumer$3 = recordConsumer$3;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateProducerId(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            ZkMigrationClient.$anonfun$migrateProducerId$1(this, recordConsumer);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateAcls(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        this.aclClient.iterateAcls((BiConsumer)new BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>>(null, recordConsumer){
            private final Consumer recordConsumer$5;

            public BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>> andThen(BiConsumer<? super ResourcePattern, ? super java.util.Set<AccessControlEntry>> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(ResourcePattern resourcePattern, java.util.Set<AccessControlEntry> acls) {
                ArrayList<E> batch = new ArrayList<E>();
                ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(acls).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    $anon$3.$anonfun$accept$1(this, batch, resourcePattern, entry);
                    return BoxedUnit.UNIT;
                });
                if (!batch.isEmpty()) {
                    this.recordConsumer$5.accept(batch);
                }
            }

            public static final /* synthetic */ void $anonfun$accept$1($anon$3 $this, ArrayList batch$3, ResourcePattern resourcePattern$1, AccessControlEntry entry) {
                batch$3.add(new ApiMessageAndVersion((ApiMessage)new AccessControlEntryRecord().setId(Uuid.randomUuid()).setResourceType(resourcePattern$1.resourceType().code()).setResourceName(resourcePattern$1.name()).setPatternType(resourcePattern$1.patternType().code()).setPrincipal(entry.principal()).setHost(entry.host()).setOperation(entry.operation().code()).setPermissionType(entry.permissionType().code()), 0));
                if (batch$3.size() == ZkMigrationClient$.MODULE$.MaxBatchSize()) {
                    $this.recordConsumer$5.accept(batch$3);
                    batch$3.clear();
                }
            }
            {
                this.recordConsumer$5 = recordConsumer$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(kafka.zk.ZkMigrationClient$$anon$3 java.util.ArrayList org.apache.kafka.common.resource.ResourcePattern org.apache.kafka.common.acl.AccessControlEntry )}, serializedLambda);
            }
        });
    }

    public void readAllMetadata(Consumer<java.util.List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer) {
        this.migrateTopics(batchConsumer, brokerIdConsumer);
        this.migrateBrokerConfigs(batchConsumer, brokerIdConsumer);
        this.migrateClientQuotas(batchConsumer);
        this.migrateProducerId(batchConsumer);
        this.migrateAcls(batchConsumer);
    }

    public java.util.Set<Integer> readBrokerIds() {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkMigrationClient.$anonfun$readBrokerIds$1(this);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<ProducerIdsBlock> readProducerId() {
        void var2_2;
        Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(var2_2.map((Function1 & Serializable & scala.Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData((byte[])jsonData))));
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        if (ZkMigrationClient$.MODULE$ == null) {
            throw null;
        }
        try {
            return ZkMigrationClient.$anonfun$writeProducerId$1(this, nextProducerId, state);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException;
            if (bl) {
                throw throwable;
            }
            boolean bl2 = throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException);
            if (bl2) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public TopicMigrationClient topicClient() {
        return this.topicClient;
    }

    public ConfigMigrationClient configClient() {
        return this.kafka$zk$ZkMigrationClient$$configClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclClient;
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$getOrCreateMigrationRecoveryState$1(ZkMigrationClient $this, ZkMigrationLeadershipState initialState$1) {
        $this.zkClient.createTopLevelPaths();
        return $this.zkClient.getOrCreateMigrationState(initialState$1);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$claimControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$2) {
        ZkMigrationLeadershipState zkMigrationLeadershipState;
        KRaftRegistrationResult kRaftRegistrationResult = $this.zkClient.tryRegisterKRaftControllerAsActiveController(state$2.kraftControllerId(), state$2.kraftControllerEpoch());
        if (kRaftRegistrationResult instanceof SuccessfulRegistrationResult) {
            SuccessfulRegistrationResult successfulRegistrationResult = (SuccessfulRegistrationResult)kRaftRegistrationResult;
            int controllerEpoch = successfulRegistrationResult.zkControllerEpoch();
            int controllerEpochZkVersion = successfulRegistrationResult.controllerEpochZkVersion();
            zkMigrationLeadershipState = state$2.withZkController(controllerEpoch, controllerEpochZkVersion);
        } else if (kRaftRegistrationResult instanceof FailedRegistrationResult) {
            zkMigrationLeadershipState = state$2.withUnknownZkController();
        } else {
            throw new MatchError((Object)kRaftRegistrationResult);
        }
        return zkMigrationLeadershipState;
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$releaseControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$3) {
        try {
            $this.zkClient.deleteController(state$3.zkControllerEpochZkVersion());
            return state$3.withUnknownZkController();
        }
        catch (ControllerMovedException controllerMovedException) {
            return state$3.withUnknownZkController();
        }
        catch (Throwable t) {
            throw new MigrationClientException("Could not release controller leadership due to underlying error", t);
        }
    }

    public static final /* synthetic */ void $anonfun$migrateTopics$1(ZkMigrationClient $this, Consumer recordConsumer$1, Consumer brokerIdConsumer$1) {
        ObjectRef topicBatch = ObjectRef.create(new ArrayList());
        $this.topicClient.iterateTopics(EnumSet.allOf(TopicMigrationClient.TopicVisitorInterest.class), new TopicMigrationClient.TopicVisitor($this, topicBatch, recordConsumer$1, brokerIdConsumer$1){
            private final /* synthetic */ ZkMigrationClient $outer;
            private final ObjectRef topicBatch$1;
            private final Consumer recordConsumer$1;
            private final Consumer brokerIdConsumer$1;

            public void visitTopic(String topicName, Uuid topicId, Map<Integer, java.util.List<Integer>> assignments) {
                if (!((ArrayList)this.topicBatch$1.elem).isEmpty()) {
                    this.recordConsumer$1.accept((ArrayList)this.topicBatch$1.elem);
                    this.topicBatch$1.elem = new ArrayList<E>();
                }
                ((ArrayList)this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName(topicName).setTopicId(topicId), (short)0));
                this.$outer.kafka$zk$ZkMigrationClient$$configClient.readTopicConfigs(topicName, topicConfigs -> topicConfigs.forEach((key, value) -> ((ArrayList)$this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setName(key.toString()).setValue(value.toString()), (short)0))));
            }

            public void visitPartition(TopicIdPartition topicIdPartition, PartitionRegistration partitionRegistration) {
                PartitionRecord record = new PartitionRecord().setTopicId(topicIdPartition.topicId()).setPartitionId(topicIdPartition.partition()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas)).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$visitPartition$1(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList()).asJava()).setAddingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.addingReplicas)).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$visitPartition$2(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList()).asJava()).setRemovingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.removingReplicas)).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$visitPartition$3(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList()).asJava()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.isr)).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$visitPartition$4(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList()).asJava()).setLeader(partitionRegistration.leader).setLeaderEpoch(partitionRegistration.leaderEpoch).setPartitionEpoch(partitionRegistration.partitionEpoch).setLeaderRecoveryState(partitionRegistration.leaderRecoveryState.value());
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$1)));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitionRegistration.addingReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$2)));
                ((ArrayList)this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)record, (short)0));
            }

            public static final /* synthetic */ Integer $anonfun$visitPartition$1(int x$1) {
                return x$1;
            }

            public static final /* synthetic */ Integer $anonfun$visitPartition$2(int x$1) {
                return x$1;
            }

            public static final /* synthetic */ Integer $anonfun$visitPartition$3(int x$1) {
                return x$1;
            }

            public static final /* synthetic */ Integer $anonfun$visitPartition$4(int x$1) {
                return x$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicBatch$1 = topicBatch$1;
                this.recordConsumer$1 = recordConsumer$1;
                this.brokerIdConsumer$1 = brokerIdConsumer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitPartition$1$adapted(java.lang.Object ), $anonfun$visitPartition$2$adapted(java.lang.Object ), $anonfun$visitPartition$3$adapted(java.lang.Object ), $anonfun$visitPartition$4$adapted(java.lang.Object ), $anonfun$visitPartition$5(kafka.zk.ZkMigrationClient$$anon$1 int ), $anonfun$visitPartition$6(kafka.zk.ZkMigrationClient$$anon$1 int )}, serializedLambda);
            }
        });
        if (!((ArrayList)topicBatch.elem).isEmpty()) {
            recordConsumer$1.accept((ArrayList)topicBatch.elem);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$migrateProducerId$1(ZkMigrationClient $this, Consumer recordConsumer$4) {
        void var3_3;
        Tuple2<Option<byte[]>, Object> tuple2 = $this.zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        if (var3_3 instanceof Some) {
            byte[] data = (byte[])((Some)var3_3).value();
            ProducerIdsBlock producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(data);
            recordConsumer$4.accept(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId(producerIdBlock.assignedBrokerId()).setNextProducerId(producerIdBlock.nextBlockFirstId()), (short)0), (List)Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(var3_3)) {
            return;
        }
        throw new MatchError((Object)var3_3);
    }

    public static final /* synthetic */ HashSet $anonfun$readBrokerIds$1(ZkMigrationClient $this) {
        return new HashSet((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)$this.zkClient.getSortedBrokerList().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).toSet()).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeProducerId$1(ZkMigrationClient $this, long nextProducerId$1, ZkMigrationLeadershipState state$4) {
        void var7_6;
        byte[] newProducerIdBlockData = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(-1, nextProducerId$1, 1000));
        SetDataRequest request = new SetDataRequest(ProducerIdBlockZNode$.MODULE$.path(), newProducerIdBlockData, ZkVersion$.MODULE$.MatchAnyVersion(), SetDataRequest$.MODULE$.apply$default$4());
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        return state$4.withMigrationZkVersion((int)var7_6);
    }

    public ZkMigrationClient(KafkaZkClient zkClient, TopicMigrationClient topicClient, ConfigMigrationClient configClient, AclMigrationClient aclClient) {
        this.zkClient = zkClient;
        this.topicClient = topicClient;
        this.kafka$zk$ZkMigrationClient$$configClient = configClient;
        this.aclClient = aclClient;
        Logging.$init$(this);
    }
}

