/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseFetchRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\n\u0015\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0001\u0004\u0001)A\u0005Q!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB\u001e\u0001A\u0003%1\u0007C\u0004=\u0001\t\u0007I\u0011A\u0014\t\ru\u0002\u0001\u0015!\u0003)\u0011\u001dq\u0004A1A\u0005\u0002\u001dBaa\u0010\u0001!\u0002\u0013A\u0003\"\u0002!\u0001\t\u0003\t\u0005\"\u0002%\u0001\t\u0003J\u0005\"B*\u0001\t\u0003!\u0006bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003C\u0001A\u0011AA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0003/Aa!!\u000b\u0001\t\u00139#\u0001\t$fi\u000eDgI]8n\r>dGn\\<fe&sG/Z4sCRLwN\u001c+fgRT!!\u0006\f\u0002\rM,'O^3s\u0015\t9\u0002$A\u0003lC\u001a\\\u0017MC\u0001\u001a\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003+}Q\u0011aF\u0005\u0003Cy\u0011ACQ1tK\u001a+Go\u00195SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0015\u0003!qW/\u001c(pI\u0016\u001cX#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\u0007%sG/A\u0005ok6tu\u000eZ3tA\u0005Aa.^7QCJ$8/A\u0005ok6\u0004\u0016M\u001d;tA\u0005)Ao\u001c9jGV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005qA.Z1eKJ\u0014%o\\6fe&#\u0017a\u00047fC\u0012,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002!\u0019|G\u000e\\8xKJ\u0014%o\\6fe&#\u0017!\u00054pY2|w/\u001a:Ce>\\WM]%eA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001C!\t\u0019e)D\u0001E\u0015\t)u'\u0001\u0003vi&d\u0017BA$E\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t!\nE\u0002L\u001dBk\u0011\u0001\u0014\u0006\u0003\u001b*\n!bY8mY\u0016\u001cG/[8o\u0013\tyEJA\u0002TKF\u0004\"!H)\n\u0005Is\"aC&bM.\f7i\u001c8gS\u001e\fq\u0006^3ti\u001a{G\u000e\\8xKJ\u001cu.\u001c9mKR,G)\u001a7bs\u0016$g)\u001a;dQ\u0016\u001cxJ\u001c*fa2L7-\u0019;j_:$\"!\u0016-\u0011\u0005%2\u0016BA,+\u0005\u0011)f.\u001b;\t\u000bes\u0001\u0019\u0001.\u0002\rE,xN];n!\tY&M\u0004\u0002]AB\u0011QLK\u0007\u0002=*\u0011qLG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005T\u0013A\u0002)sK\u0012,g-\u0003\u0002;G*\u0011\u0011M\u000b\u0015\u0005\u001d\u0015\f(\u000f\u0005\u0002g_6\tqM\u0003\u0002iS\u0006\u0019\u0011\r]5\u000b\u0005)\\\u0017a\u00026va&$XM\u001d\u0006\u0003Y6\fQA[;oSRT\u0011A\\\u0001\u0004_J<\u0017B\u00019h\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012a\u0004\u0015\u0005\u001dQdX\u0010\u0005\u0002vu6\taO\u0003\u0002xq\u0006A\u0001O]8wS\u0012,'O\u0003\u0002zS\u00061\u0001/\u0019:b[NL!a\u001f<\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\rq\u0018\u0011A\u0011\u0002\u007f\u0006\u0011!p[\u0011\u0003\u0003\u0007\tQa\u001b:bMRDsADA\u0004\u0003\u001f\t\t\u0002\u0005\u0003\u0002\n\u0005-Q\"\u0001=\n\u0007\u00055\u0001PA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u00111C\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018!\u000f;fgR4U\r^2i\rJ|W\u000eT3bI\u0016\u0014x\u000b[5mKB\u0013XMZ3se\u0016$'+Z1e%\u0016\u0004H.[2b\u0013N,f.\u0019<bS2\f'\r\\3\u0015\u0003UC3aDA\u000e!\r1\u0017QD\u0005\u0004\u0003?9'\u0001\u0002+fgR\fQ\u0004^3ti\u001a+Go\u00195Ge>lgi\u001c7m_^,'oV5uQJ{G\u000e\u001c\u0015\u0004!\u0005m\u0011A\u0007;fgR\u0014\u0016mY6Bo\u0006\u0014XMU1oO\u0016\f5o]5h]>\u0014\bfA\t\u0002\u001c\u0005\u0019r-\u001a;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0002")
public class FetchFromFollowerIntegrationTest
extends BaseFetchRequestTest {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final int leaderBrokerId;
    private final int followerBrokerId;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public int leaderBrokerId() {
        return this.leaderBrokerId;
    }

    public int followerBrokerId() {
        return this.followerBrokerId;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.numNodes()));
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.numNodes();
        String x$2 = this.zkConnectOrNull();
        boolean x$3 = false;
        boolean x$4 = true;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$4).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    @Timeout(value=15L)
    public void testFollowerCompleteDelayedFetchesOnReplication(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        short version = ApiKeys.FETCH.latestVersion();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest fetchRequest = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, 20000, 1, this.createConsumerFetchRequest$default$8());
        try (Socket socket = this.connect(this.brokerSocketServer(this.followerBrokerId()), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            FetchResponse response = (FetchResponse)this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable() {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 10, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertEquals((int)1, (int)this.getPreferredReplica());
        ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)-1, (int)this.getPreferredReplica());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchFromFollowerWithRoll() {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("client.rack", Integer.toString(this.followerBrokerId()));
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).startup();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$3(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
    }

    @Test
    public void testRackAwareRangeAssignor() {
        List partitionList = this.servers().indices().toList();
        String topicWithAllPartitionsOnAllRacks = "topicWithAllPartitionsOnAllRacks";
        this.createTopic(topicWithAllPartitionsOnAllRacks, this.servers().size(), this.servers().size(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topicWithSingleRackPartitions = "topicWithSingleRackPartitions";
        this.createTopicWithAssignment(topicWithSingleRackPartitions, (Map<Object, Seq<Object>>)((TraversableOnce)partitionList.map((Function1 & Serializable & scala.Serializable)i -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$1(this, BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), this.createTopicWithAssignment$default$3());
        this.consumerConfig().setProperty("partition.assignment.strategy", RangeAssignor.class.getName());
        Buffer consumers = (Buffer)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("client.rack", (String)server.config().rack().orNull(Predef$.MODULE$.$conforms()));
            this.consumerConfig().setProperty("group.instance.id", new StringBuilder(9).append("instance-").append(server.config().brokerId()).toString());
            this.consumerConfig().setProperty("metadata.max.age.ms", "1000");
            return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        }, Buffer$.MODULE$.canBuildFrom());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        ExecutorService executor = Executors.newFixedThreadPool(consumers.size());
        try {
            consumers.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.subscribe(Collections.singleton(topicWithSingleRackPartitions));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.subscribe(Collections.singleton(topicWithAllPartitionsOnAllRacks));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.subscribe((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions, topicWithAllPartitionsOnAllRacks}))).asJava());
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
            Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            HashMap reassignments = new HashMap();
            partitionList.foreach((Function1 & Serializable & scala.Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$18(reassignments, topicWithSingleRackPartitions, BoxesRunTime.unboxToInt((Object)p)));
            admin.alterPartitionReassignments(reassignments).all().get(30L, TimeUnit.SECONDS);
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private int getPreferredReplica() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        FetchRequest request = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, ApiKeys.FETCH.latestVersion(), 500, 1, Integer.toString(this.followerBrokerId()));
        FetchResponse response = (FetchResponse)this.connectAndReceive((AbstractRequest)request, ((KafkaBroker)this.brokers().apply(this.leaderBrokerId())).socketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        Assertions.assertEquals((int)1, (int)response.data().responses().size());
        FetchResponseData.FetchableTopicResponse topicResponse = (FetchResponseData.FetchableTopicResponse)response.data().responses().get(0);
        Assertions.assertEquals((int)1, (int)topicResponse.partitions().size());
        return ((FetchResponseData.PartitionData)topicResponse.partitions().get(0)).preferredReadReplica();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(FetchFromFollowerIntegrationTest $this, TopicPartition topicPartition$1) {
        return !((KafkaBroker)$this.brokers().apply($this.leaderBrokerId())).metadataCache().getPartitionReplicaEndpoints(topicPartition$1, $this.listenerName()).contains((Object)BoxesRunTime.boxToInteger((int)$this.followerBrokerId()));
    }

    public static final /* synthetic */ String $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2() {
        return "follower is still reachable.";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$1(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$2() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$3(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica() == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$4() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testRackAwareRangeAssignor$1(FetchFromFollowerIntegrationTest $this, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.servers().size() - i - 1})));
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testRackAwareRangeAssignor$3(Seq topics$1, int p) {
        return ((TraversableOnce)topics$1.map((Function1 & Serializable & scala.Serializable)topic -> new TopicPartition(topic, p), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ String $anonfun$testRackAwareRangeAssignor$8(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$1) {
        return new StringBuilder(73).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". The current assignment is ").append(consumer$1.assignment()).toString();
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$9(Future future) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt(future.get(30L, TimeUnit.SECONDS)));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$13(List assignments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Future future = (Future)x0$3._1();
            int i = x0$3._2$mcI$sp();
            Seq records = (Seq)future.get(30L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)assignments$1.apply(i), (Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)r -> new TopicPartition(r.topic(), r.partition()), Seq$.MODULE$.canBuildFrom())).toSet());
            return;
        }
        throw new MatchError(null);
    }

    private static final void verifyAssignments$1(List partitionOrder, Seq topics, Buffer consumers$1, ExecutorService executor$1, KafkaProducer producer$1) {
        List assignments = (List)partitionOrder.map((Function1 & Serializable & scala.Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$3(topics, BoxesRunTime.unboxToInt((Object)p)), List$.MODULE$.canBuildFrom());
        ((Buffer)((TraversableLike)consumers$1.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Consumer consumer = (Consumer)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return executor$1.submit(() -> {
                    void pollUntilTrue_action;
                    scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)assignments.apply(i);
                    long l = 30000L;
                    JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        java.util.Set set = consumer.assignment();
                        Object object = CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava();
                        return !(set != null ? !((Object)set).equals(object) : object != null);
                    };
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long pollUntilTrue_x$3 = 0L;
                    long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
                        void pollUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                            Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$8(expectedAssignment, consumer));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
                    }
                }, BoxesRunTime.boxToInteger((int)0));
            }
            throw new MatchError(null);
        }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)future -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$9(future);
            return BoxedUnit.UNIT;
        });
        ((List)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)tp -> producer$1.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)new StringBuilder(4).append("key-").append(tp).toString().getBytes(), (Object)new StringBuilder(6).append("value-").append(tp).toString().getBytes())));
        ((IterableLike)((Buffer)((TraversableLike)consumers$1.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                Consumer consumer = (Consumer)x0$2._1();
                int i = x0$2._2$mcI$sp();
                return executor$1.submit(() -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, ((TraversableOnce)assignments.apply(i)).size(), 30000L));
            }
            throw new MatchError(null);
        }, Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$13(assignments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Optional $anonfun$testRackAwareRangeAssignor$18(HashMap reassignments$1, String topicWithSingleRackPartitions$1, int p) {
        NewPartitionReassignment newAssignment = new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(p)));
        return reassignments$1.put(new TopicPartition(topicWithSingleRackPartitions$1, p), Optional.of(newAssignment));
    }

    public FetchFromFollowerIntegrationTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.topic = "test-fetch-from-follower";
        this.leaderBrokerId = 0;
        this.followerBrokerId = 1;
    }
}

