/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.MyRemoteLogMetadataManager;
import kafka.admin.MyRemoteLogMetadataManager$;
import kafka.admin.MyRemoteStorageManager;
import kafka.admin.MyRemoteStorageManager$;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001=\u0011\u0019)\u0005\u0001)A\u0005{!Ia\t\u0001a\u0001\u0002\u0004%\ta\u0012\u0005\n'\u0002\u0001\r\u00111A\u0005\u0002QC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002%\t\u000fm\u0003\u0001\u0019!C\u00019\"9\u0001\r\u0001a\u0001\n\u0003\t\u0007BB2\u0001A\u0003&Q\fC\u0004e\u0001\u0001\u0007I\u0011A$\t\u000f\u0015\u0004\u0001\u0019!C\u0001M\"1\u0001\u000e\u0001Q!\n!Cq!\u001b\u0001A\u0002\u0013\u0005q\tC\u0004k\u0001\u0001\u0007I\u0011A6\t\r5\u0004\u0001\u0015)\u0003I\u0011\u0015q\u0007\u0001\"\u0015=\u0011\u0015y\u0007\u0001\"\u0015q\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bAq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\n\te\u0001\"\u0003B/\u0001E\u0005I\u0011\u0002B0\u0011\u001d\u0011)\b\u0001C\u0005\u0005oBqA! \u0001\t\u0013\u0011yHA\nSK6|G/\u001a+pa&\u001c7I];e)\u0016\u001cHO\u0003\u0002-[\u0005)\u0011\rZ7j]*\ta&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b.\u0003\r\t\u0007/[\u0005\u0003mM\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003-\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\u0007%sG/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002)9,XNU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003UqW/\u001c*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQ\u0002^3tiR{\u0007/[2OC6,W#\u0001%\u0011\u0005%\u0003fB\u0001&O!\tYu(D\u0001M\u0015\tiu&\u0001\u0004=e>|GOP\u0005\u0003\u001f~\na\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011qjP\u0001\u0012i\u0016\u001cH\u000fV8qS\u000et\u0015-\\3`I\u0015\fHCA+Y!\tqd+\u0003\u0002X\u007f\t!QK\\5u\u0011\u001dIv!!AA\u0002!\u000b1\u0001\u001f\u00132\u00039!Xm\u001d;U_BL7MT1nK\u0002\nqc]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3\u0016\u0003u\u0003\"A\u00100\n\u0005}{$a\u0002\"p_2,\u0017M\\\u0001\u001cgf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012|F%Z9\u0015\u0005U\u0013\u0007bB-\u000b\u0003\u0003\u0005\r!X\u0001\u0019gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012\u0004\u0013aF:u_J\fw-Z'b]\u0006<WM]\"mCN\u001ch*Y7f\u0003m\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lWm\u0018\u0013fcR\u0011Qk\u001a\u0005\b36\t\t\u00111\u0001I\u0003a\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ\u001cE.Y:t\u001d\u0006lW\rI\u0001\u0019[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u000ec\u0017m]:OC6,\u0017\u0001H7fi\u0006$\u0017\r^1NC:\fw-\u001a:DY\u0006\u001c8OT1nK~#S-\u001d\u000b\u0003+2Dq!\u0017\t\u0002\u0002\u0003\u0007\u0001*A\rnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d(b[\u0016\u0004\u0013a\u00032s_.,'oQ8v]R\fQ\"\\8eS\u001aL8i\u001c8gS\u001e\u001cHCA+r\u0011\u0015\u00118\u00031\u0001t\u0003\u0015\u0001(o\u001c9t!\r!x/_\u0007\u0002k*\u0011aoP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005\r\u0019V-\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA!\u001e;jY*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001w\nQ\u0001K]8qKJ$\u0018.Z:\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$\u0012a]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004+\u0006-\u0001bBA\u0007+\u0001\u0007\u0011qB\u0001\u0005S:4w\u000e\u0005\u0003\u0002\u0012\u0005\u0005RBAA\n\u0015\r!\u0014Q\u0003\u0006\u0005\u0003/\tI\"A\u0004kkBLG/\u001a:\u000b\t\u0005m\u0011QD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003?\t1a\u001c:h\u0013\u0011\t\u0019#a\u0005\u0003\u0011Q+7\u000f^%oM>D3!FA\u0014!\u0011\t\t\"!\u000b\n\t\u0005-\u00121\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017a\u000b;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"4\u0016\r\\5e%\u0016$XM\u001c;j_:$\u0016.\\3\u0015\u0007U\u000b\t\u0004\u0003\u0004\u00024Y\u0001\r\u0001S\u0001\u0007cV|'/^7)\u000fY\t9$a\u0012\u0002JA!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005\u0005\u0013QC\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005\u0015\u00131\b\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005-\u0013qJ\u0011\u0003\u0003\u001b\n!A_6\"\u0005\u0005E\u0013!B6sC\u001a$\bf\u0002\f\u0002V\u0005u\u0013q\f\t\u0005\u0003/\nI&\u0004\u0002\u0002@%!\u00111LA \u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002b\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002WQ,7\u000f^\"sK\u0006$XMU3n_R,Gk\u001c9jG^KG\u000f\u001b,bY&$'+\u001a;f]RLwN\\*ju\u0016$2!VA4\u0011\u0019\t\u0019d\u0006a\u0001\u0011\":q#a\u000e\u0002H\u0005-D\u0006BA&\u0003\u001fBsaFA+\u0003;\ny&\u0001\u001buKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c5fe&$X\r\u001a'pG\u0006d'+\u001a;f]RLwN\u001c+j[\u0016$2!VA:\u0011\u0019\t\u0019\u0004\u0007a\u0001\u0011\":\u0001$a\u000e\u0002H\u0005]D\u0006BA&\u0003\u001fBs\u0001GA+\u0003;\ny&\u0001\u001buKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c5fe&$X\r\u001a'pG\u0006d'+\u001a;f]RLwN\\*ju\u0016$2!VA@\u0011\u0019\t\u0019$\u0007a\u0001\u0011\":\u0011$a\u000e\u0002H\u0005\rE\u0006BA&\u0003\u001fBs!GA+\u0003;\ny&A\u0017uKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\u001c+j[\u0016$2!VAF\u0011\u0019\t\u0019D\u0007a\u0001\u0011\":!$a\u000e\u0002H\u0005=E\u0006BA&\u0003\u001fBsAGA+\u0003;\ny&A\u0017uKN$8I]3bi\u0016\u0014V-\\8uKR{\u0007/[2XSRD\u0017J\u001c<bY&$'+\u001a;f]RLwN\\*ju\u0016$2!VAL\u0011\u0019\t\u0019d\u0007a\u0001\u0011\":1$a\u000e\u0002H\u0005mE\u0006BA&\u0003\u001fBsaGA+\u0003;\ny&\u0001\u0011uKN$8I]3bi\u0016\u001cu.\u001c9bGR,GMU3n_R,7\u000b^8sC\u001e,GcA+\u0002$\"1\u00111\u0007\u000fA\u0002!Cs\u0001HA\u001c\u0003\u000f\n9\u000b\f\u0003\u0002L\u0005=\u0003f\u0002\u000f\u0002V\u0005u\u0013qL\u0001'i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ(o\u000bbL7\u000f^5oOR{\u0007/[2UKN$HcA+\u00020\"1\u00111G\u000fA\u0002!Cs!HA\u001c\u0003\u000f\n\u0019\f\f\u0003\u0002L\u0005=\u0003fB\u000f\u0002V\u0005u\u0013qL\u00015i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ,iK:\u001c\u0016p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u0013N$\u0015n]1cY\u0016$GcA+\u0002<\"1\u00111\u0007\u0010A\u0002!CsAHA\u001c\u0003\u000f\ny\f\f\u0003\u0002L\u0005=\u0003f\u0002\u0010\u0002V\u0005u\u0013qL\u00010i\u0016\u001cH/\u00169eCR,Gk\u001c9jG\u000e{gNZ5h/&$\bNV1mS\u0012\u0014V\r^3oi&|g\u000eV5nKR+7\u000f\u001e\u000b\u0004+\u0006\u001d\u0007BBA\u001a?\u0001\u0007\u0001\nK\u0004 \u0003o\t9%a3-\t\u0005-\u0013q\n\u0015\b?\u0005U\u0013QLA0\u0003=\"Xm\u001d;Va\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001e<\u0016\u000e\u001e5WC2LGMU3uK:$\u0018n\u001c8TSj,G+Z:u)\r)\u00161\u001b\u0005\u0007\u0003g\u0001\u0003\u0019\u0001%)\u000f\u0001\n9$a\u0012\u0002X2\"\u00111JA(Q\u001d\u0001\u0013QKA/\u0003?\nA\u0007^3tiV\u0003H-\u0019;f)>\u0004\u0018nY\"p]\u001aLwmV5uQ&s\u0007.\u001a:ji\u0016$Gj\\2bYJ+G/\u001a8uS>tG+[7f)\r)\u0016q\u001c\u0005\u0007\u0003g\t\u0003\u0019\u0001%)\u000f\u0005\n9$a\u0012\u0002d2\"\u00111JA(Q\u001d\t\u0013QKA/\u0003?\nA\u0007^3tiV\u0003H-\u0019;f)>\u0004\u0018nY\"p]\u001aLwmV5uQ&s\u0007.\u001a:ji\u0016$Gj\\2bYJ+G/\u001a8uS>t7+\u001b>f)\r)\u00161\u001e\u0005\u0007\u0003g\u0011\u0003\u0019\u0001%)\u000f\t\n9$a\u0012\u0002p2\"\u00111JA(Q\u001d\u0011\u0013QKA/\u0003?\n\u0011\u0003^3tiR{\u0007/[2EK2,G/[8o)\r)\u0016q\u001f\u0005\u0007\u0003g\u0019\u0003\u0019\u0001%)\u000f\r\n9$a\u0012\u0002|2\"\u00111JA(Q\u001d\u0019\u0013QKA/\u0003?\nq\b^3ti\u000ecWo\u001d;fe^KG-\u001a#jg\u0006\u0014G.Z7f]R|e\rV5fe\u0016$7\u000b^8sC\u001e,w+\u001b;i\u000b:\f'\r\\3e)&,'/\u001a3U_BL7\rF\u0002V\u0005\u0007Aa!a\r%\u0001\u0004A\u0005f\u0002\u0013\u00028\u0005\u001d#q\u0001\u0017\u0005\u0003\u0017\ny\u0005K\u0004%\u0003+\ni&a\u0018\u0002\u0017R,7\u000f^\"mkN$XM],ji\"|W\u000f\u001e+jKJ,Gm\u0015;pe\u0006<Wm\u0015;beR\u001c8+^2dKN\u001ch-\u001e7ms&3Gk\u001c9jG^KG\u000f\u001b+jKJLgn\u001a#jg\u0006\u0014G.\u001a3\u0015\u0007U\u0013y\u0001\u0003\u0004\u00024\u0015\u0002\r\u0001\u0013\u0015\bK\u0005]\u0012q\tB\nY\u0011\tY%a\u0014)\u000f\u0015\n)&!\u0018\u0002`\u0005)\u0012m]:feR$\u0006N]8xg\u0016C8-\u001a9uS>tG\u0003\u0003B\u000e\u0005[\u0011IE!\u0017\u0011\t\tu!q\u0005\b\u0005\u0005?\u0011\u0019CD\u0002L\u0005CI\u0011\u0001Q\u0005\u0004\u0005Ky\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YCA\u0005UQJ|w/\u00192mK*\u0019!QE \t\u000f\t=b\u00051\u0001\u00032\u0005iQ\r_2faRLwN\u001c+za\u0016\u0004DAa\r\u0003>A)\u0011J!\u000e\u0003:%\u0019!q\u0007*\u0003\u000b\rc\u0017m]:\u0011\t\tm\"Q\b\u0007\u0001\t1\u0011yD!\f\u0002\u0002\u0003\u0005)\u0011\u0001B!\u0005\ryF%M\t\u0005\u0005\u0007\u0012Y\u0002E\u0002?\u0005\u000bJ1Aa\u0012@\u0005\u001dqu\u000e\u001e5j]\u001eDqAa\u0013'\u0001\u0004\u0011i%\u0001\u0006fq\u0016\u001cW\u000f^1cY\u0016\u0004BAa\u0014\u0003V5\u0011!\u0011\u000b\u0006\u0005\u0005'\n\u0019\"\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u00119F!\u0015\u0003\u0015\u0015CXmY;uC\ndW\r\u0003\u0005\u0003\\\u0019\u0002\n\u00111\u0001I\u0003\u001diWm]:bO\u0016\fq$Y:tKJ$H\u000b\u001b:poN,\u0005pY3qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tGK\u0002I\u0005GZ#A!\u001a\u0011\t\t\u001d$\u0011O\u0007\u0003\u0005SRAAa\u001b\u0003n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005_z\u0014AC1o]>$\u0018\r^5p]&!!1\u000fB5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cm\u0016\u0014\u0018NZ=SK6|G/\u001a'pOR{\u0007/[2D_:4\u0017nZ:\u0015\u0007U\u0013I\b\u0003\u0004\u0003|!\u0002\r!_\u0001\fi>\u0004\u0018nY\"p]\u001aLw-A\u0007pm\u0016\u0014(/\u001b3f!J|\u0007o\u001d\u000b\u0002s\":\u0001Aa!\u0003\n\n-\u0005\u0003BA\t\u0005\u000bKAAa\"\u0002\u0014\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\t5\u0015aC5oi\u0016<'/\u0019;j_:\u0004")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        if (((Method)info.getTestMethod().get()).getName().endsWith("SystemRemoteStorageIsDisabled")) {
            this.sysRemoteStorageEnabled_$eq(false);
        }
        if (((Method)info.getTestMethod().get()).getName().equals("testTopicDeletion")) {
            this.storageManagerClassName_$eq(MyRemoteStorageManager.class.getName());
            this.metadataManagerClassName_$eq(MyRemoteLogMetadataManager.class.getName());
        }
        super.setUp(info);
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        topicConfig.put("local.retention.bytes", "256");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "1001");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "1025");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        }, this.assertThrowsException$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        }, this.assertThrowsException$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateCompactedRemoteStorage(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("cleanup.policy", "compact");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        }, this.assertThrowsException$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogOnExistingTopicTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogWhenSystemRemoteStorageIsDisabled(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfigWithRemoteStorage = new Properties();
        topicConfigWithRemoteStorage.put("remote.storage.enable", "true");
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfigWithRemoteStorage);
        }, this.assertThrowsException$default$3()).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
        TestUtils$.MODULE$.createTopicWithAdmin(admin, this.testTopicName(), this.brokers(), this.controllerServers(), this.numPartitions(), this.numReplicationFactor(), TestUtils$.MODULE$.createTopicWithAdmin$default$7(), TestUtils$.MODULE$.createTopicWithAdmin$default$8());
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), this.assertThrowsException$default$3()).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionTimeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<Object>> configs = new HashMap<ConfigResource, java.util.List<Object>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "100"), AlterConfigOp.OpType.SET)}));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionSizeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<Object>> configs = new HashMap<ConfigResource, java.util.List<Object>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("retention.bytes", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "100"), AlterConfigOp.OpType.SET)}));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionTime(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<Object>> configs = new HashMap<ConfigResource, java.util.List<Object>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET)}));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), this.assertThrowsException$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionSize(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<Object>> configs = new HashMap<ConfigResource, java.util.List<Object>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("retention.bytes", "512"), AlterConfigOp.OpType.SET)}));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Invalid local retention size");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().set(0);
        int numPartitions = 2;
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = this.brokerCount();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, numPartitions, x$6, x$8, topicConfig);
        TestUtils$.MODULE$.deleteTopicWithAdmin(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName(), this.brokers(), this.controllerServers());
        this.assertThrowsException(UnknownTopicOrPartitionException.class, () -> TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName()), "Topic should be deleted");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$testTopicDeletion$2(numPartitions)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$testTopicDeletion$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        if (this.isKRaftTest()) {
            boolean x$9 = true;
            boolean x$10 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$10, x$9);
            Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
            this.faultHandler().setIgnore(true);
            return;
        }
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean x$11 = true;
            boolean x$12 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$12, x$11);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$9 = true;
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, x$9);
    }

    private Throwable assertThrowsException(Class<? extends Throwable> exceptionType, Executable executable, String message) {
        return Assertions.assertThrows(exceptionType, () -> {
            try {
                executable.execute();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, (String)message);
    }

    private String assertThrowsException$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyRemoteLogTopicConfigs(Properties topicConfig) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$1(this, topicConfig)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$3(topicConfig));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$2(int numPartitions$1) {
        return numPartitions$1 * MyRemoteLogMetadataManager$.MODULE$.segmentCountPerPartition() == MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().get();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$3() {
        return "Remote log segments should be deleted only once by the leader";
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteLogTopicConfigs$1(RemoteTopicCrudTest $this, Properties topicConfig$4) {
        Buffer logBuffer = (Buffer)$this.brokers().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManager qual$1 = x$1.logManager();
            TopicPartition x$12 = new TopicPartition($this.testTopicName(), 0);
            boolean x$2 = qual$1.getLog$default$2();
            return Option$.MODULE$.option2Iterable(qual$1.getLog(x$12, x$2));
        }, Buffer$.MODULE$.canBuildFrom());
        boolean result = logBuffer.nonEmpty();
        if (result) {
            if (topicConfig$4.containsKey("remote.storage.enable")) {
                boolean bl = result = result && new StringOps(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("remote.storage.enable"))).toBoolean() == ((UnifiedLog)logBuffer.head()).config().remoteStorageEnable();
            }
            if (topicConfig$4.containsKey("local.retention.bytes")) {
                boolean bl = result = result && new StringOps(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("local.retention.bytes"))).toLong() == ((UnifiedLog)logBuffer.head()).config().localRetentionBytes();
            }
            if (topicConfig$4.containsKey("local.retention.ms")) {
                boolean bl = result = result && new StringOps(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("local.retention.ms"))).toLong() == ((UnifiedLog)logBuffer.head()).config().localRetentionMs();
            }
            if (topicConfig$4.containsKey("retention.ms")) {
                boolean bl = result = result && new StringOps(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("retention.ms"))).toLong() == ((UnifiedLog)logBuffer.head()).config().retentionMs;
            }
            if (topicConfig$4.containsKey("retention.bytes")) {
                result = result && new StringOps(Predef$.MODULE$.augmentString(topicConfig$4.getProperty("retention.bytes"))).toLong() == ((UnifiedLog)logBuffer.head()).config().retentionSize;
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$verifyRemoteLogTopicConfigs$3(Properties topicConfig$4) {
        return new StringBuilder(30).append("Failed to update topic config ").append(topicConfig$4).toString();
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

