/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\rc\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013i\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA(\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005E\u0003\"CA3\u0001\t\u0007I\u0011AA4\u0011!\t9\b\u0001Q\u0001\n\u0005%\u0004\u0002\u00037\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u001e\u0002!\t!!\"\u0007\r\u0005\u001d\u0006\u0001QAU\u0011)\t9l\u0005BK\u0002\u0013\u0005\u0011\u0011\u0018\u0005\u000b\u0003#\u001c\"\u0011#Q\u0001\n\u0005m\u0006BCAj'\tU\r\u0011\"\u0001\u0002:\"Q\u0011Q[\n\u0003\u0012\u0003\u0006I!a/\t\r]\u001cB\u0011AAl\u0011\u001d\t\to\u0005C\u0001\u0003GD\u0011B!\u0001\u0014#\u0003%\tAa\u0001\t\u0013\te1#!A\u0005\u0002\tm\u0001\"\u0003B\u0011'E\u0005I\u0011\u0001B\u0012\u0011%\u00119cEI\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003*M\t\t\u0011\"\u0011\u0003,!I!qG\n\u0002\u0002\u0013\u0005!\u0011\b\u0005\n\u0005\u0003\u001a\u0012\u0011!C\u0001\u0005\u0007B\u0011B!\u0014\u0014\u0003\u0003%\tEa\u0014\t\u0013\tu3#!A\u0005\u0002\t}\u0003\"\u0003B5'\u0005\u0005I\u0011\tB6\u0011%\u0011igEA\u0001\n\u0003\u0012y\u0007C\u0005\u0003rM\t\t\u0011\"\u0011\u0003t\u001d9!q\u000f\u0001\t\u0002\tedaBAT\u0001!\u0005!1\u0010\u0005\u0007o\u001e\"\tA! \t\u000f\t}t\u0005\"\u0001\u0003\u0002\"I!1R\u0014\u0002\u0002\u0013\u0005%Q\u0012\u0005\n\u0005';\u0013\u0011!CA\u0005+CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u0003D\u0002!IA!2\t\u000f\t5\u0007\u0001\"\u0003\u0003P\"I!\u0011\u001c\u0001\u0012\u0002\u0013%!1\u001c\u0005\n\u0005?\u0004\u0011\u0013!C\u0005\u0005\u0007AqA!9\u0001\t\u0013\u0011\u0019\u000fC\u0005\u0004\f\u0001\t\n\u0011\"\u0003\u0003\\\"I1Q\u0002\u0001\u0012\u0002\u0013%!1\u0001\u0005\n\u0007\u001f\u0001\u0011\u0013!C\u0005\u0007#A\u0011b!\u0006\u0001#\u0003%Iaa\u0006\t\u0013\rm\u0001!%A\u0005\n\ru\u0001\"CB\u0011\u0001E\u0005I\u0011BB\f\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0003\u000bCqa!\f\u0001\t\u0003\t)\tC\u0004\u00042\u0001!\t!!\"\t\u000f\rU\u0002\u0001\"\u0001\u0002\u0006\"91\u0011\b\u0001\u0005\u0002\u0005\u0015\u0005bBB\u001f\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u0003\u0002A\u0011AAC\u0011\u001d\u0019)\u0005\u0001C\u0001\u0003\u000bCqa!\u0013\u0001\t\u0003\t)\tC\u0004\u0004N\u0001!\t!!\"\t\u000f\rE\u0003\u0001\"\u0001\u0002\u0006\"91Q\u000b\u0001\u0005\u0002\u0005\u0015\u0005bBB-\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007;\u0002A\u0011BB0\u0011\u001d\u0019)\u0007\u0001C\u0001\u0003\u000bCqa!\u001b\u0001\t\u0003\t)\tC\u0004\u0004n\u0001!Iaa\u001c\t\u000f\rM\u0004\u0001\"\u0001\u0002\u0006\"91q\u000f\u0001\u0005\u0002\u0005\u0015\u0005bBB>\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u007f\u0002A\u0011AAC\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0003\u000bCqaa\"\u0001\t\u0003\t)\tC\u0004\u0004\f\u0002!\t!!\"\t\u000f\r=\u0005\u0001\"\u0001\u0002\u0006\"911\u0013\u0001\u0005\n\rU\u0005bBBP\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007G\u0003A\u0011AAC\u0011\u001d\u00199\u000b\u0001C\u0001\u0003\u000bCqaa+\u0001\t\u0003\t)\tC\u0004\u00040\u0002!\t!!\"\t\u000f\rM\u0006\u0001\"\u0001\u0002\u0006\"91q\u0017\u0001\u0005\u0002\u0005\u0015\u0005bBB^\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0007\u007f\u0003A\u0011AAC\u0011\u001d\u0019\u0019\r\u0001C\u0001\u0003\u000bCqaa2\u0001\t\u0003\t)\tC\u0004\u0004L\u0002!\t!!\"\t\u000f\r=\u0007\u0001\"\u0001\u0002\u0006\"911\u001b\u0001\u0005\u0002\u0005\u0015\u0005bBBl\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u00077\u0004A\u0011BBo\u0011%!Y\u0002AI\u0001\n\u0013!i\u0002C\u0005\u0005\"\u0001\t\n\u0011\"\u0003\u0005$!IAq\u0005\u0001\u0012\u0002\u0013%!1\u0001\u0005\n\tS\u0001\u0011\u0013!C\u0005\u0007;A\u0011\u0002b\u000b\u0001#\u0003%I\u0001\"\f\t\u0013\u0011E\u0002!%A\u0005\n\u0011M\u0002\"\u0003C\u001c\u0001E\u0005I\u0011\u0002C\u001d\u0011%!i\u0004AI\u0001\n\u0013!yD\u0001\u0007M_\u000e\fG\u000eT8h)\u0016\u001cHO\u0003\u0002m[\u0006\u0019An\\4\u000b\u00039\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A=\u0011\u0005i\u0004Q\"A6\u0002\r\r|gNZ5h+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u00025\faa]3sm\u0016\u0014\u0018bAA\u0003\u007f\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002s\u0003\u001bI1!a\u0004t\u0005\u0011)f.\u001b;\t\u0011\u0005M1!!AA\u0002u\f1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001^7q\t&\u0014XCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!![8\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\t\t)\u0004\u0005\u0003\u00028\u0005\u001dSBAA\u001d\u0015\u0011\tY$!\u0010\u0002\r\r|W.\\8o\u0015\rq\u0017q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\n1a\u001c:h\u0013\u0011\tI%!\u000f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0003\u0003#\u0002B!a\u0015\u0002`5\u0011\u0011Q\u000b\u0006\u0004Y\u0006]#\u0002BA-\u00037\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005u\u0013QH\u0001\bgR|'/Y4f\u0013\u0011\t\t'!\u0016\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\n\u0001\"\\8dWRKW.Z\u000b\u0003\u0003S\u0002B!a\u001b\u0002t5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0003vi&d'\u0002BA\u0001\u0003{IA!!\u001e\u0002n\tAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fAU\u0011\u00111\u0010\t\u0004u\u0006u\u0014bAA@W\nAAj\\2bY2{w-\u0001\u0003m_\u001e\u0004\u0013!B:fiV\u0003HCAA\u0006Q\r\t\u0012\u0011\u0012\t\u0005\u0003\u0017\u000bI*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\r\t\u0007/\u001b\u0006\u0005\u0003'\u000b)*A\u0004kkBLG/\u001a:\u000b\t\u0005]\u00151I\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\u000biI\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004%\u0005\u0005\u0006\u0003BAF\u0003GKA!!*\u0002\u000e\nI\u0011I\u001a;fe\u0016\u000b7\r\u001b\u0002\t\u0017\u0016Lh+\u00197vKN11#]AV\u0003c\u00032A]AW\u0013\r\tyk\u001d\u0002\b!J|G-^2u!\r\u0011\u00181W\u0005\u0004\u0003k\u001b(\u0001D*fe&\fG.\u001b>bE2,\u0017aA6fsV\u0011\u00111\u0018\t\u0005\u0003{\u000bYM\u0004\u0003\u0002@\u0006\u001d\u0007cAAag6\u0011\u00111\u0019\u0006\u0004\u0003\u000b|\u0017A\u0002\u001fs_>$h(C\u0002\u0002JN\fa\u0001\u0015:fI\u00164\u0017\u0002BAg\u0003\u001f\u0014aa\u0015;sS:<'bAAeg\u0006!1.Z=!\u0003\u00151\u0018\r\\;f\u0003\u00191\u0018\r\\;fAQ1\u0011\u0011\\Ao\u0003?\u00042!a7\u0014\u001b\u0005\u0001\u0001bBA\\1\u0001\u0007\u00111\u0018\u0005\b\u0003'D\u0002\u0019AA^\u0003!!xNU3d_J$G\u0003BAs\u0003c\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fI$\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003_\fIO\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H\rC\u0005\u0002tf\u0001J\u00111\u0001\u0002v\u0006IA/[7fgR\fW\u000e\u001d\t\u0006e\u0006]\u00181`\u0005\u0004\u0003s\u001c(\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007I\fi0C\u0002\u0002\u0000N\u0014A\u0001T8oO\u0006\u0011Bo\u001c*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)A\u000b\u0003\u0002|\n\u001d1F\u0001B\u0005!\u0011\u0011YA!\u0006\u000e\u0005\t5!\u0002\u0002B\b\u0005#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tM1/\u0001\u0006b]:|G/\u0019;j_:LAAa\u0006\u0003\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\t\r|\u0007/\u001f\u000b\u0007\u00033\u0014iBa\b\t\u0013\u0005]6\u0004%AA\u0002\u0005m\u0006\"CAj7A\u0005\t\u0019AA^\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\n+\t\u0005m&qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0006\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)!!1GA\u0012\u0003\u0011a\u0017M\\4\n\t\u00055'\u0011G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005w\u00012A\u001dB\u001f\u0013\r\u0011yd\u001d\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000b\u0012Y\u0005E\u0002s\u0005\u000fJ1A!\u0013t\u0005\r\te.\u001f\u0005\n\u0003'\u0001\u0013\u0011!a\u0001\u0005w\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005#\u0002bAa\u0015\u0003Z\t\u0015SB\u0001B+\u0015\r\u00119f]\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B.\u0005+\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\rB4!\r\u0011(1M\u0005\u0004\u0005K\u001a(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003'\u0011\u0013\u0011!a\u0001\u0005\u000b\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005w\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005[\ta!Z9vC2\u001cH\u0003\u0002B1\u0005kB\u0011\"a\u0005&\u0003\u0003\u0005\rA!\u0012\u0002\u0011-+\u0017PV1mk\u0016\u00042!a7('\u00119\u0013/!-\u0015\u0005\te\u0014A\u00034s_6\u0014VmY8sIR!\u0011\u0011\u001cBB\u0011\u001d\tY/\u000ba\u0001\u0005\u000b\u0003B!a:\u0003\b&!!\u0011RAu\u0005\u0019\u0011VmY8sI\u0006)\u0011\r\u001d9msR1\u0011\u0011\u001cBH\u0005#Cq!a.+\u0001\u0004\tY\fC\u0004\u0002T*\u0002\r!a/\u0002\u000fUt\u0017\r\u001d9msR!!q\u0013BR!\u0015\u0011(\u0011\u0014BO\u0013\r\u0011Yj\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fI\u0014y*a/\u0002<&\u0019!\u0011U:\u0003\rQ+\b\u000f\\33\u0011%\u0011)kKA\u0001\u0002\u0004\tI.A\u0002yIA\nAb\u001b<t)>\u0014VmY8sIN$BAa+\u0003>B1!Q\u0016B\\\u0003KtAAa,\u00034:!\u0011\u0011\u0019BY\u0013\u0005!\u0018b\u0001B[g\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B]\u0005w\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005k\u001b\bb\u0002B`Y\u0001\u0007!\u0011Y\u0001\nW\u0016Lh+\u00197vKN\u0004bA!,\u00038\u0006e\u0017\u0001\u0004:fG>\u0014Hm\u001d+p\u0017Z\u001cH\u0003\u0002Ba\u0005\u000fDqA!3.\u0001\u0004\u0011Y-A\u0004sK\u000e|'\u000fZ:\u0011\r\t5&q\u0017BC\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRA\u00111\u0002Bi\u0005'\u0014)\u000eC\u0004\u0003J:\u0002\rAa+\t\u00111t\u0003\u0013!a\u0001\u0003wB\u0011Ba6/!\u0003\u0005\r!a?\u0002\u001b%t\u0017\u000e^5bY>3gm]3u\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003^*\"\u00111\u0010B\u0004\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z2pe\u0012\u001cHC\u0004Bs\u0005W\u0014iO!=\u0003x\nm8q\u0001\t\u0005\u0003'\u00129/\u0003\u0003\u0003j\u0006U#!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000e\u0003\u0005mcA\u0005\t\u0019AA>\u0011%\u0011y/\rI\u0001\u0002\u0004\tY0A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\"\u0003BzcA%\t\u0019\u0001B{\u0003%i\u0017\r\u001f'f]\u001e$\b\u000eE\u0003s\u0003o\u0014Y\u0004C\u0005\u0003zF\u0002\n\u00111\u0001\u0003b\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D\u0011B!@2!\u0013\u0005\rAa@\u0002#5\f\u0007p\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rE\u0003s\u0003o\u001c\t\u0001\u0005\u0003\u0002T\r\r\u0011\u0002BB\u0003\u0003+\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019I!\rI\u0001\u0002\u0004\u0011\t'\u0001\nj]\u000edW\u000fZ3BE>\u0014H/\u001a3Uq:\u001c\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%M\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa\u0005+\t\tm\"qA\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IB\u000b\u0003\u0003b\t\u001d\u0011!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007?QCa!\u0001\u0003\b\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014\u0001\b;fgRdun\u001a#fY\u0016$XmU3h[\u0016tGo]*vG\u000e,7o\u001d\u0015\u0004q\r\u001d\u0002\u0003BAF\u0007SIAaa\u000b\u0002\u000e\n!A+Z:u\u0003i!Xm\u001d;S_2dW)\u001c9us\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uQ\rI4qE\u00017i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJ\u001cVoY2fgN<\u0006.\u001a8F[B$\u00180\u00118e\r\u0006LG.\u001e:f/\",gNT8o\u000b6\u0004H/\u001f\u0015\u0004u\r\u001d\u0012\u0001\u0005;fgR,\u0006\u000fZ1uK\u000e{gNZ5hQ\rY4qE\u0001\u0019i\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$vNT3x\t&\u0014\bf\u0001\u001f\u0004(\u0005iB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u000bbL7\u000f^5oO\u0012K'\u000fK\u0002>\u0007O\tA\u0002^3ti2{wM\u00127vg\"D3APB\u0014\u00035!Xm\u001d;M_\u001e\f\u0005\u000f]3oI\"\u001aqha\n\u0002'Q,7\u000f\u001e'pO\u000ecwn]3Tk\u000e\u001cWm]:)\u0007\u0001\u001b9#\u0001\fuKN$Hj\\4DY>\u001cX-\u00133f[B|G/\u001a8uQ\r\t5qE\u0001,i\u0016\u001cH\u000fT8h\u00072|7/\u001a$bS2,(/Z,iK:Le.T3n_JL()\u001e4gKJ\u001cEn\\:fI\"\u001a!ia\n\u0002)Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:tQ\r\u00195qE\u0001\u001fi\u0016\u001cH\u000fT8h\u00072|7/\u001a%b]\u0012dWM]:JI\u0016l\u0007o\u001c;f]RD3\u0001RB\u0014\u0003m!Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ugR!\u00111BB1\u0011\u001d\u0019\u0019'\u0012a\u0001\u0005C\n1\"Y:z]\u000e$U\r\\3uK\u0006yB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\u001c\u0016P\\2)\u0007\u0019\u001b9#\u0001\u0011uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001c\u0007fA$\u0004(\u00051B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7\u000f\u0006\u0003\u0002\f\rE\u0004bBB2\u0011\u0002\u0007!\u0011M\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgNKhn\u0019\u0015\u0004\u0013\u000e\u001d\u0012a\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Bgft7\rK\u0002K\u0007O\t1\u0004^3ti\u0012+G.\u001a;bE2,7+Z4nK:$8OR5mi\u0016\u0014\bfA&\u0004(\u0005qB/Z:u\t\u0016dW\r^1cY\u0016\u001cVmZ7f]R\u001c\u0018\n^3sCRLwN\u001c\u0015\u0004\u0019\u000e\u001d\u0012A\u0007;fgR\u001c%/Z1uK\u0006sG\rR3mKR,7+Z4nK:$\bfA'\u0004(\u0005YB/Z:u)J,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003RD3ATB\u0014\u00039!Xm\u001d;UeVt7-\u0019;f)>D3aTB\u0014\u0003e!Xm\u001d;O_:\f5\r^5wKN+w-\\3oiN4%o\\7)\u0007A\u001b9#\u0001\nu_BL7\rU1si&$\u0018n\u001c8OC6,GCBA^\u0007/\u001bY\nC\u0004\u0004\u001aF\u0003\r!a/\u0002\u000bQ|\u0007/[2\t\u000f\ru\u0015\u000b1\u0001\u0002<\u0006I\u0001/\u0019:uSRLwN\\\u0001\u001ci\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3)\u0007I\u001b9#\u0001\u001buKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.Z,ji\"\u0004VM]5pI\u001a{'\u000fR3mKR,G\rV8qS\u000eD3aUB\u0014\u0003\u001d\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/R7qift\u0015-\\3)\u0007Q\u001b9#\u0001\u0012uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe:+H\u000e\u001c\u0015\u0004+\u000e\u001d\u0012A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001b&\u001c8/\u001b8h'\u0016\u0004\u0018M]1u_JD3AVB\u0014\u0003)\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rV8qS\u000eD3aVB\u0014\u00039\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/T5tg&tw\rU1si&$\u0018n\u001c8)\u0007a\u001b9#\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe&sg/\u00197jIB\u000b'\u000f^5uS>t\u0007fA-\u0004(\u0005\u0001D/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]#ySN$\u0018N\\4J]Z\fG.\u001b3ESJD3AWB\u0014\u0003Q!Xm\u001d;M_\u001e$U\r\\3uK\u0012K'OT1nK\"\u001a1la\n\u0002%Q,7\u000f^(gMN,GO\u0012:p[\u001aKG.\u001a\u0015\u00049\u000e\u001d\u0012\u0001\t;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;UQ\u0006$\u0018\t\u001c:fC\u0012LX\t_5tiND3!XB\u0014\u0003a!Xm\u001d;OK^\u001cVmZ7f]R\u001c\u0018I\u001a;feJ{G\u000e\u001c\u0015\u0004=\u000e\u001d\u0012a\u000b;fgR\u0014v\u000e\u001c7TK\u001elWM\u001c;FeJ|'o\u00165f]:+\u0007\u0010^(gMN,G/S:JY2,w-\u00197)\u0007}\u001b9#\u0001\u000euKN$h\t\\;tQ&twMT8o\u000bbL7\u000f^3oi\u0012K'\u000fK\u0002a\u0007O\tqd\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u)Q\tYha8\u0004d\u000e-8Q_B}\u0007{$9\u0001b\u0006\u0005\u001a!I1\u0011]1\u0011\u0002\u0003\u0007\u00111D\u0001\u0004I&\u0014\bBB>b\u0001\u0004\u0019)\u000f\u0005\u0003\u0002T\r\u001d\u0018\u0002BBu\u0003+\u0012\u0011\u0002T8h\u0007>tg-[4\t\u0013\r5\u0018\r%AA\u0002\r=\u0018\u0001C:fO6,g\u000e^:\u0011\u0007i\u001c\t0C\u0002\u0004t.\u00141\u0002T8h'\u0016<W.\u001a8ug\"I1q_1\u0011\u0002\u0003\u0007\u00111`\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\rm\u0018\r%AA\u0002\r\u0005\u0011A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006D\u0011ba@b!\u0003\u0005\r\u0001\"\u0001\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA6\t\u0007IA\u0001\"\u0002\u0002n\tI1k\u00195fIVdWM\u001d\u0005\n\t\u0013\t\u0007\u0013!a\u0001\t\u0017\tA\u0001^5nKB!AQ\u0002C\n\u001b\t!yA\u0003\u0003\u0005\u0012\u0005e\u0012!B;uS2\u001c\u0018\u0002\u0002C\u000b\t\u001f\u0011A\u0001V5nK\"I\u0011\u0011G1\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0003\u001b\n\u0007\u0013!a\u0001\u0003#\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\nTC\u0001C\u0010U\u0011\tYBa\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t!)C\u000b\u0003\u0004p\n\u001d\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$C'A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0011=\"\u0006\u0002C\u0001\u0005\u000f\t\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012:TC\u0001C\u001bU\u0011!YAa\u0002\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t!YD\u000b\u0003\u00026\t\u001d\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0005B)\"\u0011\u0011\u000bB\u0004\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable & scala.Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> kv.toRecord$default$1()), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable & scala.Serializable)r -> this.KeyValue().fromRecord((Record)r), Iterable$.MODULE$.canBuildFrom());
    }

    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((long)initialOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])((SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        boolean x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        LocalLog x$2 = this.readRecords$default$1();
        long x$3 = this.readRecords$default$2();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, LocalLogTest.$anonfun$testLogAppend$1(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfoBeforeAppend.records.records()).asScala()).isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo fetchDataInfo = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete, List$.MODULE$.canBuildFrom())));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, x$1) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$1)));
        List expected = ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$2, x$3)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$52 = 9L;
        LocalLog x$6 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$6, x$52);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$4, x$5)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable & scala.Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.readRecords$default$1();
        boolean x$4 = this.readRecords$default$4();
        boolean x$6 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.appendRecords$default$2();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        long x$7 = 10L;
        LocalLog x$8 = this.readRecords$default$1();
        boolean x$10 = this.readRecords$default$4();
        boolean x$12 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$8.read(x$7, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable & scala.Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L), List$.MODULE$.canBuildFrom());
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        long x$4 = 6L;
        LocalLog x$5 = this.readRecords$default$1();
        boolean x$7 = this.readRecords$default$4();
        boolean x$9 = this.readRecords$default$6();
        FetchDataInfo fetchDataInfo = x$5.read(x$4, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala()).size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchDataInfo.records.records()).asScala())));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$11 = 7L;
        LocalLog x$12 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, x$11);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition)).toInt())));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LogFileUtils.logFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile = LogFileUtils.timeIndexFile((File)this.tmpDir(), (long)offset);
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        Iterable x$1 = (Iterable)keyValues2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.mockTime().milliseconds() + 10L), List$.MODULE$.canBuildFrom());
        long x$2 = 1L;
        LocalLog x$3 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = this.readRecords$default$6();
        boolean readRecords_minOneMessage = this.readRecords$default$4();
        FetchDataInfo readResult = this.readRecords$default$1().read(this.readRecords$default$2(), this.readRecords$default$3(), readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala()).size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((GenTraversableOnce)keyValues2, List$.MODULE$.canBuildFrom()), this.recordsToKvs((Iterable<Record>)((Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(readResult.records.records()).asScala())));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        long x$4 = 1L;
        LocalLog x$5 = this.appendRecords$default$2();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, x$4);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.appendRecords$default$2(), this.appendRecords$default$3());
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.appendRecords$default$2(), this.appendRecords$default$3());
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        long x$2 = 0L;
        int x$5 = config.initFileSize();
        boolean x$6 = config.preallocate;
        boolean x$7 = LogSegment$.MODULE$.open$default$5();
        String x$8 = LogSegment$.MODULE$.open$default$8();
        segments.add(LogSegment$.MODULE$.open(dir, x$2, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        long x$2 = 2L;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$1) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$2, Option x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$4, Option x$5) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.appendRecords$default$2();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((TraversableOnce)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11());
        File x$2 = this.createLocalLogWithActiveSegment$default$1();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = this.createLocalLogWithActiveSegment$default$4();
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        Time x$7 = this.createLocalLogWithActiveSegment$default$7();
        TopicPartition x$8 = this.createLocalLogWithActiveSegment$default$8();
        LogDirFailureChannel x$9 = this.createLocalLogWithActiveSegment$default$9();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    scala.Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

