/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u00014Aa\u0003\u0007\u0001#!)a\u0004\u0001C\u0001?\u0019!!\u0005\u0001\u0001$\u0011\u0015q\"\u0001\"\u0001%\u0011\u001d9#A1A\u0005\u0002!Ba!\r\u0002!\u0002\u0013I\u0003b\u0002\u001a\u0003\u0005\u0004%\ta\r\u0005\u0007y\t\u0001\u000b\u0011\u0002\u001b\t\u000bu\u0012A\u0011\u0001 \t\u000b\u0019\u0003A\u0011A$\t\u000ba\u0003A\u0011A$\u000371Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014H+Z:u\u0015\tia\"A\u0004nKR\u0014\u0018nY:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u000f\u0003\u0015)H/\u001b7t\u0013\ti\"DA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005a!!\u0004+fgR$\u0015N]3di>\u0014\u0018p\u0005\u0002\u0003%Q\tQ\u0005\u0005\u0002'\u00055\t\u0001!A\u0004cCN,G)\u001b:\u0016\u0003%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0005%|'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012AAR5mK\u0006A!-Y:f\t&\u0014\b%A\u0004tK24G)\u001b:\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t\u0019LG.\u001a\u0006\u0003s5\n1A\\5p\u0013\tYdG\u0001\u0003QCRD\u0017\u0001C:fY\u001a$\u0015N\u001d\u0011\u0002\u001b]\u0014\u0018\u000e^3Qe>\u001cg)\u001b7f)\r!t\b\u0012\u0005\u0006\u0001\"\u0001\r!Q\u0001\ne\u0016\fGMQ=uKN\u0004\"a\u0005\"\n\u0005\r#\"\u0001\u0002'p]\u001eDQ!\u0012\u0005A\u0002\u0005\u000b!b\u001e:ji\u0016\u0014\u0015\u0010^3t\u0003A!Xm\u001d;SK\u0006$\u0007K]8d\r&dW\rF\u0001I!\t\u0019\u0012*\u0003\u0002K)\t!QK\\5uQ\tIA\n\u0005\u0002N-6\taJ\u0003\u0002P!\u0006\u0019\u0011\r]5\u000b\u0005E\u0013\u0016a\u00026va&$XM\u001d\u0006\u0003'R\u000bQA[;oSRT\u0011!V\u0001\u0004_J<\u0017BA,O\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^+oC\ndW\rV8SK\u0006$gj\u001c8fq&\u001cH/\u001a8u!J|7MR5mK\"\u0012!\u0002\u0014\u0015\u0005\u0001msv\f\u0005\u0002N9&\u0011QL\u0014\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\b")
public class LinuxIoMetricsCollectorTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void testReadProcFile() {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(100L, 1000L);
        testDirectory.writeProcFile(123L, 456L);
        LinuxIoMetricsCollector collector = new LinuxIoMetricsCollector(testDirectory.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying());
        Assertions.assertTrue((boolean)collector.usable());
        Assertions.assertEquals((long)123L, (long)collector.readBytes());
        Assertions.assertEquals((long)456L, (long)collector.writeBytes());
        testDirectory.writeProcFile(124L, 457L);
        Assertions.assertEquals((long)123L, (long)collector.readBytes());
        Assertions.assertEquals((long)456L, (long)collector.writeBytes());
        time.sleep(1L);
        Assertions.assertEquals((long)124L, (long)collector.readBytes());
        Assertions.assertEquals((long)457L, (long)collector.writeBytes());
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        TestDirectory testDirectory = new TestDirectory();
        MockTime time = new MockTime(100L, 1000L);
        Assertions.assertFalse((boolean)new LinuxIoMetricsCollector(testDirectory.baseDir().getAbsolutePath(), (Time)time, this.logger().underlying()).usable());
    }

    public LinuxIoMetricsCollectorTest() {
        Logging.$init$((Logging)this);
    }

    public class TestDirectory {
        private final File baseDir;
        private final Path selfDir;

        public File baseDir() {
            return this.baseDir;
        }

        public Path selfDir() {
            return this.selfDir;
        }

        public Path writeProcFile(long readBytes, long writeBytes) {
            StringBuilder bld = new StringBuilder();
            bld.append(new StringOps(Predef$.MODULE$.augmentString("rchar: 0%n")).format((Seq)Nil$.MODULE$));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("wchar: 0%n")).format((Seq)Nil$.MODULE$));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("syschr: 0%n")).format((Seq)Nil$.MODULE$));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("syscw: 0%n")).format((Seq)Nil$.MODULE$));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("read_bytes: %d%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)readBytes)})));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("write_bytes: %d%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)writeBytes)})));
            bld.append(new StringOps(Predef$.MODULE$.augmentString("cancelled_write_bytes: 0%n")).format((Seq)Nil$.MODULE$));
            return Files.write(this.selfDir().resolve("io"), bld.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }

        public /* synthetic */ LinuxIoMetricsCollectorTest kafka$metrics$LinuxIoMetricsCollectorTest$TestDirectory$$$outer() {
            return LinuxIoMetricsCollectorTest.this;
        }

        public TestDirectory() {
            if (LinuxIoMetricsCollectorTest.this == null) {
                throw null;
            }
            this.baseDir = TestUtils.tempDirectory();
            this.selfDir = Files.createDirectories(this.baseDir().toPath().resolve("self"), new FileAttribute[0]);
        }
    }
}

