/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DefaultApiVersionManager;
import kafka.server.DefaultApiVersionManager$;
import kafka.server.ForwardingManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.server.metadata.ZkMetadataCache$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0013q\u0002B\u0002\u0012\u0001A\u0003%q\u0004C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\r-\u0002\u0001\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015\u0011\b\u0001\"\u0001k\u0011\u0015!\b\u0001\"\u0001k\u0011\u0015a\b\u0001\"\u0001k\u0005U\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u000e\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN,\u0012a\b\t\u00039\u0001J!!I\u0007\u0003\u001d\t\u0013xn[3s\r\u0016\fG/\u001e:fg\u0006y!M]8lKJ4U-\u0019;ve\u0016\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001&D\u0001\t[\u0016$\u0018\rZ1uC&\u0011!f\n\u0002\u00105.lU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013\u0001\u0004;fgR\f\u0005/[*d_B,GC\u0001\u00182!\t!r&\u0003\u00021+\t!QK\\5u\u0011\u0015\u0011d\u00011\u00014\u0003!\t\u0007/[*d_B,\u0007C\u0001\u001bN\u001d\t)$J\u0004\u00027\u000f:\u0011q\u0007\u0012\b\u0003q\ts!!O \u000f\u0005ijT\"A\u001e\u000b\u0005q\n\u0012A\u0002\u001fs_>$h(C\u0001?\u0003\ry'oZ\u0005\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001 \n\u0005A\u0019%B\u0001!B\u0013\t)e)\u0001\u0004d_6lwN\u001c\u0006\u0003!\rK!\u0001S%\u0002\u000f5,7o]1hK*\u0011QIR\u0005\u0003\u00172\u000ba\"\u00119j\u001b\u0016\u001c8/Y4f)f\u0004XM\u0003\u0002I\u0013&\u0011aj\u0014\u0002\r\u0019&\u001cH/\u001a8feRK\b/\u001a\u0006\u0003\u00172CCAB)^=B\u0011!kW\u0007\u0002'*\u0011A+V\u0001\taJ|g/\u001b3fe*\u0011akV\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005aK\u0016a\u00026va&$XM\u001d\u0006\u00035\u0006\u000bQA[;oSRL!\u0001X*\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,XmI\u00014Q\t1\u0001\r\u0005\u0002bE6\tQ+\u0003\u0002d+\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002!Q,7\u000f\u001e#jg\u0006\u0014G.\u001a3Ba&\u001cHC\u0001\u0018g\u0011\u0015\u0011t\u00011\u00014Q\u00119\u0011+\u00180)\u0005\u001d\u0001\u0017!\b;fgR\u001cuN\u001c;s_2dWM]!qS&sG/\u001a:tK\u000e$\u0018n\u001c8\u0015\u00039B#\u0001\u00037\u0011\u00055\u0004X\"\u00018\u000b\u0005=<\u0016aA1qS&\u0011\u0011O\u001c\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$XI\u001c<fY>\u0004X\rR5tC\ndW\r\u001a$pe.\u0013\u0016M\u001a;Ce>\\WM\u001d\u0015\u0003\u00131\fq\u0006^3ti\u0016sg/\u001a7pa\u0016,e.\u00192mK\u0012<\u0006.\u001a8G_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJ\u0004&/Z:f]RD#A\u00037)\t)9XL\u001f\t\u0003[bL!!\u001f8\u0003\u0011\u0011K7/\u00192mK\u0012\f\u0013a_\u00016\u000b:\f'\r\\3!C\u001a$XM\u001d\u0011f]\u0006\u0014G.\u001a\u0011L\u0013BkS'\u000f\u0019!M>\u0014x/\u0019:eS:<\u0007%\u001b8!\u0017\u000635*Q\u00172eaBd'\u0001\u0018uKN$XI\u001c<fY>\u0004X\rR5tC\ndW\rZ,iK:4uN]<be\u0012LgnZ'b]\u0006<WM]#naRL\bFA\u0006m\u0001")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(1, MetadataVersion.latest(), this.brokerFeatures(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$4(), ZkMetadataCache$.MODULE$.$lessinit$greater$default$5());

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala()).forall((Function1 & Serializable & scala.Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)ApiVersionManagerTest.$anonfun$testApiScope$1(versionManager, apiKey))));
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testDisabledApis(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache(), false, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6());
        ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope).forEach(apiKey -> {
            if (apiKey.messageType.latestVersionUnstable()) {
                Assertions.assertFalse((boolean)versionManager.isApiEnabled(apiKey, apiKey.latestVersion()), (String)new StringBuilder(29).append(apiKey).append(" version ").append(apiKey.latestVersion()).append(" should be disabled.").toString());
                return;
            }
        });
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 1;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6()).apiVersionResponse(0).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledForKRaftBroker() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        new .colon.colon((Object)new Some((Object)forwardingManager), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)forwardingManagerOpt -> {
            ApiVersionManagerTest.$anonfun$testEnvelopeDisabledForKRaftBroker$1(this, forwardingManagerOpt);
            return BoxedUnit.UNIT;
        });
    }

    @Disabled(value="Enable after enable KIP-590 forwarding in KAFKA-12886")
    @Test
    public void testEnvelopeEnabledWhenForwardingManagerPresent() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6());
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        ApiVersionsResponseData.ApiVersion envelopeVersion = versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id);
        Assertions.assertNotNull((Object)envelopeVersion);
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.oldestVersion(), (short)envelopeVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.latestVersion(), (short)envelopeVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledWhenForwardingManagerEmpty() {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6());
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNotNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }

    public static final /* synthetic */ boolean $anonfun$testApiScope$1(DefaultApiVersionManager versionManager$1, ApiKeys apiKey) {
        return ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(apiKey.allVersions()).asScala()).forall((Function1 & Serializable & scala.Serializable)version -> BoxesRunTime.boxToBoolean((boolean)versionManager$1.isApiEnabled(apiKey, Predef$.MODULE$.Short2short(version))));
    }

    public static final /* synthetic */ void $anonfun$testEnvelopeDisabledForKRaftBroker$1(ApiVersionManagerTest $this, Option forwardingManagerOpt) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, forwardingManagerOpt, $this.brokerFeatures(), (MetadataCache)$this.metadataCache(), true, DefaultApiVersionManager$.MODULE$.$lessinit$greater$default$6());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }
}

