/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004P\u0001\u0001\u0006I\u0001\u0014\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002,\t\u0013q\u0003\u0001\u0019!A!B\u0013\u0011\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0005I\"1\u0001\u000e\u0001Q\u0001\n\u0015Dq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u00191\b\u0001)A\u0005c\"9q\u000f\u0001b\u0001\n\u0013A\bbBA\u0007\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"!\t\u0001A\u0003%\u00111\u0003\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0003C\u0006\u0002.\u0001\u0001\r\u00111A\u0005\n\u0005=\u0002bCA\u001a\u0001\u0001\u0007\t\u0011)Q\u0005\u0003OA\u0001\"!\u000e\u0001\u0005\u0004%Ia\u0013\u0005\b\u0003o\u0001\u0001\u0015!\u0003M\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0018\u0001\t\u0003\t9\u0005C\u0004\u0002j\u0001!\t!a\u0012\t\u000f\u00055\u0004\u0001\"\u0001\u0002H!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004\"CAQ\u0001E\u0005I\u0011BAR\u0011%\tI\fAI\u0001\n\u0013\tY\fC\u0004\u0002@\u0002!\t!a\u0012\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002H!9\u0011q\u0019\u0001\u0005\u0002\u0005\u001d\u0003bBAf\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001f\u0004A\u0011AA$\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003\u000fBq!a6\u0001\t\u0003\t9\u0005C\u0004\u0002\\\u0002!\t!a\u0012\t\u000f\u0005}\u0007\u0001\"\u0001\u0002H!9\u00111\u001d\u0001\u0005\u0002\u0005\u001d\u0003bBAt\u0001\u0011\u0005\u0011q\t\u0005\b\u0003W\u0004A\u0011AA$\u0011\u001d\ty\u000f\u0001C\u0001\u0003\u000fBq!a=\u0001\t\u0003\t9\u0005C\u0004\u0002x\u0002!\t!a\u0012\t\u000f\u0005m\b\u0001\"\u0001\u0002H!9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\"\u0001\u0011%!Q\t\u0005\n\u0005K\u0002\u0011\u0013!C\u0005\u0005OBqAa\u001b\u0001\t\u0013\u0011i\u0007C\u0005\u0003|\u0001\t\n\u0011\"\u0003\u0003~!9!\u0011\u0011\u0001\u0005\n\t\r\u0005\"\u0003BY\u0001E\u0005I\u0011BAR\u0011%\u0011\u0019\fAI\u0001\n\u0013\tYL\u0001\u000fBkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005mb\u0014AB:feZ,'OC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\t!(\u0001\bsKF,Xm\u001d;US6,w.\u001e;\u0016\u00031\u0003\"!Q'\n\u00059\u0013%aA%oi\u0006y!/Z9vKN$H+[7f_V$\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002%B\u0011\u0011jU\u0005\u0003)j\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005]S\u0006CA!Y\u0013\tI&I\u0001\u0003V]&$\bbB.\u0006\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003}\u0003\"!\u00131\n\u0005\u0005T$!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002KB\u0011\u0011JZ\u0005\u0003Oj\u0012\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006\u0019\"M]8lKJ$vnQ8oiJ|G\u000e\\3sA\u0005a\u0011\rZ7j]6\u000bg.Y4feV\t1\u000e\u0005\u0002JY&\u0011QN\u000f\u0002\u000f5.\fE-\\5o\u001b\u0006t\u0017mZ3s\u00035\tG-\\5o\u001b\u0006t\u0017mZ3sA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0003E\u0004\"A\u001d;\u000e\u0003MT!a\u001c\u001f\n\u0005U\u001c(aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\u0012!\u001f\t\u0004u\u0006%Q\"A>\u000b\u0005ql\u0018!B4s_V\u0004(B\u0001@\u0000\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0007u\n\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB1qC\u000eDWM\u0003\u0002\u0002\b\u0005\u0019qN]4\n\u0007\u0005-1P\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J,\"!a\u0005\u0011\t\u0005U\u0011QD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005YAO]1og\u0006\u001cG/[8o\u0015\tqH(\u0003\u0003\u0002 \u0005]!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0002/Q\u0014\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\u0004\u0013\u0001G1vi>$v\u000e]5d\u0007J,\u0017\r^5p]6\u000bg.Y4feV\u0011\u0011q\u0005\t\u0004\u0013\u0006%\u0012bAA\u0016u\tA\u0012)\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8NC:\fw-\u001a:\u00029\u0005,Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'o\u0018\u0013fcR\u0019q+!\r\t\u0011m#\u0012\u0011!a\u0001\u0003O\t\u0011$Y;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3sA\u00059\u0012N\u001c;fe:\fG\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u0001\u0019S:$XM\u001d8bYR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013AH5oi\u0016\u0014h.\u00197U_BL7MU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s+\t\ti\u0004E\u0002B\u0003\u007fI1!!\u0011C\u0005\u0015\u0019\u0006n\u001c:u\u0003}Ig\u000e^3s]\u0006dGk\u001c9jGJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002/\"\u001a!$a\u0013\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005\u0019\u0011\r]5\u000b\t\u0005U\u0013qK\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tI&!\u0002\u0002\u000b),h.\u001b;\n\t\u0005u\u0013q\n\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0006;fgR\u001c%/Z1uK>3gm]3u)>\u0004\u0018n\u0019\u0015\u00047\u0005\r\u0004\u0003BA'\u0003KJA!a\u001a\u0002P\t!A+Z:u\u0003I!Xm\u001d;De\u0016\fG/\u001a+y]R{\u0007/[2)\u0007q\t\u0019'\u0001\u000euKN$8I]3bi\u0016tuN\\%oi\u0016\u0014h.\u00197U_BL7\rK\u0002\u001e\u0003G\nq\u0002^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u000b\n/\u0006U\u0014qRAM\u0003;Cq!a\u001e\u001f\u0001\u0004\tI(A\u0005u_BL7MT1nKB!\u00111PAE\u001d\u0011\ti(!\"\u0011\u0007\u0005}$)\u0004\u0002\u0002\u0002*\u0019\u00111\u0011 \u0002\rq\u0012xn\u001c;?\u0013\r\t9IQ\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0015Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d%\tC\u0004\u0002\u0012z\u0001\r!a%\u0002\u0015%\u001c\u0018J\u001c;fe:\fG\u000eE\u0002B\u0003+K1!a&C\u0005\u001d\u0011un\u001c7fC:D\u0001\"a'\u001f!\u0003\u0005\r\u0001T\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0013\u0005}e\u0004%AA\u0002\u0005u\u0012!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0006IB/Z:u\u0007J,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t)KK\u0002M\u0003O[#!!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\u0013\u0015AC1o]>$\u0018\r^5p]&!\u0011qWAW\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ai\u0016\u001cHo\u0011:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002>*\"\u0011QHAT\u0003\u0019\"Xm\u001d;De\u0016\fG/\u001a+pa&\u001c7oV5uQ\u001a{'o^1sI&tw\rR5tC\ndW\r\u001a\u0015\u0004C\u0005\r\u0014\u0001\r;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d$pe:{g.\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000fK\u0002#\u0003G\n1\u0007^3ti&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'OR8s\u0007>t7/^7fe>3gm]3ugR{\u0007/[2)\u0007\r\n\u0019'A\u0017uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:G_J$\u0006P\\(gMN,G\u000fV8qS\u000eD3\u0001JA2\u00031\"Xm\u001d;U_BL7-\u0012=jgR\u001cXI\u001d:peN;\u0018\r\u001d$pe:{g.\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000fK\u0002&\u0003G\nq\u0006^3tiR{\u0007/[2Fq&\u001cHo]#se>\u00148k^1q\r>\u00148i\u001c8tk6,'o\u00144gg\u0016$8\u000fV8qS\u000eD3AJA2\u0003%\"Xm\u001d;U_BL7-\u0012=jgR\u001cXI\u001d:peN;\u0018\r\u001d$peRChn\u00144gg\u0016$Hk\u001c9jG\"\u001aq%a\u0019\u0002_Q,7\u000f\u001e*fcV,7\u000f\u001e+j[\u0016|W\u000f^#se>\u00148k^1q\r>\u0014hj\u001c8J]R,'O\\1m)>\u0004\u0018nY:)\u0007!\n\u0019'A\u0019uKN$(+Z9vKN$H+[7f_V$XI\u001d:peN;\u0018\r\u001d$pe\u000e{gn];nKJ|eMZ:fiR{\u0007/[2)\u0007%\n\u0019'\u0001\u0017uKN$(+Z9vKN$H+[7f_V$XI\u001d:peN;\u0018\r\u001d$peRChn\u00144gg\u0016$Hk\u001c9jG\"\u001a!&a\u0019\u0002YQ,7\u000f^+oW:|wO\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c$pe:{g.\u00138uKJ4\u0018\r\u001c+pa&\u001c\u0007fA\u0016\u0002d\u0005yC/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8o\r>\u00148i\u001c8tk6,'o\u00144gg\u0016$Hk\u001c9jG\"\u001aA&a\u0019\u0002UQ,7\u000f^+oW:|wO\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c$peRChn\u00144gg\u0016$Hk\u001c9jG\"\u001aQ&a\u0019\u0002cQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ6+G/\u00193bi\u0006\u001cuN\u001c;fqR\u0004\u0016m]:Qe&t7-\u001b9bY\"\u001aa&a\u0019\u0002\u0001R,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ6+G/\u00193bi\u0006\u001cuN\u001c;fqR<\u0006.\u001a8Qe&t7-\u001b9bYN+'\u000fZ3O_R$UMZ5oK\u0012D3aLA2\u0003\u0005#Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"lU\r^1eCR\f7i\u001c8uKb$hj\u001c*fiJLX\u000b]8o+:\u001cX\u000f\u001d9peR,GMV3sg&|g\u000eK\u00021\u0003G\n\u0001$\u001b8ji&\fG.\u001b>f%\u0016\fX/Z:u\u0007>tG/\u001a=u)!\u0011\u0019Aa\u0005\u0003\u0016\t%\u0002\u0003\u0002B\u0003\u0005\u001fi!Aa\u0002\u000b\t\t%!1B\u0001\te\u0016\fX/Z:ug*\u0019!QB@\u0002\r\r|W.\\8o\u0013\u0011\u0011\tBa\u0002\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"9\u0011qO\u0019A\u0002\u0005e\u0004b\u0002B\fc\u0001\u0007!\u0011D\u0001\u000fW\u000647.\u0019)sS:\u001c\u0017\u000e]1m!\u0011\u0011YB!\n\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\tA!Y;uQ*!!1\u0005B\u0006\u0003!\u0019XmY;sSRL\u0018\u0002\u0002B\u0014\u0005;\u0011abS1gW\u0006\u0004&/\u001b8dSB\fG\u000eC\u0004\u0003,E\u0002\rA!\f\u0002\u001dA\u0014\u0018N\\2ja\u0006d7+\u001a:eKB1!q\u0006B\u001d\u0005{i!A!\r\u000b\t\tM\"QG\u0001\u0005kRLGN\u0003\u0002\u00038\u0005!!.\u0019<b\u0013\u0011\u0011YD!\r\u0003\u0011=\u0003H/[8oC2\u0004BAa\u0007\u0003@%!!\u0011\tB\u000f\u0005MY\u0015MZ6b!JLgnY5qC2\u001cVM\u001d3f\u0003e!Xm\u001d;FeJ|'oV5uQ\u000e\u0013X-\u0019;j_:LeNW6\u0015\u0013]\u00139Ea\u0016\u0003Z\tm\u0003b\u0002B%e\u0001\u0007!1J\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)!!\u0011\u000bB\u0006\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B+\u0005\u001f\u0012a!\u0012:s_J\u001c\bbBA<e\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003#\u0013\u0004\u0019AAJ\u0011%\u0011iF\rI\u0001\u0002\u0004\u0011y&A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0006\u0003\n\u0005$1J\u0005\u0004\u0005G\u0012%AB(qi&|g.A\u0012uKN$XI\u001d:pe^KG\u000f[\"sK\u0006$\u0018n\u001c8J]j[G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%$\u0006\u0002B0\u0003O\u000b!d\u0019:fCR,Gk\u001c9jG\u0006sGMV3sS\u001aL(+Z:vYR$\u0012b\u0016B8\u0005c\u0012\u0019H!\u001e\t\u000f\t%C\u00071\u0001\u0003L!9\u0011q\u000f\u001bA\u0002\u0005e\u0004bBAIi\u0001\u0007\u00111\u0013\u0005\n\u0005o\"\u0004\u0013!a\u0001\u0005s\nq\"\\3uC\u0012\fG/Y\"p]R,\u0007\u0010\u001e\t\u0006\u0003\n\u0005$1A\u0001%GJ,\u0017\r^3U_BL7-\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0010\u0016\u0005\u0005s\n9+A\u0006hKRtUm\u001e+pa&\u001cG\u0003\u0003BC\u0005W\u0013iKa,\u0011\t\t\u001d%Q\u0015\b\u0005\u0005\u0013\u0013yJ\u0004\u0003\u0003\f\nme\u0002\u0002BG\u00053sAAa$\u0003\u0018:!!\u0011\u0013BK\u001d\u0011\tyHa%\n\u0005\u0005\u001d\u0011\u0002BA\u0002\u0003\u000bI1!PA\u0001\u0013\r\u0011ia`\u0005\u0005\u0005;\u0013Y!A\u0004nKN\u001c\u0018mZ3\n\t\t\u0005&1U\u0001\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006TAA!(\u0003\f%!!q\u0015BU\u00059\u0019%/Z1uC\ndW\rV8qS\u000eTAA!)\u0003$\"9\u0011q\u000f\u001cA\u0002\u0005e\u0004\u0002CANmA\u0005\t\u0019\u0001'\t\u0013\u0005}e\u0007%AA\u0002\u0005u\u0012!F4fi:+w\u000fV8qS\u000e$C-\u001a4bk2$HEM\u0001\u0016O\u0016$h*Z<U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.setProperty(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(this.requestTimeout()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)new Node(0, "host0", 0), (List)new .colon.colon((Object)new Node(1, "host1", 1), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn((Object)aliveBrokers);
    }

    @Test
    public void testCreateOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateTxnTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, this.testCreateTopic$default$3(), this.testCreateTopic$default$4());
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, this.createTopicAndVerifyResult$default$4());
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, this.createTopicAndVerifyResult$default$4());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false, this.createTopicAndVerifyResult$default$4());
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3()))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, this.testErrorWithCreationInZk$default$4());
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return Utils.utf8((String)principal.toString());
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])capturedRequest.requestPrincipal())));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return Utils.utf8((String)principal.toString());
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    private RequestContext initializeRequestContext(String topicName, KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        new CreateTopicsRequestData.CreatableTopicCollection().add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3()));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion((short)0).setMaxVersion((short)0);
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false, principalSerde);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (isInternal) {
            if ("__consumer_offsets".equals(topicName)) {
                creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()));
            } else {
                if (!"__transaction_state".equals(topicName)) throw new MatchError((Object)topicName);
                creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()));
            }
        } else {
            creatableTopic = this.getNewTopic(topicName, this.getNewTopic$default$2(), this.getNewTopic$default$3());
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable & scala.Serializable)() -> error), topicName, isInternal, this.createTopicAndVerifyResult$default$4());
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(5)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

