/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerChannelManager$;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u0006\f\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\u0002qAQ\u0001\u000b\u0001\u0005\u0002%BQa\u0016\u0001\u0005\u0002aCq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0002\u001e\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|gNU3rk\u0016\u001cH\u000fV3ti*\u0011A\"D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0006\u0002A\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u000b\u0003;\u0001\u0002\"A\u0007\u0010\n\u0005}Y!\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJDQ!\t\u0002A\u0002\t\nqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K5\tA\u0001^3ti&\u0011q\u0005\n\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u0006q1/\u001a8e\u0003:$'+Z2fSZ,Wc\u0001\u0016M[Q!1\u0006\u0011\"S!\taS\u0006\u0004\u0001\u0005\u000b9\u001a!\u0019A\u0018\u0003\u0003I\u000b\"\u0001M\u001a\u0011\u0005I\t\u0014B\u0001\u001a\u0014\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u000e \u000e\u0003UR!AN\u001c\u0002\u0011I,\u0017/^3tiNT!\u0001O\u001d\u0002\r\r|W.\\8o\u0015\tq!H\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<\u0017BA 6\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0003B\u0007\u0001\u0007Q$\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\t\u000b\r\u001b\u0001\u0019\u0001#\u0002\u0015I,\u0017OQ;jY\u0012,'\u000fE\u0002F\u0011.s!\u0001\u000e$\n\u0005\u001d+\u0014aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\u0005%S%a\u0002\"vS2$WM\u001d\u0006\u0003\u000fV\u0002\"\u0001\f'\u0005\u000b5\u001b!\u0019\u0001(\u0003\u0003Q\u000b\"\u0001M(\u0011\u0005Q\u0002\u0016BA)6\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"B*\u0004\u0001\u0004!\u0016!\u0003;j[\u0016|W\u000f^'t!\t\u0011R+\u0003\u0002W'\t\u0019\u0011J\u001c;\u0002\u001dI,w-[:uKJ\u0014%o\\6feR1\u0011l\u00181n_^\u0004\"AW/\u000e\u0003mS!\u0001X\u001c\u0002\u0011A\u0014x\u000e^8d_2L!AX.\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015\tE\u00011\u0001\u001e\u0011\u0015\tG\u00011\u0001c\u0003%\u0019G.^:uKJLE\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003KNi\u0011A\u001a\u0006\u0003O>\ta\u0001\u0010:p_Rt\u0014BA5\u0014\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u001c\u0002\"\u00028\u0005\u0001\u0004!\u0016\u0001\u00032s_.,'/\u00133\t\u000bA$\u0001\u0019A9\u0002\u000fi\\W\t]8dQB\u0019!C\u001d;\n\u0005M\u001c\"AB(qi&|g\u000e\u0005\u0002\u0013k&\u0011ao\u0005\u0002\u0005\u0019>tw\rC\u0003y\t\u0001\u0007\u00110A\u0005jEB$vnU3oIB\u0019!C\u001d>\u0011\tIYX0`\u0005\u0003yN\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001@\u0002\u00045\tqPC\u00029\u0003\u0003Q!\u0001D\u001d\n\u0007\u0005\u0015qPA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u00031\u0019'/Z1uKR{\u0007/[2t)\u0015I\u00161BA\u0007\u0011\u0015\tU\u00011\u0001\u001e\u0011\u0019\ty!\u0002a\u0001E\u0006IAo\u001c9jG:\u000bW.Z\u0001)i\u0016\u001cHOU3hSN$XM\u001d.l/&$\bn\u0013*bMRl\u0015n\u001a:bi&|g\u000eR5tC\ndW\r\u001a\u000b\u0005\u0003+\tY\u0002E\u0002\u0013\u0003/I1!!\u0007\u0014\u0005\u0011)f.\u001b;\t\u000b\u00052\u0001\u0019\u0001\u0012)/\u0019\ty\"a\u000b\u0002.\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002L\u00055\u0003\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015B%\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002$\tY1\t\\;ti\u0016\u0014H+Z:u\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0005\u0005=\u0012\u0002BA\u0019\u0003g\tQa\u0013*B\rRSA!!\u000e\u0002$\u0005!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012\u0001A\u0001\fG>tGO]8mY\u0016\u00148/H\u0001\u0002\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA\"\u0013\u0011\t)%a\u0012\u0002\u0017%\u0013\u0005kX\u001a`i}Ke\u000b\r\u0006\u0004\u0003\u0013z\u0018aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHFAA(W)\t\t&a\u0016\u0002Z\u0005u\u0013q\f\t\u0005\u0003C\t\u0019&\u0003\u0003\u0002V\u0005\r\"!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018EAA.\u0003\rRxn\\6fKB,'OL7fi\u0006$\u0017\r^1/[&<'/\u0019;j_:tSM\\1cY\u0016\fQA^1mk\u0016\f#!!\u0019\u0002\u000b\u0019\fGn]3\u0002=Q,7\u000f\u001e*fO&\u001cH/\u001a:[W^KG\u000f[\u001a4\u0007>tGO]8mY\u0016\u0014H\u0003BA\u000b\u0003OBQ!I\u0004A\u0002\tBscBA\u0010\u0003W\ti#a\u000e\u0002:\u0005m\u0012QHA \u0003W\nY%!\u001d%\u0005\u00055\u0014\u0002BA8\u0003\u000f\n1\"\u0013\"Q?Nz6gX%Wg1\u0012\u0011qJ\u0001(i\u0016\u001cHOU3hSN$XM\u001d.l/&$\bn\u0013*bMRl\u0015n\u001a:bi&|g.\u00128bE2,G\r\u0006\u0003\u0002\u0016\u0005]\u0004\"B\u0011\t\u0001\u0004\u0011\u0003f\u0007\u0005\u0002 \u0005-\u0012QFA\u001c\u0003{\tY$!\u0010\u0002@\u0005\u0005\u00131PA?\u0003\u0017\n9)A\u0005bkR|7\u000b^1si\u0012\u0012\u0011qP\u0005\u0005\u0003\u0003\u000b\u0019)\u0001\u0002O\u001f*!\u0011QQA\u0012\u0003%\tU\u000f^8Ti\u0006\u0014H\u000f\f\u0002\u0002\n.R\u0011\u0011KA,\u00033\ni&a#\"\u0005\u00055\u0015\u0001\u0002;sk\u0016\fq\u0005^3ti:{W*\u001a;bI\u0006$\u0018m\u00115b]\u001e,7/\u00138Qe\u0016l\u0015n\u001a:bi&|g.T8eKR!\u0011QCAJ\u0011\u0015\t\u0013\u00021\u0001#Q\u001dI\u0011qSA/\u0003;\u0003B!!\t\u0002\u001a&!\u00111TA\u0012\u00051\u0019E.^:uKJ$Vm\u001d;tY\t\tyj\u000b\f\u0002 \u0005-\u0012QFA>\u0003{\nY$!\u0010\u0002@\u0005\u0005\u00131JAQY\t\tI\tK\u0004\u0001\u0003K\u000bi&!0\u0011\t\u0005\u001d\u0016\u0011X\u0007\u0003\u0003SSA!a+\u0002.\u0006IQ\r\u001f;f]NLwN\u001c\u0006\u0005\u0003_\u000b\t,A\u0002ba&TA!a-\u00026\u00069!.\u001e9ji\u0016\u0014(bAA\\y\u0005)!.\u001e8ji&!\u00111XAU\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u0003\u007f\u001b#!!1\u0011\t\u0005\r\u0017qY\u0007\u0003\u0003\u000bT1!a.%\u0013\u0011\tI-!2\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\":\u0001!!4\u0002^\u0005U\u0007\u0003BAh\u0003#l!!!,\n\t\u0005M\u0017Q\u0016\u0002\u0004)\u0006<\u0017EAAl\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\u000f\u0001\tY.!\u0018\u0002bB!\u0011qZAo\u0013\u0011\ty.!,\u0003\u000fQKW.Z8viz\t\u0001\u0010")
public class BrokerRegistrationRequestTest {
    public BrokerToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        return BrokerToControllerChannelManager$.MODULE$.apply(new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        }, Time.SYSTEM, new Metrics(), clusterInstance.anyControllerSocketServer().config(), "heartbeat", "test-heartbeat-", 10000L);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(BrokerToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(BrokerToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(features, x0$1)));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features);
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public Errors createTopics(BrokerToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$1 -> x$1.startup());
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, autoStart=AutoStart.NO, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})})
    public void testNoMetadataChangesInPreMigrationMode(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$2 -> x$2.startup());
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertThrows(TimeoutException.class, () -> this.createTopics(channelManager, "test-pre-migration"));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.featureLevel()).setMaxSupportedVersion(max.featureLevel()));
        }
        throw new MatchError(null);
    }
}

