/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\t\r)\u0002\u0001\u0015!\u0003(\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015i\u0004\u0001\"\u0001-\u0011\u0015y\u0004\u0001\"\u0001-\u0011\u0015\t\u0005\u0001\"\u0001-\u0011\u0015\u0019\u0005\u0001\"\u0001-\u0011\u0015)\u0005\u0001\"\u0001-\u0011\u00159\u0005\u0001\"\u0001-\u0011\u0015I\u0005\u0001\"\u0001-\u0005\u0011\u001auN\u001c;s_2dWM]\"p]\u001aLw-\u001e:bi&|gNV1mS\u0012\fGo\u001c:UKN$(B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001f\u000511m\u001c8gS\u001e,\u0012!\t\t\u0003=\tJ!aI\b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003%1\u0018\r\\5eCR|'/F\u0001(!\tq\u0002&\u0003\u0002*\u001f\t\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003)1\u0018\r\\5eCR|'\u000fI\u0001#i\u0016\u001cH\u000fR3gCVdG\u000fV8qS\u000e\u0014Vm]8ve\u000e,\u0017j\u001d*fU\u0016\u001cG/\u001a3\u0015\u00035\u0002\"A\u0006\u0018\n\u0005=:\"\u0001B+oSRD#AB\u0019\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0014(A\u0003kk:LGOC\u0001;\u0003\ry'oZ\u0005\u0003yM\u0012A\u0001V3ti\u0006aB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019(b[\u0016\u0014VM[3di\u0016$\u0007FA\u00042\u0003]!Xm\u001d;V].twn\u001e8SKN|WO]2f)f\u0004X\r\u000b\u0002\tc\u0005AB/Z:u\u001dVdG\u000eV8qS\u000e\u001cuN\u001c4jOZ\u000bG.^3)\u0005%\t\u0014\u0001\u0006;fgR4\u0016\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u000bc\u00051B/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\fc\u00059B/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:F]RLG/\u001f\u0015\u0003\u0019E\n1\u0004^3ti&sg/\u00197jI:+w-\u0019;jm\u0016\u0014%o\\6fe&#\u0007FA\u00072\u0001")
public class ControllerConfigurationValidatorTest {
    private final KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createDummyBrokerConfig());
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(this.config());

    public KafkaConfig config() {
        return this.config;
    }

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config)).getMessage());
    }
}

