/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001U3Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C\u00015!)a\u0006\u0001C\u00015!)\u0001\u0007\u0001C\u00015!)!\u0007\u0001C\u00015!)A\u0007\u0001C\u00015!)a\u0007\u0001C\u00015!)\u0001\b\u0001C\u00015!)!\b\u0001C\u00015!)A\b\u0001C\u0001{\ty1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"\u0001B+oSRD#A\u0001\u0012\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005\u00152\u0013aA1qS*\u0011q\u0005K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI#&A\u0003kk:LGOC\u0001,\u0003\ry'oZ\u0005\u0003[\u0011\u0012A\u0001V3ti\u0006IC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[W\u000e{gNZ5h/\",gnU1tY\u0012K7/\u00192mK\u0012D#a\u0001\u0012\u0002QQ,7\u000f^\"sK\u0006$Xm\u001d)s_B,'OW6UYN\u001cuN\u001c4jO^CWM\u001c#jg\u0006\u0014G.\u001a3)\u0005\u0011\u0011\u0013A\u000b;fgR\u001c%/Z1uKN\u0004&o\u001c9fej[G\u000b\\:D_:4\u0017nZ,ji\"$&/^3WC2,Xm\u001d\u0015\u0003\u000b\t\n!\u0007^3ti\u000e\u0013X-\u0019;fgB\u0013x\u000e]3s5.$Fn]\"p]\u001aLwmV5uQ\u001a\u000bGn]3B]\u0012d\u0015n\u001d;WC2,Xm\u001d\u0015\u0003\r\t\n\u0001\u0003^3tij[\u0017j\u001d:NC:\fw-\u001a:)\u0005\u001d\u0011\u0013a\u0005;fgR\fE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\bF\u0001\u0005#\u0003\u0005\"Xm\u001d;SK6|G/\u001a'pO6\u000bg.Y4fe&s7\u000f^1oi&\fG/[8oQ\tI!%\u0001\u0007de\u0016\fG/Z*feZ,'\u000f\u0006\u0003?\u0003\u001a\u001b\u0006CA\n@\u0013\t\u0001EBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"\u0002\"\u000b\u0001\u0004\u0019\u0015A\u00028pI\u0016LE\r\u0005\u0002\u001d\t&\u0011Q)\b\u0002\u0004\u0013:$\b\"B$\u000b\u0001\u0004A\u0015\u0001\u00035pgRt\u0015-\\3\u0011\u0005%\u0003fB\u0001&O!\tYU$D\u0001M\u0015\ti\u0005#\u0001\u0004=e>|GOP\u0005\u0003\u001fv\ta\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q*\b\u0005\u0006)*\u0001\raQ\u0001\u0005a>\u0014H\u000f")
public class KafkaServerTest
extends QuorumTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, TestUtils$.MODULE$.boundPort$default$2())));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), TestUtils$.MODULE$.shutdownServers$default$2());
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testZkIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    @Test
    public void testAlterIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.latest().toString());
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).head();
        props.put("remote.log.storage.system.enable", Boolean.toString(true));
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager");
        props.put("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager");
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        Option option = server.remoteLogManagerOpt();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
            } else {
                throw new MatchError((Object)option);
            }
        }
        server.shutdown();
    }

    public KafkaServer createServer(int nodeId, String hostName, int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "HTTPS";
        }
        return someValue$1;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        return someValue$1;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "false";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

