/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQa\u000b\u0001\u0005R1BQA\u000f\u0001\u0005\u0002mBQa\u001b\u0001\u0005\u00021DQA\u001d\u0001\u0005\u0002MDQ\u0001\u001f\u0001\u0005\u0002eDQA \u0001\u0005\u0002}Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002\b\u0002!I!!#\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"9\u0011q\u001e\u0001\u0005\n\u0005E\bb\u0002B\u000f\u0001\u0011%!q\u0004\u0002\u000e\u0019><wJ\u001a4tKR$Vm\u001d;\u000b\u0005]A\u0012AB:feZ,'OC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\f\n\u0005}1\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u000f\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u00121!\u00138u\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002.aA\u0011aEL\u0005\u0003_\u001d\u0012A!\u00168ji\")\u0011g\u0001a\u0001e\u0005)\u0001O]8qgB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005kRLGNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$A\u0003)s_B,'\u000f^5fg\u0006iB/Z:u\u000f\u0016$xJ\u001a4tKR\u001chi\u001c:V].twn\u001e8U_BL7\r\u0006\u0002.y!)Q\b\u0002a\u0001}\u00051\u0011/^8sk6\u0004\"a\u0010$\u000f\u0005\u0001#\u0005CA!(\u001b\u0005\u0011%BA\"\u001b\u0003\u0019a$o\\8u}%\u0011QiJ\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002FO!\"AA\u0013-Z!\tYe+D\u0001M\u0015\tie*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\ty\u0005+\u0001\u0004qCJ\fWn\u001d\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002T)\u0006)!.\u001e8ji*\tQ+A\u0002pe\u001eL!a\u0016'\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\tQF,I\u0001\\\u0003\tQ8.I\u0001^\u0003\u0015Y'/\u00194uQ\t!q\f\u0005\u0002aC6\ta*\u0003\u0002c\u001d\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t\u0011!w-\u001b\t\u0003M\u0015L!AZ\u0014\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001i\u0003Ua\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;!-B\n\u0013A[\u0001\u0001\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:\u0015\u00055j\u0007\"B\u001f\u0006\u0001\u0004q\u0004\u0006B\u0003K1>d#A\u0017/)\u0005\u0015y\u0006\u0006B\u0003eO&\fa\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B4uN]'bqRKW.Z:uC6\u0004\u0018I\u001a;feR\u0013XO\\2bi\u0016$\"!\f;\t\u000bu2\u0001\u0019\u0001 )\t\u0019Q\u0005L\u001e\u0017\u00035rC#AB0\u0002\u0001R,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q/&$\b.\u00168pe\u0012,'/\u001a3US6,7\u000f^1naN$\"!\f>\t\u000bu:\u0001\u0019\u0001 )\t\u001dQ\u0005\f \u0017\u00035rC#aB0\u0002=Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u0019\u0006$Xm\u001d;US6,GcA\u0017\u0002\u0002!)Q\b\u0003a\u0001}!*\u0001B\u0013-\u0002\u00061\u0012!\f\u0018\u0015\u0003\u0011}\u000bq\u0003^3ti\u0016k\u0007\u000f^=M_\u001e\u001cx)\u001a;PM\u001a\u001cX\r^:\u0015\u00075\ni\u0001C\u0003>\u0013\u0001\u0007a\bK\u0003\n\u0015b\u000b\t\u0002\f\u0002[9\"\u0012\u0011bX\u00016i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9XSRDW)\u001c9us2{w\rF\u0002.\u00033AQ!\u0010\u0006A\u0002yBSA\u0003&Y\u0003;a#A\u0017/)\u0005)y\u0016a\u0006;fgR<U\r^(gMN,Go\u001d\"fM>\u0014XMT8x)\ri\u0013Q\u0005\u0005\u0006{-\u0001\rA\u0010\u0015\u0006\u0017)C\u0016\u0011\u0006\u0017\u00035rC#aC0)\u000b-!\u0017qF5\"\u0005\u0005E\u0012\u0001\u00077fO\u0006\u001c\u0017PR3uG\"|eMZ:fiN\u0014UMZ8sK\u0006\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016,\u0015M\u001d7jKN$H+[7f)\ri\u0013q\u0007\u0005\u0006{1\u0001\rA\u0010\u0015\u0006\u0019)C\u00161\b\u0017\u00035rC#\u0001D0)\u000b1!\u0017qF5\u0002[Q,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8u'&TX\rF\u0002.\u0003\u000bBQ!P\u0007A\u0002yBS!\u0004&Y\u0003\u0013b#A\u0017/)\u00055y\u0016A\u000b;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGo\u001d\u000b\u0004[\u0005E\u0003\"B\u001f\u000f\u0001\u0004q\u0004&\u0002\bK1\u0006UCF\u0001.]Q\tqq,\u0001\u0004ce>\\WM]\u000b\u0003\u0003;\u00022!HA0\u0013\r\t\tG\u0006\u0002\f\u0017\u000647.\u0019\"s_.,'/\u0001\ftK:$G*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0011\t9'! \u0011\t\u0005%\u0014\u0011P\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005A!/Z9vKN$8O\u0003\u0003\u0002r\u0005M\u0014AB2p[6|gNC\u0002\u001a\u0003kR1!a\u001eU\u0003\u0019\t\u0007/Y2iK&!\u00111PA6\u0005Ma\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\u0011\u001d\ty\b\u0005a\u0001\u0003\u0003\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002j\u0005\r\u0015\u0002BAC\u0003W\u0012!\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0006\u00012/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0003\u0017\u000b\t\n\u0005\u0003\u0002j\u00055\u0015\u0002BAH\u0003W\u0012QBR3uG\"\u0014Vm\u001d9p]N,\u0007bBA@#\u0001\u0007\u00111\u0013\t\u0005\u0003S\n)*\u0003\u0003\u0002\u0018\u0006-$\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0001\u00052vS2$G+\u0019:hKR$\u0016.\\3t)!\ti*!6\u0002b\u0006-\bCBAP\u0003S\u000byK\u0004\u0003\u0002\"\u0006\u0015fbA!\u0002$&\t\u0001&C\u0002\u0002(\u001e\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00065&\u0001\u0002'jgRT1!a*(!\u0011\t\t,a4\u000f\t\u0005M\u0016\u0011\u001a\b\u0005\u0003k\u000b)M\u0004\u0003\u00028\u0006\rg\u0002BA]\u0003\u0003tA!a/\u0002@:\u0019\u0011)!0\n\u0003UK1!a\u001eU\u0013\rI\u0012QO\u0005\u0005\u0003c\n\u0019(\u0003\u0003\u0002H\u0006=\u0014aB7fgN\fw-Z\u0005\u0005\u0003\u0017\fi-\u0001\fMSN$xJ\u001a4tKR\u001c(+Z9vKN$H)\u0019;b\u0015\u0011\t9-a\u001c\n\t\u0005E\u00171\u001b\u0002\u0011\u0019&\u001cHo\u00144gg\u0016$8\u000fV8qS\u000eTA!a3\u0002N\"9\u0011q\u001b\nA\u0002\u0005e\u0017A\u0001;q!\u0011\tY.!8\u000e\u0005\u0005=\u0014\u0002BAp\u0003_\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002dJ\u0001\r!!:\u0002\u0013QLW.Z:uC6\u0004\bc\u0001\u0014\u0002h&\u0019\u0011\u0011^\u0014\u0003\t1{gn\u001a\u0005\u0007\u0003[\u0014\u0002\u0019A\u0013\u0002\u001b5\f\u0007PT;n\u001f\u001a47/\u001a;t\u000351\u0017N\u001c3QCJ$\u0018\u000e^5p]R1\u00111\u001fB\u0001\u00057\u0001B!!>\u0002|:!\u00111WA|\u0013\u0011\tI0!4\u0002/1K7\u000f^(gMN,Go\u001d*fgB|gn]3ECR\f\u0017\u0002BA\u007f\u0003\u007f\u0014A\u0004T5ti>3gm]3ugB\u000b'\u000f^5uS>t'+Z:q_:\u001cXM\u0003\u0003\u0002z\u00065\u0007b\u0002B\u0002'\u0001\u0007!QA\u0001\u0007i>\u0004\u0018nY:\u0011\r\t\u001d!\u0011\u0003B\u000b\u001b\t\u0011IA\u0003\u0003\u0003\f\t5\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005\u001f9\u0013AC2pY2,7\r^5p]&!!1\u0003B\u0005\u0005\u0019\u0011UO\u001a4feB!\u0011Q\u001fB\f\u0013\u0011\u0011I\"a@\u000311K7\u000f^(gMN,Go\u001d+pa&\u001c'+Z:q_:\u001cX\rC\u0004\u0002XN\u0001\r!!7\u0002)\r\u0014X-\u0019;f)>\u0004\u0018nY!oI\u001e+G\u000fT8h)\u0019\u0011\tC!\f\u00032A!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003(a\t1\u0001\\8h\u0013\u0011\u0011YC!\n\u0003\u0015Us\u0017NZ5fI2{w\r\u0003\u0004\u00030Q\u0001\rAP\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005g!\u0002\u0019AAm\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Ds\u0001\u0001B\u001c\u0005\u0007\u0012)\u0005\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\r\u0011i\u0004U\u0001\u0004CBL\u0017\u0002\u0002B!\u0005w\u0011q\u0001V5nK>,H/A\u0003wC2,XM\b\u0002\u0002Y\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).timestamp);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L})).foreach((Function1 & Serializable & scala.Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala()).head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeNow$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-2L, -4L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)timestamp -> {
            Seq offsets = log.legacyFetchOffsetsBefore(timestamp, 10);
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeEarliestTime$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, timestamp, 10)).asJava()).build();
            Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
            Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)new Iterable<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public GenericCompanion<Iterable> companion() {
                return Iterable.companion$((Iterable)this);
            }

            public Iterable<LogSegment> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public Iterable<LogSegment> thisCollection() {
                return IterableLike.thisCollection$((IterableLike)this);
            }

            public Iterable toCollection(Object repr) {
                return IterableLike.toCollection$((IterableLike)this, (Object)repr);
            }

            public <U> void foreach(Function1<LogSegment, U> f) {
                IterableLike.foreach$((IterableLike)this, f);
            }

            public boolean forall(Function1<LogSegment, Object> p) {
                return IterableLike.forall$((IterableLike)this, p);
            }

            public boolean exists(Function1<LogSegment, Object> p) {
                return IterableLike.exists$((IterableLike)this, p);
            }

            public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                return IterableLike.find$((IterableLike)this, p);
            }

            public boolean isEmpty() {
                return IterableLike.isEmpty$((IterableLike)this);
            }

            public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableLike.foldRight$((IterableLike)this, z, op);
            }

            public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                return (B)IterableLike.reduceRight$((IterableLike)this, op);
            }

            public Iterable<LogSegment> toIterable() {
                return IterableLike.toIterable$((IterableLike)this);
            }

            public Iterator<LogSegment> toIterator() {
                return IterableLike.toIterator$((IterableLike)this);
            }

            public Object head() {
                return IterableLike.head$((IterableLike)this);
            }

            public Object slice(int from, int until) {
                return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
            }

            public Object take(int n) {
                return IterableLike.take$((IterableLike)this, (int)n);
            }

            public Object drop(int n) {
                return IterableLike.drop$((IterableLike)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
            }

            public Iterator<Iterable<LogSegment>> grouped(int size) {
                return IterableLike.grouped$((IterableLike)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size) {
                return IterableLike.sliding$((IterableLike)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
            }

            public Object takeRight(int n) {
                return IterableLike.takeRight$((IterableLike)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableLike.dropRight$((IterableLike)this, (int)n);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
            }

            public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.zip$((IterableLike)this, that, bf);
            }

            public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
            }

            public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
            }

            public <B> boolean sameElements(GenIterable<B> that) {
                return IterableLike.sameElements$((IterableLike)this, that);
            }

            public Stream<LogSegment> toStream() {
                return IterableLike.toStream$((IterableLike)this);
            }

            public boolean canEqual(Object that) {
                return IterableLike.canEqual$((IterableLike)this, (Object)that);
            }

            public IterableView<LogSegment, Iterable<LogSegment>> view() {
                return IterableLike.view$((IterableLike)this);
            }

            public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                return IterableLike.view$((IterableLike)this, (int)from, (int)until);
            }

            public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
            }

            public <B> Builder<B, Iterable<B>> genericBuilder() {
                return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
            }

            public GenTraversable flatten(Function1 asTraversable) {
                return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public GenTraversable transpose(Function1 asTraversable) {
                return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
            }

            public Object repr() {
                return TraversableLike.repr$((TraversableLike)this);
            }

            public final boolean isTraversableAgain() {
                return TraversableLike.isTraversableAgain$((TraversableLike)this);
            }

            public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                return TraversableLike.parCombiner$((TraversableLike)this);
            }

            public boolean hasDefiniteSize() {
                return TraversableLike.hasDefiniteSize$((TraversableLike)this);
            }

            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
            }

            public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.map$((TraversableLike)this, f, bf);
            }

            public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
            }

            public Object filterImpl(Function1 p, boolean isFlipped) {
                return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
            }

            public Object filter(Function1 p) {
                return TraversableLike.filter$((TraversableLike)this, (Function1)p);
            }

            public Object filterNot(Function1 p) {
                return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
            }

            public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                return TraversableLike.partition$((TraversableLike)this, p);
            }

            public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                return TraversableLike.groupBy$((TraversableLike)this, f);
            }

            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
            }

            public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
            }

            public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
            }

            public Option<LogSegment> headOption() {
                return TraversableLike.headOption$((TraversableLike)this);
            }

            public Object tail() {
                return TraversableLike.tail$((TraversableLike)this);
            }

            public Object last() {
                return TraversableLike.last$((TraversableLike)this);
            }

            public Option<LogSegment> lastOption() {
                return TraversableLike.lastOption$((TraversableLike)this);
            }

            public Object init() {
                return TraversableLike.init$((TraversableLike)this);
            }

            public Object sliceWithKnownDelta(int from, int until, int delta) {
                return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
            }

            public Object sliceWithKnownBound(int from, int until) {
                return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
            }

            public Object dropWhile(Function1 p) {
                return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                return TraversableLike.span$((TraversableLike)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                return TraversableLike.splitAt$((TraversableLike)this, (int)n);
            }

            public Iterator<Iterable<LogSegment>> tails() {
                return TraversableLike.tails$((TraversableLike)this);
            }

            public Iterator<Iterable<LogSegment>> inits() {
                return TraversableLike.inits$((TraversableLike)this);
            }

            public Traversable<LogSegment> toTraversable() {
                return TraversableLike.toTraversable$((TraversableLike)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                return (Col)TraversableLike.to$((TraversableLike)this, cbf);
            }

            public String toString() {
                return TraversableLike.toString$((TraversableLike)this);
            }

            public String stringPrefix() {
                return TraversableLike.stringPrefix$((TraversableLike)this);
            }

            public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                return TraversableLike.withFilter$((TraversableLike)this, p);
            }

            public Parallel par() {
                return Parallelizable.par$((Parallelizable)this);
            }

            public List<LogSegment> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<LogSegment, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<LogSegment> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Seq<LogSegment> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<LogSegment> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<LogSegment> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return new .colon.colon((Object)this.logSegment$1, (List)Nil$.MODULE$).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Parallelizable.$init$((Parallelizable)this);
                TraversableLike.$init$((TraversableLike)this);
                GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                GenTraversable.$init$((GenTraversable)this);
                Traversable.$init$((Traversable)this);
                GenIterable.$init$((GenIterable)this);
                IterableLike.$init$((IterableLike)this);
                Iterable.$init$((Iterable)this);
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$2))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$3))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$createTopicAndGetLog$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5(), log$2.appendAsLeader$default$6());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5(), log$3.appendAsLeader$default$6());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$2) {
        String string = x$2.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$3) {
        return x$3.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

