/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayDeque;
import java.util.Iterator;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.MockBrokerToControllerChannelManager$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.server.util.MockTime;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005Y!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u00115\u0003!\u0011!Q\u0001\n)C\u0001B\u0014\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0015\")\u0001\u000b\u0001C\u0001#\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB3\u0001A\u0003%1\fC\u0003g\u0001\u0011\u0005s\rC\u0003l\u0001\u0011\u0005s\rC\u0003m\u0001\u0011\u0005S\u000e\u0003\u0004E\u0001\u0011\u0005\u00131\u0004\u0005\t\u0003G\u0001A\u0011\u0001\u000e\u0002&!1\u0011Q\u0007\u0001\u0005\u0002\u001d<\u0011\"a\u000e\u001b\u0003\u0003E\t!!\u000f\u0007\u0011eQ\u0012\u0011!E\u0001\u0003wAa\u0001\u0015\u000b\u0005\u0002\u0005u\u0002\"CA )E\u0005I\u0011AA!\u0011%\t9\u0006FI\u0001\n\u0003\tI\u0006C\u0005\u0002^Q\t\n\u0011\"\u0001\u0002Z\t!Sj\\2l\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'O\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000e\n\u0005%R\"\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faa\u00197jK:$X#\u0001\u0017\u0011\u00055*T\"\u0001\u0018\u000b\u0005=\u0002\u0014aB2mS\u0016tGo\u001d\u0006\u0003;ER!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO&\u0011aG\f\u0002\u000b\u001b>\u001c7n\u00117jK:$\u0018aB2mS\u0016tG\u000fI\u0001\u0005i&lW\r\u0005\u0002;}5\t1H\u0003\u0002={\u0005!Q\u000f^5m\u0015\tY\u0002'\u0003\u0002@w\tAQj\\2l)&lW-\u0001\fd_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s!\t9#)\u0003\u0002D5\t12i\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'/A\u000bd_:$(o\u001c7mKJ\f\u0005/\u001b,feNLwN\\:\u0011\u000552\u0015BA$/\u0005=qu\u000eZ3Ba&4VM]:j_:\u001c\u0018A\u0004:fiJLH+[7f_V$Xj]\u000b\u0002\u0015B\u0011\u0011eS\u0005\u0003\u0019\n\u00121!\u00138u\u0003=\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fI\u001bF+\u0016,X1B\u0011q\u0005\u0001\u0005\u0006U)\u0001\r\u0001\f\u0005\u0006q)\u0001\r!\u000f\u0005\u0006\u0001*\u0001\r!\u0011\u0005\b\t*\u0001\n\u00111\u0001F\u0011\u001dA%\u0002%AA\u0002)CqA\u0014\u0006\u0011\u0002\u0003\u0007!*A\u0006v]N,g\u000e^)vKV,W#A.\u0011\u0007q\u0003'-D\u0001^\u0015\tadLC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005l&AC!se\u0006LH)Z9vKB\u0011qeY\u0005\u0003Ij\u00111D\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7feF+X-^3Ji\u0016l\u0017\u0001D;og\u0016tG/U;fk\u0016\u0004\u0013!B:uCJ$H#\u00015\u0011\u0005\u0005J\u0017B\u00016#\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\f1b]3oIJ+\u0017/^3tiR!\u0001N\\A\t\u0011\u0015yw\u00021\u0001q\u0003\u001d\u0011X-];fgR\u0004$!]@\u0011\u0007ITXP\u0004\u0002tq6\tAO\u0003\u0002vm\u0006A!/Z9vKN$8O\u0003\u0002xa\u000511m\\7n_:L!!\u001f;\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRL!a\u001f?\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011\u0011\u0010\u001e\t\u0003}~d\u0001\u0001B\u0006\u0002\u00029\f\t\u0011!A\u0003\u0002\u0005\r!aA0%cE!\u0011QAA\u0006!\r\t\u0013qA\u0005\u0004\u0003\u0013\u0011#a\u0002(pi\"Lgn\u001a\t\u0004g\u00065\u0011bAA\bi\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002\u0014=\u0001\r!!\u0006\u0002\u0011\r\fG\u000e\u001c2bG.\u00042aJA\f\u0013\r\tIB\u0007\u0002#\u0007>tGO]8mY\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0015\u0005\u0005u\u0001\u0003B\u0011\u0002 \u0015K1!!\t#\u0005\u0019y\u0005\u000f^5p]\u0006q\u0001.\u00198eY\u0016\u0014Vm\u001d9p]N,G\u0003BA\u0014\u0003g!2\u0001[A\u0015\u0011\u001d\tY#\u0005a\u0001\u0003[\t\u0001B]3ta>t7/\u001a\t\u0004[\u0005=\u0012bAA\u0019]\tq1\t\\5f]R\u0014Vm\u001d9p]N,\u0007\"B8\u0012\u0001\u0004\u0011\u0017\u0001\u00029pY2\fA%T8dW\n\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003OQ\u0019\"\u0001\u0006\u0011\u0015\u0005\u0005e\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002D)\u001aQ)!\u0012,\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0015#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\nYEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA.U\rQ\u0015QI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c")
public class MockBrokerToControllerChannelManager
implements BrokerToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ArrayDeque<BrokerToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$4();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private ArrayDeque<BrokerToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Option<NodeApiVersions> controllerApiVersions() {
        return new Some((Object)this.controllerApiVersions);
    }

    public void handleResponse(BrokerToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<BrokerToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            BrokerToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public MockBrokerToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ArrayDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

