/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.PartitionTest$;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004G\u0001\u0001\u0006I!\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019)\u0006\u0001)A\u0005\u0013\"9a\u000b\u0001b\u0001\n\u00039\u0006BB0\u0001A\u0003%\u0001\fC\u0004a\u0001\t\u0007I\u0011A1\t\r\u001d\u0004\u0001\u0015!\u0003c\u0011\u001dA\u0007A1A\u0005\u0002%DaA\u001c\u0001!\u0002\u0013Q\u0007bB8\u0001\u0005\u0004%\t!\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00026\t\u000fE\u0004!\u0019!C\u0001e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011B=\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA,\u0001\u0001\u0006I!a\t\t\u0017\u0005e\u0003\u00011AA\u0002\u0013\u0005\u00111\f\u0005\f\u0003g\u0002\u0001\u0019!a\u0001\n\u0003\t)\bC\u0006\u0002\u0002\u0002\u0001\r\u0011!Q!\n\u0005u\u0003bCAB\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000bC1\"!$\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\"Y\u00111\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BAD\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!a,\u0001\t\u0003\t9\nC\u0004\u00024\u0002!\t!a&\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u0018\"9\u00111\u0018\u0001\u0005\u0002\u0005]\u0005bBA`\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003\u0007\u0004A\u0011AAL\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013D\u0011\"!;\u0001#\u0003%\t!a;\t\u0013\t\u0005\u0001!%A\u0005\u0002\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005a\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003Y5\naa]3sm\u0016\u0014(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0013aB2p]\u001aLwm]\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001Q\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+Z9\u0011\u0005i\"\u0015BA#,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nA\u0001^5nKV\t\u0011\n\u0005\u0002K'6\t1J\u0003\u0002M\u001b\u0006!Q\u000f^5m\u0015\tacJ\u0003\u0002/\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!6J\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u0017\t\u00033vk\u0011A\u0017\u0006\u0003-nS!\u0001\u0018(\u0002\r\r|W.\\8o\u0013\tq&LA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naA]3d_J$W#\u00012\u0011\u0005\r,W\"\u00013\u000b\u0005\u0001\\\u0016B\u00014e\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003\u001d\u0011XmY8sI\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u0002UB\u00111\u000e\\\u0007\u00027&\u0011Qn\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\bu_BL7\rU1si&$\u0018n\u001c83\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004u_BL7-\u00133\u0016\u0003M\u0004\"a\u001b;\n\u0005U\\&\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\ti>\u0004\u0018nY%egV\t\u0011\u0010E\u0003{}\u0006\u00051/D\u0001|\u0015\taEPC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}\\(aA'baB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bq\fA\u0001\\1oO&!\u00111BA\u0003\u0005\u0019\u0019FO]5oO\u0006IAo\u001c9jG&#7\u000fI\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\fTCAA\n!\rY\u0017QC\u0005\u0004\u0003/Y&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\r\u0011\u0002#Q|\u0007/[2JIB\u000b'\u000f^5uS>t''\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]J\u0002\u0013!\u00034fi\u000eD\u0017J\u001c4p+\t\t\u0019\u0003\u0005\u0003?\u0003\u0006\u0015\u0002c\u0002\u001a\u0002(\u0005M\u00111F\u0005\u0004\u0003S\u0019$A\u0002+va2,'\u0007\u0005\u0003\u0002.\u0005Ec\u0002BA\u0018\u0003\u0017rA!!\r\u0002H9!\u00111GA#\u001d\u0011\t)$a\u0011\u000f\t\u0005]\u0012\u0011\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016B\u0001)R\u0013\tqs*\u0003\u0002]\u001d&\u0019\u0011\u0011J.\u0002\u0011I,\u0017/^3tiNLA!!\u0014\u0002P\u0005aa)\u001a;dQJ+\u0017/^3ti*\u0019\u0011\u0011J.\n\t\u0005M\u0013Q\u000b\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u00055\u0013qJ\u0001\u000bM\u0016$8\r[%oM>\u0004\u0013\u0001D9v_R\fW*\u00198bO\u0016\u0014XCAA/!\u0011\ty&!\u001c\u000f\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n9G\u0004\u0003\u0002:\u0005\u0015\u0014\"\u0001\u0018\n\u00051j\u0013bAA6W\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011qNA9\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u00111N\u0016\u0002!E,x\u000e^1NC:\fw-\u001a:`I\u0015\fH\u0003BA<\u0003{\u00022AMA=\u0013\r\tYh\r\u0002\u0005+:LG\u000fC\u0005\u0002\u0000e\t\t\u00111\u0001\u0002^\u0005\u0019\u0001\u0010J\u0019\u0002\u001bE,x\u000e^1NC:\fw-\u001a:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a\"\u0011\u0007i\nI)C\u0002\u0002\f.\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fH\u0003BA<\u0003#C\u0011\"a \u001d\u0003\u0003\u0005\r!a\"\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n!f\u001d5pk2$W\t_2mk\u0012,7+\u001e2tKF,XM\u001c;UQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0002x!\u001aa$a'\u0011\t\u0005u\u00151V\u0007\u0003\u0003?SA!!)\u0002$\u0006\u0019\u0011\r]5\u000b\t\u0005\u0015\u0016qU\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI+U\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\u000byJ\u0001\u0003UKN$\u0018!O:i_VdGmR3u\u001d>lUm]:bO\u0016\u001c\u0018JZ)v_R\f7/\u0012=dK\u0016$W\rZ(o'V\u00147/Z9vK:$\b+\u0019:uSRLwN\\:)\u0007}\tY*\u0001\u0012tQ>,H\u000eZ$fi\n{G\u000f['fgN\fw-Z:JMF+x\u000e^1t\u00032dwn\u001e\u0015\u0004A\u0005m\u0015\u0001J:i_VdG-\u00138dYV$W-\u00138Ts:\u001cG\u000b\u001b:piRdW\r\u001a*fa2L7-Y:)\u0007\u0005\nY*\u0001\u0018tQ>,H\u000eZ%oG2,H-\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u001a{'oQ8ogVlWM\u001d$fi\u000eD\u0007f\u0001\u0012\u0002\u001c\u0006yC/Z:u\u0007>l\u0007\u000f\\3uK&sG)\u001a7bs\u0016$g)\u001a;dQ^KG\u000f\u001b*fa2L7-\u0019+ie>$H\u000f\\5oO\"\u001a1%a'\u0002OQ,7\u000f^\"p[BdW\r^3J]\u0012+G.Y=fI\u001a+Go\u00195D_:\u001cX/\\3s\r\u0016$8\r\u001b\u0015\u0004I\u0005m\u0015AC:fiV\u0003Xj\\2lgRA\u0011qOAf\u0003;\fy\u000eC\u0004\u0002 \u0015\u0002\r!!4\u0011\r\u0005=\u0017\u0011\\A\u0013\u001d\u0011\t\t.!6\u000f\t\u0005e\u00121[\u0005\u0002i%\u0019\u0011q[\u001a\u0002\u000fA\f7m[1hK&\u0019!)a7\u000b\u0007\u0005]7\u0007C\u0004aKA\u0005\t\u0019\u00012\t\u0013\u0005\u0005X\u0005%AA\u0002\u0005\r\u0018A\u00052pi\"\u0014V\r\u001d7jG\u0006\u001c\u0018J\\*z]\u000e\u00042AMAs\u0013\r\t9o\r\u0002\b\u0005>|G.Z1o\u0003Q\u0019X\r^+q\u001b>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001e\u0016\u0004E\u0006=8FAAy!\u0011\t\u00190!@\u000e\u0005\u0005U(\u0002BA|\u0003s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m8'\u0001\u0006b]:|G/\u0019;j_:LA!a@\u0002v\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)A\u000b\u0003\u0002d\u0006=\u0018\u0001\u0003;fCJ$un\u001e8)\u0007!\u0012Y\u0001\u0005\u0003\u0002\u001e\n5\u0011\u0002\u0002B\b\u0003?\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u00135|7m[)v_R\fGC\u0001B\u000b!\rQ$qC\u0005\u0004\u00053Y#\u0001\u0004*fa2L7-Y)v_R\f\u0007")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4(), PartitionTest$.MODULE$.followerFetchParams$default$5());
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldExcludeSubsequentThrottledPartitions$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldExcludeSubsequentThrottledPartitions$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4(), PartitionTest$.MODULE$.followerFetchParams$default$5());
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4(), PartitionTest$.MODULE$.followerFetchParams$default$5());
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetBothMessagesIfQuotasAllow$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldGetBothMessagesIfQuotasAllow$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.followerFetchParams(followerReplicaId, PartitionTest$.MODULE$.followerFetchParams$default$2(), PartitionTest$.MODULE$.followerFetchParams$default$3(), PartitionTest$.MODULE$.followerFetchParams$default$4(), PartitionTest$.MODULE$.followerFetchParams$default$5());
        Seq fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldIncludeInSyncThrottledReplicas$1$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$shouldIncludeInSyncThrottledReplicas$2$adapted(kafka.server.ReplicaManagerQuotasTest scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ReplicaManagerQuotasTest)this)).get())._2()).info().records.batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchParams fetchParams = PartitionTest$.MODULE$.consumerFetchParams(PartitionTest$.MODULE$.consumerFetchParams$default$1(), PartitionTest$.MODULE$.consumerFetchParams$default$2(), PartitionTest$.MODULE$.consumerFetchParams$default$3(), PartitionTest$.MODULE$.consumerFetchParams$default$4(), PartitionTest$.MODULE$.consumerFetchParams$default$5());
        scala.collection.immutable.Map fetch = this.replicaManager().readFromLog(fetchParams, this.fetchInfo(), quota, false).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records.batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records.batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    public void setUpMocks(Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record})));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterPartitionManager alterIsrManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(leaderBrokerId, ((KafkaConfig)this.configs().head()).interBrokerProtocolVersion(), MetadataCache$.MODULE$.zkMetadataCache$default$3(), MetadataCache$.MODULE$.zkMetadataCache$default$4(), MetadataCache$.MODULE$.zkMetadataCache$default$5());
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        Option x$102 = ReplicaManager$.MODULE$.$lessinit$greater$default$6();
        BrokerTopicStats x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        Option x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$102, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$setUpMocks$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    public ReplicaQuota mockQuota() {
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return quota;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), 1, 1L, 600L, 1, 1000, FetchIsolation.LOG_END, Optional.empty());
        return new DelayedFetch(null, fetchParams, tp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    private static final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        TopicIdPartition tidp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, -1L, 600L, 1, 1000, FetchIsolation.HIGH_WATERMARK, Optional.empty());
        return new DelayedFetch(null, fetchParams, tidp, fetchPartitionStatus, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$setUpMocks$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicIdPartition p = (TopicIdPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), true, bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, LeaderRecoveryState.RECOVERED);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Object $anonfun$shouldExcludeSubsequentThrottledPartitions$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1($this, x$2));
    }

    public static final /* synthetic */ Object $anonfun$shouldExcludeSubsequentThrottledPartitions$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2($this, x$3));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1($this, x$4));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2($this, x$5));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetBothMessagesIfQuotasAllow$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1($this, x$6));
    }

    public static final /* synthetic */ Object $anonfun$shouldGetBothMessagesIfQuotasAllow$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2($this, x$7));
    }

    public static final /* synthetic */ Object $anonfun$shouldIncludeInSyncThrottledReplicas$1$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1($this, x$8));
    }

    public static final /* synthetic */ Object $anonfun$shouldIncludeInSyncThrottledReplicas$2$adapted(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2($this, x$9));
    }
}

