/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;

public class BrokerNode
implements TestKitNode {
    private final int id;
    private final Uuid incarnationId;
    private final String metadataDirectory;
    private final List<String> logDataDirectories;
    private final Map<String, String> propertyOverrides;

    BrokerNode(int id, Uuid incarnationId, String metadataDirectory, List<String> logDataDirectories) {
        this(id, incarnationId, metadataDirectory, logDataDirectories, Collections.emptyMap());
    }

    BrokerNode(int id, Uuid incarnationId, String metadataDirectory, List<String> logDataDirectories, Map<String, String> propertyOverrides) {
        this.id = id;
        this.incarnationId = incarnationId;
        this.metadataDirectory = metadataDirectory;
        this.logDataDirectories = new ArrayList<String>(logDataDirectories);
        this.propertyOverrides = new HashMap<String, String>(propertyOverrides);
    }

    @Override
    public int id() {
        return this.id;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    @Override
    public String metadataDirectory() {
        return this.metadataDirectory;
    }

    public List<String> logDataDirectories() {
        return this.logDataDirectories;
    }

    public Map<String, String> propertyOverrides() {
        return this.propertyOverrides;
    }

    public static class Builder {
        private int id = -1;
        private Uuid incarnationId = null;
        private String metadataDirectory = null;
        private List<String> logDataDirectories = null;

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setLogDirectories(List<String> logDataDirectories) {
            this.logDataDirectories = logDataDirectories;
            return this;
        }

        public Builder setMetadataDirectory(String metadataDirectory) {
            this.metadataDirectory = metadataDirectory;
            return this;
        }

        public BrokerNode build() {
            if (this.id == -1) {
                throw new RuntimeException("You must set the node id");
            }
            if (this.incarnationId == null) {
                this.incarnationId = Uuid.randomUuid();
            }
            if (this.logDataDirectories == null) {
                this.logDataDirectories = Collections.singletonList(String.format("broker_%d_data0", this.id));
            }
            if (this.metadataDirectory == null) {
                this.metadataDirectory = this.logDataDirectories.get(0);
            }
            return new BrokerNode(this.id, this.incarnationId, this.metadataDirectory, this.logDataDirectories);
        }
    }
}

