/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Console$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL, brokers=3)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\f\u0018\u0005qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001c\u0001A\u0003%\u0011\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u0019\t\ra\u0002\u0001\u0015!\u00032\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015Y\u0006\u0001\"\u0001R\u0011\u0015i\u0006\u0001\"\u0001R\u0011\u0015y\u0006\u0001\"\u0001R\u0011\u0015\t\u0007\u0001\"\u0001R\u000f\u001d\tIa\u0006E\u0001\u0003\u00171aAF\f\t\u0002\u00055\u0001B\u0002\u0016\u0012\t\u0003\ty\u0001C\u0004\u0002\u0012E!\t!a\u0005\t\u000f\u0005\r\u0014\u0003\"\u0001\u0002f!9\u0011\u0011N\t\u0005\u0002\u0005-$!\u0007'fC\u0012,'/\u00127fGRLwN\\\"p[6\fg\u000e\u001a+fgRT!\u0001G\r\u0002\u000b\u0005$W.\u001b8\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fqa\u00197vgR,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(3\u0005!A/Z:u\u0013\tIcEA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011AF\f\t\u0003[\u0001i\u0011a\u0006\u0005\u0006G\t\u0001\r\u0001J\u0001\bEJ|7.\u001a:2+\u0005\t\u0004C\u0001\u00103\u0013\t\u0019tDA\u0002J]R\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013a\u00022s_.,'oM\u0001\tEJ|7.\u001a:4A\u0005)1/\u001a;vaR\u00111H\u0010\t\u0003=qJ!!P\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f%\u0001\r\u0001Q\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0011\u0005\u0015\n\u0015B\u0001\"'\u00055\u0019E.^:uKJ\u001cuN\u001c4jO\"\u0012\u0011\u0002\u0012\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-c\u0015!\u00026v]&$(\"A'\u0002\u0007=\u0014x-\u0003\u0002P\r\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f^!mYR{\u0007/[2QCJ$\u0018\u000e^5p]R\t1\b\u000b\u0002\u000b'B\u0011AkV\u0007\u0002+*\u0011aKJ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001-V\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002%Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\u0017M\u000b!\u0003^3tiB\u000bG\u000f\u001b+p\u0015N|gNR5mK\"\u0012AbU\u0001\u001di\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\ti1+A\u000buKN$Hk\u001c9jG\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u00059\u0019\u0016\u0001\u0007;fgR,E.Z2uS>t'+Z:vYR|U\u000f\u001e9vi\"\u0012qb\u0015\u0015\u0005\u0001\u0011<\u0007\u000e\u0005\u0002FK&\u0011aM\u0012\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017%A5\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\u0007\u0001-tw\u000e^;\u0011\u0005Qc\u0017BA7V\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0003AL!!\u001d:\u0002\u0007\u0005cEJ\u0003\u0002t+\u0006!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012a\u0001\u0015\u0005\u0001]<W\u0010\u0005\u0002yw6\t\u0011P\u0003\u0002{\r\u0006IQ\r\u001f;f]NLwN\\\u0005\u0003yf\u0014!\"\u0012=uK:$w+\u001b;iY\u0005q8%A@\u0011\t\u0005\u0005\u0011QA\u0007\u0003\u0003\u0007Q!a\u0013\u0014\n\t\u0005\u001d\u00111\u0001\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0003eaU-\u00193fe\u0016cWm\u0019;j_:\u001cu.\\7b]\u0012$Vm\u001d;\u0011\u00055\n2CA\t\u001e)\t\tY!\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0003\u0002\u0016\u0005\u0005\u0003\u0003CA\f\u0003K\tY#!\r\u000f\t\u0005e\u0011\u0011\u0005\t\u0004\u00037yRBAA\u000f\u0015\r\tybG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rr$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tICA\u0002NCBT1!a\t !\u0011\t9\"!\f\n\t\u0005=\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!A.\u00198h\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003k\u0011aa\u00142kK\u000e$\bbBA\"'\u0001\u0007\u0011QI\u0001\bg\u0016\u0014h/\u001a:t!\u0019\t9%!\u0015\u0002X9!\u0011\u0011JA'\u001d\u0011\tY\"a\u0013\n\u0003\u0001J1!a\u0014 \u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002V\t\u00191+Z9\u000b\u0007\u0005=s\u0004\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti&G\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u00141\f\u0002\f\u0017\u000647.Y*feZ,'/\u0001\tc_>$8\u000f\u001e:baN+'O^3sgR!\u00111FA4\u0011\u001d\t\u0019\u0005\u0006a\u0001\u0003\u000b\na\u0003^3naR{\u0007/[2QCJ$\u0018\u000e^5p]\u001aKG.\u001a\u000b\u0005\u0003[\ni\b\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t\u0019LG.\u001a\u0006\u0005\u0003o\nI$A\u0002oS>LA!a\u001f\u0002r\t!\u0001+\u0019;i\u0011\u001d\ty(\u0006a\u0001\u0003\u0003\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\t9\"a!\u0002\b&!\u0011QQA\u0015\u0005\r\u0019V\r\u001e\t\u0005\u0003\u0013\u000b)*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0019\u0019w.\\7p]*\u0019!$!%\u000b\u0007\u0005ME*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003/\u000bYI\u0001\bU_BL7\rU1si&$\u0018n\u001c8")
public final class LeaderElectionCommandTest {
    private final ClusterInstance cluster;
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> set) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(set);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(seq);
    }

    public static Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(seq);
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeEach");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
    }

    @ClusterTest
    public void testAllTopicPartition() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--all-topic-partitions"}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    public void testTopicPartition() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--topic", topic, "--partition", Integer.toString(partition)}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    public void testPathToJsonFile() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    public void testPreferredReplicaElection() {
        String topic = "preferred-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
        this.cluster.startBroker(this.broker2());
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "preferred", "--all-topic-partitions"}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
    }

    @ClusterTest
    public void testTopicDoesNotExist() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"})))).getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testElectionResultOutput() {
        String topic = "non-preferred-topic";
        int partition0 = 0;
        int partition1 = 1;
        Seq assignment0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3(), this.broker2()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition0)), (Object)assignment0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1)), (Object)assignment1)}))));
        TopicPartition topicPartition0 = new TopicPartition(topic, partition0);
        TopicPartition topicPartition1 = new TopicPartition(topic, partition1);
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition1, this.broker3());
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, this.broker3());
        this.cluster.startBroker(this.broker2());
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition0, topicPartition1}))));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "--election-type", "preferred", "--path-to-json-file", ((Object)topicPartitionPath).toString()}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Iterator electionResultOutputIter = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.split("\n"))).iterator();
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String firstLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)firstLine.contains(new StringBuilder(66).append("Successfully completed leader election (PREFERRED) for partitions ").append(topicPartition0).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(firstLine).toString());
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String secondLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)secondLine.contains(new StringBuilder(45).append("Valid replica already elected for partitions ").append(topicPartition1).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(secondLine).toString());
    }

    public LeaderElectionCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }
}

