/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)A\t\u0001C\u0001\u000b\")\u0011\n\u0001C\u0001\u000b\")Q\n\u0001C\u0001\u001d\")1\u000b\u0001C\u0001)\n)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u0017i\u0016\u001cH\u000fT5ti\u000e{gn];nKJ<%o\\;qgR\u0011q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0005+:LG\u000fC\u0003\u001f\u0005\u0001\u0007q$\u0001\u0004rk>\u0014X/\u001c\t\u0003A\u001dr!!I\u0013\u0011\u0005\tJR\"A\u0012\u000b\u0005\u0011b\u0011A\u0002\u001fs_>$h(\u0003\u0002'3\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t1\u0013\u0004\u000b\u0003\u0003WeR\u0004C\u0001\u00178\u001b\u0005i#B\u0001\u00180\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u00192\u0003\u0019\u0001\u0018M]1ng*\u0011!gM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!T'A\u0003kk:LGOC\u00017\u0003\ry'oZ\u0005\u0003q5\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA\u001e>C\u0005a\u0014A\u0001>lC\u0005q\u0014!B6sC\u001a$\bF\u0001\u0002A!\t\t%)D\u00010\u0013\t\u0019uFA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f\u0011\u0006^3ti2K7\u000f^,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>tG#A\f)\t\rY\u0013h\u0012\u0017\u0003wuB#a\u0001!\u0002AQ,7\u000f\u001e'jgR\u001cuN\\:v[\u0016\u0014xI]8vaN<\u0016\u000e\u001e5Ti\u0006$Xm\u001d\u0015\u0005\t-J4\n\f\u0002<{!\u0012A\u0001Q\u0001\"i\u0016\u001cHoQ8ogVlWM]$s_V\u00048\u000b^1uKN4%o\\7TiJLgn\u001a\u000b\u0003/=CQAH\u0003A\u0002}AC!B\u0016:#2\u00121(\u0010\u0015\u0003\u000b\u0001\u000bA\u0003^3ti2K7\u000f^$s_V\u00048i\\7nC:$GCA\fV\u0011\u0015qb\u00011\u0001 Q\u001111&O,-\u0005mj\u0004F\u0001\u0004A\u0001")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListConsumerGroups(String quorum) {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedGroups = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup}));
        ObjectRef foundGroups = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroups$1(foundGroups, service, expectedGroups)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListConsumerGroups$2(expectedGroups, foundGroups));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"});
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListConsumerGroupsWithStates() {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedListing = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(simpleGroup, true, Optional.of(ConsumerGroupState.EMPTY)), new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        ObjectRef foundListing = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$1(foundListing, service, expectedListing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$2(expectedListing, foundListing));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set expectedListingStable = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        foundListing.elem = Predef$.MODULE$.Set().empty();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$3(foundListing, service, expectedListingStable)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListConsumerGroupsWithStates$4(expectedListingStable, foundListing));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConsumerGroupStatesFromString(String quorum) {
        Set result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable, PreparingRebalance");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE, ConsumerGroupState.PREPARING_REBALANCE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Dead,CompletingRebalance,");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.DEAD, ConsumerGroupState.COMPLETING_REBALANCE})), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("  bad, Stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("   ,   ,"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListGroupCommand(String quorum) {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        ObjectRef out = ObjectRef.create((Object)"");
        ObjectRef cgcArgs = ObjectRef.create((Object)((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$1(this, out, cgcArgs, simpleGroup)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListGroupCommand$3(this, simpleGroup, out));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"});
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$4(this, out, cgcArgs, simpleGroup)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListGroupCommand$6(this, simpleGroup, out));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state", "Stable"});
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ListConsumerGroupTest.$anonfun$testListGroupCommand$7(this, out, cgcArgs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListConsumerGroupTest.$anonfun$testListGroupCommand$9(this, out));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroups$1(ObjectRef foundGroups$1, ConsumerGroupCommand.ConsumerGroupService service$1, Set expectedGroups$1) {
        foundGroups$1.elem = service$1.listConsumerGroups().toSet();
        Set set = expectedGroups$1;
        Set set2 = (Set)foundGroups$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroups$2(Set expectedGroups$1, ObjectRef foundGroups$1) {
        return new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups$1).append(", but found ").append((Set)foundGroups$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$1(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListing$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConsumerGroupState.values())).toSet()).toSet();
        Set set = expectedListing$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$2(Set expectedListing$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListing$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$3(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListingStable$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
        Set set = expectedListingStable$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$4(Set expectedListingStable$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$1(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return !((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$3(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(45).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and no header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$4(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$6(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(46).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and the header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$7(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains($this.group()) && ((String)out$1.elem).contains("Stable");
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$9(ListConsumerGroupTest $this, ObjectRef out$1) {
        return new StringBuilder(60).append("Expected to find ").append($this.group()).append(" in state Stable and the header, but found ").append((String)out$1.elem).toString();
    }
}

