/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.server.common.AdminOperationException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005\u0002IBQa\u0011\u0001\u0005\u0002IBQ\u0001\u0013\u0001\u0005\u0002IBQ!\u0014\u0001\u0005\u0002IBQa\u0014\u0001\u0005\u0002IBQ!\u0015\u0001\u0005\nICQa\u0018\u0001\u0005\u0002IBQ!\u0019\u0001\u0005\u0002IBQa\u0019\u0001\u0005\u0002IBQ!\u001a\u0001\u0005\u0002IBQa\u001a\u0001\u0005\u0002IBQ!\u001b\u0001\u0005\u0002IBQa\u001b\u0001\u0005\u0002IBQ!\u001c\u0001\u0005\u0002IBQa\u001c\u0001\u0005\u0002IBQ!\u001d\u0001\u0005\u0002IBQa\u001d\u0001\u0005\u0002IBQ!\u001e\u0001\u0005\u0002IBQa\u001e\u0001\u0005\u0002IBQ!\u001f\u0001\u0005\u0002IBQa\u001f\u0001\u0005\u0002IBQ! \u0001\u0005\u0002IBQa \u0001\u0005\u0002IBa!a\u0001\u0001\t\u0003\u0011\u0004bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\u0007\u0003G\u0001A\u0011\u0001\u001a\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!1\u00111\n\u0001\u0005\u0002IBq!a\u0014\u0001\t\u0003\t\t\u0006\u0003\u0004\u0002\\\u0001!\tA\r\u0002\u001b%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7/\u00168jiR+7\u000f\u001e\u0006\u0003E\r\nQ!\u00193nS:T\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003\u0005\nQa]3u+B$\u0012a\r\t\u0003QQJ!!N\u0015\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005]\u0002\"\u0001O!\u000e\u0003eR!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 @\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005\r)\u0005C\u0001\u001dG\u0013\t9\u0015HA\u0005BMR,'/R1dQ\u0006QB/Z:u\u0007>l\u0007/\u0019:f)>\u0004\u0018n\u0019)beRLG/[8og\"\u0012AA\u0013\t\u0003q-K!\u0001T\u001d\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cHoQ8na\u0006\u0014X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017m\u001d\u0015\u0003\u000b)\u000b1\u0005^3tiB\u000b'\u000f^5uS>t'+Z1tg&<gn\u0015;bi\u0016\u001cHk\\*ue&tw\r\u000b\u0002\u0007\u0015\u0006I\u0011\r\u001a3U_BL7m\u001d\u000b\u0003gMCQ\u0001V\u0004A\u0002U\u000b1\"\u00193nS:\u001cE.[3oiB\u0011a+X\u0007\u0002/*\u0011!\u0005\u0017\u0006\u00033j\u000bqa\u00197jK:$8O\u0003\u0002%7*\u0011AlP\u0001\u0007CB\f7\r[3\n\u0005y;&aD'pG.\fE-\\5o\u00072LWM\u001c;\u0002GQ,7\u000f\u001e$j]\u0012\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u001cF/\u0019;fg\"\u0012\u0001BS\u0001\u0019i\u0016\u001cHOR5oI2{w\rR5s\u001b>4Xm\u0015;bi\u0016\u001c\bFA\u0005K\u0003u!Xm\u001d;SKBd\u0017nY1N_Z,7\u000b^1uKN$vn\u0015;sS:<\u0007F\u0001\u0006K\u0003e!Xm\u001d;HKR\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^:)\u0005-Q\u0015\u0001\b;fgR<U\r\u001e\"s_.,'OU1dW&sgm\u001c:nCRLwN\u001c\u0015\u0003\u0019)\u000bq\u0004^3tiB\u000b'o]3HK:,'/\u0019;f\u0003N\u001c\u0018n\u001a8nK:$\u0018I]4tQ\ti!*\u0001\u0019uKN$x)\u001a8fe\u0006$X-Q:tS\u001etW.\u001a8u\r\u0006LGn],ji\"|W\u000f^#o_V<\u0007NU3qY&\u001c\u0017m\u001d\u0015\u0003\u001d)\u000b\u0001\u0007^3ti\u001e+g.\u001a:bi\u0016\f5o]5h]6,g\u000e^,ji\"LeN^1mS\u0012\u0004\u0016M\u001d;ji&|gn\u001d$bS2\u001c\bFA\bK\u0003-\"Xm\u001d;HK:,'/\u0019;f\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u0013:\u001cwN\\:jgR,g\u000e\u001e*bG.\u001c\bF\u0001\tK\u0003\u0019\"Xm\u001d;HK:,'/\u0019;f\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\r\u0016<XM\u001d\"s_.,'o\u001d\u0015\u0003#)\u000bQ\u0006^3ti\u000e+(O]3oiB\u000b'\u000f^5uS>t'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;U_N#(/\u001b8hQ\t\u0011\"*A\u0006uKN$Xj\u001c<f\u001b\u0006\u0004\bFA\nK\u0003y!Xm\u001d;QCJ\u001cX-\u0012=fGV$X-Q:tS\u001etW.\u001a8u\u0003J<7\u000f\u000b\u0002\u0015\u0015\u0006)C/Z:u\u000bb,7-\u001e;f/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8t\r\u0006LGn\u001d\u0015\u0003+)\u000b1\u0005^3ti\u0016CXmY;uK^KG\u000f[%om\u0006d\u0017\u000e\u001a\"s_.,'/\u00133GC&d7\u000f\u000b\u0002\u0017\u0015\u0006\u0019C/Z:u\u001b>$\u0017NZ=Ce>\\WM]%oi\u0016\u0014(I]8lKJ$\u0006N]8ui2,\u0007FA\fK\u0003a!Xm\u001d;N_\u0012Lg-\u001f'pO\u0012K'\u000f\u00165s_R$H.\u001a\u0015\u00031)\u000bA\u0004^3ti\u000e+(OU3bgNLwM\\7f]R\u001cHk\\*ue&tw\r\u000b\u0002\u001a\u0015\u0006Yb/\u001a:jMf\u0014%o\\6feRC'o\u001c;uY\u0016\u0014Vm];miN$raMA\u0006\u0003+\ty\u0002C\u0004\u0002\u000ei\u0001\r!a\u0004\u0002\r\r|gNZ5h!\r1\u0016\u0011C\u0005\u0004\u0003'9&AB\"p]\u001aLw\rC\u0004\u0002\u0018i\u0001\r!!\u0007\u00027\u0015D\b/Z2uK\u0012Le\u000e^3s\u0005J|7.\u001a:UQJ|G\u000f\u001e7f!\rA\u00131D\u0005\u0004\u0003;I#\u0001\u0002'p]\u001eDq!!\t\u001b\u0001\u0004\tI\"A\u0012fqB,7\r^3e%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie>$H\u000f\\3\u00021Q,7\u000f^'pI&4\u0017\u0010V8qS\u000e$\u0006N]8ui2,7\u000f\u000b\u0002\u001c\u0015\u0006Qb/\u001a:jMf$v\u000e]5d)\"\u0014x\u000e\u001e;mKJ+7/\u001e7ugR91'a\u000b\u0002.\u0005\u001d\u0003bBA\u00079\u0001\u0007\u0011q\u0002\u0005\b\u0003_a\u0002\u0019AA\u0019\u0003Y)\u0007\u0010]3di\u0016$G*Z1eKJ$\u0006N]8ui2,\u0007\u0003BA\u001a\u0003\u0003rA!!\u000e\u0002>A\u0019\u0011qG\u0015\u000e\u0005\u0005e\"bAA\u001eK\u00051AH]8pizJ1!a\u0010*\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011qH\u0015\t\u000f\u0005%C\u00041\u0001\u00022\u0005AR\r\u001f9fGR,GMR8mY><XM\u001d+ie>$H\u000f\\3\u0002/Q,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c\bFA\u000fK\u0003A\t7o]3siN#\u0018M\u001d;t/&$\b\u000eF\u00034\u0003'\n9\u0006C\u0004\u0002Vy\u0001\r!!\r\u0002\rA\u0014XMZ5y\u0011\u001d\tIF\ba\u0001\u0003c\t1a\u001d;s\u0003u!Xm\u001d;Qe>\u0004\u0018mZ1uK&sg/\u00197jI*\u001bxN\\#se>\u0014\bFA\u0010KQ\u001d\u0001\u0011\u0011MA4\u0003S\u00022\u0001OA2\u0013\r\t)'\u000f\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005a\u0004")
public class ReassignPartitionsUnitTest {
    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsUnitTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCompareTopicPartitions() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("abc", 0), new TopicPartition("abc", 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("def", 0), new TopicPartition("abc", 1)));
    }

    @Test
    public void testCompareTopicPartitionReplicas() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("abc", 0, 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("cde", 0, 0)));
    }

    @Test
    public void testPartitionReassignStatesToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Status of partition reassignment:", (List)new .colon.colon((Object)"Reassignment of partition bar-0 is still in progress.", (List)new .colon.colon((Object)"Reassignment of partition foo-0 is completed.", (List)new .colon.colon((Object)"Reassignment of partition foo-1 is still in progress.", (List)Nil$.MODULE$)))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.partitionReassignmentStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false))}))));
    }

    private void addTopics(MockAdminClient adminClient) {
        java.util.List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(0), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1), (Node)b.get(2)}), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1)})), new TopicPartitionInfo(1, (Node)b.get(1), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}))}), Collections.emptyMap());
    }

    @Test
    public void testFindPartitionReassignmentStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Throwable v = (Throwable)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), UnknownTopicOrPartitionException.class)})), (Object)reassignmentResult);
            Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), (List)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))));
            scala.collection.immutable.Map cancelResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.cancelPartitionReassignments((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("quux", 2)}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition k = (TopicPartition)x0$2._1();
                    Throwable v = (Throwable)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 2)), UnknownTopicOrPartitionException.class)})), (Object)cancelResult);
            Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), (List)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))));
        }
    }

    @Test
    public void testFindLogDirMoveStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", null})})).build();){
            this.addTopics(adminClient);
            java.util.List b = adminClient.brokers();
            adminClient.addTopic(false, "quux", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
            adminClient.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)"/tmp/kafka-logs1")}))).asJava()).all().get();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs0"))})), (Object)ReassignPartitionsCommand$.MODULE$.findLogDirMoveStates((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)"/tmp/kafka-logs0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)"/tmp/kafka-logs0")}))));
        }
    }

    @Test
    public void testReplicaMoveStatesToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Reassignment of replica bar-0-0 completed successfully.", (List)new .colon.colon((Object)"Reassignment of replica foo-0-0 is still in progress.", (List)new .colon.colon((Object)"Partition foo-1 on broker 0 is not being moved from log dir /tmp/kafka-logs0 to /tmp/kafka-logs1.", (List)new .colon.colon((Object)"Partition quux-0 cannot be found in any live log directory on broker 0.", (List)new .colon.colon((Object)"Partition quux-1 on broker 1 is being moved to log dir /tmp/kafka-logs2 instead of /tmp/kafka-logs1.", (List)new .colon.colon((Object)"Partition quux-2 is not found in any live log dir on broker 1. There is likely an offline log directory on the broker.", (List)Nil$.MODULE$)))))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.replicaMoveStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 1)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 2, 1)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1"))}))));
    }

    @Test
    public void testGetReplicaAssignments() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForTopics((Admin)adminClient, (Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForPartitions((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}))));
        }
    }

    @Test
    public void testGetBrokerRackInformation() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "localhost", 9092, "rack0"), new Node(1, "localhost", 9093, "rack1"), new Node(2, "localhost", 9094, null)})).build();){
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(0, Optional.of("rack0")), (List)new .colon.colon((Object)new BrokerMetadata(1, Optional.of("rack1")), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), true));
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(0, Optional.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, Optional.empty()), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), false));
            this.assertStartsWith("Not all brokers have rack information", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), true)).getMessage());
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(1, Optional.empty()), (List)new .colon.colon((Object)new BrokerMetadata(2, Optional.empty()), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), false));
        }
    }

    @Test
    public void testParseGenerateAssignmentArgs() {
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "1,1,2"), () -> "Expected to detect duplicate broker list entries").getMessage());
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4,5"), () -> "Expected to detect duplicate broker list entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 2, 3, 4})), (Object)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"));
        this.assertStartsWith("List of topics to reassign contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"), () -> "Expected to detect duplicate topic entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3, 4})), (Object)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)Nil$.MODULE$))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"bar\"}], \"version\":1}", "5,3,4"));
    }

    @Test
    public void testGenerateAssignmentFailsWithoutEnoughReplicas() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Replication factor: 3 larger than available brokers: 2", Assertions.assertThrows(InvalidReplicationFactorException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", "0,1", false), () -> "Expected generateAssignment to fail").getMessage());
        }
    }

    @Test
    public void testGenerateAssignmentWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"quux\"}]}", "0,1", false), () -> "Expected generateAssignment to fail").getCause().getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithInconsistentRacks() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "localhost", 9092, "rack0"), new Node(1, "localhost", 9093, "rack0"), new Node(2, "localhost", 9094, null), new Node(3, "localhost", 9095, "rack1"), new Node(4, "localhost", 9096, "rack1"), new Node(5, "localhost", 9097, "rack2")})).build();){
            void var3_3;
            this.addTopics(adminClient);
            this.assertStartsWith("Not all brokers have rack information.", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", true), () -> "Expected generateAssignment to fail").getMessage());
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map current = (Map)tuple2._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithFewerBrokers() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void var5_5;
            void var4_4;
            this.addTopics(adminClient);
            scala.collection.immutable.Set goalBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}));
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", goalBrokers.mkString(","), false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map proposed = (Map)tuple2._1();
            Map current = (Map)tuple2._2();
            void proposed2 = var4_4;
            void current2 = var5_5;
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})), (Object)current2);
            proposed2.values().foreach(arg_0 -> ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(goalBrokers, (Map)proposed2, arg_0));
        }
    }

    @Test
    public void testCurrentPartitionReplicaAssignmentToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Current partition replica assignment", (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"Save this to use as the --reassignment-json-file option during rollback", (List)Nil$.MODULE$))))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.currentPartitionReplicaAssignmentToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12})))}))));
    }

    @Test
    public void testMoveMap() {
        scala.collection.mutable.Map moveMap = ReassignPartitionsCommand$.MODULE$.calculateProposedMoveMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6), Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))))})))})), (Object)moveMap);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:1,0:2,0:3,1:4,1:5,1:6,2:1,2:2,3:1,3:2,4:1,4:2,5:1,5:2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:2,0:3,0:4")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateLeaderThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:5,1:7,1:8,2:3,2:4,3:5,3:6,4:3,5:3,5:4,5:5,5:6"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:1")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateFollowerThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8})), (Object)ReassignPartitionsCommand$.MODULE$.calculateReassigningBrokers(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})), (Object)ReassignPartitionsCommand$.MODULE$.calculateMovingBrokers((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("quux", 0, 0), new TopicPartitionReplica("quux", 1, 2)}))));
    }

    @Test
    public void testParseExecuteAssignmentArgs() {
        this.assertStartsWith("Partition reassignment list cannot be empty", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[]}"), () -> "Expected to detect empty partition reassignment list").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"), () -> "Expected to detect a partition list with duplicate entries").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        this.assertStartsWith("Partition replica lists may not contain duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,0],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})))})), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"));
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 1)), (Object)"/tmp/a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 2)), (Object)"/tmp/b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 3)), (Object)"/tmp/c")}))), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}"));
    }

    @Test
    public void testExecuteWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"quux\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7()), () -> "Expected reassignment with non-existent topic to fail").getCause().getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidBrokerIdFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unknown broker id 4", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7()), () -> "Expected reassignment with non-existent broker id to fail").getMessage());
        }
    }

    @Test
    public void testModifyBrokerInterBrokerThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 1000L);
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), 100L);
            Seq brokers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyBrokerInterBrokerThrottle$1(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), 100L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), 100L, -1L);
        }
    }

    @Test
    public void testModifyLogDirThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 2000L);
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), -1L);
            Seq brokers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyLogDirThrottle$1(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), -1L, -1L);
        }
    }

    @Test
    public void testCurReassignmentsToString() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 4, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Throwable v = (Throwable)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)reassignmentResult);
            Assertions.assertEquals((Object)new .colon.colon((Object)"Current partition reassignments:", (List)new .colon.colon((Object)"bar-0: replicas: 2,3,0. removing: 0.", (List)new .colon.colon((Object)"foo-0: replicas: 0,1,2. adding: 4.", (List)new .colon.colon((Object)"foo-1: replicas: 1,2,3. adding: 4,5. removing: 1,2.", (List)Nil$.MODULE$)))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
        }
    }

    private void verifyBrokerThrottleResults(Config config, long expectedInterBrokerThrottle, long expectedReplicaAlterLogDirsThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        if (expectedInterBrokerThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        }
        if (expectedReplicaAlterLogDirsThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedReplicaAlterLogDirsThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
            return;
        }
    }

    @Test
    public void testModifyTopicThrottles() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            ReassignPartitionsCommand$.MODULE$.modifyTopicThrottles((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"leaderFoo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"leaderBar")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"followerBar")})));
            Seq topics = (Seq)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)id -> new ConfigResource(ConfigResource.Type.TOPIC, id), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(0)), "leaderBar", "followerBar");
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(1)), "leaderFoo", "");
        }
    }

    private void verifyTopicThrottleResults(Config config, String expectedLeaderThrottle, String expectedFollowerThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        Assertions.assertEquals((Object)expectedLeaderThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        Assertions.assertEquals((Object)expectedFollowerThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    @Test
    public void testAlterReplicaLogDirs() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Collections.nCopies(4, Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}))).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("foo", 0, 0)})), (Object)ReassignPartitionsCommand$.MODULE$.alterReplicaLogDirs((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1")}))));
        }
    }

    public void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)new StringOps(Predef$.MODULE$.augmentString("Expected the string to start with %s, but it was %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, str})));
    }

    @Test
    public void testPropagateInvalidJsonError() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unexpected character", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{invalid_json", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7())).getMessage());
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ void $anonfun$testGenerateAssignmentWithFewerBrokers$1(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq replicas) {
        Assertions.assertTrue((boolean)replicas.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> goalBrokers$1.contains((Object)BoxesRunTime.boxToInteger((int)elem))), (String)new StringBuilder(57).append("Proposed assignment ").append(proposed$1).append(" puts replicas on brokers other than ").append(goalBrokers$1).toString());
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyBrokerInterBrokerThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyLogDirThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ Object $anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq replicas) {
        ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1(goalBrokers$1, proposed$1, replicas);
        return BoxedUnit.UNIT;
    }
}

