/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import kafka.log.BrokerCompressionTest$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001#\u0011\u0019i\u0003\u0001)A\u0005G!9a\u0006\u0001b\u0001\n\u0003y\u0003BB\u001f\u0001A\u0003%\u0001\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r%\u0003\u0001\u0015!\u0003A\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015Q\u0006\u0001\"\u0001\\\u000f\u0015i\u0018\u0003#\u0001\u007f\r\u0015\u0001\u0012\u0003#\u0001\u0000\u0011\u0019iR\u0002\"\u0001\u0002\u0002!1q/\u0004C\u0001\u0003\u0007\u0011QC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0013'\u0005\u0019An\\4\u000b\u0003Q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"A\t\u0002\rQl\u0007\u000fR5s+\u0005\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\tIwNC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003\u0011!\u0018.\\3\u0016\u0003A\u0002\"!M\u001e\u000e\u0003IR!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003kY\naa]3sm\u0016\u0014(B\u0001\u000b8\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\n\u0005q\u0012$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u00131|wmQ8oM&<W#\u0001!\u0011\u0005\u0005;U\"\u0001\"\u000b\u0005I\u0019%B\u0001#F\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002Gm\u000591\u000f^8sC\u001e,\u0017B\u0001%C\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0019B\u0011\u0001$T\u0005\u0003\u001df\u0011A!\u00168ji\"\u0012!\u0002\u0015\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000b1!\u00199j\u0015\t)f+A\u0004kkBLG/\u001a:\u000b\u0005]K\u0014!\u00026v]&$\u0018BA-S\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\ruKN$(I]8lKJ\u001c\u0016\u000eZ3D_6\u0004(/Z:tS>tGc\u0001']S\")Ql\u0003a\u0001=\u0006\u0011R.Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o!\tyfM\u0004\u0002aIB\u0011\u0011-G\u0007\u0002E*\u00111-F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015L\u0012A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z\r\t\u000b)\\\u0001\u0019\u00010\u0002#\t\u0014xn[3s\u0007>l\u0007O]3tg&|g\u000e\u000b\u0003\fYR,\bCA7s\u001b\u0005q'BA8q\u0003!\u0001(o\u001c<jI\u0016\u0014(BA9U\u0003\u0019\u0001\u0018M]1ng&\u00111O\u001c\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0002m\u0006\nq/\u0001\u0006qCJ\fW.\u001a;feND#aC=\u0011\u0005i\\X\"\u00019\n\u0005q\u0004(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006)\"I]8lKJ\u001cu.\u001c9sKN\u001c\u0018n\u001c8UKN$\bC\u0001\u0011\u000e'\tiq\u0003F\u0001\u007f+\t\t)\u0001\u0005\u0004\u0002\b\u0005=\u00111C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u000511\u000f\u001e:fC6T!aM\u0014\n\t\u0005E\u0011\u0011\u0002\u0002\u0007'R\u0014X-Y7\u0011\u00075\f)\"C\u0002\u0002\u00189\u0014\u0011\"\u0011:hk6,g\u000e^:")
public class BrokerCompressionTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime(0L, 0L);
    private final LogConfig logConfig = new LogConfig((Map)new Properties());

    public static Stream<Arguments> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testBrokerSideCompression(String messageCompression, String brokerCompression) {
        CompressionType messageCompressionType = CompressionType.forName((String)messageCompression);
        Properties logProps = new Properties();
        logProps.put("compression.type", brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        LogOffsetsListener x$17 = UnifiedLog$.MODULE$.apply$default$17();
        UnifiedLog log = UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)messageCompressionType, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        if (!brokerCompression.equals("producer")) {
            CompressionType brokerCompressionType = BrokerCompressionType.forName((String)brokerCompression).targetCompressionType(null);
            Assertions.assertEquals((Object)brokerCompressionType, (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionType).toString());
            return;
        }
        Assertions.assertEquals((Object)messageCompressionType, (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionType).toString());
    }

    private static final RecordBatch readBatch$1(int offset, UnifiedLog log$1) {
        return (RecordBatch)log$1.read((long)((long)offset), (int)4096, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.batches().iterator().next();
    }
}

