/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogManagerTest$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u0005h\u0001B3g\u0001-DQA\u001d\u0001\u0005\u0002MDqA\u001e\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002=\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0005\t\u0013\u0005u\u0001A1A\u0005\u0002\u0005}\u0001\u0002CA\u0018\u0001\u0001\u0006I!!\t\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0002\u0002CA$\u0001\u0001\u0006I!!\u000e\t\u0017\u0005%\u0003\u00011AA\u0002\u0013\u0005\u00111\n\u0005\f\u00033\u0002\u0001\u0019!a\u0001\n\u0003\tY\u0006C\u0006\u0002h\u0001\u0001\r\u0011!Q!\n\u00055\u0003bCA5\u0001\u0001\u0007\t\u0019!C\u0001\u0003WB1\"a\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002v!Y\u0011\u0011\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA7\u0011%\tY\b\u0001b\u0001\n\u0003\ti\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA@\u0011%\ti\t\u0001b\u0001\n\u0003\ty\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAI\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a-\u0001\t\u0003\tY\nC\u0004\u0002>\u0002!\t!a'\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002\u001c\"9\u00111\u001a\u0001\u0005\u0002\u0005m\u0005bBAh\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003'\u0004A\u0011AAN\u0011\u001d\t9\u000e\u0001C\u0001\u00037Cq!a7\u0001\t\u0003\tY\nC\u0004\u0002`\u0002!\t!a'\t\u000f\u0005\r\b\u0001\"\u0001\u0002\u001c\"9\u0011q\u001d\u0001\u0005\u0002\u0005m\u0005bBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0005\u000f\u0001A\u0011AAN\u0011\u001d\u0011Y\u0001\u0001C\u0001\u00037CqAa\u0004\u0001\t\u0003\tY\nC\u0004\u0003\u0014\u0001!\t!a'\t\u000f\t]\u0001\u0001\"\u0001\u0002\u001c\"9!1\u0004\u0001\u0005\u0002\u0005m\u0005b\u0002B\u0010\u0001\u0011\u0005\u00111\u0014\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fB\u0011B!\u001c\u0001#\u0003%IAa\u001c\t\u0013\t\u0015\u0005!%A\u0005\n\t\u001d\u0005\"\u0003BF\u0001E\u0005I\u0011\u0002BG\u0011\u001d\u0011\t\n\u0001C\u0001\u00037CqA!&\u0001\t\u0003\tY\nC\u0004\u0003\u001a\u0002!\t!a'\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"I!q\u0017\u0001\u0012\u0002\u0013%!Q\u0012\u0005\b\u0005s\u0003A\u0011AAN\u0011\u001d\u0011i\f\u0001C\u0001\u00037CqA!1\u0001\t\u0003\tY\nC\u0004\u0003F\u0002!\t!a'\t\u000f\t%\u0007\u0001\"\u0001\u0002\u001c\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bv\u0001\u0011%!Q\u001e\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011\u001d\u0019y\u0002\u0001C\u0005\u0007CAqa!\n\u0001\t\u0003\tY\nC\u0004\u0004*\u0001!\t!a'\t\u000f\r5\u0002\u0001\"\u0001\u0002\u001c\"91\u0011\u0007\u0001\u0005\u0002\u0005m\u0005bBB\u001b\u0001\u0011\u0005\u00111\u0014\u0005\n\u0007s\u0001!\u0019!C\u0001\u0007wA\u0001ba\u0011\u0001A\u0003%1Q\b\u0005\n\u0007\u000b\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0012\u0001A\u0003%1Q\b\u0005\n\u0007\u0013\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0013\u0001A\u0003%1Q\b\u0005\n\u0007\u001b\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0014\u0001A\u0003%1Q\b\u0005\n\u0007#\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0015\u0001A\u0003%1Q\b\u0005\n\u0007+\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0016\u0001A\u0003%1Q\b\u0005\n\u00073\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0017\u0001A\u0003%1Q\b\u0005\n\u0007;\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0018\u0001A\u0003%1Q\b\u0005\n\u0007C\u0002!\u0019!C\u0001\u0007wA\u0001ba\u0019\u0001A\u0003%1Q\b\u0005\n\u0007K\u0002!\u0019!C\u0001\u0007wA\u0001ba\u001a\u0001A\u0003%1Q\b\u0005\b\u0007S\u0002A\u0011AAN\u0011\u001d\u0019i\u0007\u0001C\u0001\u00037Cqa!\u001d\u0001\t\u0003\tY\nC\u0004\u0004v\u0001!\t!a'\t\u000f\re\u0004\u0001\"\u0001\u0002\u001c\"91Q\u0010\u0001\u0005\u0002\u0005m\u0005bBBA\u0001\u0011\u0005\u00111T\u0004\b\u0007\u000b3\u0007\u0012ABD\r\u0019)g\r#\u0001\u0004\n\"1!O\u0018C\u0001\u0007\u0017Cqa!$_\t\u0003\u0019y\tC\u0004\u0004\u0016z#\taa&\t\u000f\r5f\f\"\u0001\u00040\"91Q\u00180\u0005\u0002\r}\u0006\"CBn=F\u0005I\u0011ABo\u00059aunZ'b]\u0006<WM\u001d+fgRT!a\u001a5\u0002\u00071|wMC\u0001j\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0003=\fQa]2bY\u0006L!!\u001d8\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u000f\u0005\u0002v\u00015\ta-\u0001\u0003uS6,W#\u0001=\u0011\u0007e\f9!D\u0001{\u0015\tYH0\u0001\u0003vi&d'BA?\u007f\u0003\u0019\u0019XM\u001d<fe*\u0011\u0011n \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000b\t1a\u001c:h\u0013\r\tIA\u001f\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005yQ.\u0019=S_2d\u0017J\u001c;feZ\fG.\u0006\u0002\u0002\u0012A\u0019Q.a\u0005\n\u0007\u0005UaNA\u0002J]R\f\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u00175\f\u0007\u0010T8h\u0003\u001e,Wj]\u0001\r[\u0006DHj\\4BO\u0016l5\u000fI\u0001\tY><\u0007K]8qgV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tY#\u0004\u0002\u0002&)\u001910a\n\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006LA!!\f\u0002&\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t)\u0004\u0005\u0003\u00028\u0005\rSBAA\u001d\u0015\r9\u00171\b\u0006\u0005\u0003{\ty$A\u0005j]R,'O\\1mg*\u0019\u0011\u0011\t@\u0002\u000fM$xN]1hK&!\u0011QIA\u001d\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\na\u0001\\8h\t&\u0014XCAA'!\u0011\ty%!\u0016\u000e\u0005\u0005E#\u0002BA*\u0003O\t!![8\n\t\u0005]\u0013\u0011\u000b\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$B!!\u0018\u0002dA\u0019Q.a\u0018\n\u0007\u0005\u0005dN\u0001\u0003V]&$\b\"CA3\u001b\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\bY><G)\u001b:!\u0003)awnZ'b]\u0006<WM]\u000b\u0003\u0003[\u00022!^A8\u0013\r\t\tH\u001a\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003;\n9\bC\u0005\u0002fA\t\t\u00111\u0001\u0002n\u0005YAn\\4NC:\fw-\u001a:!\u0003\u0011q\u0017-\\3\u0016\u0005\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\t\u0005\u0015\u0015qE\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\n\u0006\r%AB*ue&tw-A\u0003oC6,\u0007%A\rwKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006dWCAAI!\ri\u00171S\u0005\u0004\u0003+s'\u0001\u0002'p]\u001e\f!D^3ss2\u000b'oZ3M_\u001e4E.^:i\u0013:$XM\u001d<bY\u0002\nQa]3u+B$\"!!\u0018)\u0007Y\ty\n\u0005\u0003\u0002\"\u0006=VBAAR\u0015\u0011\t)+a*\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002*\u0006-\u0016a\u00026va&$XM\u001d\u0006\u0005\u0003[\u000b\u0019!A\u0003kk:LG/\u0003\u0003\u00022\u0006\r&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0018\u0003o\u0003B!!)\u0002:&!\u00111XAR\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0007uKN$8I]3bi\u0016dun\u001a\u0015\u00041\u0005\u0005\u0007\u0003BAQ\u0003\u0007LA!!2\u0002$\n!A+Z:u\u0003\u0011\"Xm\u001d;IC:$G.\u001b8h\u000bb\u001cW\r\u001d;j_:\u001cH)\u001e:j]\u001e\u001c\u0006.\u001e;e_^t\u0007fA\r\u0002B\u0006aD/Z:u\u00072,\u0017M\\*ikR$wn\u001e8GS2,w\u000b[3o'\",H\u000fZ8x]\u000e\u000bG\u000e\\3e\u0005\u00164wN]3Ti\u0006\u0014H/\u001e9D_6\u0004H.\u001a;fQ\rQ\u0012\u0011Y\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gj\\4XSRD\u0017J\u001c<bY&$Gj\\4ESJD3aGAa\u0003}!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f\u001b'pO\u0012K'OR1mY\n\f7m\u001b\u0015\u00049\u0005\u0005\u0017!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u0004;\u0005\u0005\u0017A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bf\u0001\u0010\u0002B\u0006\tC/Z:u\u00072,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{K\"\u001aq$!1\u0002UQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$H)\u001a7fi\u0016\u0004v\u000e\\5ds\"\u001a\u0001%!1\u0002IQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$\bk\u001c7jGfD3!IAa\u0003M!Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t)\u0011\ti&a<\t\u000f\u0005E(\u00051\u0001\u0002t\u00061\u0001o\u001c7jGf\u0004B!!>\u0003\u00049!\u0011q_A\u0000!\r\tIP\\\u0007\u0003\u0003wT1!!@k\u0003\u0019a$o\\8u}%\u0019!\u0011\u00018\u0002\rA\u0013X\rZ3g\u0013\u0011\tII!\u0002\u000b\u0007\t\u0005a.\u0001\nuKN$H+[7f\u0005\u0006\u001cX\r\u001a$mkND\u0007fA\u0012\u0002B\u0006IB/Z:u\u0019\u0016\f7\u000f\u001e'pC\u0012,G-Q:tS\u001etW.\u001a8uQ\r!\u0013\u0011Y\u0001!i\u0016\u001cH\u000fT8bI2{wm]*lSB\u0014V-\\8uK&sG-\u001a=DC\u000eDW\rK\u0002&\u0003\u0003\f1\u0005^3tiR;x\u000eT8h\u001b\u0006t\u0017mZ3sgV\u001b\u0018N\\4TC6,G)\u001b:GC&d7\u000fK\u0002'\u0003\u0003\fA\u0004^3ti\u000eCWmY6q_&tGOU3d_Z,'/\u001f)pS:$8\u000fK\u0002(\u0003\u0003\fQ\u0006^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:iQ\rA\u0013\u0011Y\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\rI\u0013\u0011Y\u0001\u0019m\u0016\u0014\u0018NZ=DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLH\u0003CA/\u0005O\u0011IEa\u0013\t\u000f\t%\"\u00061\u0001\u0003,\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003.\t]\"Q\b\b\u0005\u0005_\u0011\u0019D\u0004\u0003\u0002z\nE\u0012\"A8\n\u0007\tUb.A\u0004qC\u000e\\\u0017mZ3\n\t\te\"1\b\u0002\u0004'\u0016\f(b\u0001B\u001b]B!!q\bB#\u001b\t\u0011\tEC\u0002\u0003Dy\faaY8n[>t\u0017\u0002\u0002B$\u0005\u0003\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002j)\u0002\r!!\u001c\t\u000f\u0005%#\u00061\u0001\u0002N\u0005\u00012M]3bi\u0016dunZ'b]\u0006<WM\u001d\u000b\t\u0003[\u0012\tFa\u0016\u0003j!I!1K\u0016\u0011\u0002\u0003\u0007!QK\u0001\bY><G)\u001b:t!\u0019\u0011iCa\u000e\u0002N!I!\u0011L\u0016\u0011\u0002\u0003\u0007!1L\u0001\u0011G>tg-[4SKB|7/\u001b;pef\u0004BA!\u0018\u0003f5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'\u0001\u0005nKR\fG-\u0019;b\u0015\ti\b.\u0003\u0003\u0003h\t}#\u0001E\"p]\u001aLwMU3q_NLGo\u001c:z\u0011%\u0011Yg\u000bI\u0001\u0002\u0004\t\t\"A\rsK\u000e|g/\u001a:z)\"\u0014X-\u00193t!\u0016\u0014H)\u0019;b\t&\u0014\u0018AG2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\nTC\u0001B9U\u0011\u0011)Fa\u001d,\u0005\tU\u0004\u0003\u0002B<\u0005\u0003k!A!\u001f\u000b\t\tm$QP\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa o\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\u0013IHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uII*\"A!#+\t\tm#1O\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001fSC!!\u0005\u0003t\u0005\u0011C/Z:u\r&dWMU3gKJ,gnY3t\u0003\u001a$XM]!ts:\u001cG)\u001a7fi\u0016D3aLAa\u0003\t\"Xm\u001d;De\u0016\fG/Z!oI\u0012+G.\u001a;f\u001fZ,'\u000f\\=M_:<Gk\u001c9jG\"\u001a\u0001'!1\u0002CQ,7\u000f^\"iK\u000e\\\u0007o\\5oi\u001a{'o\u00148ms\u00063g-Z2uK\u0012dunZ:)\u0007E\n\t-A\u0004sK\u0006$Gj\\4\u0015\u0011\t\u0005&q\u0015BX\u0005g\u0003B!a\u000e\u0003$&!!QUA\u001d\u000551U\r^2i\t\u0006$\u0018-\u00138g_\"1qM\ra\u0001\u0005S\u00032!\u001eBV\u0013\r\u0011iK\u001a\u0002\u000b+:Lg-[3e\u0019><\u0007b\u0002BYe\u0001\u0007\u0011\u0011S\u0001\u0007_\u001a47/\u001a;\t\u0013\tU&\u0007%AA\u0002\u0005E\u0011!C7bq2+gn\u001a;i\u0003E\u0011X-\u00193M_\u001e$C-\u001a4bk2$HeM\u0001&i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f+B$\u0017\r^3t\u0019><7i\u001c8gS\u001eD3\u0001NAa\u0003u!Xm\u001d;D_:4\u0017nZ\"iC:<WmR3ug\u000ecW-\u00198fIV\u0003\bfA\u001b\u0002B\u0006AC/Z:u\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\rR3mSZ,'/\u001a3U_\u0006cG\u000eT8hg\"\u001aa'!1\u0002gQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKN#x\u000e]\"mK\u0006t\u0017N\\4JM\u000e{W\u000e]1di&\u001b(+Z7pm\u0016$\u0007fA\u001c\u0002B\u0006aC/Z:u\u0007>tg-[4DQ\u0006tw-Z:XSRDgj\u001c'pO\u001e+G\u000f^5oO&s\u0017\u000e^5bY&TX\r\u001a\u0015\u0004q\u0005\u0005\u0017AE1qa\u0016tGMU3d_J$7\u000fV8M_\u001e$B\"!\u0018\u0003R\nM'q\u001bBn\u0005ODQA^\u001dA\u0002aDqA!6:\u0001\u0004\ti%\u0001\u0007qCJ,g\u000e\u001e'pO\u0012K'\u000fC\u0004\u0003Zf\u0002\r!!\u0005\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0005;L\u0004\u0019\u0001Bp\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0003\u0003b\n\rXB\u0001B2\u0013\u0011\u0011)Oa\u0019\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\bb\u0002Bus\u0001\u0007\u0011\u0011C\u0001\u0017Kb\u0004Xm\u0019;fIN+w-\\3oiN\u0004VM\u001d'pO\u0006\u0011c/\u001a:jMf\u0014V-\\1j]&tw\rT8hgR{'+Z2pm\u0016\u0014X*\u001a;sS\u000e$b!!\u0018\u0003p\nM\bb\u0002Byu\u0001\u0007\u0011QN\u0001\u000egBLHj\\4NC:\fw-\u001a:\t\u000f\tU(\b1\u0001\u0003x\u0006qQ\r\u001f9fGR,G\rU1sC6\u001c\b\u0003\u0003B}\u0005\u007f\f\u00190!\u0005\u000e\u0005\tm(b\u0001B\u007f]\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r\u0005!1 \u0002\u0004\u001b\u0006\u0004\u0018A\n<fe&4\u0017PU3nC&t\u0017N\\4TK\u001elWM\u001c;t)>\u0014VmY8wKJlU\r\u001e:jGRa\u0011QLB\u0004\u0007\u0013\u0019Ya!\u0004\u0004\u001e!9!\u0011_\u001eA\u0002\u00055\u0004b\u0002B*w\u0001\u0007!Q\u000b\u0005\b\u0005WZ\u0004\u0019AA\t\u0011\u001d\u0019ya\u000fa\u0001\u0007#\tq!\\8dW6\u000b\u0007\u000f\u0005\u0005\u0004\u0014\re\u00111_A\t\u001b\t\u0019)B\u0003\u0003\u0004\u0018\u0005\u0015\u0012AC2p]\u000e,(O]3oi&!11DB\u000b\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0005\b\u0005k\\\u0004\u0019\u0001B|\u0003y1XM]5gs2{wMU3d_Z,'/T3ue&\u001c7OU3n_Z,G\r\u0006\u0003\u0002^\r\r\u0002b\u0002Byy\u0001\u0007\u0011QN\u0001\u0017i\u0016\u001cH\u000fT8h%\u0016\u001cwN^3ss6+GO]5dg\"\u001aQ(!1\u0002mQ,7\u000f\u001e'pOJ+7m\u001c<feflU\r\u001e:jGN\u001c\u0006n\\;mI\n+'+Z7pm\u0016$\u0017I\u001a;fe2{wMU3d_Z,'/\u001a3)\u0007y\n\t-\u0001\u0019uKN$X*\u001a;sS\u000e\u001cX\t_5ti^CWM\u001c'pO&\u001b(+Z2sK\u0006$X\r\u001a\"fM>\u0014X\rR3mKRLwN\u001c\u0015\u0004\u007f\u0005\u0005\u0017!\r;fgRlU\r\u001e:jGN\f%/\u001a*f[>4X\rZ,iK:luN^5oO\u000e+(O]3oiR{g)\u001e;ve\u0016dun\u001a\u0015\u0004\u0001\u0006\u0005\u0017\u0001\u0007;fgR<\u0016-\u001b;G_J\fE\u000e\u001c+p\u0007>l\u0007\u000f\\3uK\"\u001a\u0011)!1\u0002\t\u0019|w\u000eM\u000b\u0003\u0007{\u0001BAa\u0010\u0004@%!1\u0011\tB!\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u0003g_>\u0004\u0004%\u0001\u0003g_>\f\u0014!\u00024p_F\u0002\u0013\u0001\u00022beB\nQAY1sa\u0001\nAAY1sc\u0005)!-\u0019:2A\u0005!!-\u0019>1\u0003\u0015\u0011\u0017M\u001f\u0019!\u0003\u0011\u0011\u0017M_\u0019\u0002\u000b\t\f'0\r\u0011\u0002\t\t\f'PM\u0001\u0006E\u0006T(\u0007I\u0001\u0006cV,\b\u0010M\u0001\u0007cV,\b\u0010\r\u0011\u0002\u001bI,7M]3bi\u0016$gi\\81\u00039\u0011Xm\u0019:fCR,GMR8pa\u0001\nQB]3de\u0016\fG/\u001a3G_>\f\u0014A\u0004:fGJ,\u0017\r^3e\r>|\u0017\u0007I\u0001\"i\u0016\u001cHOR5oIN#(/Y=SKBd\u0017nY1t\u0013:,U\u000e\u001d;z\u00136\fw-\u001a\u0015\u0004-\u0006\u0005\u0017\u0001\t;fgR4\u0015N\u001c3T_6,7\u000b\u001e:bsJ+\u0007\u000f\\5dCNLe.S7bO\u0016D3aVAa\u0003I\"Xm\u001d;GS:$7k\\7f'R\u0014\u0018-\u001f*fa2L7-Y:J]&k\u0017mZ3XSRD'+Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001c\bf\u0001-\u0002B\u0006\u0001C/Z:u\r&tGm\u0015;sCf\u0014V\r\u001d7jG\u0006\u001c\u0018J\\#naRLH*Q%SQ\rI\u0016\u0011Y\u0001\"i\u0016\u001cHOR5oI:{7\u000b\u001e:bsJ+\u0007\u000f\\5dCNLeNR;mY2\u000b\u0015J\u0015\u0015\u00045\u0006\u0005\u0017a\t;fgR4\u0015N\u001c3T_6,7\u000b\u001e:bsJ+\u0007\u000f\\5dCNLeNR;mY2\u000b\u0015J\u0015\u0015\u00047\u0006\u0005\u0017!\b;fgR$v\u000e]5d%\u0016\u001c'/Z1uS>t\u0017J\u001c$vY2d\u0015)\u0013*)\u0007q\u000b\t-\u0001\bM_\u001el\u0015M\\1hKJ$Vm\u001d;\u0011\u0005Ut6C\u00010m)\t\u00199)A\u0004n_\u000e\\Gj\\4\u0015\t\t%6\u0011\u0013\u0005\b\u0007'\u0003\u0007\u0019AB\u001f\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\u0006u_BL7-S7bO\u0016$Ba!'\u0004&B!11TBQ\u001b\t\u0019iJC\u0002\u0004 z\fQ![7bO\u0016LAaa)\u0004\u001e\nQAk\u001c9jG&k\u0017mZ3\t\u000f\r\u001d\u0016\r1\u0001\u0004*\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0011\te(q`B\u001f\u0007W\u0003bA!\f\u00038\u0005E\u0011a\u0003;pa&\u001c7/S7bO\u0016$Ba!-\u00048B!11TBZ\u0013\u0011\u0019)l!(\u0003\u0017Q{\u0007/[2t\u00136\fw-\u001a\u0005\b\u0007s\u0013\u0007\u0019AB^\u0003\u0019!x\u000e]5dgB1!Q\u0006B\u001c\u00073\u000b!f\u0019:fCR,G*Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti\u001a{'o\u0015;sCf$U\r^3di&|g\u000e\u0006\u0004\u0004B\u000e57Q\u001b\t\u0005\u0007\u0007\u001cI-\u0004\u0002\u0004F*!1q\u0019B!\u0003!\u0011X-];fgR\u001c\u0018\u0002BBf\u0007\u000b\u00141\u0003T3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRDqaa*d\u0001\u0004\u0019y\r\u0005\u0004\u0003.\rE7QH\u0005\u0005\u0007'\u0014YD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011%\u00199n\u0019I\u0001\u0002\u0004\u0019I.A\u0004mK\u0006$WM]:\u0011\r\t52\u0011[A\t\u0003Q\u001a'/Z1uK2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_J\u001cFO]1z\t\u0016$Xm\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\u0007?TCa!7\u0003t\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;
    private final TopicIdPartition foo0;
    private final TopicIdPartition foo1;
    private final TopicIdPartition bar0;
    private final TopicIdPartition bar1;
    private final TopicIdPartition baz0;
    private final TopicIdPartition baz1;
    private final TopicIdPartition baz2;
    private final TopicIdPartition quux0;
    private final TopicIdPartition recreatedFoo0;
    private final TopicIdPartition recreatedFoo1;

    public static Iterable<Object> createLeaderAndIsrRequestForStrayDetection$default$2() {
        return LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection$default$2();
    }

    public static LeaderAndIsrRequest createLeaderAndIsrRequestForStrayDetection(Iterable<TopicIdPartition> iterable, Iterable<Object> iterable2) {
        return LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection(iterable, iterable2);
    }

    public static TopicsImage topicsImage(Seq<TopicImage> seq) {
        return LogManagerTest$.MODULE$.topicsImage(seq);
    }

    public static TopicImage topicImage(Map<TopicIdPartition, Seq<Object>> map) {
        return LogManagerTest$.MODULE$.topicImage(map);
    }

    public static UnifiedLog mockLog(TopicIdPartition topicIdPartition) {
        return LogManagerTest$.MODULE$.mockLog(topicIdPartition);
    }

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5(), log2.appendAsLeader$default$6());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        UnifiedLog log1 = qual$2.getOrCreateLog(topicPartition1, x$7, x$8, (Option)x$6);
        File logFile0 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        File logFile1 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-1").toString());
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5(), log0.appendAsLeader$default$6());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5(), log1.appendAsLeader$default$6());
        log1.takeProducerSnapshot();
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3())));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                this.$outer.logManager().startup((Set)Predef$.MODULE$.Set().empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(loadLogCalled)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.logManager().shutdown();
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$2, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        boolean x$22 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, x$22, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable & scala.Serializable containsLogFile = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$32, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$3)));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((UnifiedLog)log, (long)(offset.elem + 1L), (int)this.readLog$default$3()).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset;
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((UnifiedLog)log, (long)(offset.elem + 1L), (int)this.readLog$default$3()).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        LogManager qual$1 = this.logManager();
        TopicPartition x$42 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$42, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$4)));
        this.time().sleep((long)(this.maxLogAgeMs() + 1));
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size()), Iterable$.MODULE$.canBuildFrom());
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils$.MODULE$.tempDir();
        new File(logDir, "remote-log-index-cache").mkdir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty());
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4(), TestUtils$.MODULE$.createLogManager$default$5(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7(), TestUtils$.MODULE$.createLogManager$default$8(), TestUtils$.MODULE$.createLogManager$default$9()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$7 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$7, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = TestUtils$.MODULE$.createLogManager$default$4();
        MetadataVersion x$7 = TestUtils$.MODULE$.createLogManager$default$6();
        boolean x$8 = TestUtils$.MODULE$.createLogManager$default$8();
        Option<UnifiedLog> x$9 = TestUtils$.MODULE$.createLogManager$default$9();
        return TestUtils$.MODULE$.createLogManager(logDirs, x$1, configRepository, x$6, x$4, x$7, recoveryThreadsPerDataDir, x$8, x$9);
    }

    private Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$8)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$82 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$5, x$6, x$7, x$82).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach(arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep((long)this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$5, x$6, x$7, x$8);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$11 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$11, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, FetchIsolation.LOG_END, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = spyLogManager.getOrCreateLog$default$2();
        boolean x$7 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$6, x$7, (Option)x$5);
        log0.updateConfig(oldLogConfig);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = spyLogManager.getOrCreateLog$default$2();
        boolean x$11 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$10, x$11, (Option)x$9);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties, false);
        Assertions.assertTrue((boolean)log0.config().delete);
        Assertions.assertTrue((boolean)log1.config().delete);
        Assertions.assertFalse((boolean)log0.config().compact);
        Assertions.assertFalse((boolean)log1.config().compact);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler, (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17());
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)num -> num + 1, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable & scala.Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> this.logConfig());
            long x$6 = 0L;
            long x$7 = 0L;
            int x$8 = 300000;
            ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(300000, false);
            int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$11 = mockTime$1.scheduler;
            LogDirFailureChannel x$14 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            boolean x$15 = false;
            None$ x$16 = None$.MODULE$;
            boolean x$17 = false;
            boolean x$19 = UnifiedLog$.MODULE$.apply$default$16();
            LogOffsetsListener x$20 = UnifiedLog$.MODULE$.apply$default$17();
            return UnifiedLog$.MODULE$.apply(dir, config, x$6, x$7, (Scheduler)x$11, mockBrokerTopicStats, (Time)mockTime, x$8, x$9, x$10, x$14, x$15, (Option)x$16, x$17, (ConcurrentMap)mockMap, x$19, x$20);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        this.logManager().shutdown();
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        ConfigRepository x$3 = this.createLogManager$default$2();
        this.logManager_$eq(this.createLogManager((Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$6, x$7, x$8).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        boolean x$12 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$11, x$12, (Option)x$10);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, x$6, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWaitForAllToComplete() {
        void waitForAllToComplete_callback;
        void waitForAllToComplete_jobs;
        void waitForAllToComplete_callback2;
        void waitForAllToComplete_jobs2;
        void waitForAllToComplete_callback3;
        void waitForAllToComplete_jobs3;
        void waitForAllToComplete_callback4;
        void waitForAllToComplete_jobs4;
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$12 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$12)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$13 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$14 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$14);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon2 = new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        Assertions.assertFalse((waitForAllToComplete_jobs4.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback4, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$15);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon3 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        Assertions.assertFalse((waitForAllToComplete_jobs3.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback3, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$16 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$16);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon4 = new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        Assertions.assertTrue((waitForAllToComplete_jobs2.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback2, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$17 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$17);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon5 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        Assertions.assertFalse((waitForAllToComplete_jobs.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public TopicIdPartition foo0() {
        return this.foo0;
    }

    public TopicIdPartition foo1() {
        return this.foo1;
    }

    public TopicIdPartition bar0() {
        return this.bar0;
    }

    public TopicIdPartition bar1() {
        return this.bar1;
    }

    public TopicIdPartition baz0() {
        return this.baz0;
    }

    public TopicIdPartition baz1() {
        return this.baz1;
    }

    public TopicIdPartition baz2() {
        return this.baz2;
    }

    public TopicIdPartition quux0() {
        return this.quux0;
    }

    public TopicIdPartition recreatedFoo0() {
        return this.recreatedFoo0;
    }

    public TopicIdPartition recreatedFoo1() {
        return this.recreatedFoo1;
    }

    @Test
    public void testFindStrayReplicasInEmptyImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((Seq<TopicImage>)Nil$.MODULE$);
        .colon.colon onDisk = new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)((TraversableOnce)onDisk.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)((TraversableOnce)onDisk.map((Function1 & Serializable & scala.Serializable)x$19 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$19), Seq$.MODULE$.canBuildFrom())).toSet()));
    }

    @Test
    public void testFindSomeStrayReplicasInImage() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)Nil$.MODULE$)));
        Seq onDisk = (Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x$20 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$20), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo1(), this.quux0()}))).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)onDisk).toSet());
    }

    @Test
    public void testFindSomeStrayReplicasInImageWithRemoteReplicas() {
        TopicsImage image = LogManagerTest$.MODULE$.topicsImage((Seq<TopicImage>)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.foo0()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})))), (List)new .colon.colon((Object)LogManagerTest$.MODULE$.topicImage((Map<TopicIdPartition, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar0()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.bar1()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})))), (List)Nil$.MODULE$)));
        Seq onDisk = (Seq)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$22 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$22), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.bar0()}))).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())), (Object)LogManager$.MODULE$.findStrayReplicas(0, image, (Iterable)onDisk).toSet());
    }

    @Test
    public void testFindStrayReplicasInEmptyLAIR() {
        Seq onDisk = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        Assertions.assertEquals((Object)((TraversableOnce)onDisk.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)Nil$.MODULE$, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection$default$2()), (Iterable)onDisk.map((Function1 & Serializable & scala.Serializable)x$25 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$25), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testFindNoStrayReplicasInFullLAIR() {
        Seq onDisk = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)onDisk, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection$default$2()), (Iterable)onDisk.map((Function1 & Serializable & scala.Serializable)x$26 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$26), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testFindSomeStrayReplicasInFullLAIR() {
        Seq onDisk = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        .colon.colon present = new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.bar1(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$))));
        Assertions.assertEquals((Object)((TraversableOnce)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.baz0(), (List)new .colon.colon((Object)this.baz1(), (List)new .colon.colon((Object)this.baz2(), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)present, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection$default$2()), (Iterable)onDisk.map((Function1 & Serializable & scala.Serializable)x$28 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$28), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testTopicRecreationInFullLAIR() {
        Seq onDisk = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.foo0(), this.foo1(), this.bar0(), this.bar1(), this.baz0(), this.baz1(), this.baz2(), this.quux0()}));
        .colon.colon present = new .colon.colon((Object)this.recreatedFoo0(), (List)new .colon.colon((Object)this.recreatedFoo1(), (List)new .colon.colon((Object)this.bar0(), (List)new .colon.colon((Object)this.baz0(), (List)new .colon.colon((Object)this.baz1(), (List)new .colon.colon((Object)this.baz2(), (List)new .colon.colon((Object)this.quux0(), (List)Nil$.MODULE$)))))));
        Assertions.assertEquals((Object)((TraversableOnce)new .colon.colon((Object)this.foo0(), (List)new .colon.colon((Object)this.foo1(), (List)new .colon.colon((Object)this.bar1(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)LogManager$.MODULE$.findStrayReplicas(0, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection((Iterable<TopicIdPartition>)present, LogManagerTest$.MODULE$.createLeaderAndIsrRequestForStrayDetection$default$2()), (Iterable)onDisk.map((Function1 & Serializable & scala.Serializable)x$30 -> LogManagerTest$.MODULE$.mockLog((TopicIdPartition)x$30), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        UnifiedLog cfr_ignored_0 = (UnifiedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$3) {
        return x$3.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5(), log$4.appendAsLeader$default$6());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$8) {
        return x$8.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$9) {
        String string = x$9.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$9)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$1);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingLogsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$2);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingSegmentsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                    return;
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$1).size());
        LogManagerTest.logMetrics$2(topicName$1).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$2) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$2).size());
        LogManagerTest.logMetrics$3(topicName$2).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$12) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$14) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$15) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$16) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$17) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
        this.foo0 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 0));
        this.foo1 = new TopicIdPartition(Uuid.fromString((String)"Sl08ZXU2QW6uF5hIoSzc8w"), new TopicPartition("foo", 1));
        this.bar0 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 0));
        this.bar1 = new TopicIdPartition(Uuid.fromString((String)"69O438ZkTSeqqclTtZO2KA"), new TopicPartition("bar", 1));
        this.baz0 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 0));
        this.baz1 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 1));
        this.baz2 = new TopicIdPartition(Uuid.fromString((String)"2Ik9_5-oRDOKpSXd2SuG5w"), new TopicPartition("baz", 2));
        this.quux0 = new TopicIdPartition(Uuid.fromString((String)"YS9owjv5TG2OlsvBM0Qw6g"), new TopicPartition("quux", 0));
        this.recreatedFoo0 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 0));
        this.recreatedFoo1 = new TopicIdPartition(Uuid.fromString((String)"_dOOzPe3TfiWV21Lh7Vmqg"), new TopicPartition("foo", 1));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

