/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.RemoteIndexCache;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}e\u0001\u0002$H\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004d\u0001\u0001\u0006Ia\u0017\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019\t\b\u0001)A\u0005M\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB<\u0001A\u0003%A\u000fC\u0004y\u0001\t\u0007I\u0011B=\t\ru\u0004\u0001\u0015!\u0003{\u0011\u001dq\bA1A\u0005\neDaa \u0001!\u0002\u0013Q\b\u0002CA\u0001\u0001\t\u0007I\u0011B:\t\u000f\u0005\r\u0001\u0001)A\u0005i\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\t\u0017\u0005u\u0002\u00011A\u0001B\u0003&\u0011q\u0004\u0005\f\u0003\u007f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0005C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0003bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007B1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u0011Q\r\u0001A\u0002\u0003\u0007I\u0011BA4\u0011-\tY\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0016\t\u0017\u00055\u0004\u00011AA\u0002\u0013%\u00111\u000b\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005U\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA>\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!+\u0001\t\u0003\t\t\nC\u0004\u00024\u0002!\t!!%\t\u000f\u0005u\u0006\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005E\u0005bBAc\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003\u0013\u0004A\u0011AAI\u0011\u001d\ti\r\u0001C\u0001\u0003#Cq!!5\u0001\t\u0003\t\t\nC\u0004\u0002V\u0002!\t!!%\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\u0012\"9\u0011Q\u001c\u0001\u0005\u0002\u0005E\u0005bBAq\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003K\u0004A\u0011AAI\u0011\u001d\tI\u000f\u0001C\u0001\u0003#Cq!!<\u0001\t\u0003\t\t\nC\u0004\u0002r\u0002!\t!!%\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!Q\f\u0001\u0005\u0002\u0005E\u0005b\u0002B1\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0005K\u0002A\u0011AAI\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005WBqAa\u001e\u0001\t\u0003\t\t\nC\u0004\u0003|\u0001!IA! \t\u0013\t]\u0005!%A\u0005\n\te\u0005b\u0002BX\u0001\u0011%!\u0011\u0017\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001fD\u0011Ba;\u0001#\u0003%IA!<\t\u000f\tE\b\u0001\"\u0003\u0003t\"911\u0001\u0001\u0005\n\r\u0015\u0001bBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u00073\u0001A\u0011BB\u000e\u0011\u001d\u00199\u0003\u0001C\u0005\u0007SAqa!\u000f\u0001\t\u0013\u0019Y\u0004C\u0004\u0004F\u0001!Iaa\u0012\t\u000f\r-\u0003\u0001\"\u0003\u0004N!91\u0011\u000b\u0001\u0005\n\rM\u0003bBB-\u0001\u0011%11\f\u0002\u0015%\u0016lw\u000e^3J]\u0012,\u0007pQ1dQ\u0016$Vm\u001d;\u000b\u0005!K\u0015A\u0002:f[>$XM\u0003\u0002K\u0017\u0006\u0019An\\4\u000b\u00031\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001fB\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A,\u0011\u0005a\u0003Q\"A$\u0002\r1|wmZ3s+\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0017aA8sO&\u0011!-\u0018\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005!A/[7f+\u00051\u0007CA4p\u001b\u0005A'BA5k\u0003\u0011)H/\u001b7\u000b\u0005-d\u0017AB:feZ,'O\u0003\u0002M[*\u0011anX\u0001\u0007CB\f7\r[3\n\u0005AD'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u001e\t\u0003!VL!A^)\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003i\u0004\"\u0001U>\n\u0005q\f&\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005QA.Y:u\u001f\u001a47/\u001a;\u0002\u00171\f7\u000f^(gMN,G\u000fI\u0001\fg\u0016<W.\u001a8u'&TX-\u0001\u0007tK\u001elWM\u001c;TSj,\u0007%A\u0002sg6,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u000591\u000f^8sC\u001e,'b\u0001%\u0002\u0014)\u0011!J[\u0005\u0005\u0003/\tiA\u0001\u000bSK6|G/Z*u_J\fw-Z'b]\u0006<WM]\u0001\u0005eNl\u0007%A\u0003dC\u000eDW-\u0006\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019CC\u0002K\u0003KQA!a\n\u0002*\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u001fa\u0017\u0002BA\u0017\u0003G\u0011\u0001CU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3\u0002\u0013\r\f7\r[3`I\u0015\fH\u0003BA\u001a\u0003s\u00012\u0001UA\u001b\u0013\r\t9$\u0015\u0002\u0005+:LG\u000fC\u0005\u0002<E\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010J\u0019\u0002\r\r\f7\r[3!\u0003-\u0011Hn]'fi\u0006$\u0017\r^1\u0016\u0005\u0005\r\u0003\u0003BA\u0006\u0003\u000bJA!a\u0012\u0002\u000e\tA\"+Z7pi\u0016dunZ*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0002\u001fId7/T3uC\u0012\fG/Y0%KF$B!a\r\u0002N!I\u00111\b\u000b\u0002\u0002\u0003\u0007\u00111I\u0001\re2\u001cX*\u001a;bI\u0006$\u0018\rI\u0001\u0007Y><G)\u001b:\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0003S>T!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003G\nIF\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR!\u00111GA5\u0011%\tYdFA\u0001\u0002\u0004\t)&A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000bQ\u0004H)\u001b:\u0002\u0013Q\u0004H)\u001b:`I\u0015\fH\u0003BA\u001a\u0003gB\u0011\"a\u000f\u001b\u0003\u0003\u0005\r!!\u0016\u0002\rQ\u0004H)\u001b:!\u0003-IG\rU1si&$\u0018n\u001c8\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005E.\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u000b\u000byH\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006y\u0011\u000e\u001a)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005-\u0005\"CA\u001e;\u0005\u0005\t\u0019AA>\u00031IG\rU1si&$\u0018n\u001c8!\u0003\u0015\u0019X\r^;q)\t\t\u0019\u0004K\u0002 \u0003+\u0003B!a&\u0002&6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0002ba&TA!a(\u0002\"\u00069!.\u001e9ji\u0016\u0014(bAAR?\u0006)!.\u001e8ji&!\u0011qUAM\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\bG2,\u0017M\\;qQ\r\u0001\u0013Q\u0016\t\u0005\u0003/\u000by+\u0003\u0003\u00022\u0006e%!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;J]\u0012,\u0007PR5mK:\u000bW.Z!oI2{7-\u0019;j_:|e\u000eR5tW\"\u001a\u0011%a.\u0011\t\u0005]\u0015\u0011X\u0005\u0005\u0003w\u000bIJ\u0001\u0003UKN$\u0018a\b;fgR4U\r^2i\u0013:$W\r\u001f$s_6\u0014V-\\8uKN#xN]1hK\"\u001a!%a.\u0002QQ,7\u000f\u001e$fi\u000eD\u0017J\u001c3fq\u001a{'/T5tg&tw\r\u0016:b]N\f7\r^5p]&sG-\u001a=)\u0007\r\n9,\u0001\u0019uKN$\bk\\:ji&|gNR8s\u001d>tW\t_5ti&tw-\u00138eKb4%o\\7SK6|G/Z*u_J\fw-\u001a\u0015\u0004I\u0005]\u0016\u0001\u0006;fgR\u001c\u0015m\u00195f\u000b:$(/_#ya&\u0014\u0018\u0010K\u0002&\u0003o\u000b1\u0004^3ti\u001e+G/\u00138eKb\fe\r^3s\u0007\u0006\u001c\u0007.Z\"m_N,\u0007f\u0001\u0014\u00028\u0006)B/Z:u\u00072|7/Z%t\u0013\u0012,W\u000e]8uK:$\bfA\u0014\u00028\u0006\u0001C/Z:u\u0007\u0006\u001c\u0007.Z#oiJL\u0018j\u001d#fY\u0016$X\rZ(o%\u0016lwN^1mQ\rA\u0013qW\u0001\u001ai\u0016\u001cHo\u00117fC:,'\u000f\u00165sK\u0006$7\u000b[;uI><h\u000eK\u0002*\u0003o\u000b\u0011\u0002^3ti\u000ecwn]3)\u0007)\n9,A\u0013uKN$8i\u001c8dkJ\u0014XM\u001c;SK\u0006$wK]5uK\u0006\u001b7-Z:t\r>\u00148)Y2iK\"\u001a1&a.\u00023Q,7\u000f\u001e*fY>\fGmQ1dQ\u0016\fe\r^3s\u00072|7/\u001a\u0015\u0004Y\u0005]\u0016A\u0004;fgR\u0014V-\\8wK&#X-\u001c\u0015\u0004[\u0005]\u0016!\u0007;fgR\u0014V-\\8wK:{g.\u0012=jgR,g\u000e^%uK6D3ALA\\\u0003]!Xm\u001d;SK6|g/Z'vYRL\u0007\u000f\\3Ji\u0016l7\u000fK\u00020\u0003o\u000bA\u0006^3ti\u000e{'O];qi\u000e\u000b7\r[3J]\u0012,\u0007PR5mK\u0016C\u0018n\u001d;t\u0005V$hj\u001c;J]\u000e\u000b7\r[3\u0015\t\u0005M\u0012\u0011 \u0005\b\u0003w\u0004\u0004\u0019AA\u007f\u0003%Ig\u000eZ3y)f\u0004X\r\u0005\u0003\u0002\u0000\n\u001db\u0002\u0002B\u0001\u0005GqAAa\u0001\u0003\"9!!Q\u0001B\u0010\u001d\u0011\u00119A!\b\u000f\t\t%!1\u0004\b\u0005\u0005\u0017\u0011IB\u0004\u0003\u0003\u000e\t]a\u0002\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tMQ*\u0001\u0004=e>|GOP\u0005\u0002A&\u0011anX\u0005\u0003\u00196L!a\u001b7\n\u0005)S\u0017b\u0001%\u0002\u0014%!\u0011qBA\t\u0013\u0011\u0011)#!\u0004\u0002)I+Wn\u001c;f'R|'/Y4f\u001b\u0006t\u0017mZ3s\u0013\u0011\u0011ICa\u000b\u0003\u0013%sG-\u001a=UsB,'\u0002\u0002B\u0013\u0003\u001bA3\u0002\rB\u0018\u0005\u007f\u0011\tEa\u0011\u0003FA!!\u0011\u0007B\u001e\u001b\t\u0011\u0019D\u0003\u0003\u00036\t]\u0012\u0001\u00039s_ZLG-\u001a:\u000b\t\te\u0012QT\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\tu\"1\u0007\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7EAA\u007f\u0003\u0015q\u0017-\\3tY\u0019\u00119Ea\u0013\u0003P\u0005\u0012!\u0011J\u0001\u0007\u001f\u001a35+\u0012+\"\u0005\t5\u0013!\u0003+J\u001b\u0016\u001bF+Q'QC\t\u0011\t&A\u0006U%\u0006s5+Q\"U\u0013>s\u0005f\u0001\u0019\u0003VA!!q\u000bB-\u001b\t\u00119$\u0003\u0003\u0003\\\t]\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0001C/Z:u\u0007>t7-\u001e:sK:$(+Z7pm\u0016\u0014V-\u00193G_J\u001c\u0015m\u00195fQ\r\t\u0014qW\u00014i\u0016\u001cH/T;mi&\u0004H.Z%oI\u0016DXI\u001c;sS\u0016\u001cX\t_3dkRLwN\\%o\u0007>\u0014(/\u001e9u\u000bb\u001cW\r\u001d;j_:D3AMA\\\u00031\"Xm\u001d;J]\u0012,\u0007PR5mK\u0006c'/Z1es\u0016C\u0018n\u001d;P]\u0012K7o\u001b\"vi:{G/\u00138DC\u000eDW\rK\u00024\u0003o\u000bq\u0004^3tiJ\u001bVJU3ukJt7i\u001c:skB$X\rZ%oI\u0016Dh)\u001b7f)\u0011\t\u0019D!\u001c\t\u000f\t=D\u00071\u0001\u0002~\u0006iA/Z:u\u0013:$W\r\u001f+za\u0016D3\u0002\u000eB\u0018\u0005\u007f\u0011\tEa\u0011\u0003t12!q\tB&\u0005\u001fB3\u0001\u000eB+\u0003\u0011\"Xm\u001d;D_:\u001cWO\u001d:f]R\u001c\u0015m\u00195f\t\u0016dW\r^3e\r&dW-\u0012=jgR\u001c\bfA\u001b\u00028\u0006)r-\u001a8fe\u0006$Xm\u00159z\u0007\u0006\u001c\u0007.Z#oiJLH\u0003\u0002B@\u0005\u001b\u0003BA!!\u0003\b:!\u0011\u0011\u0005BB\u0013\u0011\u0011))a\t\u0002!I+Wn\u001c;f\u0013:$W\r_\"bG\",\u0017\u0002\u0002BE\u0005\u0017\u0013Q!\u00128uefTAA!\"\u0002$!I!q\u0012\u001c\u0011\u0002\u0003\u0007!\u0011S\u0001\u0013e\u0016lw\u000e^3M_\u001e\u001cVmZ7f]RLE\r\u0005\u0003\u0002\f\tM\u0015\u0002\u0002BK\u0003\u001b\u0011!CU3n_R,Gj\\4TK\u001elWM\u001c;JI\u0006yr-\u001a8fe\u0006$Xm\u00159z\u0007\u0006\u001c\u0007.Z#oiJLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm%\u0006\u0002BI\u0005;[#Aa(\u0011\t\t\u0005&1V\u0007\u0003\u0005GSAA!*\u0003(\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005S\u000b\u0016AC1o]>$\u0018\r^5p]&!!Q\u0016BR\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018CN\u001cXM\u001d;Bi2+\u0017m\u001d;P]\u0016\u0004&/Z:f]R$b!a\r\u00034\nU\u0006bBA\u000eq\u0001\u0007\u0011q\u0004\u0005\b\u0005oC\u0004\u0019\u0001B]\u0003\u0015)X/\u001b3t!\u0015\u0001&1\u0018B`\u0013\r\u0011i,\u0015\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003BA?\u0005\u0003LAAa1\u0002\u0000\t!Q+^5e\u0003=\t7o]3si\u000e\u000b7\r[3TSj,G\u0003BA\u001a\u0005\u0013DaAa3:\u0001\u0004!\u0018\u0001D3ya\u0016\u001cG/\u001a3TSj,\u0017A\u0007<fe&4\u0017PR3uG\"Le\u000eZ3y\u0013:4xnY1uS>tGCBA\u001a\u0005#\u0014)\u000e\u0003\u0004\u0003Tj\u0002\r\u0001^\u0001\u0006G>,h\u000e\u001e\u0005\n\u0005/T\u0004\u0013!a\u0001\u00053\f!\"\u001b8eKb$\u0016\u0010]3t!\u0019\u0011YN!:\u0002~:!!Q\u001cBq\u001d\u0011\u0011yAa8\n\u0003IK1Aa9R\u0003\u001d\u0001\u0018mY6bO\u0016LAAa:\u0003j\n\u00191+Z9\u000b\u0007\t\r\u0018+\u0001\u0013wKJLg-\u001f$fi\u000eD\u0017J\u001c3fq&sgo\\2bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yO\u000b\u0003\u0003Z\nu\u0015aH2sK\u0006$X\r\u0016=J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR1!Q\u001fB~\u0005\u007f\u0004B!!\t\u0003x&!!\u0011`A\u0012\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010C\u0004\u0003~r\u0002\r!a\u0011\u0002\u00115,G/\u00193bi\u0006Dqa!\u0001=\u0001\u0004\t)&A\u0002eSJ\fqe\u0019:fCR,7i\u001c:skB$H\u000b\u001f8J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR1!Q_B\u0004\u0007\u0013Aqa!\u0001>\u0001\u0004\t)\u0006C\u0004\u0003~v\u0002\r!a\u0011\u0002C\r\u0014X-\u0019;f)&lW-\u00138eKb4uN]*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0015\r\r=1QCB\f!\u0011\t\tc!\u0005\n\t\rM\u00111\u0005\u0002\n)&lW-\u00138eKbDqA!@?\u0001\u0004\t\u0019\u0005C\u0004\u0004\u0002y\u0002\r!!\u0016\u0002G\r\u0014X-\u0019;f\u001f\u001a47/\u001a;J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR11QDB\u0012\u0007K\u0001B!!\t\u0004 %!1\u0011EA\u0012\u0005-yeMZ:fi&sG-\u001a=\t\u000f\tux\b1\u0001\u0002D!91\u0011A A\u0002\u0005U\u0013\u0001I4f]\u0016\u0014\u0018\r^3SK6|G/\u001a'pON+w-\\3oi6+G/\u00193bi\u0006$baa\u000b\u00042\rU\u0002C\u0002Bn\u0007[\t\u0019%\u0003\u0003\u00040\t%(\u0001\u0002'jgRDaaa\rA\u0001\u0004!\u0018\u0001B:ju\u0016Dqaa\u000eA\u0001\u0004\tY(\u0001\u0003ua&#\u0017aF7bs\n,\u0017\t\u001d9f]\u0012Le\u000eZ3y\u000b:$(/[3t)\u0019\t\u0019d!\u0010\u0004B!91qH!A\u0002\ru\u0011aC8gMN,G/\u00138eKbDqaa\u0011B\u0001\u0004\u0019y!A\u0005uS6,\u0017J\u001c3fq\u0006a2M]3bi\u0016\u001cuN\u001d:vaR|eMZ:fi&sG-\u001a=GS2,G\u0003BA\u001a\u0007\u0013Bqa!\u0001C\u0001\u0004\t)&\u0001\u0011de\u0016\fG/Z\"peJ,\b\u000f\u001e+j[\u0016Le\u000eZ3y\u001f\u001a47/\u001a;GS2,G\u0003BA\u001a\u0007\u001fBqa!\u0001D\u0001\u0004\t)&\u0001\rde\u0016\fG/Z\"peJ,\b\u000f^3e\u0013:$W\r\u001f$jY\u0016$b!a\r\u0004V\r]\u0003bBA~\t\u0002\u0007\u0011Q \u0005\b\u0007\u0003!\u0005\u0019AA+\u0003y9W\r^%oI\u0016Dh)\u001b7f\rJ|WNU3n_R,7)Y2iK\u0012K'\u000f\u0006\u0004\u0004^\r%51\u0012\u0019\u0005\u0007?\u001ai\u0007\u0005\u0004\u0004b\r\u00154\u0011N\u0007\u0003\u0007GR1![A/\u0013\u0011\u00199ga\u0019\u0003\u0011=\u0003H/[8oC2\u0004Baa\u001b\u0004n1\u0001AaCB8\u000b\u0006\u0005\t\u0011!B\u0001\u0007c\u0012!aX\u0019\u0012\t\rM4\u0011\u0010\t\u0004!\u000eU\u0014bAB<#\n9aj\u001c;iS:<\u0007\u0003BB>\u0007\u000bk!a! \u000b\t\r}4\u0011Q\u0001\u0005M&dWM\u0003\u0003\u0004\u0004\u0006u\u0013a\u00018j_&!1qQB?\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005mQ\t1\u0001\u0002 !91QR#A\u0002\r=\u0015AB:vM\u001aL\u0007\u0010\u0005\u0003\u0004\u0012\u000eee\u0002BBJ\u0007+\u00032Aa\u0004R\u0013\r\u00199*U\u0001\u0007!J,G-\u001a4\n\t\rm5Q\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\r]\u0015\u000b")
public class RemoteIndexCacheTest {
    private final Logger logger = LoggerFactory.getLogger(RemoteIndexCacheTest.class);
    private final MockTime time = new MockTime();
    private final int brokerId;
    private final long baseOffset = (long)Integer.MAX_VALUE + 101337L;
    private final long lastOffset = this.baseOffset() + 30L;
    private final int segmentSize;
    private final RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
    private RemoteIndexCache cache;
    private RemoteLogSegmentMetadata rlsMetadata;
    private File logDir;
    private File tpDir;
    private TopicIdPartition idPartition;

    private Logger logger() {
        return this.logger;
    }

    private MockTime time() {
        return this.time;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private long baseOffset() {
        return this.baseOffset;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private int segmentSize() {
        return this.segmentSize;
    }

    private RemoteStorageManager rsm() {
        return this.rsm;
    }

    private RemoteIndexCache cache() {
        return this.cache;
    }

    private void cache_$eq(RemoteIndexCache x$1) {
        this.cache = x$1;
    }

    private RemoteLogSegmentMetadata rlsMetadata() {
        return this.rlsMetadata;
    }

    private void rlsMetadata_$eq(RemoteLogSegmentMetadata x$1) {
        this.rlsMetadata = x$1;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private File tpDir() {
        return this.tpDir;
    }

    private void tpDir_$eq(File x$1) {
        this.tpDir = x$1;
    }

    private TopicIdPartition idPartition() {
        return this.idPartition;
    }

    private void idPartition_$eq(TopicIdPartition x$1) {
        this.idPartition = x$1;
    }

    @BeforeEach
    public void setup() {
        this.idPartition_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0)));
        this.logDir_$eq(TestUtils.tempDirectory((String)new StringBuilder(6).append("kafka-").append(this.getClass().getSimpleName()).toString()));
        this.tpDir_$eq(new File(this.logDir(), this.idPartition().toString()));
        Files.createDirectory(this.tpDir().toPath(), new FileAttribute[0]);
        RemoteLogSegmentId remoteLogSegmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
        this.rlsMetadata_$eq(new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L))));
        this.cache_$eq(new RemoteIndexCache(this.rsm(), this.tpDir().toString()));
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
    }

    @AfterEach
    public void cleanup() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        try {
            Utils.delete((File)this.logDir());
        }
        catch (IOException iOException) {}
        TestUtils$.MODULE$.assertNoNonDaemonThreads("remote-log-index-cleaner");
    }

    @Test
    public void testIndexFileNameAndLocationOnDisk() {
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(46).append("offsetIndex=").append(offsetIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(43).append("txnIndex=").append(txnIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(44).append("timeIndex=").append(timeIndexFile).append(" is created under incorrect parent").toString());
    }

    @Test
    public void testFetchIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        OffsetPosition offsetPosition1 = offsetIndex.entry(1);
        int resultPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition1.offset);
        Assertions.assertEquals((int)offsetPosition1.position, (int)resultPosition);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        OffsetPosition offsetPosition2 = offsetIndex.entry(2);
        int resultPosition2 = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition2.offset);
        Assertions.assertEquals((int)offsetPosition2.position, (int)resultPosition2);
        Assertions.assertNotNull((Object)this.cache().getIndexEntry(this.rlsMetadata()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rsm()});
    }

    @Test
    public void testFetchIndexForMissingTransactionIndex() {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                throw new RemoteResourceNotFoundException("txn index not found");
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)entry.txnIndex().file().exists());
        Assertions.assertEquals((long)0L, (long)entry.txnIndex().file().length());
    }

    @Test
    public void testPositionForNonExistingIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        int lastOffsetPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetIndex.lastOffset());
        long greaterOffsetThanLastOffset = offsetIndex.lastOffset() + 1L;
        Assertions.assertEquals((int)lastOffsetPosition, (int)this.cache().lookupOffset(this.rlsMetadata(), greaterOffsetThanLastOffset));
        OffsetPosition nonExistentOffsetPosition = new OffsetPosition(this.baseOffset(), 0);
        long lowerOffsetThanBaseOffset = offsetIndex.baseOffset() - 1L;
        Assertions.assertEquals((int)nonExistentOffsetPosition.position, (int)this.cache().lookupOffset(this.rlsMetadata(), lowerOffsetThanBaseOffset));
    }

    @Test
    public void testCacheEntryExpiry() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        this.assertAtLeastOnePresent(this.cache(), (Seq<Uuid>)Predef$.MODULE$.wrapRefArray((Object[])new Uuid[]{((RemoteLogSegmentMetadata)metadataList.apply(1)).remoteLogSegmentId().id(), ((RemoteLogSegmentMetadata)metadataList.head()).remoteLogSegmentId().id()}));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        Option missingEntryOpt = metadataList.find((Function1 & Serializable & scala.Serializable)segmentMetadata -> BoxesRunTime.boxToBoolean((boolean)RemoteIndexCacheTest.$anonfun$testCacheEntryExpiry$1(this, segmentMetadata)));
        Assertions.assertFalse((boolean)missingEntryOpt.isEmpty());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)missingEntryOpt.get());
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(4, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testGetIndexAfterCacheClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
    }

    @Test
    public void testCloseIsIdempotent() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheEntryIsDeletedOnRemoval() {
        Uuid internalIndexKey = this.rlsMetadata().remoteLogSegmentId().id();
        RemoteIndexCache.Entry cacheEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        this.cache().internalCache().put((Object)internalIndexKey, (Object)cacheEntry);
        Assertions.assertEquals((int)0, (int)this.cache().expiredIndexes().size(), (String)"expiredIndex queue should be zero at start of test");
        this.cache().remove(internalIndexKey);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCacheEntryIsDeletedOnRemoval$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCacheEntryIsDeletedOnRemoval$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry, (VerificationMode)Mockito.times((int)2))).markForCleanup();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry)).cleanup();
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.timeIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.offsetIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((TransactionIndex)Mockito.verify((Object)cacheEntry.txnIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)new StringBuilder(51).append("Offset index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)new StringBuilder(48).append("Txn index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)new StringBuilder(49).append("Time index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".deleted").isPresent(), (String)new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append(this.tpDir().toPath()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanerThreadShutdown() {
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().isEmpty());
        TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        spyEntry.cleanup();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("kaboom! I am expected exception in unit test.")});
        Uuid key = Uuid.randomUuid();
        this.cache().internalCache().put((Object)key, (Object)spyEntry);
        this.cache().internalCache().invalidate((Object)key);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCleanerThreadShutdown$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Thread.sleep(100L);
        Set<Thread> threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertEquals((int)1, (int)threads.size(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((TraversableOnce)threads.map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        this.cache().close();
        threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertTrue((boolean)threads.isEmpty(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((TraversableOnce)threads.map((Function1 & Serializable & scala.Serializable)t -> t.getName(), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        Assertions.assertFalse((boolean)this.cache().cleanerThread().isRunning(), (String)"Unexpected thread state=running. Check error logs.");
    }

    @Test
    public void testClose() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex())).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        Assertions.assertTrue((boolean)this.cache().cleanerThread().isShutdownComplete());
    }

    @Test
    public void testConcurrentReadWriteAccessForCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        CountDownLatch latchForCacheHit = new CountDownLatch(1);
        CountDownLatch latchForCacheMiss = new CountDownLatch(1);
        Runnable readerCacheHit = () -> {
            this.logger().debug(new StringBuilder(38).append("Waiting for signal to begin read from ").append(Thread.currentThread()).toString());
            latchForCacheHit.await();
            Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
            this.logger().debug(new StringBuilder(36).append("Signaling CacheMiss to unblock from ").append(Thread.currentThread()).toString());
            latchForCacheMiss.countDown();
        };
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(x$2 -> {
            RemoteIndexCacheTest.$anonfun$testConcurrentReadWriteAccessForCache$2(this, latchForCacheHit, latchForCacheMiss, x$2);
            return BoxedUnit.UNIT;
        });
        Runnable readerCacheMiss = () -> Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.submit(readerCacheMiss);
            executor.submit(readerCacheHit);
            Assertions.assertTrue((boolean)latchForCacheMiss.await(30L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testReloadCacheAfterClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        RemoteIndexCache reloadedCache = new RemoteIndexCache(2, this.rsm(), this.tpDir().toString());
        Assertions.assertEquals((int)2, (int)reloadedCache.internalCache().asMap().size());
        reloadedCache.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.rsm()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRemoveItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        this.cache().remove(segmentId.id());
        Assertions.assertFalse((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testRemoveItem$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRemoveNonExistentItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        this.cache().remove(Uuid.randomUuid());
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
    }

    @Test
    public void testRemoveMultipleItems() {
        HashMap uuidAndEntryList = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            RemoteLogSegmentId segmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
            Uuid segmentUuid = segmentId.id();
            RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
            uuidAndEntryList.put(segmentUuid, spyEntry);
            this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
            Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
            Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        });
        this.cache().removeAll(uuidAndEntryList.keySet());
        uuidAndEntryList.values().forEach(entry -> {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!entry.isMarkedForCleanup()) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testRemoveMultipleItems$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testCorruptCacheIndexFileExistsButNotInCache(RemoteStorageManager.IndexType indexType) {
        this.createCorruptedIndexFile(indexType, this.cache().cacheDir());
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(46).append("offsetIndex=").append(offsetIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(43).append("txnIndex=").append(txnIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(44).append("timeIndex=").append(timeIndexFile).append(" is created under incorrect parent").toString());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testConcurrentRemoveReadForCache() {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition()), this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        RemoteIndexCache.Entry spyEntry = (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
        this.cache().internalCache().put((Object)rlsMetadata.remoteLogSegmentId().id(), (Object)spyEntry);
        this.assertCacheSize(1);
        ObjectRef entry = ObjectRef.create(null);
        CountDownLatch latchForCacheRead = new CountDownLatch(1);
        CountDownLatch latchForCacheRemove = new CountDownLatch(1);
        CountDownLatch latchForTestWait = new CountDownLatch(1);
        ((RemoteIndexCache.Entry)Mockito.doAnswer(arg_0 -> RemoteIndexCacheTest.$anonfun$testConcurrentRemoveReadForCache$1(IntRef.create((int)0), latchForCacheRead, latchForCacheRemove, latchForTestWait, arg_0)).when((Object)spyEntry)).markForCleanup();
        Runnable removeCache = () -> this.cache().remove(rlsMetadata.remoteLogSegmentId().id());
        Runnable readCache = () -> {
            latchForCacheRead.await();
            entry$2.elem = this.cache().getIndexEntry(rlsMetadata);
            latchForCacheRemove.countDown();
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<?> removeCacheFuture = executor.submit(removeCache);
            Future<?> readCacheFuture = executor.submit(readCache);
            removeCacheFuture.get();
            readCacheFuture.get();
            latchForTestWait.await();
            if (this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent()) {
                this.assertCacheSize(1);
            } else {
                this.assertCacheSize(0);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMultipleIndexEntriesExecutionInCorruptException() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptTimeIndexOffsetFile(this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Files.walk(this.tpDir().toPath(), 1, new FileVisitOption[0]).filter(x$3 -> Files.isRegularFile(x$3, new LinkOption[0])).forEach(path -> Files.deleteIfExists(path));
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIndexFileAlreadyExistOnDiskButNotInCache() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        String tempSuffix = ".tmptest";
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        RemoteIndexCacheTest.renameRemoteCacheIndexFileFromDisk$1(tempSuffix, remoteIndexCacheDir, tempSuffix);
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testRSMReturnCorruptedIndexFile(RemoteStorageManager.IndexType testIndexType) {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptedIndexFile(testIndexType, this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentCacheDeletedFileExists() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".index", remoteIndexCacheDir).isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".txnindex", remoteIndexCacheDir).isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Assertions.assertTrue((boolean)RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".timeindex", remoteIndexCacheDir).isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Assertions.assertTrue((boolean)RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".deleted", remoteIndexCacheDir).isPresent(), (String)new StringBuilder(55).append("Deleted Offset index file should be present on disk at ").append(remoteIndexCacheDir.toPath()).toString());
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$7(remoteIndexCacheDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$8(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$9(remoteIndexCacheDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$10(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$11(remoteIndexCacheDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$12(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$13(remoteIndexCacheDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$14(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private RemoteIndexCache.Entry generateSpyCacheEntry(RemoteLogSegmentId remoteLogSegmentId) {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        return (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
    }

    private RemoteLogSegmentId generateSpyCacheEntry$default$1() {
        return RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
    }

    private void assertAtLeastOnePresent(RemoteIndexCache cache, Seq<Uuid> uuids) {
        Object object = new Object();
        try {
            uuids.foreach((Function1 & Serializable & scala.Serializable)uuid -> {
                RemoteIndexCacheTest.$anonfun$assertAtLeastOnePresent$1(cache, object, uuid);
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"all uuids are not present in cache");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertCacheSize(int expectedSize) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$assertCacheSize$1(this, expectedSize)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$assertCacheSize$2(expectedSize));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyFetchIndexInvocation(int count, Seq<RemoteStorageManager.IndexType> indexTypes) {
        indexTypes.foreach((Function1 & Serializable & scala.Serializable)indexType -> ((RemoteStorageManager)Mockito.verify((Object)this.rsm(), (VerificationMode)Mockito.times((int)count))).fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.eq((Object)indexType)));
    }

    private Seq<RemoteStorageManager.IndexType> verifyFetchIndexInvocation$default$2() {
        return new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$)));
    }

    private TransactionIndex createTxIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        return new TransactionIndex(metadata.startOffset(), txnIdxFile);
    }

    private TransactionIndex createCorruptTxnIndexForSegmentMetadata(File dir, RemoteLogSegmentMetadata metadata) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        TransactionIndex txnIndex = new TransactionIndex(metadata.startOffset(), txnIdxFile);
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            txnIndex.append(x$1);
            return BoxedUnit.UNIT;
        });
        txnIndex.close();
        return new TransactionIndex(100L, txnIdxFile);
    }

    private TimeIndex createTimeIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new TimeIndex(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 12);
    }

    private OffsetIndex createOffsetIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new OffsetIndex(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 8);
    }

    private List<RemoteLogSegmentMetadata> generateRemoteLogSegmentMetadata(int size, TopicIdPartition tpId) {
        Buffer metadataList = (Buffer)Buffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> metadataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoteLogSegmentMetadata[]{new RemoteLogSegmentMetadata(new RemoteLogSegmentId(tpId, Uuid.randomUuid()), this.baseOffset() * (long)i, this.baseOffset() * (long)i + 10L, this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)))})));
        return metadataList.toList();
    }

    private void maybeAppendIndexEntries(OffsetIndex offsetIndex, TimeIndex timeIndex) {
        if (!offsetIndex.isFull()) {
            long curTime = this.time().milliseconds();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetIndex.maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                long offset = offsetIndex.baseOffset() + (long)i;
                offsetIndex.append(offset, i);
                timeIndex.maybeAppend(curTime + (long)i, offset, true);
            });
            offsetIndex.flush();
            timeIndex.flush();
            return;
        }
    }

    private void createCorruptOffsetIndexFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world");
        pw.close();
    }

    private void createCorruptTimeIndexOffsetFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world1");
        pw.close();
    }

    private void createCorruptedIndexFile(RemoteStorageManager.IndexType indexType, File dir) {
        block9: {
            block8: {
                RemoteStorageManager.IndexType indexType2;
                RemoteStorageManager.IndexType indexType3;
                block7: {
                    RemoteStorageManager.IndexType indexType4 = indexType;
                    RemoteStorageManager.IndexType indexType5 = RemoteStorageManager.IndexType.OFFSET;
                    if (!(indexType4 != null ? !indexType4.equals(indexType5) : indexType5 != null)) {
                        this.createCorruptOffsetIndexFile(dir);
                        return;
                    }
                    RemoteStorageManager.IndexType indexType6 = indexType;
                    RemoteStorageManager.IndexType indexType7 = RemoteStorageManager.IndexType.TIMESTAMP;
                    if (!(indexType6 != null ? !indexType6.equals(indexType7) : indexType7 != null)) {
                        this.createCorruptTimeIndexOffsetFile(dir);
                        return;
                    }
                    indexType3 = indexType;
                    indexType2 = RemoteStorageManager.IndexType.TRANSACTION;
                    if (indexType3 != null) break block7;
                    if (indexType2 != null) {
                        return;
                    }
                    break block8;
                }
                if (!indexType3.equals(indexType2)) break block9;
            }
            this.createCorruptTxnIndexForSegmentMetadata(dir, this.rlsMetadata());
            return;
        }
    }

    private Optional<? extends Path> getIndexFileFromRemoteCacheDir(RemoteIndexCache cache, String suffix) {
        try {
            return Files.walk(cache.cacheDir().toPath(), new FileVisitOption[0]).filter(x$6 -> Files.isRegularFile(x$6, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFileException ? true : throwable instanceof UncheckedIOException) {
                return Optional.empty();
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryExpiry$1(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata segmentMetadata) {
        Uuid segmentId = segmentMetadata.remoteLogSegmentId().id();
        return !$this.cache().internalCache().asMap().containsKey(segmentId);
    }

    private final Optional getIndexFileFromDisk$1(String suffix) {
        return Files.walk(this.tpDir().toPath(), new FileVisitOption[0]).filter(x$1 -> Files.isRegularFile(x$1, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$6() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testCleanerThreadShutdown$2() {
        return "Failed while waiting for clean up to start";
    }

    public static final /* synthetic */ void $anonfun$testConcurrentReadWriteAccessForCache$2(RemoteIndexCacheTest $this, CountDownLatch latchForCacheHit$1, CountDownLatch latchForCacheMiss$1, InvocationOnMock x$2) {
        $this.logger().debug(new StringBuilder(38).append("Signaling CacheHit to begin read from ").append(Thread.currentThread()).toString());
        latchForCacheHit$1.countDown();
        $this.logger().debug(new StringBuilder(46).append("Waiting for signal to complete rsm fetch from ").append(Thread.currentThread()).toString());
        latchForCacheMiss$1.await();
    }

    public static final /* synthetic */ String $anonfun$testRemoveItem$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testRemoveMultipleItems$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ Object $anonfun$testConcurrentRemoveReadForCache$1(IntRef markForCleanupCallCount$1, CountDownLatch latchForCacheRead$1, CountDownLatch latchForCacheRemove$1, CountDownLatch latchForTestWait$1, InvocationOnMock invocation) {
        ++markForCleanupCallCount$1.elem;
        if (markForCleanupCallCount$1.elem == 1) {
            latchForCacheRead$1.countDown();
            latchForCacheRemove$1.await();
            invocation.callRealMethod();
            latchForTestWait$1.countDown();
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final void renameRemoteCacheIndexFileFromDisk$1(String suffix, File remoteIndexCacheDir$1, String tempSuffix$1) {
        Files.walk(remoteIndexCacheDir$1.toPath(), new FileVisitOption[0]).filter(x$4 -> Files.isRegularFile(x$4, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).forEach(f -> Utils.atomicMoveWithFallback((Path)f, (Path)f.resolveSibling(new StringOps(Predef$.MODULE$.augmentString(((Object)f.getFileName()).toString())).stripSuffix(tempSuffix$1))));
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$5() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$7() {
        return "Failed to cleanup cache entry after invalidation";
    }

    private static final Optional getRemoteCacheIndexFileFromDisk$1(String suffix, File remoteIndexCacheDir$2) {
        return Files.walk(remoteIndexCacheDir$2.toPath(), new FileVisitOption[0]).filter(x$5 -> Files.isRegularFile(x$5, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$6() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$7(File remoteIndexCacheDir$2) {
        return !RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".index", remoteIndexCacheDir$2).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$8(File remoteIndexCacheDir$2) {
        return new StringBuilder(51).append("Offset index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$9(File remoteIndexCacheDir$2) {
        return !RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".txnindex", remoteIndexCacheDir$2).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$10(File remoteIndexCacheDir$2) {
        return new StringBuilder(48).append("Txn index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$11(File remoteIndexCacheDir$2) {
        return !RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".timeindex", remoteIndexCacheDir$2).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$12(File remoteIndexCacheDir$2) {
        return new StringBuilder(49).append("Time index file should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$13(File remoteIndexCacheDir$2) {
        return !RemoteIndexCacheTest.getRemoteCacheIndexFileFromDisk$1(".deleted", remoteIndexCacheDir$2).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$14(File remoteIndexCacheDir$2) {
        return new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append(remoteIndexCacheDir$2.toPath()).toString();
    }

    public static final /* synthetic */ void $anonfun$assertAtLeastOnePresent$1(RemoteIndexCache cache$1, Object nonLocalReturnKey1$1, Uuid uuid) {
        if (cache$1.internalCache().asMap().containsKey(uuid)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertCacheSize$1(RemoteIndexCacheTest $this, int expectedSize$1) {
        return $this.cache().internalCache().asMap().size() == expectedSize$1;
    }

    public static final /* synthetic */ String $anonfun$assertCacheSize$2(int expectedSize$1) {
        return new StringBuilder(41).append("cache did not adhere to expected size of ").append(expectedSize$1).toString();
    }

    public RemoteIndexCacheTest() {
        this.brokerId = 1;
        this.segmentSize = 1024;
    }
}

