/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import scala.Function1;
import scala.Predef;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!\u0002\u0006\f\u0003\u0003\u0001\u0002\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\t\u000by\u0001A\u0011A\u0010\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000b}\u0002A\u0011\u0001!\t\u000b9\u0003A\u0011A(\t\u000bE\u0003A\u0011\u0001*\t\u000f\u0001\u0004\u0011\u0013!C\u0001C\"9A\u000eAI\u0001\n\u0003i\u0007bB8\u0001#\u0003%\t\u0001\u001d\u0002\u001f\u0003\n\u001cHO]1di\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u00033qi\u0011A\u0007\u0006\u000375\tA\u0001^3ti&\u0011QD\u0007\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"\u0001\t\u0012\u0011\u0005\u0005\u0002Q\"A\u0006\t\u000b]\u0011\u0001\u0019\u0001\r\u0002-M,g\u000eZ!qSZ+'o]5p]N\u0014V-];fgR$2!\n\u001a8!\t1\u0003'D\u0001(\u0015\tA\u0013&\u0001\u0005sKF,Xm\u001d;t\u0015\tQ3&\u0001\u0004d_6lwN\u001c\u0006\u0003\u001d1R!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011g\n\u0002\u0014\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a\u0005\u0006g\r\u0001\r\u0001N\u0001\be\u0016\fX/Z:u!\t1S'\u0003\u00027O\t\u0011\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u0015A4\u00011\u0001:\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\tQT(D\u0001<\u0015\ta\u0014&A\u0004oKR<xN]6\n\u0005yZ$\u0001\u0004'jgR,g.\u001a:OC6,\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\tE\t\u0005\u0002\u0013\u0005&\u00111i\u0005\u0002\u0005+:LG\u000fC\u0003F\t\u0001\u0007a)\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005J\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001e]3oIVs7/\u001e9q_J$X\rZ!qSZ+'o]5p]J+\u0017/^3tiR\u0011Q\u0005\u0015\u0005\u0006g\u0015\u0001\r\u0001N\u0001\u001cm\u0006d\u0017\u000eZ1uK\u0006\u0003\u0018NV3sg&|gn\u001d*fgB|gn]3\u0015\u000b\u0005\u001bVKV.\t\u000bQ3\u0001\u0019A\u0013\u0002'\u0005\u0004\u0018NV3sg&|gn\u001d*fgB|gn]3\t\u000fa2\u0001\u0013!a\u0001s!9qK\u0002I\u0001\u0002\u0004A\u0016!G3oC\ndW-\u00168ti\u0006\u0014G.\u001a'bgR4VM]:j_:\u0004\"AE-\n\u0005i\u001b\"a\u0002\"p_2,\u0017M\u001c\u0005\b9\u001a\u0001\n\u00111\u0001^\u0003)\t\u0007/\u001b,feNLwN\u001c\t\u0003%yK!aX\n\u0003\u000bMCwN\u001d;\u0002KY\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u0012T#\u00012+\u0005e\u001a7&\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!C;oG\",7m[3e\u0015\tI7#\u0001\u0006b]:|G/\u0019;j_:L!a\u001b4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0013wC2LG-\u0019;f\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\taN\u000b\u0002YG\u0006)c/\u00197jI\u0006$X-\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016$C-\u001a4bk2$H\u0005N\u000b\u0002c*\u0012Ql\u0019\u0015\u0005\u0001Mlh\u0010\u0005\u0002uw6\tQO\u0003\u0002wo\u0006\u0019\u0011\r]5\u000b\u0005aL\u0018a\u00026va&$XM\u001d\u0006\u0003u:\nQA[;oSRL!\u0001`;\u0003\u0007Q\u000bw-A\u0003wC2,X-I\u0001\u0000\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        SocketServer socket = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerSocketServers()).asScala()).head() : (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head();
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socket, listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public void brokerPropertyOverrides(Properties properties) {
        if (!this.cluster.isKRaftTest()) {
            String controlPlaneListenerName = "CONTROL_PLANE";
            SecurityProtocol securityProtocol = this.cluster.config().securityProtocol();
            properties.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), controlPlaneListenerName);
            properties.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(3).append(controlPlaneListenerName).append(":").append(securityProtocol).append(",").append(securityProtocol).append(":").append(securityProtocol).toString());
            properties.setProperty("listeners", new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            properties.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            return;
        }
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, IntegrationTestUtils$.MODULE$.nextRequestHeader$default$3(), IntegrationTestUtils$.MODULE$.nextRequestHeader$default$4());
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            byte[] serializedBytes = Utils.toArray((ByteBuffer)RequestUtils.serialize((Message)overrideHeader.data(), (short)overrideHeader.headerVersion(), (Message)request.data(), (short)request.version()));
            IntegrationTestUtils$.MODULE$.sendRequest(socket, serializedBytes);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse, ListenerName listenerName, boolean enableUnstableLastVersion, short apiVersion) {
        if (this.cluster.isKRaftTest() && apiVersion >= 3) {
            Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().finalizedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.latest().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").minVersionLevel());
            Assertions.assertEquals((short)MetadataVersion.latest().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").maxVersionLevel());
            Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().supportedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").minVersion());
            Assertions.assertEquals((short)MetadataVersion.latest().featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").maxVersion());
        }
        ApiVersionsResponseData.ApiVersionCollection expectedApis = !this.cluster.isKRaftTest() ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER), (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER), (boolean)enableUnstableLastVersion) : ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (RecordVersion)RecordVersion.current(), (Map)NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.controllerApis()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1), Set$.MODULE$.canBuildFrom())).asJava())).allSupportedApiVersions(), (boolean)enableUnstableLastVersion));
        Assertions.assertEquals((int)expectedApis.size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = !this.cluster.isKRaftTest() ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER, (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER, (boolean)enableUnstableLastVersion) : TestUtils.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)expectedApis));
        ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$3(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public ListenerName validateApiVersionsResponse$default$2() {
        return this.cluster.clientListener();
    }

    public boolean validateApiVersionsResponse$default$3() {
        return false;
    }

    public short validateApiVersionsResponse$default$4() {
        return ApiKeys.API_VERSIONS.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$validateApiVersionsResponse$2(ApiVersionsResponseData.ApiVersion check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$3(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(expectedApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

