/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Predef;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005BeAQA\r\u0001\u0005\u0002MBQ\u0001\u0017\u0001\u0005\u0002eCQA\u0018\u0001\u0005\u0002}CQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002-DQ\u0001\u001d\u0001\u0005\nED\u0011\"!\u0006\u0001#\u0003%I!a\u0006\u0003O\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aC\u0005\u0003)-\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002\u000bM,G/\u00169\u0015\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0002A\u0002\t\n\u0001\u0002^3ti&sgm\u001c\t\u0003G1j\u0011\u0001\n\u0006\u0003K\u0019\n1!\u00199j\u0015\t9\u0003&A\u0004kkBLG/\u001a:\u000b\u0005%R\u0013!\u00026v]&$(\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.I\tAA+Z:u\u0013:4w\u000e\u000b\u0002\u0003_A\u00111\u0005M\u0005\u0003c\u0011\u0012!BQ3g_J,W)Y2i\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u001d>$\b.\u001b8h)\tQB\u0007C\u00036\u0007\u0001\u0007a'\u0001\u0004rk>\u0014X/\u001c\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005ebR\"\u0001\u001e\u000b\u0005mz\u0011A\u0002\u001fs_>$h(\u0003\u0002>9\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\tiD\u0004\u000b\u0003\u0004\u0005*[\u0005CA\"I\u001b\u0005!%BA#G\u0003!\u0001(o\u001c<jI\u0016\u0014(BA$'\u0003\u0019\u0001\u0018M]1ng&\u0011\u0011\n\u0012\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u00051s\u0015%A'\u0002\u000b-\u0014\u0018M\u001a;\"\u0003=\u000b!A_6)\t\r\tVK\u0016\t\u0003%Nk\u0011AR\u0005\u0003)\u001a\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003]\u000b\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003Q!Xm\u001d;EKN\u001c'/\u001b2f/&$\bNT;mYR\u0011!D\u0017\u0005\u0006k\u0011\u0001\rA\u000e\u0015\u0005\t\tSE\f\f\u0002M\u001d\"\"A!U+W\u0003e!Xm\u001d;EKN\u001c'/\u001b2f\u001d>$8i\u001c8ue>dG.\u001a:\u0015\u0003iA#!B1\u0011\u0005\r\u0012\u0017BA2%\u0005\u0011!Vm\u001d;\u00023Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3TC6,Wk]3s)^L7-\u001a\u000b\u00035\u0019DQ!\u000e\u0004A\u0002YBCA\u0002\"KQ2\u0012AJ\u0014\u0015\u0005\rE+f+A\buKN$XK\\6o_^tWk]3s)\tQB\u000eC\u00036\u000f\u0001\u0007a\u0007\u000b\u0003\b\u0005*sGF\u0001'OQ\u00119\u0011+\u0016,\u0002OM,g\u000e\u001a#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u000b\u0005ev\f)\u0001\u0005\u0002tw6\tAO\u0003\u0002vm\u0006A!/Z9vKN$8O\u0003\u0002xq\u000611m\\7n_:T!AD=\u000b\u0005iT\u0013AB1qC\u000eDW-\u0003\u0002}i\n!C)Z:de&\u0014W-V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z:q_:\u001cX\rC\u0003\u007f\u0011\u0001\u0007q0A\u0004sKF,Xm\u001d;\u0011\u0007M\f\t!C\u0002\u0002\u0004Q\u00141\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fC\u0005\u0002\b!\u0001\n\u00111\u0001\u0002\n\u0005a1o\\2lKR\u001cVM\u001d<feB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u00105\tqA\\3uo>\u00148.\u0003\u0003\u0002\u0014\u00055!\u0001D*pG.,GoU3sm\u0016\u0014\u0018!M:f]\u0012$Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0003\u00033QC!!\u0003\u0002\u001c-\u0012\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0002(q\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY#!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DescribeUserScramCredentialsRequestTest
extends BaseRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
        } else {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeNothing(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeWithNull(String quorum) {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(null)).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        short error = response.data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Expected no error when describing everything and there are no credentials");
        Assertions.assertEquals((int)0, (int)response.data().results().size(), (String)"Expected no credentials when describing everything and there are no credentials");
    }

    @Test
    public void testDescribeNotController() {
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build();
        short error = this.sendDescribeUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().errorCode();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)error, (String)"Did not expect controller error when routed to non-controller");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeSameUserTwice(String quorum) {
        String user = "user1";
        DescribeUserScramCredentialsRequestData.UserName userName = new DescribeUserScramCredentialsRequestData.UserName().setName(user);
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)userName, (List)new .colon.colon((Object)userName, (List)Nil$.MODULE$))).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.DUPLICATE_RESOURCE.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(user).toString());
        Assertions.assertEquals((Object)new StringBuilder(79).append("Cannot describe SCRAM credentials for the same user twice in a single request: ").append(user).toString(), (Object)result.errorMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testUnknownUser(String quorum) {
        String unknownUser = "unknownUser";
        DescribeUserScramCredentialsRequest request = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new DescribeUserScramCredentialsRequestData.UserName().setName(unknownUser), (List)Nil$.MODULE$)).asJava())).build();
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest(request, this.sendDescribeUserScramCredentialsRequest$default$2());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode(), (String)"Expected no top-level error");
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result = (DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult)response.data().results().get(0);
        Assertions.assertEquals((short)Errors.RESOURCE_NOT_FOUND.code(), (short)result.errorCode(), (String)new StringBuilder(38).append("Expected duplicate resource error for ").append(unknownUser).toString());
        Assertions.assertEquals((Object)new StringBuilder(59).append("Attempt to describe a user credential that does not exist: ").append(unknownUser).toString(), (Object)result.errorMessage());
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }
}

