/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.server.MockBrokerToControllerChannelManager$;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004:\u0001\u0001\u0006I!\f\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013!\u0005B\u0002%\u0001A\u0003%Q\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r9\u0003\u0001\u0015!\u0003L\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007C\u0002\u0001\u000b\u0011B,\t\u000b\t\u0004A\u0011B2\t\u000b\u001d\u0004A\u0011\u00025\t\u000b1\u0004A\u0011\u00025\t\u000b5\u0004A\u0011\u00018\t\u000bu\u0004A\u0011\u00018\t\u000b}\u0004A\u0011\u00018\t\r\u0005\r\u0001\u0001\"\u0001o\u0011\u0019\t9\u0001\u0001C\u0001]\"1\u00111\u0002\u0001\u0005\u00029Dq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u0010\u0001!I!!\u0013\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:UKN$(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005!A/[7f+\u0005i\u0003C\u0001\u00188\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0005q\u0011$B\u0001\u00104\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005az#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r\rd\u0017.\u001a8u+\u0005a\u0004CA\u001fA\u001b\u0005q$BA 3\u0003\u001d\u0019G.[3oiNL!!\u0011 \u0003\u00155{7m[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002-\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ,\u0012!\u0012\t\u0003U\u0019K!aR\u000e\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fqcY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\u0011\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002\u0017B\u0011!\u0006T\u0005\u0003\u001bn\u0011A%T8dW\n\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0014EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\u0012M>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014X#A)\u0011\u0005)\u0012\u0016BA*\u001c\u0005U1uN]<be\u0012LgnZ'b]\u0006<WM]%na2\f!CZ8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3sA\u0005\u0001\u0002O]5oG&\u0004\u0018\r\u001c\"vS2$WM]\u000b\u0002/B\u0011\u0001lX\u0007\u00023*\u0011!lW\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u000b\u0005qk\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005y\u0013\u0014AB2p[6|g.\u0003\u0002a3\naB)\u001a4bk2$8*\u00194lCB\u0013\u0018N\\2ja\u0006d')^5mI\u0016\u0014\u0018!\u00059sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3sA\u0005)2m\u001c8ue>dG.\u001a:Ba&4VM]:j_:\u001cX#\u00013\u0011\u0005u*\u0017B\u00014?\u0005=qu\u000eZ3Ba&4VM]:j_:\u001c\u0018AD2p]R\u0014x\u000e\u001c7fe&sgm\\\u000b\u0002SB\u0011!F[\u0005\u0003Wn\u0011QcQ8oiJ|G\u000e\\3s\u0013:4wN]7bi&|g.A\nf[B$\u0018pQ8oiJ|G\u000e\\3s\u0013:4w.A\u0011uKN$(+Z:q_:\u001cXmQ8se\u0016d\u0017\r^5p]&#W*[:nCR\u001c\u0007\u000eF\u0001p!\t\u0011\u0003/\u0003\u0002rG\t!QK\\5uQ\t\t2\u000f\u0005\u0002uw6\tQO\u0003\u0002wo\u0006\u0019\u0011\r]5\u000b\u0005aL\u0018a\u00026va&$XM\u001d\u0006\u0003uV\nQA[;oSRL!\u0001`;\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]ND#AE:\u0002eQ,7\u000f\u001e$pe^\f'\u000fZ5oORKW.Z8vi^\u000b\u0017\u000e^5oO\u001a{'oQ8oiJ|G\u000e\\3s\t&\u001c8m\u001c<fefD#aE:\u0002?Q,7\u000f\u001e$pe^\f'\u000fZ5oORKW.Z8vi\u00063G/\u001a:SKR\u0014\u0018\u0010\u000b\u0002\u0015g\u00069C/Z:u+:\u001cX\u000f\u001d9peR,GMV3sg&|gN\u0012:p[:+Go^8sW\u000ec\u0017.\u001a8uQ\t)2/\u0001\ruKN$h)Y5mK\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:D#AF:\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0015\r\u0005M\u0011QGA !\u001d\u0011\u0013QCA\r\u0003KI1!a\u0006$\u0005\u0019!V\u000f\u001d7feA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 u\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003G\tiBA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\rq\u0017n\u001c\u0006\u0003\u0003_\tAA[1wC&!\u00111GA\u0015\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003o9\u0002\u0019AA\u001d\u0003\u0011\u0011w\u000eZ=\u0011\t\u0005m\u00111H\u0005\u0005\u0003{\tiBA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001d\t\te\u0006a\u0001\u0003\u0007\nQbY8se\u0016d\u0017\r^5p]&#\u0007c\u0001\u0012\u0002F%\u0019\u0011qI\u0012\u0003\u0007%sG\u000f\u0006\u0005\u0002L\u0005}\u00131MA4!\u0011\ti%!\u0017\u000f\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u001e\u0003\u001dqW\r^<pe.LA!a\u0016\u0002R\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BA.\u0003;\u0012qAU3rk\u0016\u001cHO\u0003\u0003\u0002X\u0005E\u0003bBA11\u0001\u0007\u0011\u0011D\u0001\u000ee\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002&\u0005i!/Z9vKN$()\u001e4gKJDq!!\u001b\u0019\u0001\u0004\tY'A\u0005qe&t7-\u001b9bYB!\u0011QNA:\u001b\t\tyGC\u0002\u0002rm\u000bA!Y;uQ&!\u0011QOA8\u00059Y\u0015MZ6b!JLgnY5qC2\fa\u0003^3ti\u0006cG/\u001a:D_:4\u0017n\u001a*fcV,7\u000f^\u000b\u0003\u0003w\u0002B!a\u0007\u0002~%!\u0011qPA\u000f\u0005M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0001")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockBrokerToControllerChannelManager brokerToController = new MockBrokerToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((BrokerToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockBrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava()));
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)requestHeader2, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }
}

