/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.storage.internals.checkpoint.InMemoryLeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\t\t\u0013J\\'f[>\u0014\u0018\u0010T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG\u000fV3ti*\u0011aaB\u0001\fG\",7m\u001b9pS:$8O\u0003\u0002\t\u0013\u000511/\u001a:wKJT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\u0015\tAc\u001d5pk2$\u0017\t\u001d9f]\u0012tUm^#oiJLH#A\r\u0011\u00059Q\u0012BA\u000e\u0010\u0005\u0011)f.\u001b;)\u0005\ti\u0002C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nqA[;qSR,'O\u0003\u0002%K\u0005)!.\u001e8ji*\ta%A\u0002pe\u001eL!\u0001K\u0010\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cHOU3bI\u0006\u001b()\u001f;f\u0005V4g-\u001a:)\u0005\ri\u0002")
public class InMemoryLeaderEpochCheckpointTest {
    @Test
    public void shouldAppendNewEntry() {
        InMemoryLeaderEpochCheckpoint checkpoint = new InMemoryLeaderEpochCheckpoint();
        List<Object> epochs = Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 1L), new EpochEntry(1, 2L), new EpochEntry(2, 3L)});
        checkpoint.write(epochs);
        Assertions.assertEquals(epochs, (Object)checkpoint.read());
        List<Object> epochs2 = Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 4L), new EpochEntry(4, 5L)});
        checkpoint.write(epochs2);
        Assertions.assertEquals(epochs2, (Object)checkpoint.read());
    }

    @Test
    public void testReadAsByteBuffer() {
        InMemoryLeaderEpochCheckpoint checkpoint = new InMemoryLeaderEpochCheckpoint();
        int expectedEpoch = 0;
        long expectedStartOffset = 1L;
        int expectedVersion = 0;
        List<Object> epochs = Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(expectedEpoch, expectedStartOffset)});
        checkpoint.write(epochs);
        Assertions.assertEquals(epochs, (Object)checkpoint.read());
        ByteBuffer buffer = checkpoint.readAsByteBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer.array()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)Integer.toString(expectedVersion), (Object)bufferedReader.readLine());
        Assertions.assertEquals((Object)Integer.toString(epochs.size()), (Object)bufferedReader.readLine());
        Assertions.assertEquals((Object)new StringBuilder(1).append(expectedEpoch).append(" ").append(expectedStartOffset).toString(), (Object)bufferedReader.readLine());
    }
}

