/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.server.Defaults$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!9q\t\u0001b\u0001\n\u0003A\u0005BB(\u0001A\u0003%\u0011\nC\u0004Q\u0001\t\u0007I\u0011A)\t\rq\u0003\u0001\u0015!\u0003S\u0011\u001di\u0006A1A\u0005\u0002ECaA\u0018\u0001!\u0002\u0013\u0011\u0006bB0\u0001\u0005\u0004%\t!\u0015\u0005\u0007A\u0002\u0001\u000b\u0011\u0002*\t\u000f\u0005\u0004!\u0019!C\u0001#\"1!\r\u0001Q\u0001\nICqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004s\u0001\u0001\u0006I!\u001a\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0011\u001d\t\t\u0001\u0001Q\u0001\nUD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006!Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011AA\n\u0011-\ty\u0002\u0001a\u0001\u0002\u0003\u0006K!a\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u00111\b\u0001\u0005\u0002\u0005\r\u0002bBA\u001f\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u000f\u0002A\u0011AA\u0012\u0011\u001d\t\t\u0006\u0001C\u0001\u0003GAq!!\u0016\u0001\t\u0003\t\u0019\u0003C\u0004\u0002Z\u0001!\t!a\t\t\u000f\u0005u\u0003\u0001\"\u0001\u0002$!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0002bBA3\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t9\b\u0001C\u0001\u0003GAq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAa\u0001\u0011%\u00111\u0019\u0005\b\u0003\u001f\u0004A\u0011BA\u0012\u0005M!U/\u001c9M_\u001e\u001cVmZ7f]R\u001cH+Z:u\u0015\tYC&A\u0003u_>d7OC\u0001.\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u0002:\u00015\t!&\u0001\u0004u[B$\u0015N]\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0003S>T\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002D}\t!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\fg\u0016<W.\u001a8u\u001d\u0006lW-F\u0001J!\tQU*D\u0001L\u0015\ta\u0005)\u0001\u0003mC:<\u0017B\u0001(L\u0005\u0019\u0019FO]5oO\u0006a1/Z4nK:$h*Y7fA\u0005YAn\\4GS2,\u0007+\u0019;i+\u0005\u0011\u0006CA*[\u001d\t!\u0006\f\u0005\u0002Ve5\taK\u0003\u0002X]\u00051AH]8pizJ!!\u0017\u001a\u0002\rA\u0013X\rZ3g\u0013\tq5L\u0003\u0002Ze\u0005aAn\\4GS2,\u0007+\u0019;iA\u0005a1O\\1qg\"|G\u000fU1uQ\u0006i1O\\1qg\"|G\u000fU1uQ\u0002\nQ\"\u001b8eKb4\u0015\u000e\\3QCRD\u0017AD5oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0012i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0017A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002\nA\u0001^5nKV\tQ\r\u0005\u0002ga6\tqM\u0003\u0002iS\u0006!Q\u000f^5m\u0015\tQ7.\u0001\u0004tKJ4XM\u001d\u0006\u0003[1T!!\u001c8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0017aA8sO&\u0011\u0011o\u001a\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!-\u0019;dQ\u0016\u001cX#A;\u0011\u0007Y\\X0D\u0001x\u0015\tA\u00180A\u0004nkR\f'\r\\3\u000b\u0005i\u0014\u0014AC2pY2,7\r^5p]&\u0011Ap\u001e\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002:}&\u0011qP\u000b\u0002\n\u0005\u0006$8\r[%oM>\f\u0001BY1uG\",7\u000fI\u0001\u0004Y><WCAA\u0004!\u0011\tI!!\u0004\u000e\u0005\u0005-!bAA\u0002Y%!\u0011qBA\u0006\u0005))f.\u001b4jK\u0012dunZ\u0001\bY><w\fJ3r)\u0011\t)\"a\u0007\u0011\u0007E\n9\"C\u0002\u0002\u001aI\u0012A!\u00168ji\"I\u0011QD\u000b\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0014\u0001\u00027pO\u0002\nQa]3u+B$\"!!\u0006)\u0007]\t9\u0003\u0005\u0003\u0002*\u0005]RBAA\u0016\u0015\u0011\ti#a\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00022\u0005M\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003kq\u0017!\u00026v]&$\u0018\u0002BA\u001d\u0003W\u0011!BQ3g_J,W)Y2i\u0003A\tG\rZ*j[BdWMU3d_J$7/\u0001\u0005uK\u0006\u0014Hi\\<oQ\rI\u0012\u0011\t\t\u0005\u0003S\t\u0019%\u0003\u0003\u0002F\u0005-\"!C!gi\u0016\u0014X)Y2i\u0003\u0001\"Xm\u001d;CCR\u001c\u0007.\u00118e%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u001fV$\b/\u001e;)\u0007i\tY\u0005\u0005\u0003\u0002*\u00055\u0013\u0002BA(\u0003W\u0011A\u0001V3ti\u0006\u0001B/Z:u!JLg\u000e\u001e#bi\u0006dun\u001a\u0015\u00047\u0005-\u0013a\u0006;fgR$U/\u001c9J]\u0012,\u00070T5t[\u0006$8\r[3tQ\ra\u00121J\u0001\u0018i\u0016\u001cH\u000fR;naRKW.Z%oI\u0016DXI\u001d:peND3!HA&\u0003]!Xm\u001d;Ek6\u0004X*\u001a;bI\u0006$\u0018MU3d_J$7\u000fK\u0002\u001f\u0003\u0017\n\u0001\u0004^3ti\u0012+X\u000e]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8uQ\ry\u00121J\u0001\u0013i\u0016\u001cH\u000fR;na\u0016k\u0007\u000f^=J]\u0012,\u0007\u0010K\u0002!\u0003\u0017\n!C];o\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR\u0019!+!\u001c\t\u000f\u0005=\u0014\u00051\u0001\u0002r\u0005!\u0011M]4t!\u0011\t\u00141\u000f*\n\u0007\u0005U$GA\u0003BeJ\f\u00170\u0001\u0010uKN$\bK]5oi\u0012\u000bG/\u0019'pOB\u000b'\u000f^5bY\n\u000bGo\u00195fg\"\u001a!%a\u0013\u0002#I,\u0017\r\u001a\"bi\u000eDW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002\u0000\u0005\u0015\u0005\u0003B\u0019\u0002\u0002JK1!a!3\u0005\u0019y\u0005\u000f^5p]\"9\u0011qQ\u0012A\u0002\u0005%\u0015!\u00027j]\u0016\u001c\b#BAF\u0003\u001f\u0013VBAAG\u0015\tA\u0007)\u0003\u0003\u0002\u0012\u00065%\u0001\u0004'jgRLE/\u001a:bi>\u0014\u0018a\u0006:fC\u0012\u0004\u0016M\u001d;jC2\u0014\u0015\r^2iKN\u0014\u0015\u0010^3t)\u0019\t9*!(\u0002 B\u0019\u0011'!'\n\u0007\u0005m%GA\u0002J]RDq!a\"%\u0001\u0004\tI\tC\u0004\u0002\"\u0012\u0002\r!a&\u0002\u000b1LW.\u001b;\u0002\u0019\r|WO\u001c;CCR\u001c\u0007.Z:\u0015\t\u0005]\u0015q\u0015\u0005\b\u0003\u000f+\u0003\u0019AAE\u0003A\u0011X-\u00193CCR\u001c\u0007NU3d_J$7\u000f\u0006\u0003\u0002.\u0006}\u0006#BAX\u0003s\u0013f\u0002BAY\u0003ks1!VAZ\u0013\u0005\u0019\u0014bAA\\e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA^\u0003{\u00131aU3r\u0015\r\t9L\r\u0005\b\u0003\u000f3\u0003\u0019AAE\u0003M\u0001\u0018M]:f\u001b\u0016$\u0018\rZ1uC\u001aKW\r\u001c3t)\u0011\t)-a3\u0011\u000bM\u000b9M\u0015*\n\u0007\u0005%7LA\u0002NCBDa!!4(\u0001\u0004\u0011\u0016\u0001\u00027j]\u0016\f1$Y:tKJ$H)^7q\u0019><'+Z2pe\u0012lU\r^1eCR\f\u0007")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1());
        int x$8 = 300000;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        ConcurrentMap x$15 = UnifiedLog$.MODULE$.apply$default$15();
        boolean x$16 = UnifiedLog$.MODULE$.apply$default$16();
        LogOffsetsListener x$17 = UnifiedLog$.MODULE$.apply$default$17();
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13, x$15, x$16, x$17));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            UnifiedLog qual$1 = this.log();
            MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$2 = 0;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            Object x$6 = qual$1.appendAsLeader$default$6();
            return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5, x$6);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        UnifiedLog qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        Object x$6 = qual$1.appendAsLeader$default$6();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5, x$6);
        UnifiedLog qual$2 = this.log();
        MemoryRecords x$7 = MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$8 = 3;
        AppendOrigin x$9 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$10 = qual$2.appendAsLeader$default$4();
        RequestLocal x$11 = qual$2.appendAsLeader$default$5();
        Object x$12 = qual$2.appendAsLeader$default$6();
        qual$2.appendAsLeader(x$7, x$8, x$9, x$10, x$11, x$12);
        UnifiedLog qual$3 = this.log();
        MemoryRecords x$13 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$14 = 3;
        AppendOrigin x$15 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$16 = qual$3.appendAsLeader$default$4();
        RequestLocal x$17 = qual$3.appendAsLeader$default$5();
        Object x$18 = qual$3.appendAsLeader$default$6();
        qual$3.appendAsLeader(x$13, x$14, x$15, x$16, x$17, x$18);
        UnifiedLog qual$4 = this.log();
        MemoryRecords x$19 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$20 = 3;
        AppendOrigin x$21 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$22 = qual$4.appendAsLeader$default$4();
        RequestLocal x$23 = qual$4.appendAsLeader$default$5();
        Object x$24 = qual$4.appendAsLeader$default$6();
        qual$4.appendAsLeader(x$19, x$20, x$21, x$22, x$23, x$24);
        UnifiedLog qual$5 = this.log();
        MemoryRecords x$25 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.GZIP, (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$26 = 5;
        AppendOrigin x$27 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$28 = qual$5.appendAsLeader$default$4();
        RequestLocal x$29 = qual$5.appendAsLeader$default$5();
        Object x$30 = qual$5.appendAsLeader$default$6();
        qual$5.appendAsLeader(x$25, x$26, x$27, x$28, x$29, x$30);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$31 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin x$32 = AppendOrigin.COORDINATOR;
        int x$33 = 7;
        MetadataVersion x$34 = qual$6.appendAsLeader$default$4();
        RequestLocal x$35 = qual$6.appendAsLeader$default$5();
        Object x$36 = qual$6.appendAsLeader$default$6();
        qual$6.appendAsLeader(x$31, x$33, x$32, x$34, x$35, x$36);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        boolean x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(BrokerTopicStats$.MODULE$.$lessinit$greater$default$1()), (Scheduler)mockTime.scheduler, (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15(), LogTestUtils$.MODULE$.createLog$default$16(), LogTestUtils$.MODULE$.createLog$default$17());
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.flush(false);
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())}), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()}));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataSnapshot() {
        void resource_resource;
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (Time)this.time(), (Scheduler)this.time().scheduler, new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        AutoCloseable autoCloseable = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((Seq)metadataRecords, snapshotWriter);
        }
        finally {
            resource_resource.close();
        }
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()}));
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<Object> partialLines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()})).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = new StringOps(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+")).r();
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOptimized)option.get()).apply(0);
                batchesBytes += new StringOps(Predef$.MODULE$.augmentString(size)).toInt();
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$4))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$2) {
        return x$2.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ long $anonfun$testDumpMetadataSnapshot$2(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(metadataRecords$1).asJava());
        return snapshotWriter.freeze();
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$14))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$15))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$16))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$17))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$18))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$5))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$6))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$7))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$8))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$12))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$13))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        return BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter));
    }
}

