/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import kafka.utils.TestUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.metadata.migration.ZkRecordConsumer;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000b\u0016\u0001iAQa\n\u0001\u0005\u0002!2Aa\u000b\u0001\u0001Y!A!I\u0001B\u0001B\u0003%1\tC\u0003(\u0005\u0011\u0005a\tC\u0004K\u0005\t\u0007I\u0011A&\t\r\u0001\u0014\u0001\u0015!\u0003M\u0011\u001d\t'\u00011A\u0005\u0002\tDqa\u001b\u0002A\u0002\u0013\u0005A\u000e\u0003\u0004s\u0005\u0001\u0006Ka\u0019\u0005\bg\n\u0001\r\u0011\"\u0001u\u0011\u001dA(\u00011A\u0005\u0002eDaa\u001f\u0002!B\u0013)\b\"\u0002?\u0003\t\u0003j\bbBA\r\u0005\u0011\u0005\u00111\u0004\u0005\b\u0003[\u0011A\u0011AA\u0018\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\n9\"l['jOJ\fG/[8o\r\u0006LGn\u001c<feR+7\u000f\u001e\u0006\u0003-]\t!A_6\u000b\u0003a\tQa[1gW\u0006\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0018\u0003\u0015)H/\u001b7t\u0013\t13EA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005)\"!F\"baR,(/\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\n\u0004\u00055*\u0004C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011a\u0017M\\4\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005Y\u0002U\"A\u001c\u000b\u0005aJ\u0014!\u00024bk2$(B\u0001\u001e<\u0003\u0019\u0019XM\u001d<fe*\u0011\u0001\u0004\u0010\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014x-\u0003\u0002Bo\taa)Y;mi\"\u000bg\u000e\u001a7fe\u00061an\u001c3f\u0013\u0012\u0004\"\u0001\b#\n\u0005\u0015k\"aA%oiR\u0011q)\u0013\t\u0003\u0011\ni\u0011\u0001\u0001\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0007M\u0006,H\u000e^:\u0016\u00031\u00032!\u0014*U\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!U\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T\u001d\n1!)\u001e4gKJ\u0004\"!V/\u000f\u0005Y[fBA,[\u001b\u0005A&BA-\u001a\u0003\u0019a$o\\8u}%\ta$\u0003\u0002];\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u0005%!\u0006N]8xC\ndWM\u0003\u0002];\u00059a-Y;miN\u0004\u0013A\u00024viV\u0014X-F\u0001d!\r!\u0017\u000eV\u0007\u0002K*\u0011amZ\u0001\u000bG>t7-\u001e:sK:$(B\u000152\u0003\u0011)H/\u001b7\n\u0005),'!E\"p[BdW\r^1cY\u00164U\u000f^;sK\u0006Qa-\u001e;ve\u0016|F%Z9\u0015\u00055\u0004\bC\u0001\u000fo\u0013\tyWD\u0001\u0003V]&$\bbB9\t\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0014a\u00024viV\u0014X\rI\u0001\u000eo\u0006LG/\u001b8h\r>\u0014Xj]4\u0016\u0003U\u0004\"A\f<\n\u0005]|#AB*ue&tw-A\txC&$\u0018N\\4G_Jl5oZ0%KF$\"!\u001c>\t\u000fE\\\u0011\u0011!a\u0001k\u0006qq/Y5uS:<gi\u001c:Ng\u001e\u0004\u0013a\u00035b]\u0012dWMR1vYR$RA`A\u0002\u0003+\u0001\"!V@\n\u0007\u0005\u0005qL\u0001\tSk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]\"9\u0011QA\u0007A\u0002\u0005\u001d\u0011A\u00044bS2,(/Z'fgN\fw-\u001a\t\u0005\u0003\u0013\t\tB\u0004\u0003\u0002\f\u00055\u0001CA,\u001e\u0013\r\ty!H\u0001\u0007!J,G-\u001a4\n\u0007]\f\u0019BC\u0002\u0002\u0010uAa!a\u0006\u000e\u0001\u0004!\u0016!B2bkN,\u0017!D2iK\u000e\\\u0017I\u001c3DY\u0016\f'\u000fF\u0002n\u0003;Aq!a\b\u000f\u0001\u0004\t\t#\u0001\u0005wKJLg-[3s!\u0019a\u00121EA\u0014[&\u0019\u0011QE\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003B+\u0002*QK1!a\u000b`\u0005\r\u0019V-]\u0001\ro\u0006LGOR8s\u000bJ\u0014xN\u001d\u000b\u0004G\u0006E\u0002bBA\u001a\u001f\u0001\u0007\u0011qA\u0001\b[\u0016\u001c8/Y4f\u0003Q\u0011W/\u001b7e\u001b&<'/\u0019;j_:$%/\u001b<feR1\u0011\u0011HA(\u0003#\u0002b\u0001HA\u001e\u0003\u007f9\u0015bAA\u001f;\t1A+\u001e9mKJ\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005nS\u001e\u0014\u0018\r^5p]*\u0019\u0011\u0011J\u001e\u0002\u00115,G/\u00193bi\u0006LA!!\u0014\u0002D\t!2JU1gi6KwM]1uS>tGI]5wKJDQA\u0011\tA\u0002\rCq!a\u0015\u0011\u0001\u0004\t)&A\t{W6KwM]1uS>t7\t\\5f]R\u00042AKA,\u0013\r\tI&\u0006\u0002\u00125.l\u0015n\u001a:bi&|gn\u00117jK:$\u0018A\u0005:fC\u0012l\u0015n\u001a:bi&|gN\u0017(pI\u0016$B!a\u0018\u0002fA!\u0011\u0011IA1\u0013\u0011\t\u0019'a\u0011\u00035i[W*[4sCRLwN\u001c'fC\u0012,'o\u001d5jaN#\u0018\r^3\t\u000f\u0005M\u0013\u00031\u0001\u0002V\u000591/\u00194f\u000f\u0016$X\u0003BA6\u0003c\"B!!\u001c\u0002\u0004B!\u0011qNA9\u0019\u0001!q!a\u001d\u0013\u0005\u0004\t)HA\u0001U#\u0011\t9(! \u0011\u0007q\tI(C\u0002\u0002|u\u0011qAT8uQ&tw\rE\u0002\u001d\u0003\u007fJ1!!!\u001e\u0005\r\te.\u001f\u0005\u0007CJ\u0001\r!!\"\u0011\t\u0011L\u0017QN\u0001\u001di\u0016\u001cHoQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<fej['+Y2f)\u0005i\u0007fA\n\u0002\u000eB!\u0011qRAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015aA1qS*!\u0011qSAM\u0003\u001dQW\u000f]5uKJT1!a'?\u0003\u0015QWO\\5u\u0013\u0011\ty*!%\u0003\tQ+7\u000f\u001e")
public class ZkMigrationFailoverTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Tuple2<KRaftMigrationDriver, CapturingFaultHandler> buildMigrationDriver(int nodeId, ZkMigrationClient zkMigrationClient) {
        CapturingFaultHandler faultHandler = new CapturingFaultHandler(this, nodeId);
        KRaftMigrationDriver driver = KRaftMigrationDriver.newBuilder().setNodeId(nodeId).setZkRecordConsumer(new ZkRecordConsumer(null){

            public CompletableFuture<?> beginMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CompletableFuture<?> acceptBatch(List<ApiMessageAndVersion> recordBatch) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CompletableFuture<OffsetAndEpoch> completeMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void abortMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }).setInitialZkLoadHandler(x$1 -> {}).setZkMigrationClient((MigrationClient)zkMigrationClient).setFaultHandler((FaultHandler)faultHandler).setQuorumFeatures(QuorumFeatures.create((int)nodeId, (ApiVersions)new ApiVersions(), (Map)QuorumFeatures.defaultFeatureMap(), Arrays.asList((Object[])new Node[]{new Node(3000, "localhost", 3000), new Node(3001, "localhost", 3001), new Node(3002, "localhost", 3002)}))).setConfigSchema(KafkaConfigSchema.EMPTY).setControllerMetrics(new QuorumControllerMetrics(Optional.empty(), Time.SYSTEM, true)).setTime(Time.SYSTEM).setPropagator(new LegacyPropagator(null){

            public void startup() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void shutdown() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void publishMetadata(MetadataImage image) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void sendRPCsToBrokersFromMetadataDelta(MetadataDelta delta, MetadataImage image, int zkControllerEpoch) {
            }

            public void sendRPCsToBrokersFromMetadataImage(MetadataImage image, int zkControllerEpoch) {
            }

            public void clear() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }).build();
        return new Tuple2((Object)driver, (Object)faultHandler);
    }

    public ZkMigrationLeadershipState readMigrationZNode(ZkMigrationClient zkMigrationClient) {
        return zkMigrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
    }

    public <T> T safeGet(CompletableFuture<T> future) {
        return future.get(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailoverZkRace() {
        void var13_13;
        void var12_12;
        void var8_8;
        void var7_7;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, false, 30000, 60000, 1, Time.SYSTEM, "ZkMigrationFailoverTest", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
        }
        catch (Throwable t) {
            Utils.closeQuietly((AutoCloseable)zookeeper, (String)"EmbeddedZookeeper");
            zookeeper.shutdown();
            if ((KafkaZkClient)zkClient.elem != null) {
                Utils.closeQuietly((AutoCloseable)((KafkaZkClient)zkClient.elem), (String)"KafkaZkClient");
            }
            throw t;
        }
        ZkMigrationClient zkMigrationClient = ZkMigrationClient$.MODULE$.apply((KafkaZkClient)zkClient.elem, (PasswordEncoder)PasswordEncoder$.MODULE$.noop());
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple2 = this.buildMigrationDriver(3000, zkMigrationClient);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver1 = (KRaftMigrationDriver)tuple2._1();
        CapturingFaultHandler faultHandler1 = (CapturingFaultHandler)tuple2._2();
        void driver12 = var7_7;
        void faultHandler12 = var8_8;
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple22 = this.buildMigrationDriver(3001, zkMigrationClient);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver2 = (KRaftMigrationDriver)tuple22._1();
        CapturingFaultHandler faultHandler2 = (CapturingFaultHandler)tuple22._2();
        void driver22 = var12_12;
        void faultHandler22 = var13_13;
        ((KafkaZkClient)zkClient.elem).registerControllerAndIncrementControllerEpoch(0);
        ZkMigrationLeadershipState zkState = zkMigrationClient.claimControllerLeadership(ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3000, 1));
        zkState = zkState.withKRaftMetadataOffsetAndEpoch(100L, 10);
        zkMigrationClient.getOrCreateMigrationRecoveryState(zkState);
        zkState = null;
        try {
            driver12.start();
            driver22.start();
            LeaderAndEpoch newLeader1 = new LeaderAndEpoch(OptionalInt.of(3000), 2);
            MetadataImage image1 = MetadataImage.EMPTY;
            MetadataDelta delta1 = new MetadataDelta(image1);
            delta1.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV1.featureLevel()));
            delta1.replay(ZkMigrationState.MIGRATION.toRecord().message());
            delta1.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("topic-to-sync"));
            MetadataProvenance provenance1 = new MetadataProvenance(210L, 11, 1L);
            image1 = delta1.apply(provenance1);
            LogDeltaManifest manifest1 = LogDeltaManifest.newBuilder().provenance(provenance1).leaderAndEpoch(newLeader1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            driver12.onMetadataUpdate(delta1, image1, (LoaderManifest)manifest1);
            driver12.onControllerChange(newLeader1);
            driver22.onControllerChange(newLeader1);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$1(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            LeaderAndEpoch newLeader2 = new LeaderAndEpoch(OptionalInt.of(3001), 3);
            driver22.onControllerChange(newLeader2);
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$3(this, (KRaftMigrationDriver)driver22)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            MetadataDelta delta2 = new MetadataDelta(image1);
            delta2.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("another-topic-to-sync"));
            MetadataProvenance provenance2 = new MetadataProvenance(211L, 11, 1L);
            MetadataImage image2 = delta2.apply(provenance2);
            LogDeltaManifest manifest2 = LogDeltaManifest.newBuilder().provenance(provenance2).leaderAndEpoch(newLeader1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            int migrationZkVersion = this.readMigrationZNode(zkMigrationClient).migrationZkVersion();
            driver12.onMetadataUpdate(delta2, image2, (LoaderManifest)manifest2);
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$5(this, zkMigrationClient, migrationZkVersion)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            MetadataDelta delta3 = new MetadataDelta(image1);
            delta3.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("another-topic-to-sync"));
            MetadataProvenance provenance3 = new MetadataProvenance(211L, 11, 1L);
            MetadataImage image3 = delta3.apply(provenance3);
            LogDeltaManifest manifest3 = LogDeltaManifest.newBuilder().provenance(provenance3).leaderAndEpoch(newLeader2).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            driver22.onMetadataUpdate(delta3, image3, (LoaderManifest)manifest3);
            long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$7(zkClient)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$8());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            faultHandler22.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$9(faults);
                return BoxedUnit.UNIT;
            });
            driver12.onMetadataUpdate(delta3, image3, (LoaderManifest)manifest3);
            this.safeGet(faultHandler12.waitForError("Controller epoch zkVersion check fails"));
            driver12.onControllerChange(newLeader2);
            faultHandler22.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$10(faults);
                return BoxedUnit.UNIT;
            });
            long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$11(this, (KRaftMigrationDriver)driver22)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$12());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            faultHandler22.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$13(faults);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            driver12.close();
            driver22.close();
            Utils.closeQuietly((AutoCloseable)zookeeper, (String)"EmbeddedZookeeper");
            zookeeper.shutdown();
            if ((KafkaZkClient)zkClient.elem != null) {
                Utils.closeQuietly((AutoCloseable)((KafkaZkClient)zkClient.elem), (String)"KafkaZkClient");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$1(ObjectRef zkClient$1) {
        Option option = ((KafkaZkClient)zkClient$1.elem).getControllerId();
        if (option instanceof Some) {
            return BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3000;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$2() {
        return "waiting for 3000 to claim ZK leadership";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$3(ZkMigrationFailoverTest $this, KRaftMigrationDriver driver2$1) {
        return ((Enum)$this.safeGet(driver2$1.migrationState())).equals(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$4() {
        return "waiting for node 3001 to enter WAIT_FOR_CONTROLLER_QUORUM";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$5(ZkMigrationFailoverTest $this, ZkMigrationClient zkMigrationClient$1, int migrationZkVersion$1) {
        return $this.readMigrationZNode(zkMigrationClient$1).migrationZkVersion() > migrationZkVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$6() {
        return "waiting for /migration znode to change";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$7(ObjectRef zkClient$1) {
        Option option = ((KafkaZkClient)zkClient$1.elem).getControllerId();
        if (option instanceof Some) {
            return BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3001;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$8() {
        return "waiting for 3001 to claim ZK leadership";
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$9(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$10(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$11(ZkMigrationFailoverTest $this, KRaftMigrationDriver driver2$1) {
        return ((Enum)$this.safeGet(driver2$1.migrationState())).equals(MigrationDriverState.DUAL_WRITE);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$12() {
        return "waiting for driver to enter DUAL_WRITE";
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$13(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    public ZkMigrationFailoverTest() {
        Logging.$init$((Logging)this);
    }

    public class CapturingFaultHandler
    implements FaultHandler {
        private final int nodeId;
        private final Buffer<Throwable> faults;
        private CompletableFuture<Throwable> future;
        private String waitingForMsg;
        public final /* synthetic */ ZkMigrationFailoverTest $outer;

        public RuntimeException handleFault(String x$1) {
            return super.handleFault(x$1);
        }

        public Buffer<Throwable> faults() {
            return this.faults;
        }

        public CompletableFuture<Throwable> future() {
            return this.future;
        }

        public void future_$eq(CompletableFuture<Throwable> x$1) {
            this.future = x$1;
        }

        public String waitingForMsg() {
            return this.waitingForMsg;
        }

        public void waitingForMsg_$eq(String x$1) {
            this.waitingForMsg = x$1;
        }

        public RuntimeException handleFault(String failureMessage, Throwable cause) {
            this.kafka$zk$ZkMigrationFailoverTest$CapturingFaultHandler$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Fault handled on node ").append($this.nodeId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> cause);
            this.faults().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{cause}));
            if (!this.future().isDone() && cause.getMessage().contains(this.waitingForMsg())) {
                this.future().complete(cause);
            }
            return new RuntimeException(cause);
        }

        public void checkAndClear(Function1<Seq<Throwable>, BoxedUnit> verifier) {
            Seq faultsSoFar = this.faults().toSeq();
            try {
                verifier.apply((Object)faultsSoFar);
                return;
            }
            catch (AssertionError ae) {
                Assertions.fail((String)new StringBuilder(35).append("Assertion failed. Faults on ").append(this.nodeId).append(" were: ").append(faultsSoFar).toString(), (Throwable)((Object)ae));
                return;
            }
        }

        public CompletableFuture<Throwable> waitForError(String message) {
            this.future_$eq(new CompletableFuture<Throwable>());
            this.waitingForMsg_$eq(message);
            return this.future();
        }

        public /* synthetic */ ZkMigrationFailoverTest kafka$zk$ZkMigrationFailoverTest$CapturingFaultHandler$$$outer() {
            return this.$outer;
        }

        public CapturingFaultHandler(ZkMigrationFailoverTest $outer, int nodeId) {
            this.nodeId = nodeId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.faults = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.future = CompletableFuture.completedFuture(new RuntimeException());
            this.waitingForMsg = "";
        }
    }
}

