/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.AclApis;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.ControllerMutationQuota;
import kafka.server.DelegationTokenManager$;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015a\u0001B\"E\u0001%C\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tE\u0002\u0011\t\u0011)A\u00059\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003f\u0011!!\bA!b\u0001\n\u0003)\b\"CA\u0005\u0001\t\u0005\t\u0015!\u0003w\u0011)\tY\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u0010\u0001\t\u0015\r\u0011\"\u0001\u0002\"!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005=\u0002A!b\u0001\n\u0003\t\t\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003gA!\"a\u0013\u0001\u0005\u000b\u0007I\u0011AA'\u0011)\t)\u0006\u0001B\u0001B\u0003%\u0011q\n\u0005\u000b\u0003/\u0002!Q1A\u0005\u0002\u0005e\u0003BCA1\u0001\t\u0005\t\u0015!\u0003\u0002\\!Q\u00111\r\u0001\u0003\u0006\u0004%\t!!\u001a\t\u0015\u0005\u0005\u0005A!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002\u0004\u0002\u0011)\u0019!C\u0001\u0003\u000bC!\"!$\u0001\u0005\u0003\u0005\u000b\u0011BAD\u0011\u001d\ty\t\u0001C\u0001\u0003#C\u0011\"!+\u0001\u0005\u0004%\t!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[C\u0011\"!.\u0001\u0005\u0004%\t!a.\t\u0011\u0005}\u0006\u0001)A\u0005\u0003sC\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u0005-\u0007\u0001)A\u0005\u0003\u000bDq!!4\u0001\t\u0003\ty\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u00036\u0001!\tAa\u000e\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!1\u0018\u0001\u0005\u0002\tu\u0006b\u0002Ba\u0001\u0011%!1\u0019\u0005\b\u0005g\u0004A\u0011\u0001B{\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0007'Aqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004@\u0001!\ta!\u0011\t\u000f\r\u0015\u0003\u0001\"\u0001\u0004H!911\n\u0001\u0005\u0002\r5\u0003bBB)\u0001\u0011\u000511\u000b\u0005\b\u0007/\u0002A\u0011AB-\u0011\u001d\u0019i\u0006\u0001C\u0001\u0007?Bqaa\u0019\u0001\t\u0003\u0019)\u0007C\u0004\u0004j\u0001!\taa\u001b\t\u000f\r=\u0004\u0001\"\u0001\u0004r!91Q\u000f\u0001\u0005\u0002\r]\u0004bBB>\u0001\u0011%1Q\u0010\u0005\b\u00073\u0003A\u0011ABN\u0011\u001d\u0019y\n\u0001C\u0001\u0007CCqa!*\u0001\t\u0003\u00199\u000bC\u0004\u0004,\u0002!\ta!,\t\u000f\r=\u0007\u0001\"\u0001\u0004R\"91Q\u001b\u0001\u0005\u0002\r]\u0007bBBn\u0001\u0011\u00051Q\u001c\u0005\b\u0007C\u0004A\u0011ABr\u0011\u001d\u00199\u000f\u0001C\u0001\u0007SDqa!<\u0001\t\u0003\u0019y\u000fC\u0004\u0004t\u0002!\ta!>\t\u000f\re\b\u0001\"\u0001\u0004|\"91q \u0001\u0005\u0002\u0011\u0005!AD\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0006\u0003\u000b\u001a\u000baa]3sm\u0016\u0014(\"A$\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0013)U!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fMB\u0011\u0011KU\u0007\u0002\t&\u00111\u000b\u0012\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\bCA+Y\u001b\u00051&BA,G\u0003\u0015)H/\u001b7t\u0013\tIfKA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYV\tA\f\u0005\u0002^A6\taL\u0003\u0002`\r\u00069a.\u001a;x_J\\\u0017BA1_\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fqB]3rk\u0016\u001cHo\u00115b]:,G\u000eI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014X#A3\u0011\u0007-3\u0007.\u0003\u0002h\u0019\n1q\n\u001d;j_:\u0004\"![9\u000e\u0003)T!aY6\u000b\u0005\u0015c'BA$n\u0015\tqw.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0006\u0019qN]4\n\u0005IT'AC!vi\"|'/\u001b>fe\u0006Y\u0011-\u001e;i_JL'0\u001a:!\u0003\u0019\tXo\u001c;bgV\ta\u000fE\u0002x\u0003\u0007q!\u0001_@\u000f\u0005ethB\u0001>~\u001b\u0005Y(B\u0001?I\u0003\u0019a$o\\8u}%\tq)\u0003\u0002F\r&\u0019\u0011\u0011\u0001#\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\u0005\u0015\u0011q\u0001\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\u0005\u0005A)A\u0004rk>$\u0018m\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0004/\u0006U!bAA\fY\u000611m\\7n_:LA!a\u0007\u0002\u0014\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0003\u0003G\u0001B!!\n\u0002*5\u0011\u0011q\u0005\u0006\u0004\u0003?a\u0017\u0002BA\u0016\u0003O\u0011!bQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003g\u0001b!!\u000e\u0002<\u0005}RBAA\u001c\u0015\r\tIDR\u0001\u0005e\u00064G/\u0003\u0003\u0002>\u0005]\"a\u0003*bMRl\u0015M\\1hKJ\u0004B!!\u0011\u0002F5\u0011\u00111\t\u0006\u0004\u0003/Y\u0017\u0002BA$\u0003\u0007\u0012A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002PA\u0019\u0011+!\u0015\n\u0007\u0005MCIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t+\t\tY\u0006E\u0002R\u0003;J1!a\u0018E\u00059iU\r^1Qe>\u0004XM\u001d;jKN\fq\"\\3uCB\u0013x\u000e]3si&,7\u000fI\u0001\u0010G>tGO]8mY\u0016\u0014hj\u001c3fgV\u0011\u0011q\r\t\u0007\u0003S\n\u0019(!\u001f\u000f\t\u0005-\u0014q\u000e\b\u0004u\u00065\u0014\"A'\n\u0007\u0005ED*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0014q\u000f\u0002\u0004'\u0016\f(bAA9\u0019B!\u00111PA?\u001b\t\t)\"\u0003\u0003\u0002\u0000\u0005U!\u0001\u0002(pI\u0016\f\u0001cY8oiJ|G\u000e\\3s\u001d>$Wm\u001d\u0011\u0002#\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'/\u0006\u0002\u0002\bB\u0019\u0011+!#\n\u0007\u0005-EIA\tBa&4VM]:j_:l\u0015M\\1hKJ\f!#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"b#a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0016q\u0015\t\u0003#\u0002AQAW\u000bA\u0002qCQaY\u000bA\u0002\u0015DQ\u0001^\u000bA\u0002YDq!a\u0003\u0016\u0001\u0004\ty\u0001C\u0004\u0002 U\u0001\r!a\t\t\u000f\u0005=R\u00031\u0001\u00024!9\u00111J\u000bA\u0002\u0005=\u0003bBA,+\u0001\u0007\u00111\f\u0005\b\u0003G*\u0002\u0019AA4\u0011\u001d\t\u0019)\u0006a\u0001\u0003\u000f\u000b!\"Y;uQ\"+G\u000e]3s+\t\ti\u000bE\u0002R\u0003_K1!!-E\u0005)\tU\u000f\u001e5IK2\u0004XM]\u0001\fCV$\b\u000eS3ma\u0016\u0014\b%A\u0007sKF,Xm\u001d;IK2\u0004XM]\u000b\u0003\u0003s\u00032!UA^\u0013\r\ti\f\u0012\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0002\u001dI,\u0017/^3ti\"+G\u000e]3sA\u00059\u0011m\u00197Ba&\u001cXCAAc!\r\t\u0016qY\u0005\u0004\u0003\u0013$%aB!dY\u0006\u0003\u0018n]\u0001\tC\u000ed\u0017\t]5tA\u0005A\u0011n]\"m_N,G-\u0006\u0002\u0002RB\u00191*a5\n\u0007\u0005UGJA\u0004C_>dW-\u00198\u0002\u000b\rdwn]3\u0015\u0005\u0005m\u0007cA&\u0002^&\u0019\u0011q\u001c'\u0003\tUs\u0017\u000e^\u0001\u0007Q\u0006tG\r\\3\u0015\r\u0005m\u0017Q]A|\u0011\u001d\t9O\ba\u0001\u0003S\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002l\u0006EhbA/\u0002n&\u0019\u0011q\u001e0\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u00111_A{\u0005\u001d\u0011V-];fgRT1!a<_\u0011\u001d\tIP\ba\u0001\u0003w\fAB]3rk\u0016\u001cH\u000fT8dC2\u00042!UA\u007f\u0013\r\ty\u0010\u0012\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u0016Q\u0006tG\r\\3F]Z,Gn\u001c9f%\u0016\fX/Z:u)\u0019\u0011)A!\u0007\u0003\u001cA1!q\u0001B\u000b\u00037l!A!\u0003\u000b\t\t-!QB\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B\b\u0005#\tA!\u001e;jY*\u0011!1C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0018\t%!!E\"p[BdW\r^1cY\u00164U\u000f^;sK\"9\u0011q]\u0010A\u0002\u0005%\bbBA}?\u0001\u0007\u00111`\u0001\u001bQ\u0006tG\r\\3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u000b\u0005\u0005\u000b\u0011\t\u0003C\u0004\u0002h\u0002\u0002\r!!;\u0002;!\fg\u000e\u001a7f'\u0006\u001cH.Q;uQ\u0016tG/[2bi\u0016\u0014V-];fgR$BA!\u0002\u0003(!9\u0011q]\u0011A\u0002\u0005%\u0018a\u00035b]\u0012dWMR3uG\"$BA!\u0002\u0003.!9\u0011q\u001d\u0012A\u0002\u0005%\u0018a\u00055b]\u0012dWMR3uG\"\u001cf.\u00199tQ>$H\u0003\u0002B\u0003\u0005gAq!a:$\u0001\u0004\tI/\u0001\niC:$G.\u001a#fY\u0016$X\rV8qS\u000e\u001cH\u0003\u0002B\u0003\u0005sAq!a:%\u0001\u0004\tI/\u0001\u0007eK2,G/\u001a+pa&\u001c7\u000f\u0006\b\u0003@\t=$\u0011\u0010BB\u0005\u001b\u0013\tJa.\u0011\r\t\u001d!Q\u0003B!!\u0019\u0011\u0019E!\u0012\u0003J5\u0011!QB\u0005\u0005\u0005\u000f\u0012iA\u0001\u0003MSN$\b\u0003\u0002B&\u0005SrAA!\u0014\u0003d9!!q\nB0\u001d\u0011\u0011\tF!\u0018\u000f\t\tM#1\f\b\u0005\u0005+\u0012IFD\u0002{\u0005/J\u0011\u0001]\u0005\u0003]>L!aR7\n\u0007\u0005]A.\u0003\u0003\u0003b\u0005U\u0011aB7fgN\fw-Z\u0005\u0005\u0005K\u00129'\u0001\rEK2,G/\u001a+pa&\u001c7OU3ta>t7/\u001a#bi\u0006TAA!\u0019\u0002\u0016%!!1\u000eB7\u0005Q!U\r\\3uC\ndW\rV8qS\u000e\u0014Vm];mi*!!Q\rB4\u0011\u001d\u0011\t(\na\u0001\u0005g\nqaY8oi\u0016DH\u000f\u0005\u0003\u0002&\tU\u0014\u0002\u0002B<\u0003O\u0011\u0001dQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\t9/\na\u0001\u0005w\u0002BA! \u0003\u00005\u0011!qM\u0005\u0005\u0005\u0003\u00139GA\fEK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC\"9!QQ\u0013A\u0002\t\u001d\u0015AC1qSZ+'o]5p]B\u00191J!#\n\u0007\t-EJA\u0002J]RDqAa$&\u0001\u0004\t\t.\u0001\biCN\u001cE.^:uKJ\fU\u000f\u001e5\t\u000f\tMU\u00051\u0001\u0003\u0016\u0006!r-\u001a;EKN\u001c'/\u001b2bE2,Gk\u001c9jGN\u0004ra\u0013BL\u00057\u0013\t,C\u0002\u0003\u001a2\u0013\u0011BR;oGRLwN\\\u0019\u0011\r\u0005%$Q\u0014BQ\u0013\u0011\u0011y*a\u001e\u0003\u0011%#XM]1cY\u0016\u0004BAa)\u0003,:!!Q\u0015BT!\tQH*C\u0002\u0003*2\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002BW\u0005_\u0013aa\u0015;sS:<'b\u0001BU\u0019B1!1\u0015BZ\u0005CKAA!.\u00030\n\u00191+\u001a;\t\u000f\teV\u00051\u0001\u0003\u0016\u0006\u0011r-\u001a;EK2,G/\u00192mKR{\u0007/[2t\u0003IA\u0017M\u001c3mK\u000e\u0013X-\u0019;f)>\u0004\u0018nY:\u0015\t\t\u0015!q\u0018\u0005\b\u0003O4\u0003\u0019AAu\u0003\t\u001awN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018MU3d_J$WM\u001d$peR!!Q\u0019Bu%\u0019\u00119Ma3\u0003X\u001a1!\u0011Z\u0014\u0001\u0005\u000b\u0014A\u0002\u0010:fM&tW-\\3oiz\u0002BA!4\u0003T6\u0011!q\u001a\u0006\u0005\u0005#\u0014\t\"\u0001\u0003mC:<\u0017\u0002\u0002Bk\u0005\u001f\u0014aa\u00142kK\u000e$\bC\u0002Bm\u0005?\u0014\u0019/\u0004\u0002\u0003\\*!!Q\u001cB\u0007\u0003!1WO\\2uS>t\u0017\u0002\u0002Bq\u00057\u0014\u0001bQ8ogVlWM\u001d\t\u0005\u0005\u001b\u0014)/\u0003\u0003\u0003h\n='aB%oi\u0016<WM\u001d\u0005\b\u0005W<\u0003\u0019\u0001Bw\u0003]\u0019wN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rE\u0002R\u0005_L1A!=E\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0007\u0003x\n}8\u0011AB\u0005\u0007\u0017\u0019y\u0001\u0005\u0004\u0003\b\tU!\u0011 \t\u0005\u0005{\u0012Y0\u0003\u0003\u0003~\n\u001d$\u0001G\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rR1uC\"9!\u0011\u000f\u0015A\u0002\tM\u0004bBAtQ\u0001\u000711\u0001\t\u0005\u0005{\u001a)!\u0003\u0003\u0004\b\t\u001d$aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0011\u001d\u0011y\t\u000ba\u0001\u0003#Dqa!\u0004)\u0001\u0004\u0011)*\u0001\nhKR\u001c%/Z1uC\ndW\rV8qS\u000e\u001c\bb\u0002BJQ\u0001\u0007!QS\u0001\u0019Q\u0006tG\r\\3Ba&4VM]:j_:\u001c(+Z9vKN$H\u0003\u0002B\u0003\u0007+Aq!a:*\u0001\u0004\tI/\u0001\fbkRDwN]5{K\u0006cG/\u001a:SKN|WO]2f)\u0019\u0019Yba\n\u00042A!1QDB\u0012\u001b\t\u0019yB\u0003\u0003\u0004\"\u0005U\u0011\u0001\u0003:fcV,7\u000f^:\n\t\r\u00152q\u0004\u0002\t\u0003BLWI\u001d:pe\"91\u0011\u0006\u0016A\u0002\r-\u0012A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007;\u0019i#\u0003\u0003\u00040\r}!A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0007gQ\u0003\u0019AB\u001b\u0003!\u0011Xm]8ve\u000e,\u0007\u0003BB\u001c\u0007wi!a!\u000f\u000b\t\u0005-\u0013QC\u0005\u0005\u0007{\u0019ID\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u00021!\fg\u000e\u001a7f\u0019\u0016<\u0017mY=BYR,'oQ8oM&<7\u000f\u0006\u0003\u0003\u0006\r\r\u0003bBAtW\u0001\u0007\u0011\u0011^\u0001\u000bQ\u0006tG\r\\3W_R,G\u0003\u0002B\u0003\u0007\u0013Bq!a:-\u0001\u0004\tI/\u0001\fiC:$G.\u001a\"fO&t\u0017+^8sk6,\u0005o\\2i)\u0011\u0011)aa\u0014\t\u000f\u0005\u001dX\u00061\u0001\u0002j\u0006!\u0002.\u00198eY\u0016,e\u000eZ)v_J,X.\u00129pG\"$BA!\u0002\u0004V!9\u0011q\u001d\u0018A\u0002\u0005%\u0018\u0001\u00065b]\u0012dW\rR3tGJL'-Z)v_J,X\u000e\u0006\u0003\u0003\u0006\rm\u0003bBAt_\u0001\u0007\u0011\u0011^\u0001\u0013Q\u0006tG\r\\3FY\u0016\u001cG\u000fT3bI\u0016\u00148\u000f\u0006\u0003\u0003\u0006\r\u0005\u0004bBAta\u0001\u0007\u0011\u0011^\u0001\u001cQ\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SKF,Xm\u001d;\u0015\t\t\u00151q\r\u0005\b\u0003O\f\u0004\u0019AAu\u0003qA\u0017M\u001c3mK\n\u0013xn[3s\u0011\u0016\f'\u000f\u001e\"fCR\u0014V-];fgR$BA!\u0002\u0004n!9\u0011q\u001d\u001aA\u0002\u0005%\u0018A\u00065b]\u0012dW-\u00168sK\u001eL7\u000f^3s\u0005J|7.\u001a:\u0015\t\t\u001511\u000f\u0005\b\u0003O\u001c\u0004\u0019AAu\u0003aA\u0017M\u001c3mK\n\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u000b\u0005\u0005\u000b\u0019I\bC\u0004\u0002hR\u0002\r!!;\u0002#!\fg\u000e\u001a7f%\u00064GOU3rk\u0016\u001cH\u000f\u0006\u0004\u0003\u0006\r}4\u0011\u0011\u0005\b\u0003O,\u0004\u0019AAu\u0011\u001d\u0019\u0019)\u000ea\u0001\u0007\u000b\u000bQBY;jY\u0012\u0014Vm\u001d9p]N,\u0007cB&\u0003\u0018\u000e\u001d51\u0013\t\u0005\u0007\u0013\u001by)\u0004\u0002\u0004\f*!1QRA\u000b\u0003!\u0001(o\u001c;pG>d\u0017\u0002BBI\u0007\u0017\u0013!\"\u00119j\u001b\u0016\u001c8/Y4f!\u0011\u0019ib!&\n\t\r]5q\u0004\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016\fq\u0003[1oI2,\u0017\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\t\u00151Q\u0014\u0005\b\u0003O4\u0004\u0019AAu\u0003uA\u0017M\u001c3mK&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001cH\u0003\u0002B\u0003\u0007GCq!a:8\u0001\u0004\tI/\u0001\fiC:$G.Z\"sK\u0006$X\rU1si&$\u0018n\u001c8t)\u0011\u0011)a!+\t\u000f\u0005\u001d\b\b1\u0001\u0002j\u0006\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\t\u0007_\u001b\tma1\u0004LB1!q\u0001B\u000b\u0007c\u0003bAa\u0011\u0003F\rM\u0006\u0003BB[\u0007wsAA!\u0014\u00048&!1\u0011\u0018B4\u0003q\u0019%/Z1uKB\u000b'\u000f^5uS>t7OU3ta>t7/\u001a#bi\u0006LAa!0\u0004@\nY2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d+pa&\u001c'+Z:vYRTAa!/\u0003h!9!\u0011O\u001dA\u0002\tM\u0004bBAts\u0001\u00071Q\u0019\t\u0005\u0005{\u001a9-\u0003\u0003\u0004J\n\u001d$aG\"sK\u0006$X\rU1si&$\u0018n\u001c8t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0004Nf\u0002\rA!&\u00021\u001d,G/\u00117uKJ\fU\u000f\u001e5pe&TX\r\u001a+pa&\u001c7/A\u0011iC:$G.Z!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$8\u000f\u0006\u0003\u0003\u0006\rM\u0007bBAtu\u0001\u0007\u0011\u0011^\u0001 Q\u0006tG\r\\3BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cH\u0003\u0002B\u0003\u00073Dq!a:<\u0001\u0004\tI/\u0001\nbY2|w\u000fV8lK:\u0014V-];fgR\u001cH\u0003BAi\u0007?Dq!a:=\u0001\u0004\tI/\u0001\u0012iC:$G.Z\"sK\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\u001c*fcV,7\u000f\u001e\u000b\u0005\u0005\u000b\u0019)\u000fC\u0004\u0002hv\u0002\r!!;\u0002C!\fg\u000e\u001a7f%\u0016tWm\u001e#fY\u0016<\u0017\r^5p]R{7.\u001a8SKF,Xm\u001d;\u0015\t\t\u001511\u001e\u0005\b\u0003Ot\u0004\u0019AAu\u0003\tB\u0017M\u001c3mK\u0016C\b/\u001b:f\t\u0016dWmZ1uS>tGk\\6f]J+\u0017/^3tiR!!QABy\u0011\u001d\t9o\u0010a\u0001\u0003S\f\u0001\u0005[1oI2,G*[:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8ugR!!QAB|\u0011\u001d\t9\u000f\u0011a\u0001\u0003S\f\u0001\u0005[1oI2,\u0017\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egJ+\u0017/^3tiR!!QAB\u007f\u0011\u001d\t9/\u0011a\u0001\u0003S\fA\u0003[1oI2,W\u000b\u001d3bi\u00164U-\u0019;ve\u0016\u001cH\u0003\u0002B\u0003\t\u0007Aq!a:C\u0001\u0004\tI\u000f")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private final AclApis aclApis;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void tryCompleteActions() {
        ApiRequestHandler.tryCompleteActions$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    private AclApis aclApis() {
        return this.aclApis;
    }

    public boolean isClosed() {
        return this.aclApis().isClosed();
    }

    public void close() {
        this.aclApis().close();
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        try {
            try {
                CompletableFuture<BoxedUnit> completableFuture;
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    completableFuture = this.handleFetch(request);
                } else if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                    completableFuture = this.handleFetchSnapshot(request);
                } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleCreateTopics(request);
                } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleDeleteTopics(request);
                } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    completableFuture = this.handleApiVersionsRequest(request);
                } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleLegacyAlterConfigs(request);
                } else if (ApiKeys.VOTE.equals(apiKeys)) {
                    completableFuture = this.handleVote(request);
                } else if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleBeginQuorumEpoch(request);
                } else if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleEndQuorumEpoch(request);
                } else if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    completableFuture = this.handleDescribeQuorum(request);
                } else if (ApiKeys.ALTER_PARTITION.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionRequest(request);
                } else if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    completableFuture = this.handleBrokerRegistration(request);
                } else if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    completableFuture = this.handleBrokerHeartBeatRequest(request);
                } else if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    completableFuture = this.handleUnregisterBroker(request);
                } else if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    completableFuture = this.handleAlterClientQuotas(request);
                } else if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleIncrementalAlterConfigs(request);
                } else if (ApiKeys.ALTER_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionReassignments(request);
                } else if (ApiKeys.LIST_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleListPartitionReassignments(request);
                } else if (ApiKeys.ALTER_USER_SCRAM_CREDENTIALS.equals(apiKeys)) {
                    completableFuture = this.handleAlterUserScramCredentials(request);
                } else if (ApiKeys.CREATE_DELEGATION_TOKEN.equals(apiKeys)) {
                    completableFuture = this.handleCreateDelegationTokenRequest(request);
                } else if (ApiKeys.RENEW_DELEGATION_TOKEN.equals(apiKeys)) {
                    completableFuture = this.handleRenewDelegationTokenRequest(request);
                } else if (ApiKeys.EXPIRE_DELEGATION_TOKEN.equals(apiKeys)) {
                    completableFuture = this.handleExpireDelegationTokenRequest(request);
                } else if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    completableFuture = this.handleEnvelopeRequest(request, requestLocal);
                } else if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    completableFuture = this.handleSaslHandshakeRequest(request);
                } else if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    completableFuture = this.handleSaslAuthenticateRequest(request);
                } else if (ApiKeys.ALLOCATE_PRODUCER_IDS.equals(apiKeys)) {
                    completableFuture = this.handleAllocateProducerIdsRequest(request);
                } else if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
                    completableFuture = this.handleCreatePartitions(request);
                } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDescribeAcls(request);
                } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleCreateAcls(request);
                } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDeleteAcls(request);
                } else if (ApiKeys.ELECT_LEADERS.equals(apiKeys)) {
                    completableFuture = this.handleElectLeaders(request);
                } else if (ApiKeys.UPDATE_FEATURES.equals(apiKeys)) {
                    completableFuture = this.handleUpdateFeatures(request);
                } else {
                    throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
                }
                completableFuture.whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        this.requestHelper().handleError(request, (Throwable)exception);
                        return;
                    }
                });
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                this.requestHelper().handleError(request, t);
            }
        }
        finally {
            if (request.apiLocalCompleteTimeNanos() < 0L) {
                request.apiLocalCompleteTimeNanos_$eq(this.time().nanoseconds());
            }
        }
    }

    public CompletableFuture<BoxedUnit> handleEnvelopeRequest(RequestChannel.Request request, RequestLocal requestLocal) {
        if (!this.authHelper().authorize(request.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
        } else {
            EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
                this.handle(x$2, requestLocal);
                return BoxedUnit.UNIT;
            });
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)x$3 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$3)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)x$4 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$4)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleFetchSnapshot(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDeleteTopics(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)5);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)deleteTopicsRequest.data().timeoutMs()), this.controllerMutationQuotaRecorderFor(controllerMutationQuota));
        RequestContext x$1 = request.context();
        AclOperation x$2 = AclOperation.DELETE;
        ResourceType x$3 = ResourceType.CLUSTER;
        String x$4 = "kafka-cluster";
        boolean x$5 = false;
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.deleteTopics(context, deleteTopicsRequest.data(), request.context().apiVersion(), this.authHelper().authorize(x$1, x$2, x$3, x$4, x$6, x$5, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)n -> n)).handle((results, exception) -> {
            ControllerApis.$anonfun$handleDeleteTopics$5(this, controllerMutationQuota, request, deleteTopicsRequest, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<DeleteTopicsResponseData.DeletableTopicResult>> deleteTopics(ControllerRequestContext context, DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        ArrayList responses = new ArrayList();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
                return;
            }
            if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                return;
            }
            ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        return this.controller().findTopicNames(context, providedIds).thenCompose(topicNames -> {
            void var13_14;
            void var12_13;
            Object object;
            Object object2;
            topicNames.forEach((id, nameOrError) -> {
                if (nameOrError.isError()) {
                    ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                    return;
                }
                toAuthenticate.add(nameOrError.result());
                idToName.put(id, nameOrError.result());
            });
            scala.collection.mutable.Set topicsToAuthenticate = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)toAuthenticate).asScala();
            if (hasClusterAuth) {
                object2 = topicsToAuthenticate.toSet();
                object = topicsToAuthenticate.toSet();
            } else {
                object2 = getDescribableTopics.apply((Object)topicsToAuthenticate);
                object = getDeletableTopics.apply((Object)topicsToAuthenticate);
            }
            scala.collection.immutable.Set set = object;
            Object describable = object2;
            scala.collection.immutable.Set deletable = set;
            void describable2 = var12_13;
            void deletable2 = var13_14;
            Iterator iterator = idToName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Uuid id2 = (Uuid)entry.getKey();
                String name = (String)entry.getValue();
                if (deletable2.contains((Object)name)) continue;
                if (describable2.contains((Object)name)) {
                    ControllerApis.appendResponse$1(name, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                } else {
                    ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                }
                iterator.remove();
            }
            return this.controller().findTopicIds(context, (Collection)providedNames).thenCompose(arg_0 -> ControllerApis.$anonfun$deleteTopics$7(this, (scala.collection.immutable.Set)describable2, (scala.collection.immutable.Set)deletable2, duplicateProvidedIds, idToName, context, responses, arg_0));
        });
    }

    public CompletableFuture<BoxedUnit> handleCreateTopics(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)6);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createTopicsRequest.data().timeoutMs()), this.controllerMutationQuotaRecorderFor(controllerMutationQuota));
        RequestContext x$1 = request.context();
        AclOperation x$2 = AclOperation.CREATE;
        ResourceType x$3 = ResourceType.CLUSTER;
        String x$4 = "kafka-cluster";
        boolean x$5 = false;
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.createTopics(context, createTopicsRequest.data(), this.authHelper().authorize(x$1, x$2, x$3, x$4, x$6, x$5, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)names -> {
            RequestContext x$8 = request.context();
            AclOperation x$9 = AclOperation.DESCRIBE_CONFIGS;
            ResourceType x$10 = ResourceType.TOPIC;
            boolean x$12 = false;
            boolean x$13 = this.authHelper().filterByAuthorized$default$5();
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
            return this.authHelper().filterByAuthorized(x$8, x$9, x$10, names, x$13, x$12, x$14);
        }).handle((result, exception) -> {
            ControllerApis.$anonfun$handleCreateTopics$5(this, controllerMutationQuota, request, createTopicsRequest, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    private Consumer<Integer> controllerMutationQuotaRecorderFor(ControllerMutationQuota controllerMutationQuota) {
        return new Consumer<Integer>(null, controllerMutationQuota){
            private final ControllerMutationQuota controllerMutationQuota$3;

            public Consumer<Integer> andThen(Consumer<? super Integer> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(Integer permits) {
                this.controllerMutationQuota$3.record(permits.doubleValue());
            }
            {
                this.controllerMutationQuota$3 = controllerMutationQuota$3;
            }
        };
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics) {
        HashSet topicNames = new HashSet();
        HashSet duplicateTopicNames = new HashSet();
        request.topics().forEach(topicData -> {
            if (!duplicateTopicNames.contains(topicData.name())) {
                if (!topicNames.add(topicData.name())) {
                    topicNames.remove(topicData.name());
                    duplicateTopicNames.add(topicData.name());
                    return;
                }
                return;
            }
        });
        if (topicNames.contains("__cluster_metadata")) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Rejecting creation of internal topic ").append("__cluster_metadata").toString());
        }
        scala.collection.mutable.Set allowedTopicNames = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topicNames).asScala()).diff((GenSet)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"})));
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? allowedTopicNames : (Set)getCreatableTopics.apply((Object)allowedTopicNames);
        java.util.Set describableTopicNames = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)getDescribableTopics.apply((Object)allowedTopicNames)).asJava();
        CreateTopicsRequestData effectiveRequest = request.duplicate();
        Iterator iterator = effectiveRequest.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (!duplicateTopicNames.contains(creatableTopic.name()) && authorizedTopicNames.contains((Object)creatableTopic.name())) continue;
            iterator.remove();
        }
        return this.controller().createTopics(context, effectiveRequest, describableTopicNames).thenApply(arg_0 -> ControllerApis.$anonfun$createTopics$3(duplicateTopicNames, topicNames, (Set)authorizedTopicNames, arg_0));
    }

    public CompletableFuture<BoxedUnit> handleApiVersionsRequest(RequestChannel.Request request) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> apiVersionRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)Errors.UNSUPPORTED_VERSION.exception()));
        } else if (!apiVersionRequest.isValid()) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> apiVersionRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)Errors.INVALID_REQUEST.exception()));
        } else {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleApiVersionsRequest$3(this, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public ApiError authorizeAlterResource(RequestContext requestContext, ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, resource.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED);
        }
        return new ApiError(Errors.INVALID_REQUEST, new StringBuilder(26).append("Unexpected resource type ").append(type).append(".").toString());
    }

    public CompletableFuture<BoxedUnit> handleLegacyAlterConfigs(RequestChannel.Request request) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap configs = new HashMap();
                resource.configs().forEach(config -> configs.put(config.name(), config.value()));
                if (configChanges.put(configResource, configs) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().legacyAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleLegacyAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable & scala.Serializable handleRaftRequest_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleElectLeaders(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ElectLeadersRequest electLeadersRequest = (ElectLeadersRequest)request.body(ClassTag$.MODULE$.apply(ElectLeadersRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)electLeadersRequest.data().timeoutMs()));
        return this.controller().electLeaders(context, electLeadersRequest.data()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleElectLeaders$1(this, request, electLeadersRequest, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionRequest(RequestChannel.Request request) {
        AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        return this.controller().alterPartition(context, alterPartitionRequest.data()).handle((result, exception) -> {
            ControllerApis.$anonfun$handleAlterPartitionRequest$1(this, alterPartitionRequest, request, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)(this.config().brokerHeartbeatIntervalMs() / 2)));
        return this.controller().processBrokerHeartbeat(context, heartbeatRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().unregisterBroker(context, decommissionRequest.data().brokerId()).handle((x$6, e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$6, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().registerBroker(context, registrationRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private CompletableFuture<BoxedUnit> handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            AbstractResponse $anonfun$handleRaftRequest$1_response = exception != null ? handleRaftRequest_requestBody.getErrorResponse(exception) : (AbstractResponse)handleRaftRequest_buildResponse.apply(responseData);
            this.requestHelper().sendResponseExemptThrottle(request, $anonfun$handleRaftRequest$1_response, this.requestHelper().sendResponseExemptThrottle$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER_CONFIGS);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().alterClientQuotas(context, (Collection)quotaRequest.entries(), quotaRequest.validateOnly()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAlterClientQuotas$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap altersByName = new HashMap();
                resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
                if (configChanges.put(configResource, altersByName) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().incrementalAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleIncrementalAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleCreatePartitions(RequestChannel.Request request) {
        CreatePartitionsRequest createPartitionsRequest = (CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)3);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createPartitionsRequest.data().timeoutMs()), this.controllerMutationQuotaRecorderFor(controllerMutationQuota));
        return this.createPartitions(context, createPartitionsRequest.data(), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable & scala.Serializable)topics -> this.filterAlterAuthorizedTopics$1((Iterable)topics, request)).handle((responses, exception) -> {
            ControllerApis.$anonfun$handleCreatePartitions$3(this, request, controllerMutationQuota, responses, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, CreatePartitionsRequestData request, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getAlterAuthorizedTopics) {
        ArrayList responses = new ArrayList();
        HashSet duplicateTopicNames = new HashSet();
        HashSet topicNames = new HashSet();
        request.topics().forEach(topic -> {
            if (!topicNames.add(topic.name())) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."));
            topicNames.remove(topicName);
        });
        scala.collection.immutable.Set authorizedTopicNames = (scala.collection.immutable.Set)getAlterAuthorizedTopics.apply(CollectionConverters$.MODULE$.asScalaSetConverter(topicNames).asScala());
        ArrayList topics = new ArrayList();
        topicNames.forEach(topicName -> {
            if (authorizedTopicNames.contains(topicName)) {
                topics.add(request.topics().find(topicName));
                return;
            }
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
        });
        return this.controller().createPartitions(context, topics, request.validateOnly()).thenApply(results -> {
            results.forEach(response -> responses.add(response));
            return responses;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionReassignments(RequestChannel.Request request) {
        AlterPartitionReassignmentsRequest alterRequest = (AlterPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)alterRequest.data().timeoutMs()));
        return this.controller().alterPartitionReassignments(context, alterRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleAlterPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterUserScramCredentials(RequestChannel.Request request) {
        AlterUserScramCredentialsRequest alterRequest = (AlterUserScramCredentialsRequest)request.body(ClassTag$.MODULE$.apply(AlterUserScramCredentialsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().alterUserScramCredentials(context, alterRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleAlterUserScramCredentials$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public boolean allowTokenRequests(RequestChannel.Request request) {
        block4: {
            block2: {
                SecurityProtocol protocol;
                block3: {
                    protocol = request.context().securityProtocol;
                    if (request.context().principal.tokenAuthenticated()) break block2;
                    if (request.isForwarded()) break block3;
                    SecurityProtocol securityProtocol = protocol;
                    SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                    if (!(securityProtocol == null ? securityProtocol2 != null : !securityProtocol.equals(securityProtocol2))) break block2;
                }
                if (request.isForwarded()) break block4;
                SecurityProtocol securityProtocol = protocol;
                SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
                if (securityProtocol != null ? !securityProtocol.equals(securityProtocol3) : securityProtocol3 != null) break block4;
                KafkaPrincipal kafkaPrincipal = request.context().principal;
                KafkaPrincipal kafkaPrincipal2 = KafkaPrincipal.ANONYMOUS;
                if (kafkaPrincipal != null ? !kafkaPrincipal.equals(kafkaPrincipal2) : kafkaPrincipal2 != null) break block4;
            }
            return false;
        }
        return true;
    }

    public CompletableFuture<BoxedUnit> handleCreateDelegationTokenRequest(RequestChannel.Request request) {
        KafkaPrincipal owner;
        CreateDelegationTokenRequest createTokenRequest = (CreateDelegationTokenRequest)request.body(ClassTag$.MODULE$.apply(CreateDelegationTokenRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        KafkaPrincipal requester = request.context().principal;
        String ownerPrincipalName = createTokenRequest.data().ownerPrincipalName();
        String ownerPrincipalType = createTokenRequest.data().ownerPrincipalType();
        KafkaPrincipal kafkaPrincipal = owner = ownerPrincipalName == null || ownerPrincipalName.isEmpty() ? request.context().principal : new KafkaPrincipal(ownerPrincipalType, ownerPrincipalName);
        if (!this.allowTokenRequests(request)) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreateDelegationTokenRequest$1(request, owner, requester, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        if (!owner.equals((Object)requester) && !this.authHelper().authorize(request.context(), AclOperation.CREATE_TOKENS, ResourceType.USER, owner.toString(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreateDelegationTokenRequest$2(request, owner, requester, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().createDelegationToken(context, createTokenRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleCreateDelegationTokenRequest$3(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleRenewDelegationTokenRequest(RequestChannel.Request request) {
        RenewDelegationTokenRequest renewTokenRequest = (RenewDelegationTokenRequest)request.body(ClassTag$.MODULE$.apply(RenewDelegationTokenRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        if (!this.allowTokenRequests(request)) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleRenewDelegationTokenRequest$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().renewDelegationToken(context, renewTokenRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleRenewDelegationTokenRequest$2(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleExpireDelegationTokenRequest(RequestChannel.Request request) {
        ExpireDelegationTokenRequest expireTokenRequest = (ExpireDelegationTokenRequest)request.body(ClassTag$.MODULE$.apply(ExpireDelegationTokenRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        if (!this.allowTokenRequests(request)) {
            this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleExpireDelegationTokenRequest$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().expireDelegationToken(context, expireTokenRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleExpireDelegationTokenRequest$2(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleListPartitionReassignments(RequestChannel.Request request) {
        ListPartitionReassignmentsRequest listRequest = (ListPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(ListPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().listPartitionReassignments(context, listRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleListPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAllocateProducerIdsRequest(RequestChannel.Request request) {
        AllocateProducerIdsRequest allocatedProducerIdsRequest = (AllocateProducerIdsRequest)request.body(ClassTag$.MODULE$.apply(AllocateProducerIdsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().allocateProducerIds(context, allocatedProducerIdsRequest.data()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAllocateProducerIdsRequest$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUpdateFeatures(RequestChannel.Request request) {
        UpdateFeaturesRequest updateFeaturesRequest = (UpdateFeaturesRequest)request.body(ClassTag$.MODULE$.apply(UpdateFeaturesRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().updateFeatures(context, updateFeaturesRequest.data()).handle((response, exception) -> {
            ControllerApis.$anonfun$handleUpdateFeatures$1(this, request, response, exception);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$3) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$4) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleDeleteTopics$6(Throwable exception$2, DeleteTopicsRequest deleteTopicsRequest$1, List results$1, int throttleTimeMs) {
        if (exception$2 != null) {
            return deleteTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$2);
        }
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(results$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleDeleteTopics$5(ControllerApis $this, ControllerMutationQuota controllerMutationQuota$1, RequestChannel.Request request$2, DeleteTopicsRequest deleteTopicsRequest$1, List results, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$1, request$2, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$6(exception, deleteTopicsRequest$1, results, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$deleteTopics$7(ControllerApis $this, scala.collection.immutable.Set describable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, ControllerRequestContext context$1, ArrayList responses$1, Map topicIds) {
        topicIds.forEach((name, idOrError) -> {
            if (!describable$1.contains(name)) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
                return;
            }
            if (idOrError.isError()) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$1);
                return;
            }
            if (deletable$1.contains(name)) {
                Uuid id = (Uuid)idOrError.result();
                if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                    duplicateProvidedIds$1.add(id);
                    idToName$1.remove(id);
                    ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$1);
                    return;
                }
                return;
            }
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
        });
        return $this.controller().deleteTopics(context$1, idToName$1.keySet()).thenApply(idToError -> {
            idToError.forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName$1.get(id), id, error, responses$1));
            Collections.shuffle(responses$1);
            return responses$1;
        });
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleCreateTopics$6(Throwable exception$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result$1, int throttleTimeMs) {
        if (exception$3 != null) {
            return createTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$3);
        }
        result$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(result$1);
    }

    public static final /* synthetic */ void $anonfun$handleCreateTopics$5(ControllerApis $this, ControllerMutationQuota controllerMutationQuota$2, RequestChannel.Request request$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$2, request$3, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$6(exception, createTopicsRequest$1, result, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    public static final /* synthetic */ CreateTopicsResponseData $anonfun$createTopics$3(HashSet duplicateTopicNames$1, HashSet topicNames$1, Set authorizedTopicNames$1, CreateTopicsResponseData response) {
        duplicateTopicNames$1.forEach(name -> response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name.")));
        topicNames$1.forEach(name -> {
            if (!authorizedTopicNames$1.contains(name)) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed."));
                return;
            }
        });
        return response;
    }

    public static final /* synthetic */ ApiVersionsResponse $anonfun$handleApiVersionsRequest$3(ControllerApis $this, int requestThrottleMs) {
        return $this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    public static final /* synthetic */ AlterConfigsResponse $anonfun$handleLegacyAlterConfigs$5(AlterConfigsResponseData response$2, int throttleMs) {
        return new AlterConfigsResponse(response$2.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleLegacyAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$4, AlterConfigsResponseData response$2, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$4, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$2.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$4, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleMs -> ControllerApis.$anonfun$handleLegacyAlterConfigs$5(response$2, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ ElectLeadersResponse $anonfun$handleElectLeaders$3(ElectLeadersResponseData responseData$3, int throttleMs) {
        return new ElectLeadersResponse(responseData$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleElectLeaders$1(ControllerApis $this, RequestChannel.Request request$5, ElectLeadersRequest electLeadersRequest$1, ElectLeadersResponseData responseData, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleMs -> electLeadersRequest$1.getErrorResponse(BoxesRunTime.unboxToInt((Object)throttleMs), exception));
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleMs -> ControllerApis.$anonfun$handleElectLeaders$3(responseData, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionRequest$1(ControllerApis $this, AlterPartitionRequest alterPartitionRequest$1, RequestChannel.Request request$6, AlterPartitionResponseData result, Throwable exception) {
        AlterPartitionResponse response = exception != null ? alterPartitionRequest$1.getErrorResponse(exception) : new AlterPartitionResponse(result);
        $this.requestHelper().sendResponseExemptThrottle(request$6, (AbstractResponse)response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    private static final BrokerHeartbeatResponse createResponseCallback$1(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$7, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$7, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$2(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$8, Void x$6, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$3(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$9, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$9, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ void $anonfun$handleRaftRequest$1(ControllerApis $this, AbstractRequest requestBody$1, Function1 buildResponse$1, RequestChannel.Request request$10, ApiMessage responseData, Throwable exception) {
        AbstractResponse response = exception != null ? requestBody$1.getErrorResponse(exception) : (AbstractResponse)buildResponse$1.apply((Object)responseData);
        $this.requestHelper().sendResponseExemptThrottle(request$10, response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$2, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$2, (int)requestThrottleMs);
    }

    public static final /* synthetic */ void $anonfun$handleAlterClientQuotas$1(ControllerApis $this, RequestChannel.Request request$11, Map results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$11, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$11, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$5(IncrementalAlterConfigsResponseData response$3, int throttleMs) {
        return new IncrementalAlterConfigsResponse(response$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleIncrementalAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$12, IncrementalAlterConfigsResponseData response$3, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$12, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$3.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$12, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)throttleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$5(response$3, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    private final scala.collection.immutable.Set filterAlterAuthorizedTopics$1(Iterable topics, RequestChannel.Request request$13) {
        return this.authHelper().filterByAuthorized(request$13.context(), AclOperation.ALTER, ResourceType.TOPIC, topics, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable & scala.Serializable)n -> n);
    }

    public static final /* synthetic */ CreatePartitionsResponse $anonfun$handleCreatePartitions$4(List responses$2, int requestThrottleMs) {
        CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(responses$2).setThrottleTimeMs(requestThrottleMs);
        return new CreatePartitionsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleCreatePartitions$3(ControllerApis $this, RequestChannel.Request request$13, ControllerMutationQuota controllerMutationQuota$4, List responses, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$13, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$4, request$13, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreatePartitions$4(responses, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AlterPartitionReassignmentsResponse $anonfun$handleAlterPartitionReassignments$2(AlterPartitionReassignmentsResponseData response$4, int requestThrottleMs) {
        return new AlterPartitionReassignmentsResponse(response$4.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$15, AlterPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$15, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AlterUserScramCredentialsResponse $anonfun$handleAlterUserScramCredentials$2(AlterUserScramCredentialsResponseData response$5, int requestThrottleMs) {
        return new AlterUserScramCredentialsResponse(response$5.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleAlterUserScramCredentials$1(ControllerApis $this, RequestChannel.Request request$16, AlterUserScramCredentialsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$16, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterUserScramCredentials$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ CreateDelegationTokenResponse $anonfun$handleCreateDelegationTokenRequest$1(RequestChannel.Request request$17, KafkaPrincipal owner$1, KafkaPrincipal requester$1, int requestThrottleMs) {
        return CreateDelegationTokenResponse.prepareResponse((int)request$17.context().requestVersion(), (int)requestThrottleMs, (Errors)Errors.DELEGATION_TOKEN_REQUEST_NOT_ALLOWED, (KafkaPrincipal)owner$1, (KafkaPrincipal)requester$1);
    }

    public static final /* synthetic */ CreateDelegationTokenResponse $anonfun$handleCreateDelegationTokenRequest$2(RequestChannel.Request request$17, KafkaPrincipal owner$1, KafkaPrincipal requester$1, int requestThrottleMs) {
        return CreateDelegationTokenResponse.prepareResponse((int)request$17.context().requestVersion(), (int)requestThrottleMs, (Errors)Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED, (KafkaPrincipal)owner$1, (KafkaPrincipal)requester$1);
    }

    public static final /* synthetic */ CreateDelegationTokenResponse $anonfun$handleCreateDelegationTokenRequest$4(RequestChannel.Request request$17, CreateDelegationTokenResponseData response$6, int requestThrottleMs) {
        return CreateDelegationTokenResponse.prepareResponse((int)request$17.context().requestVersion(), (int)requestThrottleMs, (Errors)Errors.forCode((short)response$6.errorCode()), (KafkaPrincipal)new KafkaPrincipal(response$6.principalType(), response$6.principalName()), (KafkaPrincipal)new KafkaPrincipal(response$6.tokenRequesterPrincipalType(), response$6.tokenRequesterPrincipalName()), (long)response$6.issueTimestampMs(), (long)response$6.expiryTimestampMs(), (long)response$6.maxTimestampMs(), (String)response$6.tokenId(), (ByteBuffer)ByteBuffer.wrap(response$6.hmac()));
    }

    public static final /* synthetic */ void $anonfun$handleCreateDelegationTokenRequest$3(ControllerApis $this, RequestChannel.Request request$17, CreateDelegationTokenResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$17, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreateDelegationTokenRequest$4(request$17, response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ RenewDelegationTokenResponse $anonfun$handleRenewDelegationTokenRequest$1(int requestThrottleMs) {
        return new RenewDelegationTokenResponse(new RenewDelegationTokenResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.DELEGATION_TOKEN_REQUEST_NOT_ALLOWED.code()).setExpiryTimestampMs((long)DelegationTokenManager$.MODULE$.ErrorTimestamp()));
    }

    public static final /* synthetic */ RenewDelegationTokenResponse $anonfun$handleRenewDelegationTokenRequest$3(RenewDelegationTokenResponseData response$7, int requestThrottleMs) {
        return new RenewDelegationTokenResponse(response$7.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleRenewDelegationTokenRequest$2(ControllerApis $this, RequestChannel.Request request$18, RenewDelegationTokenResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$18, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleRenewDelegationTokenRequest$3(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ ExpireDelegationTokenResponse $anonfun$handleExpireDelegationTokenRequest$1(int requestThrottleMs) {
        return new ExpireDelegationTokenResponse(new ExpireDelegationTokenResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.DELEGATION_TOKEN_REQUEST_NOT_ALLOWED.code()).setExpiryTimestampMs((long)DelegationTokenManager$.MODULE$.ErrorTimestamp()));
    }

    public static final /* synthetic */ ExpireDelegationTokenResponse $anonfun$handleExpireDelegationTokenRequest$3(ExpireDelegationTokenResponseData response$8, int requestThrottleMs) {
        return new ExpireDelegationTokenResponse(response$8.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleExpireDelegationTokenRequest$2(ControllerApis $this, RequestChannel.Request request$19, ExpireDelegationTokenResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$19, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleExpireDelegationTokenRequest$3(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ ListPartitionReassignmentsResponse $anonfun$handleListPartitionReassignments$2(ListPartitionReassignmentsResponseData response$9, int requestThrottleMs) {
        return new ListPartitionReassignmentsResponse(response$9.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleListPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$20, ListPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$20, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleListPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AllocateProducerIdsResponse $anonfun$handleAllocateProducerIdsRequest$2(AllocateProducerIdsResponseData results$3, int requestThrottleMs) {
        results$3.setThrottleTimeMs(requestThrottleMs);
        return new AllocateProducerIdsResponse(results$3);
    }

    public static final /* synthetic */ void $anonfun$handleAllocateProducerIdsRequest$1(ControllerApis $this, RequestChannel.Request request$21, AllocateProducerIdsResponseData results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$21, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$21, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAllocateProducerIdsRequest$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ UpdateFeaturesResponse $anonfun$handleUpdateFeatures$2(UpdateFeaturesResponseData response$10, int requestThrottleMs) {
        return new UpdateFeaturesResponse(response$10.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUpdateFeatures$1(ControllerApis $this, RequestChannel.Request request$22, UpdateFeaturesResponseData response, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$22, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$22, (Function1<Object, AbstractResponse>)(Function1 & Serializable & scala.Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleUpdateFeatures$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        ApiRequestHandler.$init$(this);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(25).append("[ControllerApis nodeId=").append(config.nodeId()).append("] ").toString());
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.aclApis = new AclApis(this.authHelper(), authorizer, this.requestHelper(), "controller", config);
    }
}

