/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\f\u0019\u0001uA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u00033\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\f\u0001B\u0001B\u0003%q\nC\u0003\\\u0001\u0011\u0005A\fC\u0004f\u0001\t\u0007I\u0011\u00024\t\r9\u0004\u0001\u0015!\u0003h\u0011\u001dy\u0007A1A\u0005\u0002ADa! \u0001!\u0002\u0013\t\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011\u0004\u0001C\u0002\u0013\u0005\u00111\u0004\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002\u001e!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011AA'\u0005]Y\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!>|GN\u0003\u0002\u001a5\u000511/\u001a:wKJT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dR\u0012!B;uS2\u001c\u0018BA\u0015'\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002YA\u0011q$L\u0005\u0003]\u0001\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u000e\u0002\u000f9,Go^8sW&\u0011q\u0007\u000e\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0013\u0001B1qSN,\u0012a\u000f\t\u0003yuj\u0011\u0001G\u0005\u0003}a\u0011\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003\u0015\t\u0007/[:!\u0003\u0011!\u0018.\\3\u0011\u0005\t[U\"A\"\u000b\u0005\u001d\"%BA#G\u0003\u0019\u0019w.\\7p]*\u00111d\u0012\u0006\u0003\u0011&\u000ba!\u00199bG\",'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0007\n!A+[7f\u0003)qW/\u001c+ie\u0016\fGm]\u0001 e\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003Z<\u0017\n\u001a7f\u001b\u0016$(/[2OC6,\u0007C\u0001)X\u001d\t\tV\u000b\u0005\u0002SA5\t1K\u0003\u0002U9\u00051AH]8pizJ!A\u0016\u0011\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-\u0002\na\u0003\\8h\u0003:$G\u000b\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011usv\fY1cG\u0012\u0004\"\u0001\u0010\u0001\t\u000b)Z\u0001\u0019\u0001\u0017\t\u000bAZ\u0001\u0019\u0001\u001a\t\u000beZ\u0001\u0019A\u001e\t\u000b\u0001[\u0001\u0019A!\t\u000b5[\u0001\u0019\u0001\u0017\t\u000b9[\u0001\u0019A(\t\u000bi[\u0001\u0019A(\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0003\u001d\u0004\"\u0001\u001b7\u000e\u0003%T!A[6\u0002\u000f5,GO]5dg*\u0011\u0011DR\u0005\u0003[&\u0014\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005qA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,W#A9\u0011\u0005I\\X\"A:\u000b\u0005Q,\u0018AB1u_6L7M\u0003\u0002wo\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005aL\u0018\u0001B;uS2T\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}g\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fq\u0002\u001e5sK\u0006$\u0007k\\8m'&TX\rI\u0001\u0013C\u001e<'/Z4bi\u0016LE\r\\3NKR,'/\u0006\u0002\u0002\u0002A!\u00111AA\n\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001B2pe\u0016T1A[A\u0006\u0015\u0011\ti!a\u0004\u0002\re\fW.\\3s\u0015\t\t\t\"A\u0002d_6LA!!\u0006\u0002\u0006\t)Q*\u001a;fe\u0006\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA\u0005I!/\u001e8oC\ndWm]\u000b\u0003\u0003;\u0001b!a\b\u0002*\u00055RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0005\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0005\"aC!se\u0006L()\u001e4gKJ\u00042\u0001PA\u0018\u0013\r\t\t\u0004\u0007\u0002\u0014\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u000beVtg.\u00192mKN\u0004\u0013!D2sK\u0006$X\rS1oI2,'\u000f\u0006\u0003\u0002:\u0005}\u0002cA\u0010\u0002<%\u0019\u0011Q\b\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0003\"\u0002\u0019\u0001\u0017\u0002\u0005%$\u0017\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\tI$a\u0012\t\r\u0005%S\u00031\u0001-\u0003\u001dqWm^*ju\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003s\u0001")
public class KafkaRequestHandlerPool
implements Logging {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.metricsGroup().newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
    }
}

