/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\f\u0018\u0001yAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005B-BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00034\u0011\u0019q\u0004\u0001)A\u0005i!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002+\u0001A\u0003%\u0011\tC\u0005V\u0001\u0001\u0007\t\u0019!C\u0005-\"IA\f\u0001a\u0001\u0002\u0004%I!\u0018\u0005\nG\u0002\u0001\r\u0011!Q!\n]C\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011\u00023\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0013I\u0007\"C6\u0001\u0001\u0004\u0005\t\u0015)\u0003f\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tY\u0001\u0001C)\u0003\u001bAq!a\b\u0001\t#\n\t\u0003C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\u000f\u0001\u0005\u0002\u0005U$AI!e[&tg)\u001a8dKB\u0013x\u000eZ;dKJ\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u00193\u0005)\u0011\rZ7j]*\u0011!dG\u0001\u0006W\u000647.\u0019\u0006\u00029\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\"S\"A\u0011\u000b\u0005\t\u001a\u0013aA1qS*\t!$\u0003\u0002&C\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002/\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#aA%oi\u0006IAo\u001c9jG:\u000bW.Z\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB*ue&tw-\u0001\u0006u_BL7MT1nK\u0002\nQ\u0001\u001e=o\u0013\u0012\fa\u0001\u001e=o\u0013\u0012\u0004\u0013A\u0002:fG>\u0014H-F\u0001B!\u0011\u0011EJ\u0014(\u000e\u0003\rS!\u0001R#\u0002\u0011A\u0014x\u000eZ;dKJT!AR$\u0002\u000f\rd\u0017.\u001a8ug*\u0011!\u0004\u0013\u0006\u0003\u0013*\u000ba!\u00199bG\",'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\u0007\nq\u0001K]8ek\u000e,'OU3d_J$\u0007cA\u0017P#&\u0011\u0001K\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003[IK!a\u0015\u0018\u0003\t\tKH/Z\u0001\be\u0016\u001cwN\u001d3!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0003]\u0003\"\u0001\u0017.\u000e\u0003eS!\u0001G#\n\u0005mK&!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\u0005y\u000b\u0007CA\u0017`\u0013\t\u0001gF\u0001\u0003V]&$\bb\u00022\u000b\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0014\u0001D1e[&t7\t\\5f]R\u0004S#A3\u0011\t\t3gJT\u0005\u0003O\u000e\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHC\u00010k\u0011\u001d\u0011W\"!AA\u0002\u0015\f\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005ys\u0007\"B8\u0010\u0001\u0004\u0001\u0018\u0001\u0003;fgRLeNZ8\u0011\u0005E<X\"\u0001:\u000b\u0005\t\u001a(B\u0001;v\u0003\u001dQW\u000f]5uKJT!A\u001e&\u0002\u000b),h.\u001b;\n\u0005a\u0014(\u0001\u0003+fgRLeNZ8)\u0005=Q\bCA9|\u0013\ta(O\u0001\u0006CK\u001a|'/Z#bG\"\fqb\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006a\nA!\u001e;jY&!\u0011\u0011BA\u0002\u0005)\u0001&o\u001c9feRLWm]\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0007y\u000by\u0001C\u0004\u0002\u0012E\u0001\r!a\u0005\u0002\u000bA\u0014x\u000e]:\u0011\u000b\u0005U\u00111D@\u000e\u0005\u0005]!bAA\r]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\u0004'\u0016\f\u0018AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0005\u0005M\u0011\u0001\u0003;fCJ$un\u001e8\u0015\u0003yC3aEA\u0015!\r\t\u00181F\u0005\u0004\u0003[\u0011(!C!gi\u0016\u0014X)Y2i\u0003q!Xm\u001d;GK:\u001cW-\u00114uKJ\u0004&o\u001c3vG\u0016\u00148i\\7nSR$2AXA\u001a\u0011\u001d\t)\u0004\u0006a\u0001\u0003o\ta!];peVl\u0007\u0003BA\u001d\u0003\u000frA!a\u000f\u0002DA\u0019\u0011Q\b\u0018\u000e\u0005\u0005}\"bAA!;\u00051AH]8pizJ1!!\u0012/\u0003\u0019\u0001&/\u001a3fM&\u00191(!\u0013\u000b\u0007\u0005\u0015c\u0006K\u0004\u0015\u0003\u001b\ni&a\u0018\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005A\u0001O]8wS\u0012,'OC\u0002\u0002XM\fa\u0001]1sC6\u001c\u0018\u0002BA.\u0003#\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA1\u0003K\n#!a\u0019\u0002\u0005i\\\u0017EAA4\u0003\u0015Y'/\u00194uQ\r!\u00121\u000e\t\u0005\u0003[\ny'\u0004\u0002\u0002V%!\u0011\u0011OA+\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001ei\u0016\u001cHOR3oG\u0016\u0014UMZ8sKB\u0013x\u000eZ;dKJ\u001cu.\\7jiR\u0019a,a\u001e\t\u000f\u0005UR\u00031\u0001\u00028!:Q#!\u0014\u0002^\u0005mD\u0006BA1\u0003KB3!FA6Q\u001d\u0001\u0011\u0011QAD\u0003\u0013\u00032!]AB\u0013\r\t)I\u001d\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017%\u0001\u000f")
public class AdminFenceProducersIntegrationTest
extends IntegrationTestHarness {
    private final String topicName;
    private final String txnId;
    private final ProducerRecord<byte[], byte[]> record = new ProducerRecord(this.topicName(), null, (Object)new byte[1]);
    private Admin adminClient;
    private KafkaProducer<byte[], byte[]> producer;

    @Override
    public int brokerCount() {
        return 1;
    }

    private String topicName() {
        return this.topicName;
    }

    private String txnId() {
        return this.txnId;
    }

    private ProducerRecord<byte[], byte[]> record() {
        return this.record;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties producerProps = new Properties();
        producerProps.put("transactional.id", this.txnId());
        producerProps.put("transaction.timeout.ms", "2000");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        this.producer_$eq(this.createProducer(x$2, x$3, producerProps));
        this.adminClient_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
        this.createTopic(this.topicName(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "2000");
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)p -> {
            p.putAll((Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"AdminFenceProducersIntegrationTest");
        Utils.closeQuietly(this.producer(), (String)"AdminFenceProducersIntegrationTest");
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFenceAfterProducerCommit(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(this.record()).get();
        this.producer().commitTransaction();
        this.adminClient().fenceProducers(Collections.singletonList(this.txnId())).all().get();
        this.producer().beginTransaction();
        try {
            this.producer().send(this.record()).get();
            Assertions.fail((String)"expected ProducerFencedException");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException ee) {
            Assertions.assertInstanceOf(ProducerFencedException.class, (Object)ee.getCause());
        }
        catch (Exception exception) {
            throw exception;
        }
        Assertions.assertThrows(ProducerFencedException.class, () -> this.producer().commitTransaction());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFenceBeforeProducerCommit(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(this.record()).get();
        this.adminClient().fenceProducers(Collections.singletonList(this.txnId())).all().get();
        try {
            this.producer().send(this.record()).get();
            Assertions.fail((String)"expected Exception");
        }
        catch (ExecutionException ee) {
            Assertions.assertTrue((ee.getCause() instanceof ProducerFencedException || ee.getCause() instanceof InvalidProducerEpochException ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected ExecutionException cause ").append(ee.getCause()).toString());
        }
        catch (Exception exception) {
            throw exception;
        }
        try {
            this.producer().commitTransaction();
            Assertions.fail((String)"expected Exception");
            return;
        }
        catch (ProducerFencedException producerFencedException) {
            return;
        }
        catch (InvalidProducerEpochException invalidProducerEpochException) {
            return;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public AdminFenceProducersIntegrationTest() {
        this.topicName = "mytopic";
        this.txnId = "mytxnid";
    }
}

