/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.Exit$;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001\u0002#F\u0001)CQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001A\u0002\u0013\u0005A\fC\u0004o\u0001\u0001\u0007I\u0011A8\t\rY\u0004\u0001\u0015)\u0003^\u0011\u001d9\bA1A\u0005\naDq!!\u0005\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u0011q\u0005\u0001!\u0002\u0013\t9\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011q\b\u0001!\u0002\u0013\ti\u0003C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011q\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011\u0011\r\u0001!\u0002\u0013\t)\u0006C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011\u0011\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011\u0011\u000f\u0001!\u0002\u0013\t9\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000f\u0001!\u0002\u0013\t9\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011\u0011\u0010\u0001!\u0002\u0013\t9\u0007C\u0005\u0002|\u0001\u0011\r\u0011\"\u0003\u0002~!A\u0011\u0011\u0014\u0001!\u0002\u0013\ty\bC\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0003\u0002\u001e\"A\u0011Q\u0017\u0001!\u0002\u0013\ty\nC\u0004\u00028\u0002!I!!/\t\u0013\u0005=\u0007!%A\u0005\n\u0005E\u0007\"CAt\u0001\t\u0007I\u0011BAu\u0011!\tY\u000f\u0001Q\u0001\n\u0005m\u0006\"CAw\u0001\t\u0007I\u0011BAx\u0011!\t9\u0010\u0001Q\u0001\n\u0005E\bbCA}\u0001\u0001\u0007\t\u0019!C\u0005\u0003wD1B!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\f!Y!q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA\u007f\u0011-\u0011\t\u0002\u0001a\u0001\u0002\u0004%IAa\u0005\t\u0017\tU\u0001\u00011AA\u0002\u0013%!q\u0003\u0005\f\u00057\u0001\u0001\u0019!A!B\u0013\t\u0019\nC\u0006\u0003\u001e\u0001\u0001\r\u00111A\u0005\n\tM\u0001b\u0003B\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0005CA1B!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014\"9!q\u0005\u0001\u0005B\t%\u0002b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u0005/\u0002A\u0011\u0001B'\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005\u001bBqA!\u001a\u0001\t\u0013\u00119\u0007C\u0005\u0003\u0000\u0001\t\n\u0011\"\u0003\u0003\u0002\"9!Q\u0011\u0001\u0005\n\t\u001d\u0005b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u0005/\u0003A\u0011\u0002BM\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005\u001bBqAa,\u0001\t\u0003\u0011i\u0005C\u0004\u00034\u0002!\tA!\u0014\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!Q\u0018\u0001\u0005\u0002\t5\u0003b\u0002Ba\u0001\u0011\u0005!Q\n\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001bBqAa4\u0001\t\u0003\u0011i\u0005C\u0004\u0003T\u0002!IA!6\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!\u0011\u001f\u0001\u0005\n\tM\bb\u0002B|\u0001\u0011%!\u0011 \u0002\u000f\u0003\u000ed7i\\7nC:$G+Z:u\u0015\t1u)A\u0003bI6LgNC\u0001I\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A&R!\tau*D\u0001N\u0015\tqu)\u0001\u0004tKJ4XM]\u0005\u0003!6\u0013\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\t\u0011V+D\u0001T\u0015\t!v)A\u0003vi&d7/\u0003\u0002W'\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001Z!\tQ\u0006!D\u0001F\u0003\u001d\u0019XM\u001d<feN,\u0012!\u0018\t\u0004=\"\\gBA0f\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0017*\u0001\u0004=e>|GOP\u0005\u0002I\u0006)1oY1mC&\u0011amZ\u0001\ba\u0006\u001c7.Y4f\u0015\u0005!\u0017BA5k\u0005\r\u0019V-\u001d\u0006\u0003M\u001e\u0004\"\u0001\u00147\n\u00055l%aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001\u000f\u001e\t\u0003cJl\u0011aZ\u0005\u0003g\u001e\u0014A!\u00168ji\"9QoAA\u0001\u0002\u0004i\u0016a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%A\u0005qe&t7-\u001b9bYV\t\u0011\u0010E\u0002{\u0003\u001bi\u0011a\u001f\u0006\u0003yv\fA!Y;uQ*\u0011ap`\u0001\tg\u0016\u001cWO]5us*!\u0011\u0011AA\u0002\u0003\u0019\u0019w.\\7p]*\u0019\u0001*!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0011aA8sO&\u0019\u0011qB>\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u000bU\u001bXM]:\u0016\u0005\u0005]\u0001#BA\r\u0003GIXBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013%lW.\u001e;bE2,'bAA\u0011O\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0004'\u0016$\u0018AB+tKJ\u001c\b%A\u0003I_N$8/\u0006\u0002\u0002.A1\u0011\u0011DA\u0012\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003mC:<'BAA\u001d\u0003\u0011Q\u0017M^1\n\t\u0005u\u00121\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002\r!{7\u000f^:!\u0003A\tE\u000e\\8x\u0011>\u001cHoQ8n[\u0006tG-\u0006\u0002\u0002FA)\u0011/a\u0012\u00020%\u0019\u0011\u0011J4\u0003\u000b\u0005\u0013(/Y=\u0002#\u0005cGn\\<I_N$8i\\7nC:$\u0007%A\bEK:L\bj\\:u\u0007>lW.\u00198e\u0003A!UM\\=I_N$8i\\7nC:$\u0007%A\bDYV\u001cH/\u001a:SKN|WO]2f+\t\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tYf`\u0001\te\u0016\u001cx.\u001e:dK&!\u0011qLA-\u0005=\u0011Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017\u0001E\"mkN$XM\u001d*fg>,(oY3!\u00039!v\u000e]5d%\u0016\u001cx.\u001e:dKN,\"!a\u001a\u0011\r\u0005e\u00111EA+\u0003=!v\u000e]5d%\u0016\u001cx.\u001e:dKN\u0004\u0013AD$s_V\u0004(+Z:pkJ\u001cWm]\u0001\u0010\u000fJ|W\u000f\u001d*fg>,(oY3tA\u0005ABK]1og\u0006\u001cG/[8oC2LEMU3t_V\u00148-Z:\u00023Q\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014Vm]8ve\u000e,7\u000fI\u0001\u000f)>\\WM\u001c*fg>,(oY3t\u0003=!vn[3o%\u0016\u001cx.\u001e:dKN\u0004\u0013!D+tKJ\u0014Vm]8ve\u000e,7/\u0001\bVg\u0016\u0014(+Z:pkJ\u001cWm\u001d\u0011\u0002#I+7o\\;sG\u0016$vnQ8n[\u0006tG-\u0006\u0002\u0002\u0000AA\u0011\u0011DAA\u0003\u000b\u000b\u0019*\u0003\u0003\u0002\u0004\u0006m!aA'baB1\u0011qQAH\u0003+rA!!#\u0002\fB\u0011\u0001mZ\u0005\u0004\u0003\u001b;\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0005E%bAAGOB)\u0011/a\u0012\u0002\u0016B!\u0011qQAL\u0013\u0011\ti$!%\u0002%I+7o\\;sG\u0016$vnQ8n[\u0006tG\rI\u0001\u0015%\u0016\u001cx.\u001e:dKR{w\n]3sCRLwN\\:\u0016\u0005\u0005}\u0005\u0003CA\r\u0003\u0003\u000b))!)\u0011\u000fE\f\u0019+a*\u0002\u0014&\u0019\u0011QU4\u0003\rQ+\b\u000f\\33!\u0019\t9)a$\u0002*B!\u00111VAY\u001b\t\tiKC\u0002\u00020~\f1!Y2m\u0013\u0011\t\u0019,!,\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\u0002+I+7o\\;sG\u0016$vn\u00149fe\u0006$\u0018n\u001c8tA\u00051\u0002K]8ek\u000e,'OU3t_V\u00148-\u001a+p\u0003\u000ed7\u000f\u0006\u0003\u0002<\u0006\u0015\u0007\u0003CA\r\u0003\u0003\u000b))!0\u0011\r\u0005\u001d\u0015qRA`!\u0011\tY+!1\n\t\u0005\r\u0017Q\u0016\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0005\u0002H~\u0001\n\u00111\u0001\u0002J\u0006\tRM\\1cY\u0016LE-Z7q_R,gnY3\u0011\u0007E\fY-C\u0002\u0002N\u001e\u0014qAQ8pY\u0016\fg.\u0001\u0011Qe>$WoY3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197tI\u0011,g-Y;mi\u0012\nTCAAjU\u0011\tI-!6,\u0005\u0005]\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!9h\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\fYNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\facQ8ogVlWM\u001d*fg>,(oY3U_\u0006\u001bGn]\u000b\u0003\u0003w\u000bqcQ8ogVlWM\u001d*fg>,(oY3U_\u0006\u001bGn\u001d\u0011\u0002'\rkG\rV8SKN|WO]2fgR{\u0017i\u00197\u0016\u0005\u0005E\b\u0003CA\r\u0003\u0003\u000b\u0019*a=\u0011\u0011\u0005\u001d\u0015Q_AC\u0003{KA!a!\u0002\u0012\u0006!2)\u001c3U_J+7o\\;sG\u0016\u001cHk\\!dY\u0002\n1B\u0019:pW\u0016\u0014\bK]8qgV\u0011\u0011Q \t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AA\u001c\u0003\u0011)H/\u001b7\n\t\t\u001d!\u0011\u0001\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018a\u00042s_.,'\u000f\u0015:paN|F%Z9\u0015\u0007A\u0014i\u0001\u0003\u0005vM\u0005\u0005\t\u0019AA\u007f\u00031\u0011'o\\6feB\u0013x\u000e]:!\u0003\u0019Q8.\u0011:hgV\u0011\u00111S\u0001\u000bu.\f%oZ:`I\u0015\fHc\u00019\u0003\u001a!AQ/KA\u0001\u0002\u0004\t\u0019*A\u0004{W\u0006\u0013xm\u001d\u0011\u0002\u0013\u0005$W.\u001b8Be\u001e\u001c\u0018!D1e[&t\u0017I]4t?\u0012*\u0017\u000fF\u0002q\u0005GA\u0001\"\u001e\u0017\u0002\u0002\u0003\u0007\u00111S\u0001\u000bC\u0012l\u0017N\\!sON\u0004\u0013!B:fiV\u0003Hc\u00019\u0003,!9!Q\u0006\u0018A\u0002\t=\u0012\u0001\u0003;fgRLeNZ8\u0011\t\tE\"qH\u0007\u0003\u0005gQAA!\u000e\u00038\u0005\u0019\u0011\r]5\u000b\t\te\"1H\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011i$!\u0003\u0002\u000b),h.\u001b;\n\t\t\u0005#1\u0007\u0002\t)\u0016\u001cH/\u00138g_\"\u001aaF!\u0012\u0011\t\tE\"qI\u0005\u0005\u0005\u0013\u0012\u0019D\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002a\"\u001aqF!\u0015\u0011\t\tE\"1K\u0005\u0005\u0005+\u0012\u0019DA\u0005BMR,'/R1dQ\u0006AB/Z:u\u0003\u000ed7\t\\5XSRD\u0017)\u001e;i_JL'0\u001a:)\u0007A\u0012Y\u0006\u0005\u0003\u00032\tu\u0013\u0002\u0002B0\u0005g\u0011A\u0001V3ti\u00061B/Z:u\u0003\u000ed7\t\\5XSRD\u0017\tZ7j]\u0006\u0003\u0016\nK\u00022\u00057\nAb\u0019:fCR,7+\u001a:wKJ$2\u0001\u001dB5\u0011%\u0011YG\rI\u0001\u0002\u0004\u0011i'A\u0007d_6l\u0017M\u001c3D_:4\u0017n\u001a\t\u0006c\n=$1O\u0005\u0004\u0005c:'AB(qi&|g\u000e\u0005\u0003\u0003v\tmTB\u0001B<\u0015\u0011\u0011I(a\u000e\u0002\u0005%|\u0017\u0002\u0002B?\u0005o\u0012AAR5mK\u000612M]3bi\u0016\u001cVM\u001d<fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0004*\"!QNAk\u0003!\u0019\u0017\r\u001c7NC&tG\u0003\u0002BE\u0005\u0017\u0003r!]AR\u0003+\u000b)\nC\u0004\u0003\u000eR\u0002\r!a%\u0002\t\u0005\u0014xm]\u0001\u000bi\u0016\u001cH/Q2m\u00072LGc\u00019\u0003\u0014\"9!QS\u001bA\u0002\u0005M\u0015aB2nI\u0006\u0013xm]\u0001\u0015CN\u001cXM\u001d;PkR\u0004X\u000f^\"p]R\f\u0017N\\:\u0015\u0013A\u0014YJa(\u0003$\n\u001d\u0006b\u0002BOm\u0001\u0007\u0011QS\u0001\u0007aJ,g-\u001b=\t\u000f\t\u0005f\u00071\u0001\u0002\u0006\u0006I!/Z:pkJ\u001cWm\u001d\u0005\b\u0005K3\u0004\u0019AAJ\u0003-\u0011Xm]8ve\u000e,7)\u001c3\t\u000f\t%f\u00071\u0001\u0002\u0016\u00061q.\u001e;qkR\fQ\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u00148\t\\5XSRD\u0017)\u001e;i_JL'0\u001a:)\u0007]\u0012Y&A\u0012uKN$\bK]8ek\u000e,'oQ8ogVlWM]\"mS^KG\u000f[!e[&t\u0017\tU%)\u0007a\u0012Y&\u0001\fuKN$\u0018i\u00197DY&<\u0016\u000e\u001e5DY&,g\u000e^%eQ\rI$1L\u0001\u0018i\u0016\u001cH\u000f\u0015:pIV\u001cWM]\"p]N,X.\u001a:DY&$2\u0001\u001dB^\u0011\u001d\u0011)J\u000fa\u0001\u0003'\u000b\u0011\u0006^3ti\u0006\u001bGn](o!J,g-\u001b=fIJ+7o\\;sG\u0016\u001cx+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014\bfA\u001e\u0003\\\u00059C/Z:u\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dKN<\u0016\u000e\u001e5BI6Lg.\u0011)JQ\ra$1L\u0001\u001ci\u0016\u001cH/Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-Z:\u0015\u0007A\u0014I\rC\u0004\u0003\u0016v\u0002\r!a%\u0002;Q,7\u000f^%om\u0006d\u0017\u000eZ!vi\"|'/\u001b>feB\u0013x\u000e]3sifD3A\u0010B.\u0003A!Xm\u001d;QCR$XM\u001d8UsB,7\u000fK\u0002@\u00057\n!\u0002^3tiJ+Wn\u001c<f)\u001d\u0001(q\u001bBm\u00057DqA!&A\u0001\u0004\t\u0019\nC\u0004\u0003\"\u0002\u0003\r!!\"\t\u000f\t\u0015\u0006\t1\u0001\u0002\u0014\u0006yq-\u001a;BG2$vnQ8n[\u0006tG\r\u0006\u0004\u0003b\n\r(Q\u001e\t\bc\u0006\r\u0016QXAJ\u0011\u001d\u0011)/\u0011a\u0001\u0005O\fa\u0002]3s[&\u001c8/[8o)f\u0004X\r\u0005\u0003\u0002,\n%\u0018\u0002\u0002Bv\u0003[\u0013\u0011#Q2m!\u0016\u0014X.[:tS>tG+\u001f9f\u0011\u001d\u0011y/\u0011a\u0001\u0003O\u000b!b\u001c9fe\u0006$\u0018n\u001c8t\u0003\u00199W\r^\"nIR!\u00111\u0013B{\u0011\u001d\u0011)O\u0011a\u0001\u0005O\fab^5uQ\u0006+H\u000f[8sSj,'\u000f\u0006\u0002\u0003|R\u0019\u0001O!@\t\u000f\t}8\t1\u0001\u0004\u0002\u0005\ta\r\u0005\u0004r\u0007\u0007\u00199\u0001]\u0005\u0004\u0007\u000b9'!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0019Ia!\u0005\u000e\u0005\r-!\u0002BB\u0007\u0007\u001f\t!\"Y;uQ>\u0014\u0018N_3s\u0015\rq\u00151A\u0005\u0005\u0007'\u0019YA\u0001\u0006BkRDwN]5{KJ\u0004")
public class AclCommandTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = (String[])((Object[])new String[]{"--allow-host", "host1", "--allow-host", "host2"});
    private final String[] DenyHostCommand = (String[])((Object[])new String[]{"--deny-host", "host1", "--deny-host", "host2"});
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final Set<ResourcePattern> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> UserResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.USER, "User:test-user1", PatternType.LITERAL), new ResourcePattern(ResourceType.USER, "User:test-user2", PatternType.LITERAL)}));
    private final Map<Set<ResourcePattern>, String[]> ResourceToCommand = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new String[]{"--user-principal", "User:test-user1", "--user-principal", "User:test-user2"})}));
    private final Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS})), (Object)new String[]{"--operation", "CreateTokens", "--operation", "DescribeTokens"}))}));
    private final Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts()))}));
    private final Map<String[], Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
        if (x0$1 != null) {
            Set k = (Set)x0$1._1();
            Set v = (Set)x0$1._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1()).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        }
        throw new MatchError(null);
    }, Map$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
        if (x0$2 != null) {
            Set k = (Set)x0$2._1();
            Set v = (Set)x0$2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        }
        throw new MatchError(null);
    }, Map$.MODULE$.canBuildFrom()))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private Set<ResourcePattern> UserResources() {
        return this.UserResources;
    }

    private Map<Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private Map<Set<ResourcePattern>, Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), this.Hosts()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private Map<String[], Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq((String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()}));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclCli(this.adminArgs());
    }

    private void createServer(Option<File> commandConfig) {
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(this.brokerProps()), TestUtils$.MODULE$.createServer$default$2()), (List)Nil$.MODULE$));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        String[] adminArgs = (String[])((Object[])new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)});
        if (commandConfig.isDefined()) {
            adminArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])adminArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        this.adminArgs_$eq(adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AclCommand$.MODULE$.main(args);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            void grabConsoleOutputAndError_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCli$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testProducerConsumerCli(this.adminArgs());
    }

    @Test
    public void testAclCliWithClientId() {
        File adminClientConfig = TestUtils$.MODULE$.tempFile("client.id=my-client");
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        Assertions.assertFalse((boolean)appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e))).isDefined(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$9);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        String[] cmd = (String[])((Object[])new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"});
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)aclAuthorizer);
        }
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test
    public void testInvalidAuthorizerProperty() {
        String[] args = (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()});
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args));
        Assertions.assertThrows(IllegalArgumentException.class, () -> aclCommandService.listAcls());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPatternTypes() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$10) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$10);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PatternType.values())).foreach((Function1 & Serializable & scala.Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testRemove(String[] cmdArgs, Set<ResourcePattern> resources, String[] resourceCmd) {
        void var6_6;
        void var5_5;
        Tuple2<String, String> tuple2 = this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String out = (String)tuple2._1();
        String err = (String)tuple2._2();
        void out2 = var5_5;
        void err2 = var6_6;
        Assertions.assertEquals((Object)"", (Object)out2);
        Assertions.assertEquals((Object)"", (Object)err2);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable & scala.Serializable)(cmd, user) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{principalCmd, user.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAclCli$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        void var18_18;
        void var17_17;
        void var13_13;
        void var12_12;
        void var8_8;
        void var7_7;
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<AclOperation>)((Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        void acls2 = var7_7;
        void cmd2 = var8_8;
        Tuple2<String, String> tuple22 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        void addOut2 = var12_12;
        void addErr2 = var13_13;
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)addOut2);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)addOut2);
        Assertions.assertEquals((Object)"", (Object)addErr2);
        resources$1.foreach(arg_0 -> AclCommandTest.$anonfun$testAclCli$4$adapted($this, (Set)acls2, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$colon$plus((Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        void listOut2 = var17_17;
        void listErr2 = var18_18;
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)listOut2);
        Assertions.assertEquals((Object)"", (Object)listErr2);
        $this.testRemove(cmdArgs$1, (Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$4) {
        if (x$4 != null) {
            Set resources = (Set)x$4._1();
            String[] resourceCmd = (String[])x$4._2();
            ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable & scala.Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assertions.assertTrue((boolean)output$1.contains(expected), (String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString());
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        String resourceType = resource.resourceType().toString();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(resource.equals($this.ClusterResource()) ? (Object[])new String[]{"kafka-cluster"} : (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("--"))))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$4(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, Set acls$2, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$8) {
        if (x$8 != null) {
            Set resources = (Set)x$8._1();
            Set acls = (Set)x$8._2();
            resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$9) {
        if (x$9 != null) {
            String[] cmd = (String[])x$9._1();
            Map resourcesToAcls = (Map)x$9._2();
            String[] resourceCommand = (String[])((TraversableOnce)resourcesToAcls.keys().map($this.ResourceToCommand(), Iterable$.MODULE$.canBuildFrom())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.getCmd(AclPermissionType.ALLOW))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$4(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$8);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (Set<ResourcePattern>)((TraversableOnce)resourcesToAcls.keys().flatten((Function1)Predef$.MODULE$.$conforms())).toSet(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$10) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, authorizer, resource$1, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$4$adapted(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testAclCli$4($this, acls$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, authorizer, resource$2, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$3, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$3, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }
}

