/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.server.util.ShutdownableThread;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00115g!B4i\u0003\u0003i\u0007\"\u0002;\u0001\t\u0003)\bb\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003{\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bA\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003#A\u0011\"a\t\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003WA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u000fA\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005%\u0003\u0001)A\u0005\u0003WA\u0011\"a\u0013\u0001\u0005\u0004%\t!a\u0004\t\u0011\u00055\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0014\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005E\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0015\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005U\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0016\u0001\u0005\u0004%\t!!\u0017\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00037Bq!a\u0019\u0001\t#\n)\u0007C\u0004\u0002~\u0001!\t%a \u0007\r\u0005}\u0005\u0001CAQ\u0011\u0019!\u0018\u0004\"\u0001\u0002:\"I\u0011qX\rA\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u0003L\u0002\u0019!C\u0001\u0003\u0007D\u0001\"!3\u001aA\u0003&\u0011q\u0001\u0005\n\u0003\u0017L\u0002\u0019!C\u0001\u0003\u000bA\u0011\"!4\u001a\u0001\u0004%\t!a4\t\u0011\u0005M\u0017\u0004)Q\u0005\u0003\u000fAq!!6\u001a\t\u0003\t9\u000eC\u0004\u0002df!\t!!:\t\u000f\u0005%\b\u0001\"\u0005\u0002l\"9!q\u0003\u0001\u0005\u0012\te\u0001\"\u0003B&\u0001E\u0005I\u0011\u0003B'\u0011\u001d\u0011\u0019\u0007\u0001C\t\u0005KB\u0011Ba#\u0001#\u0003%\tB!$\t\u0013\tE\u0005!%A\u0005\u0012\t5\u0003\"\u0003BJ\u0001E\u0005I\u0011\u0003BK\u0011%\u0011I\nAI\u0001\n#\u0011Y\nC\u0005\u0003 \u0002\t\n\u0011\"\u0005\u0003\u000e\"9!\u0011\u0015\u0001\u0005\u0012\t\r\u0006\"\u0003Bq\u0001E\u0005I\u0011\u0003Br\u0011\u001d\u0011I\u000f\u0001C\t\u0005WDqa!\u0001\u0001\t#\u0019\u0019\u0001C\u0005\u0004*\u0001\t\n\u0011\"\u0005\u0004,!91Q\u0007\u0001\u0005\u0002\r]\u0002\"CB\u007f\u0001E\u0005I\u0011AB\u0000\u0011\u001d!\u0019\u0001\u0001C\u0001\t\u000bA\u0011\u0002b\u0005\u0001#\u0003%\taa@\t\u000f\u0011U\u0001\u0001\"\u0001\u0005\u0018!IAQ\u0006\u0001\u0012\u0002\u0013\u0005Aq\u0006\u0005\n\tg\u0001\u0011\u0013!C\u0001\u0005\u001bB\u0011\u0002\"\u000e\u0001#\u0003%\t\u0001b\u000e\t\u000f\u0011m\u0002\u0001\"\u0001\u0005>!IAQ\t\u0001\u0012\u0002\u0013\u0005Aq\t\u0005\b\t\u0017\u0002A\u0011\u0003C'\u0011\u001d!\u0019\u0007\u0001C\t\tK2a\u0001b\u001f\u0001\u0011\u0011u\u0004B\u0002;>\t\u0003!)\tC\u0005\u0005\nv\u0002\r\u0011\"\u0001\u0002\u0006!IA1R\u001fA\u0002\u0013\u0005AQ\u0012\u0005\t\t#k\u0004\u0015)\u0003\u0002\b!IA1S\u001fA\u0002\u0013\u0005\u0011Q\u0001\u0005\n\t+k\u0004\u0019!C\u0001\t/C\u0001\u0002b'>A\u0003&\u0011q\u0001\u0005\n\t;k\u0004\u0019!C\u0001\t?C\u0011\u0002\"+>\u0001\u0004%\t\u0001b+\t\u0011\u0011=V\b)Q\u0005\tCCq\u0001\"->\t\u0003\"\u0019L\u0002\u0004\u0004J\u0001A11\n\u0005\u000b\u0003_K%\u0011!Q\u0001\n\u00055\bBCB-\u0013\n\u0005\t\u0015!\u0003\u0004\\!Q1\u0011M%\u0003\u0002\u0003\u0006IA!<\t\u0015\r\r\u0014J!A!\u0002\u0013\tI\u000b\u0003\u0004u\u0013\u0012\u00051Q\r\u0005\u0007i&#\taa\u001c\t\rQLE\u0011AB;\u0011%\u0019Y(\u0013a\u0001\n\u0003\u0019i\bC\u0005\u0004\b&\u0003\r\u0011\"\u0001\u0004\n\"A1QR%!B\u0013\u0019y\bC\u0005\u0004\u0018&\u0003\r\u0011\"\u0001\u0002\u0006!I1\u0011T%A\u0002\u0013\u000511\u0014\u0005\t\u0007?K\u0005\u0015)\u0003\u0002\b!I11U%C\u0002\u0013%1Q\u0015\u0005\t\u0007WK\u0005\u0015!\u0003\u0004(\"I1QV%A\u0002\u0013%1q\u0016\u0005\n\u0007oK\u0005\u0019!C\u0005\u0007sC\u0001b!0JA\u0003&1\u0011\u0017\u0005\n\u0007\u0003L\u0005\u0019!C\u0005\u0007\u0007D\u0011b!2J\u0001\u0004%Iaa2\t\u0011\r-\u0017\n)Q\u0005\u00077B\u0011b!4J\u0005\u0004%\taa4\t\u0011\rE\u0017\n)A\u0005\u0003SCqaa5J\t\u0003\u0019)\u000eC\u0004\u0004X&#\ta!7\t\u000f\r}\u0017\n\"\u0001\u00040\"91\u0011]%\u0005B\r\r\bbBBs\u0013\u0012\u00053q\u001d\u0005\b\t\u0003\u0004A\u0011\u0001Cb\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti*\u0011\u0011N[\u0001\u0004CBL'\"A6\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c*\faa]3sm\u0016\u0014\u0018BA:q\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001w!\t9\b!D\u0001i\u0003\u001d)\u0007o]5m_:,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0002{\u0006)1oY1mC&\u0011q\u0010 \u0002\u0007\t>,(\r\\3\u0002\u0011\u0015\u00048/\u001b7p]\u0002\n1B\u0019:pW\u0016\u00148i\\;oiV\u0011\u0011q\u0001\t\u0004w\u0006%\u0011bAA\u0006y\n\u0019\u0011J\u001c;\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"!\u0006\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/\u0006\u0002\u0002,A!\u0011QFA\u001f\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012AB2p[6|gNC\u0002l\u0003kQA!a\u000e\u0002:\u00051\u0011\r]1dQ\u0016T!!a\u000f\u0002\u0007=\u0014x-\u0003\u0003\u0002@\u0005=\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013!\u00029beR\u0014\u0014A\u00029beR\u0014\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005)qM]8va\u00061qM]8va\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u00021\u001d\u0014x.\u001e9NCb\u001cVm]:j_:$\u0016.\\3pkRl5/\u0006\u0002\u0002\\A\u001910!\u0018\n\u0007\u0005}CP\u0001\u0003M_:<\u0017!G4s_V\u0004X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004w\u0006%\u0014bAA6y\n!QK\\5u\u0011\u001d\tyg\u0006a\u0001\u0003c\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$\u0002BA<\u00033\tA!\u001e;jY&!\u00111PA;\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003O\n\t\tC\u0004\u0002\u0004b\u0001\r!!\"\u0002\u0011Q,7\u000f^%oM>\u0004B!a\"\u0002\u00146\u0011\u0011\u0011\u0012\u0006\u0004S\u0006-%\u0002BAG\u0003\u001f\u000bqA[;qSR,'O\u0003\u0003\u0002\u0012\u0006e\u0012!\u00026v]&$\u0018\u0002BAK\u0003\u0013\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u00041\u0005e\u0005\u0003BAD\u00037KA!!(\u0002\n\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0003AQ+7\u000f^\"p]N,X.\u001a:SK\u0006\u001c8/[4o[\u0016tG\u000fT5ti\u0016tWM]\n\u00063\u0005\r\u0016\u0011\u0016\t\u0005\u0003'\t)+\u0003\u0003\u0002(\u0006U!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\u0011\r|gn];nKJTA!a-\u00024\u000591\r\\5f]R\u001c\u0018\u0002BA\\\u0003[\u0013\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feR\u0011\u00111\u0018\t\u0004\u0003{KR\"\u0001\u0001\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\f1cY1mYN$v.Q:tS\u001etW\rZ0%KF$B!a\u001a\u0002F\"I\u0011q\u0019\u000f\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0014\u0001E2bY2\u001cHk\\!tg&<g.\u001a3!\u00039\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012\f!cY1mYN$vNU3w_.,Gm\u0018\u0013fcR!\u0011qMAi\u0011%\t9mHA\u0001\u0002\u0004\t9!A\bdC2d7\u000fV8SKZ|7.\u001a3!\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!\u0011qMAm\u0011\u001d\tY.\ta\u0001\u0003;\f!\u0002]1si&$\u0018n\u001c8t!\u0019\t\u0019(a8\u0002,%!\u0011\u0011]A;\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0005\u0003O\n9\u000fC\u0004\u0002\\\n\u0002\r!!8\u00023\r\u0014X-\u0019;f\u0007>t7/^7fe^KG\u000f[$s_V\u0004\u0018\n\u001a\u000b\u0005\u0003[\fy\u0010\u0005\u0005\u0002,\u0006=\u00181_Az\u0013\u0011\t\t0!,\u0003\u0011\r{gn];nKJ\u0004Ra_A{\u0003sL1!a>}\u0005\u0015\t%O]1z!\rY\u00181`\u0005\u0004\u0003{d(\u0001\u0002\"zi\u0016DqA!\u0001$\u0001\u0004\u0011\u0019!A\u0004he>,\b/\u00133\u0011\t\t\u0015!1\u0003\b\u0005\u0005\u000f\u0011y\u0001E\u0002\u0003\nql!Aa\u0003\u000b\u0007\t5A.\u0001\u0004=e>|GOP\u0005\u0004\u0005#a\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002 \tU!b\u0001B\ty\u0006Y1/\u001a8e%\u0016\u001cwN\u001d3t))\u0011YB!\u000f\u0003B\t\u0015#q\t\t\u0007\u0005;\u00119C!\f\u000f\t\t}!1\u0005\b\u0005\u0005\u0013\u0011\t#C\u0001~\u0013\r\u0011)\u0003`\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011ICa\u000b\u0003\u0007M+\u0017OC\u0002\u0003&q\u0004\u0002Ba\f\u00036\u0005M\u00181_\u0007\u0003\u0005cQAAa\r\u00022\u0006A\u0001O]8ek\u000e,'/\u0003\u0003\u00038\tE\"A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000f\u001a\u0005\b\u0005g!\u0003\u0019\u0001B\u001e!!\u0011yC!\u0010\u0002t\u0006M\u0018\u0002\u0002B \u0005c\u0011QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bb\u0002B\"I\u0001\u0007\u0011qA\u0001\u000b]Vl'+Z2pe\u0012\u001c\bbBA\u0014I\u0001\u0007\u00111\u0006\u0005\n\u0005\u0013\"\u0003\u0013!a\u0001\u00037\n\u0011c\u001d;beRLgn\u001a+j[\u0016\u001cH/Y7q\u0003U\u0019XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"Aa\u0014+\t\u0005m#\u0011K\u0016\u0003\u0005'\u0002BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&A\u0005v]\u000eDWmY6fI*\u0019!Q\f?\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003b\t]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0013\u0003O\u00129G!\u001b\u0003l\t=$1\u000fB;\u0005\u000b\u00139\tC\u0004\u00020\u001a\u0002\r!!<\t\u000f\t\rc\u00051\u0001\u0002\b!9!Q\u000e\u0014A\u0002\u0005\u001d\u0011AD:uCJ$\u0018N\\4PM\u001a\u001cX\r\u001e\u0005\n\u0005c2\u0003\u0013!a\u0001\u0003\u000f\t\u0001d\u001d;beRLgnZ&fs\u0006sGMV1mk\u0016Le\u000eZ3y\u0011%\u0011IE\nI\u0001\u0002\u0004\tY\u0006C\u0005\u0003x\u0019\u0002\n\u00111\u0001\u0003z\u0005iA/[7fgR\fW\u000e\u001d+za\u0016\u0004BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0005\u0005\u007f\ny#\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005\u0007\u0013iHA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\n\u0003O1\u0003\u0013!a\u0001\u0003WA\u0011B!#'!\u0003\u0005\r!a\u0002\u0002\u001d5\f\u0007\u0010U8mYJ+7m\u001c:eg\u0006\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0012\u0016\u0005\u0003\u000f\u0011\t&A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$S'A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u0018*\"!\u0011\u0010B)\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011iJ\u000b\u0003\u0002,\tE\u0013!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012B\u0014AD2p]N,X.\u001a*fG>\u0014Hm]\u000b\u0007\u0005K\u0013\tM!6\u0015\u0011\t\u001d&\u0011\u001cBo\u0005?\u0004bA!+\u00034\n]VB\u0001BV\u0015\u0011\u0011iKa,\u0002\u000f5,H/\u00192mK*\u0019!\u0011\u0017?\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00036\n-&aC!se\u0006L()\u001e4gKJ\u0004\u0002\"a+\u0003:\nu&1[\u0005\u0005\u0005w\u000biK\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\t\t}&\u0011\u0019\u0007\u0001\t\u001d\u0011\u0019\r\fb\u0001\u0005\u000b\u0014\u0011aS\t\u0005\u0005\u000f\u0014i\rE\u0002|\u0005\u0013L1Aa3}\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u001fBh\u0013\r\u0011\t\u000e \u0002\u0004\u0003:L\b\u0003\u0002B`\u0005+$qAa6-\u0005\u0004\u0011)MA\u0001W\u0011\u001d\ty\u000b\fa\u0001\u00057\u0004\u0002\"a+\u0002p\nu&1\u001b\u0005\b\u0005\u0007b\u0003\u0019AA\u0004\u0011%\u0011I\t\fI\u0001\u0002\u0004\t9!\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*bA!$\u0003f\n\u001dHa\u0002Bb[\t\u0007!Q\u0019\u0003\b\u0005/l#\u0019\u0001Bc\u0003e\u0019'/Z1uKR{\u0007/[2B]\u0012\u001cVM\u001c3SK\u000e|'\u000fZ:\u0015\u0015\t5(1\u001fB{\u0005s\u0014i\u0010\u0005\u0004\u0003\u0006\t=\u00181F\u0005\u0005\u0005c\u0014)BA\u0002TKRDqAa\r/\u0001\u0004\u0011Y\u0004C\u0004\u0003x:\u0002\rAa\u0001\u0002\u0013Q|\u0007/[2OC6,\u0007b\u0002B~]\u0001\u0007\u0011qA\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\t}h\u00061\u0001\u0002\b\u0005\u0019\"/Z2pe\u0012\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\u000692/\u001a8e\u0003:$\u0017i^1ji\u0006\u001b\u0018P\\2D_6l\u0017\u000e^\u000b\u0007\u0007\u000b\u0019ia!\u0005\u0015\r\u0005\u001d4qAB\n\u0011\u001d\tyk\fa\u0001\u0007\u0013\u0001\u0002\"a+\u0002p\u000e-1q\u0002\t\u0005\u0005\u007f\u001bi\u0001B\u0004\u0003D>\u0012\rA!2\u0011\t\t}6\u0011\u0003\u0003\b\u0005/|#\u0019\u0001Bc\u0011%\u0019)b\fI\u0001\u0002\u0004\u00199\"\u0001\u0006pM\u001a\u001cX\r^:PaR\u0004Ra_B\r\u0007;I1aa\u0007}\u0005\u0019y\u0005\u000f^5p]BA!QAB\u0010\u0003W\u0019\u0019#\u0003\u0003\u0004\"\tU!aA'baB!\u00111VB\u0013\u0013\u0011\u00199#!,\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018-A\u0011tK:$\u0017I\u001c3Bo\u0006LG/Q:z]\u000e\u001cu.\\7ji\u0012\"WMZ1vYR$#'\u0006\u0004\u0004.\rE21G\u000b\u0003\u0007_QCaa\u0006\u0003R\u00119!1\u0019\u0019C\u0002\t\u0015Ga\u0002Bla\t\u0007!QY\u0001-C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$bb!\u000f\u0004j\u000e58\u0011_B{\u0007o\u001cY\u0010E\u0004|\u0007w\u0019yd!\u0012\n\u0007\ruBP\u0001\u0004UkBdWM\r\t\u0007\u0005S\u001b\t%!<\n\t\r\r#1\u0016\u0002\u0007\u0005V4g-\u001a:\u0011\r\t%6\u0011IB$!\r\ti,\u0013\u0002\u0019\u0007>t7/^7fe\u0006\u001b8/[4o[\u0016tG\u000fU8mY\u0016\u00148cA%\u0004NA!1qJB+\u001b\t\u0019\tF\u0003\u0003\u0002x\rM#bA9\u00024%!1qKB)\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002#Q|\u0007/[2t)>\u001cVOY:de&\u0014W\r\u0005\u0004\u0003\u001e\ru#1A\u0005\u0005\u0007?\u0012YC\u0001\u0003MSN$\u0018A\u00059beRLG/[8ogR{\u0017i]:jO:\fQ#^:feJ+'-\u00197b]\u000e,G*[:uK:,'\u000f\u0006\u0006\u0004H\r\u001d4\u0011NB6\u0007[Bq!a,O\u0001\u0004\ti\u000fC\u0004\u0004Z9\u0003\raa\u0017\t\u000f\r\u0005d\n1\u0001\u0003n\"911\r(A\u0002\u0005%FCBB$\u0007c\u001a\u0019\bC\u0004\u00020>\u0003\r!!<\t\u000f\res\n1\u0001\u0004\\Q11qIB<\u0007sBq!a,Q\u0001\u0004\ti\u000fC\u0004\u0004bA\u0003\rA!<\u0002\u001fQD'o\\<o\u000bb\u001cW\r\u001d;j_:,\"aa \u0011\u000bm\u001cIb!!\u0011\t\tu11Q\u0005\u0005\u0007\u000b\u0013YCA\u0005UQJ|w/\u00192mK\u0006\u0019B\u000f\u001b:po:,\u0005pY3qi&|gn\u0018\u0013fcR!\u0011qMBF\u0011%\t9MUA\u0001\u0002\u0004\u0019y(\u0001\tuQJ|wO\\#yG\u0016\u0004H/[8oA!\u001a1k!%\u0011\u0007m\u001c\u0019*C\u0002\u0004\u0016r\u0014\u0001B^8mCRLG.Z\u0001\u0011e\u0016\u001cW-\u001b<fI6+7o]1hKN\fAC]3dK&4X\rZ'fgN\fw-Z:`I\u0015\fH\u0003BA4\u0007;C\u0011\"a2V\u0003\u0003\u0005\r!a\u0002\u0002#I,7-Z5wK\u0012lUm]:bO\u0016\u001c\b\u0005K\u0002W\u0007#\u000b1\u0003]1si&$\u0018n\u001c8BgNLwM\\7f]R,\"aa*\u0011\r\t%6\u0011VA\u0016\u0013\u0011\u0011\tPa+\u0002)A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;!\u0003M\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3e+\t\u0019\t\fE\u0002|\u0007gK1a!.}\u0005\u001d\u0011un\u001c7fC:\fqc];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012|F%Z9\u0015\t\u0005\u001d41\u0018\u0005\n\u0003\u000fT\u0016\u0011!a\u0001\u0007c\u000bAc];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012\u0004\u0003fA.\u0004\u0012\u0006\u0011Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o+\t\u0019Y&\u0001\fu_BL7m]*vEN\u001c'/\u001b9uS>tw\fJ3r)\u0011\t9g!3\t\u0013\u0005\u001dW,!AA\u0002\rm\u0013a\u0005;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013!\u0005:fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feV\u0011\u0011\u0011V\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\b%\u0001\nd_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8nK:$HC\u0001Bw\u0003%\u0019XOY:de&\u0014W\r\u0006\u0003\u0002h\rm\u0007bBBoE\u0002\u000711L\u0001\u0015]\u0016<Hk\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\u00027%\u001c8+\u001e2tGJL'-\u001a*fcV,7\u000f\u001e)s_\u000e,7o]3e\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u00042\u00061Am\\,pe.$\"!a\u001a\t\u000f\r-\u0018\u00071\u0001\u0002\b\u0005\u0019b.^7PM\u000e{gn];nKJ\u001cHk\\!eI\"91q^\u0019A\u0002\r}\u0012!D2p]N,X.\u001a:He>,\b\u000fC\u0004\u0004tF\u0002\ra!\u0012\u0002\u001f\r|gn];nKJ\u0004v\u000e\u001c7feNDqa!\u00172\u0001\u0004\u0019Y\u0006C\u0004\u0004zF\u0002\rA!<\u0002\u001bM,(m]2sSB$\u0018n\u001c8t\u0011%\tY%\rI\u0001\u0002\u0004\u0011\u0019!\u0001\u001cbI\u0012\u001cuN\\:v[\u0016\u00148\u000fV8He>,\b/\u00118e/\u0006LGOR8s\u000fJ|W\u000f]!tg&<g.\\3oi\u0012\"WMZ1vYR$c'\u0006\u0002\u0005\u0002)\"!1\u0001B)\u0003M\tG\rZ\"p]N,X.\u001a:t)><%o\\;q)9\u0019I\u0004b\u0002\u0005\n\u0011-AQ\u0002C\b\t#Aqaa;4\u0001\u0004\t9\u0001C\u0004\u0004pN\u0002\raa\u0010\t\u000f\rM8\u00071\u0001\u0004F!91\u0011L\u001aA\u0002\rm\u0003bBB}g\u0001\u0007!Q\u001e\u0005\n\u0003\u0017\u001a\u0004\u0013!a\u0001\u0005\u0007\tQ$\u00193e\u0007>t7/^7feN$vn\u0012:pkB$C-\u001a4bk2$HEN\u0001\u0018m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$B\"a\u001a\u0005\u001a\u0011mAQ\u0004C\u0012\tOAqaa=6\u0001\u0004\u0019)\u0005C\u0004\u0004zV\u0002\rA!<\t\u0013\u0011}Q\u0007%AA\u0002\u0011\u0005\u0012aA7tOB)1p!\u0007\u0003\u0004!IAQE\u001b\u0011\u0002\u0003\u0007\u00111L\u0001\to\u0006LG\u000fV5nK\"IA\u0011F\u001b\u0011\u0002\u0003\u0007A1F\u0001\u0013Kb\u0004Xm\u0019;fI\u0006\u001b8/[4o[\u0016tG\u000f\u0005\u0004\u0003*\u000e\u0005#Q^\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$HeM\u000b\u0003\tcQC\u0001\"\t\u0003R\u0005\tc/\u00197jI\u0006$Xm\u0012:pkB\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\tc/\u00197jI\u0006$Xm\u0012:pkB\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011A\u0011\b\u0016\u0005\tW\u0011\t&\u0001\u0011tk\n\u001c8M]5cK\u000e{gn];nKJ\fe\u000eZ*uCJ$\bk\u001c7mS:<G\u0003CB$\t\u007f!\t\u0005b\u0011\t\u000f\u0005=\u0016\b1\u0001\u0002n\"91\u0011L\u001dA\u0002\rm\u0003\"CB1sA\u0005\t\u0019\u0001Bw\u0003)\u001aXOY:de&\u0014WmQ8ogVlWM]!oIN#\u0018M\u001d;Q_2d\u0017N\\4%I\u00164\u0017-\u001e7uIM*\"\u0001\"\u0013+\t\t5(\u0011K\u0001\u000fC^\f\u0017\u000e\u001e*fE\u0006d\u0017M\\2f)\u0019\t9\u0007b\u0014\u0005b!9\u0011qV\u001eA\u0002\u0011E\u0003G\u0002C*\t/\"i\u0006\u0005\u0005\u0002,\u0006=HQ\u000bC.!\u0011\u0011y\fb\u0016\u0005\u0019\u0011eCqJA\u0001\u0002\u0003\u0015\tA!2\u0003\u0007}#\u0013\u0007\u0005\u0003\u0003@\u0012uC\u0001\u0004C0\t\u001f\n\t\u0011!A\u0003\u0002\t\u0015'aA0%e!91QZ\u001eA\u0002\u0005m\u0016!E3ogV\u0014XMT8SK\n\fG.\u00198dKR1\u0011q\rC4\tsBq!a,=\u0001\u0004!I\u0007\r\u0004\u0005l\u0011=DQ\u000f\t\t\u0003W\u000by\u000f\"\u001c\u0005tA!!q\u0018C8\t1!\t\bb\u001a\u0002\u0002\u0003\u0005)\u0011\u0001Bc\u0005\ryFe\r\t\u0005\u0005\u007f#)\b\u0002\u0007\u0005x\u0011\u001d\u0014\u0011!A\u0001\u0006\u0003\u0011)MA\u0002`IQBqa!4=\u0001\u0004\tYLA\u000eD_VtGoQ8ogVlWM]\"p[6LGoQ1mY\n\f7m[\n\u0006{\u0005\rFq\u0010\t\u0005\u0003W#\t)\u0003\u0003\u0005\u0004\u00065&\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7\u000e\u0006\u0002\u0005\bB\u0019\u0011QX\u001f\u0002\u0019M,8mY3tg\u000e{WO\u001c;\u0002!M,8mY3tg\u000e{WO\u001c;`I\u0015\fH\u0003BA4\t\u001fC\u0011\"a2A\u0003\u0003\u0005\r!a\u0002\u0002\u001bM,8mY3tg\u000e{WO\u001c;!\u0003%1\u0017-\u001b7D_VtG/A\u0007gC&d7i\\;oi~#S-\u001d\u000b\u0005\u0003O\"I\nC\u0005\u0002H\u000e\u000b\t\u00111\u0001\u0002\b\u0005Qa-Y5m\u0007>,h\u000e\u001e\u0011\u0002\u00131\f7\u000f^#se>\u0014XC\u0001CQ!\u0015Y8\u0011\u0004CR!\u0011\u0011i\u0002\"*\n\t\u0011\u001d&1\u0006\u0002\n\u000bb\u001cW\r\u001d;j_:\fQ\u0002\\1ti\u0016\u0013(o\u001c:`I\u0015\fH\u0003BA4\t[C\u0011\"a2G\u0003\u0003\u0005\r\u0001\")\u0002\u00151\f7\u000f^#se>\u0014\b%\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$b!a\u001a\u00056\u0012u\u0006b\u0002C\\\u0011\u0002\u0007A\u0011X\u0001\b_\u001a47/\u001a;t!!\t\u0019\bb/\u0002,\r\r\u0012\u0002BB\u0011\u0003kBq\u0001b0I\u0001\u0004!\u0019+A\u0005fq\u000e,\u0007\u000f^5p]\u0006Q\u0012n\u001d)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$h+\u00197jIRA1\u0011\u0017Cc\t\u0013$Y\rC\u0004\u0005H\u001a\u0004\r\u0001b\u000b\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\u0005\b\u000374\u0007\u0019\u0001Bw\u0011\u001d!IC\u001aa\u0001\tW\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), Long.toString(this.groupMaxSessionTimeoutMs()));
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.topic();
        int x$2 = 2;
        int x$3 = this.brokerCount();
        Properties x$4 = this.adminClientConfig();
        Properties x$5 = this.createTopic$default$4();
        ListenerName x$6 = this.createTopic$default$5();
        this.createTopic(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Consumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, groupOverrideConfig, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp, long startingTimestamp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(startingTimestamp, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public long sendRecords$default$4() {
        return System.currentTimeMillis();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assertions.assertEquals((int)tp.partition(), (int)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
                Assertions.assertEquals((long)(startingTimestamp + (long)i), (long)record.timestamp());
            } else {
                Assertions.assertTrue((record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0, (String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString());
            }
            Assertions.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((int)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (int)record.serializedKeySize());
            Assertions.assertEquals((int)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (int)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollRecordsUntilTrue_x$3 = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, x$2)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + x$3) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$consumeRecords$2(numRecords, records));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$3), pollRecordsUntilTrue_x$3));
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp, this.sendRecords$default$4());
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        void pollUntilTrue_action;
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    return;
                }
                this.isComplete_$eq(true);
                this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception));
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$sendAndAwaitAsyncCommit$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<Consumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assertions.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<Consumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.$anonfun$validateGroupAssignment$1(this, assignments, consumerPollers, subscriptions, expectedAssignment)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTime) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$validateGroupAssignment$3(msg, subscriptions, assignments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), (long)waitUntilTrue_pause));
        }
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public Buffer<scala.collection.immutable.Set<TopicPartition>> validateGroupAssignment$default$5() {
        return (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        void pollUntilTrue_action;
        int numReassignments = rebalanceListener.callsToAssigned();
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$awaitRebalance$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assertions.assertEquals((int)initialRevokeCalls, (int)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Object object = new Object();
        try {
            if (!assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()))) {
                return false;
            }
            if (BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3)))) != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.immutable.Set)x$4.$plus$plus((GenTraversableOnce)x$5));
            if (set == null || !set.equals(partitions)) {
                return false;
            }
            if (expectedAssignment.nonEmpty()) {
                assignments.foreach((Function1 & Serializable & scala.Serializable)assignment -> {
                    AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$4(expectedAssignment, object, assignment);
                    return BoxedUnit.UNIT;
                });
            }
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(long startingTimestamp$1, TopicPartition tp$1, KafkaProducer producer$1, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return record;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assertions.assertTrue((((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecords$2(int numRecords$1, ArrayBuffer records$2) {
        return new StringBuilder(71).append("Timed out before consuming expected ").append(numRecords$1).append(" records. ").append("The number consumed was ").append(records$2.size()).append(".").toString();
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        if (offsetsOpt$1 instanceof Some) {
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)((Some)offsetsOpt$1).value();
            consumer$1.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            return;
        }
        if (None$.MODULE$.equals(offsetsOpt$1)) {
            consumer$1.commitAsync(callback);
            return;
        }
        throw new MatchError((Object)offsetsOpt$1);
    }

    public static final /* synthetic */ String $anonfun$sendAndAwaitAsyncCommit$2() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int _) {
        Consumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling(consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateGroupAssignment$1(AbstractConsumerTest $this, Buffer assignments$1, Buffer consumerPollers$2, scala.collection.immutable.Set subscriptions$1, Buffer expectedAssignment$1) {
        assignments$1.clear();
        consumerPollers$2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> assignments$1.$plus$eq(x$1.consumerAssignment()));
        return $this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments$1, (scala.collection.immutable.Set<TopicPartition>)subscriptions$1, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment$1);
    }

    public static final /* synthetic */ String $anonfun$validateGroupAssignment$3(Option msg$1, scala.collection.immutable.Set subscriptions$1, Buffer assignments$1) {
        return (String)msg$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions$1).append(". Instead, got ").append(assignments$1).toString());
    }

    public static final /* synthetic */ String $anonfun$awaitRebalance$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, scala.collection.immutable.Set x$3) {
        return x$2 + x$3.size();
    }

    public static final /* synthetic */ void $anonfun$isPartitionAssignmentValid$4(Buffer expectedAssignment$2, Object nonLocalReturnKey1$1, scala.collection.immutable.Set assignment) {
        if (!expectedAssignment$2.contains((Object)assignment)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 60000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        public final ConsumerRebalanceListener kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        public boolean initiateShutdown() {
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return res;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
                return;
            }
            catch (WakeupException wakeupException) {
                return;
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign, ConsumerRebalanceListener userRebalanceListener) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener = userRebalanceListener;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsLost(Collection<TopicPartition> x$1) {
                    super.onPartitionsLost(x$1);
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                    if (this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener != null) {
                        this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener.onPartitionsAssigned(partitions);
                        return;
                    }
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                    if (this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener != null) {
                        this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener.onPartitionsRevoked(partitions);
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
                return;
            }
            consumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitionsToAssign).asJava());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), null);
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign, null);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
                return;
            }
            this.failCount_$eq(this.failCount() + 1);
            this.lastError_$eq((Option<Exception>)new Some((Object)exception));
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

