/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u0014)\u00015BQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!\tF\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019Q\u0006\u0001)A\u0005%\"91\f\u0001b\u0001\n\u0013a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011B4\t\rI\u0004\u0001\u0015!\u0003i\u0011\u0015\u0019\b\u0001\"\u0015u\u0011\u001di\bA1A\u0005RyDq!!\u0005\u0001A\u0003%q\u0010\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0015\u007f\u0011\u001d\t)\u0002\u0001Q\u0001\n}Dq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+DqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!\u0011\u0006\u0001\u0005\n\t-\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\n\u0005w\u0002\u0011\u0013!C\u0005\u0005{BqAa&\u0001\t\u0013\u0011I\nC\u0004\u00034\u0002!IA!.\t\u0013\t%\u0007!%A\u0005\n\t}\u0004b\u0002Bf\u0001\u0011%!Q\u001a\u0005\b\u0005#\u0004A\u0011\u0002Bj\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_D\u0011Ba>\u0001#\u0003%IA!?\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\u0006\u0001\u0011%1Q\u0002\u0002\f\u001b\u0016$(/[2t)\u0016\u001cHO\u0003\u0002*U\u0005\u0019\u0011\r]5\u000b\u0003-\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001]I\u0002\"a\f\u0019\u000e\u0003!J!!\r\u0015\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"aL\u001a\n\u0005QB#!C*bg2\u001cV\r^;q\u0003\u0019a\u0014N\\5u}Q\tq\u0007\u0005\u00020\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005aA.[:uK:,'OT1nKV\t1\t\u0005\u0002E\u001d6\tQI\u0003\u0002G\u000f\u00069a.\u001a;x_J\\'B\u0001%J\u0003\u0019\u0019w.\\7p]*\u00111F\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000b\naA*[:uK:,'OT1nK\u0006A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0004TiJLgnZ\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007%A\rlC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001cX#A/\u0011\u0007y\u001b'+D\u0001`\u0015\t\u0001\u0017-A\u0005j[6,H/\u00192mK*\u0011!\rP\u0001\u000bG>dG.Z2uS>t\u0017B\u00013`\u0005\u0011a\u0015n\u001d;\u00025-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn\u001d\u0011\u00021-\fgm[1TKJ4XM\u001d&bCN,e\u000e\u001e:z\u001d\u0006lW-F\u0001i!\tI\u0007O\u0004\u0002k]B\u00111\u000eP\u0007\u0002Y*\u0011Q\u000eL\u0001\u0007yI|w\u000e\u001e \n\u0005=d\u0014A\u0002)sK\u0012,g-\u0003\u0002Zc*\u0011q\u000eP\u0001\u001aW\u000647.Y*feZ,'OS1bg\u0016sGO]=OC6,\u0007%\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\tQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006!\u0011-\u001e;i\u0015\tQx)\u0001\u0005tK\u000e,(/\u001b;z\u0013\taxO\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006!2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN,\u0012a \t\u0006w\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007a$\u0001B*p[\u0016\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0016\u0001B;uS2LA!a\u0004\u0002\n\tQ\u0001K]8qKJ$\u0018.Z:\u0002+M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\fQc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%A\u0003tKR,\u0006\u000f\u0006\u0003\u0002\u001c\u0005\u0005\u0002cA\u001e\u0002\u001e%\u0019\u0011q\u0004\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003G\u0001\u0002\u0019AA\u0013\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\u0014\u0003gi!!!\u000b\u000b\u0007%\nYC\u0003\u0003\u0002.\u0005=\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003ca\u0015!\u00026v]&$\u0018\u0002BA\u001b\u0003S\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004!\u0005e\u0002\u0003BA\u0014\u0003wIA!!\u0010\u0002*\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\"!a\u0007)\u0007E\t)\u0005\u0005\u0003\u0002(\u0005\u001d\u0013\u0002BA%\u0003S\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0017Q,7\u000f^'fiJL7m\u001d\u000b\u0005\u00037\ty\u0005C\u0004\u0002RI\u0001\r!a\u0015\u00025ML8\u000f^3n%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3\u0011\u0007m\n)&C\u0002\u0002Xq\u0012qAQ8pY\u0016\fg\u000eK\u0004\u0013\u00037\nY'!\u001c\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002f\u0005-\u0012A\u00029be\u0006l7/\u0003\u0003\u0002j\u0005}#a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003_\n\t(G\u0001\u00023\u0005\u0001\u0001f\u0002\n\u0002v\u0005u\u0014q\u0010\t\u0005\u0003o\nI(\u0004\u0002\u0002d%!\u00111PA2\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002\u0002\u0006\u0001D/Z:u\u001b\u0016$(/[2tA]LG\u000f\u001b\u0011tsN$X-\u001c*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,GM\u000f\u0011|au\f1b]3oIJ+7m\u001c:egRQ\u00111DAD\u0003K\u000bI+!,\t\u000f\u0005%5\u00031\u0001\u0002\f\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0002\u000e\u0006U\u0015\u0011TAM\u001b\t\tyI\u0003\u0003\u0002\n\u0006E%bAAJ\u0013\u000691\r\\5f]R\u001c\u0018\u0002BAL\u0003\u001f\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#B\u001e\u0002\u001c\u0006}\u0015bAAOy\t)\u0011I\u001d:bsB\u00191(!)\n\u0007\u0005\rFH\u0001\u0003CsR,\u0007BBAT'\u0001\u0007!(\u0001\u0006ok6\u0014VmY8sINDa!a+\u0014\u0001\u0004Q\u0014A\u0003:fG>\u0014HmU5{K\"9\u0011qV\nA\u0002\u0005E\u0016A\u0001;q!\u0011\t\u0019,!.\u000e\u0003\u001dK1!a.H\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQdZ3oKJ\fG/Z!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u000b\u0005\u00037\ti\fC\u0004\u00020R\u0001\r!!-\u0002SY,'/\u001b4z\u0017\u000647.\u0019*bi\u0016lU\r\u001e:jGND\u0015M^3Dk6,H.\u0019;jm\u0016\u001cu.\u001e8u)\u0019\tY\"a1\u0002F\"9\u0011\u0011R\u000bA\u0002\u0005-\u0005bBAd+\u0001\u0007\u0011\u0011Z\u0001\tG>t7/^7feBA\u00111ZAh\u00033\u000bI*\u0004\u0002\u0002N*!\u0011qYAI\u0013\u0011\t\t.!4\u0003\u0011\r{gn];nKJ\f!D^3sS\u001aL8\t\\5f]R4VM]:j_:lU\r\u001e:jGN$b!a\u0007\u0002X\u0006}\bbBAm-\u0001\u0007\u00111\\\u0001\b[\u0016$(/[2ta\u0011\ti.!<\u0011\u0011\u0005\u001d\u0011q\\Ar\u0003SLA!!9\u0002\n\t\u0019Q*\u00199\u0011\t\u0005M\u0016Q]\u0005\u0004\u0003O<%AC'fiJL7MT1nKB!\u00111^Aw\u0019\u0001!A\"a<\u0002X\u0006\u0005\t\u0011!B\u0001\u0003c\u00141a\u0018\u00132#\u0011\t\u00190!?\u0011\u0007m\n)0C\u0002\u0002xr\u0012qAT8uQ&tw\r\u0005\u0003\u00024\u0006m\u0018bAA\u007f\u000f\n1Q*\u001a;sS\u000eDaA!\u0001\u0017\u0001\u0004A\u0017AB3oi&$\u00180A\u0011wKJLg-\u001f\"s_.,'/Q;uQ\u0016tG/[2bi&|g.T3ue&\u001c7\u000f\u0006\u0003\u0002\u001c\t\u001d\u0001b\u0002B\u0005/\u0001\u0007!1B\u0001\u0007g\u0016\u0014h/\u001a:\u0011\t\t5!\u0011C\u0007\u0003\u0005\u001fQ1A!\u0003+\u0013\u0011\u0011\u0019Ba\u0004\u0003\u0017-\u000bgm[1TKJ4XM]\u0001%m\u0016\u0014\u0018NZ=Ce>\\WM]'fgN\fw-Z\"p]Z,'o]5p]6+GO]5dgRA\u00111\u0004B\r\u00057\u0011i\u0002C\u0004\u0003\na\u0001\rAa\u0003\t\r\u0005-\u0006\u00041\u0001;\u0011\u001d\ty\u000b\u0007a\u0001\u0003c\u000bQC^3sS\u001aL(I]8lKJT6.T3ue&\u001c7\u000f\u0006\u0004\u0002\u001c\t\r\"Q\u0005\u0005\b\u0005\u0013I\u0002\u0019\u0001B\u0006\u0011\u0019\u00119#\u0007a\u0001Q\u0006)Ao\u001c9jG\u0006Ab/\u001a:jMf\u0014%o\\6fe\u0016\u0013(o\u001c:NKR\u0014\u0018nY:\u0015\t\u0005m!Q\u0006\u0005\b\u0005\u0013Q\u0002\u0019\u0001B\u0006\u0003E1XM]5gs.\u000bgm[1NKR\u0014\u0018nY\u000b\u0005\u0005g\u0011I\u0004\u0006\u0006\u00036\t\u0005$1\rB8\u0005c\"BAa\u000e\u0003FA!\u00111\u001eB\u001d\t\u001d\u0011Yd\u0007b\u0001\u0005{\u0011\u0011\u0001V\t\u0005\u0003g\u0014y\u0004E\u0002<\u0005\u0003J1Aa\u0011=\u0005\r\te.\u001f\u0005\b\u0005\u000fZ\u0002\u0019\u0001B%\u0003\u00191XM]5gsB91Ha\u0013\u0003P\t]\u0012b\u0001B'y\tIa)\u001e8di&|g.\r\t\u0007\u0005#\u0012Y&!?\u000f\t\tM#q\u000b\b\u0004W\nU\u0013\"A\u001f\n\u0007\teC(A\u0004qC\u000e\\\u0017mZ3\n\t\tu#q\f\u0002\t\u0013R,'/\u00192mK*\u0019!\u0011\f\u001f\t\r\u0005u4\u00041\u0001i\u0011\u001d\tIn\u0007a\u0001\u0005K\u0002DAa\u001a\u0003lAA\u0011qAAp\u0003G\u0014I\u0007\u0005\u0003\u0002l\n-D\u0001\u0004B7\u0005G\n\t\u0011!A\u0003\u0002\u0005E(aA0%e!1!\u0011A\u000eA\u0002!D\u0011Ba\u001d\u001c!\u0003\u0005\rA!\u001e\u0002\u000b\u001d\u0014x.\u001e9\u0011\tm\u00129\b[\u0005\u0004\u0005sb$AB(qi&|g.A\u000ewKJLg-_&bM.\fW*\u001a;sS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0005\u0005\u007f\u0012)*\u0006\u0002\u0003\u0002*\"!Q\u000fBBW\t\u0011)\t\u0005\u0003\u0003\b\nEUB\u0001BE\u0015\u0011\u0011YI!$\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BHy\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM%\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B\u001e9\t\u0007!QH\u0001\u0014[\u0006D8*\u00194lC6+GO]5d-\u0006dW/\u001a\u000b\u000b\u00057\u0013\tKa)\u00030\nE\u0006cA\u001e\u0003\u001e&\u0019!q\u0014\u001f\u0003\r\u0011{WO\u00197f\u0011\u0019\ti(\ba\u0001Q\"9\u0011\u0011\\\u000fA\u0002\t\u0015\u0006\u0007\u0002BT\u0005W\u0003\u0002\"a\u0002\u0002`\u0006\r(\u0011\u0016\t\u0005\u0003W\u0014Y\u000b\u0002\u0007\u0003.\n\r\u0016\u0011!A\u0001\u0006\u0003\t\tPA\u0002`IMBaA!\u0001\u001e\u0001\u0004A\u0007b\u0002B:;\u0001\u0007!QO\u0001\u001am\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001c'+Z2pe\u0012,G\r\u0006\u0006\u0002\u001c\t]&\u0011\u0018Bc\u0005\u000fDa!! \u001f\u0001\u0004A\u0007bBAm=\u0001\u0007!1\u0018\u0019\u0005\u0005{\u0013\t\r\u0005\u0005\u0002\b\u0005}\u00171\u001dB`!\u0011\tYO!1\u0005\u0019\t\r'\u0011XA\u0001\u0002\u0003\u0015\t!!=\u0003\u0007}#C\u0007\u0003\u0004\u0003\u0002y\u0001\r\u0001\u001b\u0005\n\u0005gr\u0002\u0013!a\u0001\u0005k\n1E^3sS\u001aL8*\u00194lC6+GO]5d%\u0016\u001cwN\u001d3fI\u0012\"WMZ1vYR$C'A\tzC6lWM]'fiJL7MV1mk\u0016$BAa\u0010\u0003P\"1\u0011Q\u0010\u0011A\u0002!\fq\"_1n[\u0016\u0014\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u0005+\u0014Y\u000f\u0005\u0003\u0003X\n\u001dXB\u0001Bm\u0015\u0011\u0011YN!8\u0002\t\r|'/\u001a\u0006\u0005\u00033\u0014yN\u0003\u0003\u0003b\n\r\u0018AB=b[6,'O\u0003\u0002\u0003f\u0006\u00191m\\7\n\t\t%(\u0011\u001c\u0002\n\u0011&\u001cHo\\4sC6Da!! \"\u0001\u0004A\u0017A\u0007<fe&4\u00170W1n[\u0016\u0014X*\u001a;sS\u000e\u0014VmY8sI\u0016$GC\u0002BN\u0005c\u0014\u0019\u0010\u0003\u0004\u0002~\t\u0002\r\u0001\u001b\u0005\n\u0005\u000f\u0012\u0003\u0013!a\u0001\u0005k\u0004ra\u000fB&\u00057\u000b\u0019&\u0001\u0013wKJLg-_-b[6,'/T3ue&\u001c'+Z2pe\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YP\u000b\u0003\u0003v\n\r\u0015A\u0006<fe&4\u0017PT8SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\u0005m1\u0011\u0001\u0005\u0007\u0007\u0007!\u0003\u0019\u00015\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0002?\u0019\u0014x.\u001c(b[\u0016$vN\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:N\u0005\u0016\fg\u000eF\u0002i\u0007\u0013Aa!! &\u0001\u0004A\u0017A\u0007<fe&4\u0017PU3n_R,7\u000b^8sC\u001e,W*\u001a;sS\u000e\u001cH\u0003BA\u000e\u0007\u001fAqa!\u0005'\u0001\u0004\t\u0019&\u0001\u000btQ>,H\u000eZ\"p]R\f\u0017N\\'fiJL7m\u001d")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (testInfo.getDisplayName().contains("testMetrics") && testInfo.getDisplayName().endsWith("true")) {
            this.serverConfig().setProperty("remote.log.storage.system.enable", "true");
            this.serverConfig().setProperty("remote.log.storage.manager.class.name", NoOpRemoteStorageManager.class.getName());
            this.serverConfig().setProperty("remote.log.metadata.manager.class.name", NoOpRemoteLogMetadataManager.class.getName());
        }
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @ParameterizedTest(name="testMetrics with systemRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty("message.format.version", "0.9.0");
        this.createTopic(topic, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", "false");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        this.sendRecords(producer, numRecords, recordSize, tp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
        this.verifyRemoteStorageMetrics(systemRemoteStorageEnabled);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$2 = 0;
        int x$3 = 1000;
        long x$4 = 1000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = TestUtils$.MODULE$.createProducer$default$4();
        int x$9 = TestUtils$.MODULE$.createProducer$default$5();
        int x$10 = TestUtils$.MODULE$.createProducer$default$6();
        int x$11 = TestUtils$.MODULE$.createProducer$default$7();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        String x$13 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$2, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, Consumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Meter) {
            return BoxesRunTime.boxToDouble((double)((Meter)var4_4).count());
        }
        if (var4_4 instanceof Histogram) {
            return BoxesRunTime.boxToDouble((double)((Histogram)var4_4).max());
        }
        if (var4_4 instanceof Gauge) {
            return ((Gauge)var4_4).value();
        }
        return Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_4 instanceof Histogram) {
            return (Histogram)var4_4;
        }
        throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private String fromNameToBrokerTopicStatsMBean(String name) {
        return new StringBuilder(42).append("kafka.server:type=BrokerTopicMetrics,name=").append(name).toString();
    }

    private void verifyRemoteStorageMetrics(boolean shouldContainMetrics) {
        List metrics = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(RemoteStorageMetrics.allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$1(name)))).toList();
        Set aggregatedBrokerTopicStats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        List aggregatedBrokerTopicMetrics = ((TraversableOnce)aggregatedBrokerTopicStats.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$3(this, name)))).toList();
        if (shouldContainMetrics) {
            Assertions.assertEquals((int)RemoteStorageMetrics.allMetrics().size(), (int)metrics.size(), (String)new StringBuilder(27).append("Only ").append(metrics).append(" appear in the metrics").toString());
            Assertions.assertEquals((int)aggregatedBrokerTopicStats.size(), (int)aggregatedBrokerTopicMetrics.size(), (String)new StringBuilder(27).append("Only ").append(aggregatedBrokerTopicMetrics).append(" appear in the metrics").toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)metrics.size(), (String)new StringBuilder(33).append(metrics).append(" should not appear in the metrics").toString());
        Assertions.assertEquals((int)0, (int)aggregatedBrokerTopicMetrics.size(), (String)new StringBuilder(33).append(aggregatedBrokerTopicMetrics).append(" should not appear in the metrics").toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && new StringOps(Predef$.MODULE$.augmentString((String)value)).nonEmpty() ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        Option<String> verifyKafkaMetric_group = $this.verifyKafkaMetric$default$4();
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics$1).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            return !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$2(com.yammer.metrics.core.MetricName name$5, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals(name$5.getMBeanName());
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$1(com.yammer.metrics.core.MetricName name) {
        return ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).find((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$2(name, metric))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$4(MetricsTest $this, String name$6, Tuple2 metric) {
        return ((com.yammer.metrics.core.MetricName)metric._1()).getMBeanName().equals($this.fromNameToBrokerTopicStatsMBean(name$6));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteStorageMetrics$3(MetricsTest $this, String name) {
        return ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).find((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyRemoteStorageMetrics$4($this, name, metric))).isDefined();
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

