/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQ!\u0015\u0001\u0005\u0002ICQa\u0016\u0001\u0005\u0002aCQ!\u001f\u0001\u0005\u0002iDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u001d9\u00111\u000f\n\t\u0002\u0005UdAB\t\u0013\u0011\u0003\t9\b\u0003\u0004\u001d\u001d\u0011\u0005\u0011q\u0010\u0005\b\u0003oqA\u0011AAA\u0005e\u0001F.Y5oi\u0016DH\u000f\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u000b\u0005M!\u0012aA1qS*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001b\u001b\u0005\u0011\u0012BA\u000e\u0013\u0005Q\u0011\u0015m]3Qe>$WoY3s'\u0016tG\rV3ti\u00061A(\u001b8jiz\"\u0012A\b\t\u00033\u0001\t1\u0003^3ti^\u0013xN\\4TKJL\u0017\r\\5{KJ$\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\t\u0001\r!K\u0001\u0007cV|'/^7\u0011\u0005)\ndBA\u00160!\ta3%D\u0001.\u0015\tqc#\u0001\u0004=e>|GOP\u0005\u0003a\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\t\u0015\u0005\u0005U\u001aE\t\u0005\u00027\u00036\tqG\u0003\u00029s\u0005A\u0001O]8wS\u0012,'O\u0003\u0002;w\u00051\u0001/\u0019:b[NT!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\t;$a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002F\u000f\u0006\na)\u0001\u0002{W\u0006\n\u0001*A\u0003le\u00064G\u000f\u000b\u0003\u0003\u0015:{\u0005CA&M\u001b\u0005I\u0014BA':\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001Q\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\u0006\tB/Z:u\u0005\u0006$8\r[*ju\u0016TVM]8\u0015\u0005\u0005\u001a\u0006\"\u0002\u0015\u0004\u0001\u0004I\u0003\u0006B\u00026\u0007Vc#!R$)\t\rQejT\u0001(i\u0016\u001cHOQ1uG\"\u001c\u0016N_3[KJ|gj\u001c)beRLG/[8o\u001d>\u0014VmY8sI.+\u0017\u0010\u0006\u0002\"3\")\u0001\u0006\u0002a\u0001S!\"A!N\"\\Y\t)u\t\u000b\u0003\u0005\u0015:{\u0005\u0006\u0003\u0003_G\u0012,g-\u001d:\u0011\u0005}\u000bW\"\u00011\u000b\u0005MY\u0014B\u00012a\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012aD\u0001\u0005k:LG\u000fJ\u0001h\u0013\tA\u0017.A\u0004T\u000b\u000e{e\nR*\u000b\u0005)\\\u0017\u0001\u0003+j[\u0016,f.\u001b;\u000b\u00051l\u0017AC2p]\u000e,(O]3oi*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\u0002\u0015QD'/Z1e\u001b>$W\rJ\u0001t\u0013\t!X/A\bT\u000bB\u000b%+\u0011+F?RC%+R!E\u0015\t1x/\u0001\u0006UQJ,\u0017\rZ'pI\u0016T!\u0001\u001f1\u0002\u000fQKW.Z8vi\u0006QC/Z:u'\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4f/&$\b\u000eT8h\u0003B\u0004XM\u001c3US6,GCA\u0011|\u0011\u0015AS\u00011\u0001*Q\u0011)QgQ?-\u0005\u0015;\u0005\u0006B\u0003K\u001d>\u000bQ\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ2{w-\u00119qK:$G+[7f)\r\t\u00131\u0001\u0005\u0006Q\u0019\u0001\r!\u000b\u0015\u0006\rU\u001a\u0015q\u0001\u0017\u0003\u000b\u001eCCA\u0002&O\u001f\u0006\u0019B/Z:u\u0003V$xn\u0011:fCR,Gk\u001c9jGR\u0019\u0011%a\u0004\t\u000b!:\u0001\u0019A\u0015)\u000b\u001d)4)a\u0005-\u0005\u0015;\u0005\u0006B\u0004K\u001d>\u000b!\u0006^3tiN+g\u000eZ,ji\"LeN^1mS\u0012\u0014UMZ8sK\u0006sG-\u00114uKJ$\u0016.\\3ti\u0006l\u0007\u000fF\u0004\"\u00037\ti\"!\t\t\u000b!B\u0001\u0019A\u0015\t\r\u0005}\u0001\u00021\u0001*\u0003YiWm]:bO\u0016$\u0016.\\3Ti\u0006l\u0007oQ8oM&<\u0007bBA\u0012\u0011\u0001\u0007\u0011QE\u0001\u0010e\u0016\u001cwN\u001d3US6,7\u000f^1naB\u0019!%a\n\n\u0007\u0005%2E\u0001\u0003M_:<\u0007F\u0002\u0005\u0002.\r\f\u0019\u0004E\u00027\u0003_I1!!\r8\u00051iU\r\u001e5pIN{WO]2fY\t\t)$\t\u0002\u00028\u0005\u0001\u0013/^8sk6\fe\u000e\u001a+j[\u0016\u001cH/Y7q\u0007>tg-[4Qe>4\u0018\u000eZ3sQ\u0011A!JT(\u0002YQ,7\u000f\u001e,bY&$')\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014H+[7fgR\fW\u000e]:BiRC'/Z:i_2$GcB\u0011\u0002@\u0005\u0005\u00131\t\u0005\u0006Q%\u0001\r!\u000b\u0005\u0007\u0003?I\u0001\u0019A\u0015\t\u000f\u0005\r\u0012\u00021\u0001\u0002&!2\u0011\"!\fd\u0003\u000fb#!!\u000e)\u0005%Q\u0015\u0001\r;fgR4\u0016\r\\5e\u0005\u00164wN]3B]\u0012\fe\r^3s)&lWm\u001d;b[B\u001cx+\u001b;iS:$\u0006N]3tQ>dG\rF\u0004\"\u0003\u001f\n\t&a\u0015\t\u000b!R\u0001\u0019A\u0015\t\r\u0005}!\u00021\u0001*\u0011\u001d\t\u0019C\u0003a\u0001\u0003KAcACA\u0017G\u0006]CFAA\u001bQ\tQ!*A\fuKN$hj\u001c8CY>\u001c7.\u001b8h!J|G-^2feR\u0019\u0011%a\u0018\t\u000b!Z\u0001\u0019A\u0015)\u000b-)4)a\u0019-\u0005\u0015;\u0005\u0006B\u0006K\u001d>\u000ba\u0006^3tiN+g\u000e\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5NCb\u0014V-];fgR\u001c\u0016N_3B]\u0012D\u0015n\u001a5feR\u0019\u0011%a\u001b\t\u000b!b\u0001\u0019A\u0015)\u000b1)4)a\u001c-\u0005\u0015;\u0005\u0006\u0002\u0007K\u001d>\u000b\u0011\u0004\u00157bS:$X\r\u001f;Qe>$WoY3s'\u0016tG\rV3tiB\u0011\u0011DD\n\u0004\u001d\u0005e\u0004c\u0001\u0012\u0002|%\u0019\u0011QP\u0012\u0003\r\u0005s\u0017PU3g)\t\t)(\u0006\u0002\u0002\u0004B1\u0011QQAF\u0003\u001fk!!a\"\u000b\u0007\u0005%U.\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003\u001b\u000b9I\u0001\u0004TiJ,\u0017-\u001c\t\u0004m\u0005E\u0015bAAJo\tI\u0011I]4v[\u0016tGo\u001d")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> quorumAndTimestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.quorumAndTimestampConfigProvider();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongSerializer(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZero(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String quorum) {
        int x$1 = 0;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$1, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7(), TestUtils$.MODULE$.createTopicWithAdmin$default$8());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithLogAppendTime(String quorum) {
        String x$1 = "gzip";
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithLogAppendTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopic(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest
    @MethodSource(value={"quorumAndTimestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String quorum, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = 1;
        int x$6 = 2;
        Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        String x$9 = "gzip";
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, x$9, x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNonBlockingProducer(String quorum) {
        long x$1 = 0L;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, x$1, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        long x$7 = 0L;
        int x$8 = 15000;
        int x$9 = 1100;
        long x$10 = 1500L;
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(x$8, x$11, x$9, x$12, x$7, x$10);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String quorum) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

