/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0013q\u0004BB%\u0001A\u0003%q\bC\u0004K\u0001\t\u0007I\u0011\u0002 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u001da\u0005A1A\u0005\u0002yBa!\u0014\u0001!\u0002\u0013y\u0004b\u0002(\u0001\u0005\u0004%\ta\u0014\u0005\u00071\u0002\u0001\u000b\u0011\u0002)\t\u000be\u0003A\u0011\u0001.\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0011)\t9\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\u000b\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013A\u0007bCA\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bA!\"!\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011)\t\u0019\u0002\u0001a\u0001\u0002\u0004%I\u0001\u001b\u0005\f\u0003+\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0002\u0003\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\n%D!\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0015\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011\u000eC\u0005\u0002(\u0001\u0011\r\u0011\"\u0003\u0002*!A\u0011q\u0007\u0001!\u0002\u0013\tY\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002*!A\u00111\b\u0001!\u0002\u0013\tY\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002b\u0002!\t!a9\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u0003\u0001\u0011\u0005!q\u0001\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\t1t&A\u0006j]R,wM]1uS>t\u0017B\u0001\u001d6\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001<!\ta\u0004!D\u0001.\u0003I\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u00131!\u00138u\u0003M\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3!\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\fac]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001\u001ee\u0016\u0004H.[2b\r\u0016$8\r['bqB\u000b'\u000f^5uS>t')\u001f;fg\u0006q\"/\u001a9mS\u000e\fg)\u001a;dQ6\u000b\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fI\u0001\u001de\u0016\u0004H.[2b\r\u0016$8\r['bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3t\u0003u\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D(+Z:q_:\u001cXMQ=uKN\u0004\u0013A\u00038v[N+'O^3sg\u0006Ya.^7TKJ4XM]:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\nQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003m\u00032\u0001X0b\u001b\u0005i&B\u00010B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Av\u00131aU3r!\t\u0011W-D\u0001d\u0015\t!w&\u0001\u0004tKJ4XM]\u0005\u0003M\u000e\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006I\u0001O]8ek\u000e,'/M\u000b\u0002SB!!\u000e\u001e<w\u001b\u0005Y'B\u00017n\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u00018p\u0003\u001d\u0019G.[3oiNT!\u0001\r9\u000b\u0005E\u0014\u0018AB1qC\u000eDWMC\u0001t\u0003\ry'oZ\u0005\u0003k.\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bc\u0001!xs&\u0011\u00010\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0001jL!a_!\u0003\t\tKH/Z\u0001\u000eaJ|G-^2feFzF%Z9\u0015\u0007y\f\u0019\u0001\u0005\u0002A\u007f&\u0019\u0011\u0011A!\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000b\u0001\u0012\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002\u0015A\u0014x\u000eZ;dKJ\f\u0004%A\u0005qe>$WoY3se\u0005i\u0001O]8ek\u000e,'OM0%KF$2A`A\b\u0011!\t)aEA\u0001\u0002\u0004I\u0017A\u00039s_\u0012,8-\u001a:3A\u0005I\u0001O]8ek\u000e,'oM\u0001\u000eaJ|G-^2feNzF%Z9\u0015\u0007y\fI\u0002\u0003\u0005\u0002\u0006Y\t\t\u00111\u0001j\u0003)\u0001(o\u001c3vG\u0016\u00148\u0007I\u0001\naJ|G-^2feR\nQ\u0002\u001d:pIV\u001cWM\u001d\u001b`I\u0015\fHc\u0001@\u0002$!A\u0011QA\r\u0002\u0002\u0003\u0007\u0011.\u0001\u0006qe>$WoY3si\u0001\na\u0001^8qS\u000e\fTCAA\u0016!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019)\u0006!A.\u00198h\u0013\u0011\t)$a\f\u0003\rM#(/\u001b8h\u0003\u001d!x\u000e]5dc\u0001\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004}\u0006\u0005\u0003bBA\"?\u0001\u0007\u0011QI\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qIA*\u001b\t\tIEC\u0002/\u0003\u0017RA!!\u0014\u0002P\u00059!.\u001e9ji\u0016\u0014(bAA)e\u0006)!.\u001e8ji&!\u0011QKA%\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0010\u0002ZA!\u0011qIA.\u0013\u0011\ti&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005q\bf\u0001\u0011\u0002fA!\u0011qIA4\u0013\u0011\tI'!\u0013\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.TVM]8\u0015\u0007y\fy\u0007C\u0004\u0002r\u0005\u0002\r!a\u001d\u0002\rE,xN];n!\u0011\t)(a!\u000f\t\u0005]\u0014q\u0010\t\u0004\u0003s\nUBAA>\u0015\r\ti(M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005\u0015)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t)IC\u0002\u0002\u0002\u0006Cs!IAE\u00033\u000bY\n\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u0011A\u0014xN^5eKJTA!a%\u0002L\u00051\u0001/\u0019:b[NLA!a&\u0002\u000e\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!(\u0002\"\u0006\u0012\u0011qT\u0001\u0003u.\f#!a)\u0002\u000b-\u0014\u0018M\u001a;)\u000f\u0005\n9+a,\u00022B!\u0011\u0011VAV\u001b\t\t\t*\u0003\u0003\u0002.\u0006E%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\u0019,\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/`\u0001\u001di\u0016\u001cH\u000fV8p\u0019\u0006\u0014x-\u001a*fG>\u0014HmV5uQ\u0006\u001b7n\u00148f)\rq\u0018\u0011\u0018\u0005\b\u0003c\u0012\u0003\u0019AA:Q\u001d\u0011\u0013\u0011RAM\u0003{cC!!(\u0002\"\":!%a*\u00020\u0006E\u0016aK2iK\u000e\\Gk\\8MCJ<WMU3d_J$gi\u001c:SKBd\u0017nY1uS>tw+\u001b;i\u0003\u000e\\\u0017\t\u001c7\u0015\u0007y\f)\r\u0003\u0004\u0002H\u000e\u0002\raP\u0001\r[\u0006Dh)\u001a;dQNK'0Z\u0001.i\u0016\u001cH\u000fU1si&$\u0018n\u001c8U_>d\u0015M]4f\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGc\u0001@\u0002N\"9\u0011\u0011\u000f\u0013A\u0002\u0005M\u0004f\u0002\u0013\u0002\n\u0006e\u0015\u0011\u001b\u0017\u0005\u0003;\u000b\t\u000bK\u0004%\u0003O\u000by+!-\u0002YQ,7\u000f\u001e*fgB|gn]3U_>d\u0015M]4f\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGc\u0001@\u0002Z\"9\u0011\u0011O\u0013A\u0002\u0005M\u0004fB\u0013\u0002\n\u0006e\u0015Q\u001c\u0017\u0005\u0003;\u000b\t\u000bK\u0004&\u0003O\u000by+!-\u0002)Q,7\u000f\u001e(p]\u0016C\u0018n\u001d;f]R$v\u000e]5d)\rq\u0018Q\u001d\u0005\b\u0003c2\u0003\u0019AA:Q\u001d1\u0013\u0011RAM\u0003SdC!!(\u0002\"\":a%a*\u00020\u0006E\u0016a\u0005;fgR<&o\u001c8h\u0005J|7.\u001a:MSN$Hc\u0001@\u0002r\"9\u0011\u0011O\u0014A\u0002\u0005M\u0004fB\u0014\u0002\n\u0006e\u0015Q\u001f\u0017\u0005\u0003;\u000b\t\u000bK\u0004(\u0003O\u000by+!-\u0002)Q,7\u000f^%om\u0006d\u0017\u000e\u001a)beRLG/[8o)\rq\u0018Q \u0005\b\u0003cB\u0003\u0019AA:Q\u001dA\u0013\u0011RAM\u0005\u0003aC!!(\u0002\"\":\u0001&a*\u00020\u0006E\u0016a\u0005;fgR\u001cVM\u001c3BMR,'o\u00117pg\u0016$Gc\u0001@\u0003\n!9\u0011\u0011O\u0015A\u0002\u0005M\u0004fB\u0015\u0002\n\u0006e%Q\u0002\u0017\u0005\u0003;\u000b\t\u000bK\u0004*\u0003O\u000by+!-\u0002;Q,7\u000f^\"b]:|GoU3oIR{\u0017J\u001c;fe:\fG\u000eV8qS\u000e$2A B\u000b\u0011\u001d\t\tH\u000ba\u0001\u0003gBsAKAE\u00033\u0013I\u0002\f\u0003\u0002\u001e\u0006\u0005\u0006f\u0002\u0016\u0002(\u0006=\u0016\u0011W\u0001)i\u0016\u001cHOT8u\u000b:|Wo\u001a5SKBd\u0017nY1t\u0003\u001a$XM\u001d\"s_.,'o\u00155vi\u0012|wO\u001c\u000b\u0004}\n\u0005\u0002bBA9W\u0001\u0007\u00111\u000f\u0015\bW\u0005%\u0015\u0011\u0014B\u0013Y\u0011\ti*!))\u000f-\n9+a,\u00022\u0002")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnectOrNull(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17(), TestUtils$.MODULE$.createBrokerConfigs$default$18()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$2 = 0;
        int x$3 = 0;
        int x$4 = 30000;
        long x$5 = 10000L;
        long x$6 = this.producerBufferSize();
        int x$7 = TestUtils$.MODULE$.createProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createProducer$default$7();
        int x$9 = TestUtils$.MODULE$.createProducer$default$8();
        String x$10 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$11 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$12 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer1_$eq(TestUtils$.MODULE$.createProducer(x$1, x$2, x$5, x$6, x$3, x$7, x$8, x$9, x$10, x$4, x$11, x$12, x$13, x$14, x$15, x$16));
        String x$17 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$18 = 1;
        int x$19 = 0;
        int x$20 = 30000;
        long x$21 = 10000L;
        long x$22 = this.producerBufferSize();
        int x$23 = TestUtils$.MODULE$.createProducer$default$6();
        int x$24 = TestUtils$.MODULE$.createProducer$default$7();
        int x$25 = TestUtils$.MODULE$.createProducer$default$8();
        String x$26 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$27 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$28 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$29 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$30 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$32 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer2_$eq(TestUtils$.MODULE$.createProducer(x$17, x$18, x$21, x$22, x$19, x$23, x$24, x$25, x$26, x$20, x$27, x$28, x$29, x$30, x$31, x$32));
        String x$33 = this.bootstrapServers(this.bootstrapServers$default$1());
        int x$34 = -1;
        int x$35 = 0;
        int x$36 = 30000;
        long x$37 = 10000L;
        long x$38 = this.producerBufferSize();
        int x$39 = TestUtils$.MODULE$.createProducer$default$6();
        int x$40 = TestUtils$.MODULE$.createProducer$default$7();
        int x$41 = TestUtils$.MODULE$.createProducer$default$8();
        String x$42 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$43 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$44 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$45 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$46 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$47 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$48 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer3_$eq(TestUtils$.MODULE$.createProducer(x$33, x$34, x$37, x$38, x$35, x$39, x$40, x$41, x$42, x$36, x$43, x$44, x$45, x$46, x$47, x$48));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTooLargeRecordWithAckZero(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assertions.assertNotNull((Object)recordMetadata);
        Assertions.assertFalse((boolean)recordMetadata.hasOffset());
        Assertions.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTooLargeRecordWithAckOne(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(record).get());
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", Integer.toString(this.numServers()));
        topicConfig.setProperty("max.message.bytes", Integer.toString(maxMessageSize));
        String topic10 = "topic10";
        this.createTopic(topic10, this.brokers().size(), this.numServers(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assertions.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPartitionTooLargeForReplicationWithAckAll(String quorum) {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testResponseTooLargeForReplicationWithAckAll(String quorum) {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNonExistentTopic(String quorum) {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(record).get());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongBrokerList(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        this.producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer4().send(record).get());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidPartition(String quorum) {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(higherRecord).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendAfterClosed(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        this.producer1().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer1().send(record));
        this.producer2().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer2().send(record));
        this.producer3().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer3().send(record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCannotSendToInternalTopic(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get());
        Assertions.assertTrue((boolean)(thrown.getCause() instanceof InvalidTopicException), (String)new StringBuilder(55).append("Unexpected exception while sending to an invalid topic ").append(thrown.getCause()).toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNotEnoughReplicasAfterBrokerShutdown(String quorum) {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", Integer.toString(this.numServers()));
        int x$2 = this.numServers();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topicName, x$4, x$2, topicProps, x$5, x$6);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer3().send(record).get();
        ((KafkaBroker)this.brokers().head()).shutdown();
        ((KafkaBroker)this.brokers().head()).awaitShutdown();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer3().send(record).get());
        Assertions.assertTrue((e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException ? 1 : 0) != 0);
        ((KafkaBroker)this.brokers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), Integer.toString(this.replicaFetchMaxPartitionBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), Integer.toString(this.replicaFetchMaxResponseBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

