/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEe\u0001\u0002 @\u0001\u0011CQ!\u0013\u0001\u0005\u0002)CQ\u0001\u0014\u0001\u0005B5Cq\u0001\u0016\u0001C\u0002\u0013\u0005Q\n\u0003\u0004V\u0001\u0001\u0006IA\u0014\u0005\b-\u0002\u0011\r\u0011\"\u0001N\u0011\u00199\u0006\u0001)A\u0005\u001d\"9\u0001\f\u0001b\u0001\n\u0003i\u0005BB-\u0001A\u0003%a\nC\u0004[\u0001\t\u0007I\u0011A.\t\r\u0011\u0004\u0001\u0015!\u0003]\u0011\u001d)\u0007A1A\u0005\u0002mCaA\u001a\u0001!\u0002\u0013a\u0006bB4\u0001\u0005\u0004%\t!\u0014\u0005\u0007Q\u0002\u0001\u000b\u0011\u0002(\t\u000f%\u0004!\u0019!C\u0001U\"9\u0011Q\u0002\u0001!\u0002\u0013Y\u0007\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\t\t\u0003\u0001Q\u0001\n\u0005M\u0001\"CA\u0012\u0001\t\u0007I\u0011AA\t\u0011!\t)\u0003\u0001Q\u0001\n\u0005M\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003o\u0001A\u0011KA\u001d\u0011\u001d\ti\u0005\u0001C)\u0003\u001fBq!!\u0015\u0001\t\u0003\tI\u0003C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005bBAh\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t5\u0001\u0001\"\u0001\u0003\u0010!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!\u0011\u0010\u0001\u0005\u0002\tm\u0004b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!+\u0001\t\u0003\u0011Y\u000bC\u0004\u00036\u0002!\tAa.\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003D\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Br\u0001\u0011%!Q\u001d\u0005\n\u0005c\u0004\u0011\u0013!C\u0005\u0005gD\u0011b!\u0003\u0001#\u0003%Iaa\u0003\t\u0013\r=\u0001!%A\u0005\n\rE\u0001bBB\u000b\u0001\u0011%1q\u0003\u0005\b\u00077\u0001A\u0011BB\u000f\u0011%\u0019I\u0004AI\u0001\n\u0013\u0019Y\u0004C\u0005\u0004@\u0001\t\n\u0011\"\u0003\u0004<!I1\u0011\t\u0001\u0012\u0002\u0013%11\u0002\u0005\n\u0007\u0007\u0002\u0011\u0013!C\u0005\u0007\u0017Aqa!\u0012\u0001\t\u0003\u00199\u0005C\u0004\u0004\\\u0001!\ta!\u0018\t\u000f\r%\u0004\u0001\"\u0001\u0004l\t\u0001BK]1og\u0006\u001cG/[8ogR+7\u000f\u001e\u0006\u0003\u0001\u0006\u000b1!\u00199j\u0015\u0005\u0011\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0003\"AR$\u000e\u0003}J!\u0001S \u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A&\u0011\u0005\u0019\u0003\u0011a\u00032s_.,'oQ8v]R,\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0004\u0013:$\u0018A\u0007;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]\"pk:$\u0018a\u0007;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]\"pk:$\b%\u0001\u000eue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG/A\u000eue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG\u000fI\u0001\u001e]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0006qbn\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG\u000fI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\t1\fgn\u001a\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gL\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003\u0019!x\u000e]5de\u00059Ao\u001c9jGJ\u0002\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN,\u0012a\u001b\t\u0004YF\u001cX\"A7\u000b\u00059|\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003aB\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011XN\u0001\u0004Ck\u001a4WM\u001d\t\u0007iz\f\t!!\u0001\u000e\u0003UT!A^<\u0002\u0011A\u0014x\u000eZ;dKJT!\u0001_=\u0002\u000f\rd\u0017.\u001a8ug*\u0011!I\u001f\u0006\u0003wr\fa!\u00199bG\",'\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000k\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RaTA\u0002\u0003\u000fI1!!\u0002Q\u0005\u0015\t%O]1z!\ry\u0015\u0011B\u0005\u0004\u0003\u0017\u0001&\u0001\u0002\"zi\u0016\fq\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN,\"!a\u0005\u0011\t1\f\u0018Q\u0003\t\t\u0003/\ti\"!\u0001\u0002\u00025\u0011\u0011\u0011\u0004\u0006\u0004\u000379\u0018\u0001C2p]N,X.\u001a:\n\t\u0005}\u0011\u0011\u0004\u0002\t\u0007>t7/^7fe\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u001a]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148/\u0001\u000eo_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t)\t\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004Y\u0001\u0005kRLG.\u0003\u0003\u00026\u0005=\"A\u0003)s_B,'\u000f^5fg\u0006iQn\u001c3jMf\u001cuN\u001c4jON$B!a\u000f\u0002BA\u0019q*!\u0010\n\u0007\u0005}\u0002K\u0001\u0003V]&$\bbBA\"-\u0001\u0007\u0011QI\u0001\u0006aJ|\u0007o\u001d\t\u0007\u0003\u000f\nI%a\u000b\u000e\u0003=L1!a\u0013p\u0005\r\u0019V-]\u0001\u0017WJ\fg\r^\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hgR\u0011\u0011QI\u0001\fi>\u0004\u0018nY\"p]\u001aLw-A\u0003tKR,\u0006\u000f\u0006\u0003\u0002<\u0005]\u0003bBA-3\u0001\u0007\u00111L\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QLA5\u001b\t\tyFC\u0002A\u0003CRA!a\u0019\u0002f\u00059!.\u001e9ji\u0016\u0014(bAA4y\u0006)!.\u001e8ji&!\u00111NA0\u0005!!Vm\u001d;J]\u001a|\u0007fA\r\u0002pA!\u0011QLA9\u0013\u0011\t\u0019(a\u0018\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tY\u0004K\u0002\u001b\u0003w\u0002B!!\u0018\u0002~%!\u0011qPA0\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u000buKN$()Y:jGR\u0013\u0018M\\:bGRLwN\\:\u0015\t\u0005m\u0012Q\u0011\u0005\b\u0003\u000f[\u0002\u0019AAE\u0003\u0019\tXo\u001c:v[B!\u00111RAM\u001d\u0011\ti)!&\u0011\u0007\u0005=\u0005+\u0004\u0002\u0002\u0012*\u0019\u00111S\"\u0002\rq\u0012xn\u001c;?\u0013\r\t9\nU\u0001\u0007!J,G-\u001a4\n\u0007\r\fYJC\u0002\u0002\u0018BCsaGAP\u0003_\u000b\t\f\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\u0011A\u0014xN^5eKJTA!!+\u0002b\u00051\u0001/\u0019:b[NLA!!,\u0002$\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdc!a-\u00028\u0006m\u0016EAA[\u0003\tQ8.\t\u0002\u0002:\u0006)1N]1gi\u0006\u0012\u0011QX\u0001\rWJ\fg\r^\u0016lSBDD\u0007\u000f\u0015\b7\u0005\u0005\u0017\u0011ZAf!\u0011\t\u0019-!2\u000e\u0005\u0005\u001d\u0016\u0002BAd\u0003O\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u00055\u0017AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX0\u0001\u001auKN$(+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u00148\u000b[8vY\u0012tu\u000e^*fKVsG-Z2jI\u0016$G)\u0019;b)\u0011\tY$a5\t\u000f\u0005\u001dE\u00041\u0001\u0002\n\":A$a(\u00020\u0006]GFBAZ\u0003o\u000bY\fK\u0004\u001d\u0003\u0003\fI-a3\u0002UQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017J\\2mk\u0012,7/\u00112peR,G\r\u0016:b]N\f7\r^5p]R!\u00111HAp\u0011\u001d\t9)\ba\u0001\u0003\u0013Cs!HAP\u0003_\u000b\u0019\u000f\f\u0004\u00024\u0006]\u00161\u0018\u0015\b;\u0005\u0005\u0017\u0011ZAf\u0003i!Xm\u001d;TK:$wJ\u001a4tKR\u001cx+\u001b;i\u000fJ|W\u000f]%e)\u0011\tY$a;\t\u000f\u0005\u001de\u00041\u0001\u0002\n\":a$a(\u00020\u0006=HFBAZ\u0003o\u000bY\fK\u0004\u001f\u0003\u0003\fI-a3\u0002AQ,7\u000f^*f]\u0012|eMZ:fiN<\u0016\u000e\u001e5He>,\b/T3uC\u0012\fG/\u0019\u000b\u0005\u0003w\t9\u0010C\u0004\u0002\b~\u0001\r!!#)\u000f}\ty*a,\u0002|22\u00111WA\\\u0003wCsaHAa\u0003\u0013\fY-\u0001\u0006tK:$wJ\u001a4tKR$B!a\u000f\u0003\u0004!9!Q\u0001\u0011A\u0002\t\u001d\u0011AB2p[6LG\u000f\u0005\u0006P\u0005\u0013\u0019\u0018\u0011RA\u000b\u0003wI1Aa\u0003Q\u0005%1UO\\2uS>t7'A\nuKN$h)\u001a8dS:<wJ\\\"p[6LG\u000f\u0006\u0003\u0002<\tE\u0001bBADC\u0001\u0007\u0011\u0011\u0012\u0015\bC\u0005}\u0015q\u0016B\u000bY\u0019\t\u0019,a.\u0002<\":\u0011%!1\u0002J\u0006-\u0017\u0001\u0007;fgR4UM\\2j]\u001e|enU3oI>3gm]3ugR!\u00111\bB\u000f\u0011\u001d\t9I\ta\u0001\u0003\u0013CsAIAP\u0003_\u0013\t\u0003\f\u0004\u00024\u0006]\u00161\u0018\u0015\bE\u0005\u0005\u0017\u0011ZAf\u00031\"Xm\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1J]N+g\u000eZ(gMN,Go\u001d+p)J\fgn]1di&|g\u000e\u0006\u0003\u0002<\t%\u0002bBADG\u0001\u0007\u0011\u0011\u0012\u0015\bG\u0005}\u0015q\u0016B\u0017Y\u0019\t\u0019,a.\u0002<\":1%!1\u0002J\u0006-\u0017a\u0007;fgRLe.\u001b;Ue\u0006t7/Y2uS>t7\u000fV5nK>,H\u000f\u0006\u0003\u0002<\tU\u0002bBADI\u0001\u0007\u0011\u0011\u0012\u0015\bI\u0005}\u0015q\u0016B\u001dY\u0019\t\u0019,a.\u0002<\":A%!1\u0002J\u0006-\u0017a\t;fgR\u001cVM\u001c3PM\u001a\u001cX\r^:U_R\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u000b\u0005\u0003w\u0011\t\u0005C\u0004\u0002\b\u0016\u0002\r!!#)\u000f\u0015\ny*a,\u0003F12\u00111WA\\\u0003wCs!JAa\u0003\u0013\fY-\u0001\u000fuKN$8i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;\u0015\t\u0005m\"Q\n\u0005\b\u0003\u000f3\u0003\u0019AAEQ\u001d1\u0013qTAX\u0005#bc!a-\u00028\u0006m\u0006f\u0002\u0014\u0002B\u0006%\u00171Z\u0001\u001ci\u0016\u001cH/\u00112peR$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;\u0015\t\u0005m\"\u0011\f\u0005\b\u0003\u000f;\u0003\u0019AAEQ\u001d9\u0013qTAX\u0005;bc!a-\u00028\u0006m\u0006fB\u0014\u0002B\u0006%\u00171Z\u0001\fi\u0016\u001cH\u000fV5nK>,H\u000f\u0006\u0004\u0002<\t\u0015$q\u000e\u0005\b\u0005OB\u0003\u0019\u0001B5\u0003IqW-\u001a3J]&$\u0018I\u001c3TK:$Wj]4\u0011\u0007=\u0013Y'C\u0002\u0003nA\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003r!\u0002\rAa\u001d\u0002\u001dQLW.Z8viB\u0013xnY3tgB1qJ!\u001et\u0003wI1Aa\u001eQ\u0005%1UO\\2uS>t\u0017'A\tuKN$h)\u001a8dS:<wJ\\*f]\u0012$B!a\u000f\u0003~!9\u0011qQ\u0015A\u0002\u0005%\u0005fB\u0015\u0002 \u0006=&\u0011\u0011\u0017\u0007\u0003g\u000b9,a/)\u000f%\n\t-!3\u0002L\u0006QB/Z:u\r\u0016t7-\u001b8h\u001f:\fE\r\u001a)beRLG/[8ogR!\u00111\bBE\u0011\u001d\t9I\u000ba\u0001\u0003\u0013CsAKAP\u0003_\u0013i\t\f\u0004\u00024\u0006]\u00161\u0018\u0015\bU\u0005\u0005\u0017\u0011ZAf\u0003\t\"Xm\u001d;GK:\u001c\u0017N\\4P]R\u0013\u0018M\\:bGRLwN\\#ya&\u0014\u0018\r^5p]R!\u00111\bBK\u0011\u001d\t9i\u000ba\u0001\u0003\u0013CsaKAP\u0003_\u0013I\n\f\u0004\u00024\u0006]\u00161\u0018\u0015\bW\u0005\u0005\u0017\u0011ZAf\u0003q!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u001b\u0006\u00148.\u001a:t\u001f:,G*Z1eKJ$B!a\u000f\u0003\"\"9\u0011q\u0011\u0017A\u0002\u0005%\u0005f\u0002\u0017\u0002 \u0006=&Q\u0015\u0017\u0007\u0003g\u000b9,a/)\u000f1\n\t-!3\u0002L\u0006!C/Z:u\u0007>t7/Z2vi&4X\r\\=Sk:Le.\u001b;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u0002<\t5\u0006bBAD[\u0001\u0007\u0011\u0011\u0012\u0015\b[\u0005}\u0015q\u0016BYY\u0019\t\u0019,a.\u0002<\":Q&!1\u0002J\u0006-\u0017A\u0007;fgR\u0014U/\u001c9Ue\u0006t7/Y2uS>t\u0017\r\\#q_\u000eDG\u0003BA\u001e\u0005sCq!a\"/\u0001\u0004\tI\tK\u0004/\u0003?\u000byK!0-\r\u0005M\u0016qWA^Q\u001dq\u0013\u0011YAe\u0003\u0017\fq\u0003^3ti\u001a\u000b\u0017\u000e\\;sKR{g)\u001a8dK\u0016\u0003xn\u00195\u0015\t\u0005m\"Q\u0019\u0005\b\u0003\u000f{\u0003\u0019AAEQ\u001dy\u0013qTAX\u0005\u0013dc!a-\u00028\u0006m\u0006fB\u0018\u0002B\u0006%\u00171Z\u0001(g\u0016tG\r\u0016:b]N\f7\r^5p]\u0006dW*Z:tC\u001e,7oV5uQZ\u000bG.^3SC:<W\r\u0006\u0007\u0002<\tE'1\u001bBl\u00057\u0014y\u000eC\u0003wa\u0001\u00071\u000fC\u0004\u0003VB\u0002\r!!#\u0002\u000bQ|\u0007/[2\t\r\te\u0007\u00071\u0001O\u0003\u0015\u0019H/\u0019:u\u0011\u0019\u0011i\u000e\ra\u0001\u001d\u0006\u0019QM\u001c3\t\u000f\t\u0005\b\u00071\u0001\u0003j\u0005yq/\u001b7m\u0005\u0016\u001cu.\\7jiR,G-A\u000ede\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u000b\t\u0003+\u00119Oa;\u0003p\"I!\u0011^\u0019\u0011\u0002\u0003\u0007\u0011\u0011R\u0001\u0006OJ|W\u000f\u001d\u0005\t\u0005[\f\u0004\u0013!a\u0001\u001d\u0006qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\b\"CA\"cA\u0005\t\u0019AA\u0016\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003v*\"\u0011\u0011\u0012B|W\t\u0011I\u0010\u0005\u0003\u0003|\u000e\u0015QB\u0001B\u007f\u0015\u0011\u0011yp!\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0002!\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001d!Q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!J2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iAK\u0002O\u0005o\fQe\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rM!\u0006BA\u0016\u0005o\fQd\u0019:fCR,'+Z1e+:\u001cw.\\7jiR,GmQ8ogVlWM\u001d\u000b\u0005\u0003+\u0019I\u0002C\u0004\u0003jV\u0002\r!!#\u00027\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3s)-\u00198qDB\u0012\u0007[\u0019\td!\u000e\t\u000f\r\u0005b\u00071\u0001\u0002\n\u0006yAO]1og\u0006\u001cG/[8oC2LE\rC\u0005\u0004&Y\u0002\n\u00111\u0001\u0004(\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u00042aTB\u0015\u0013\r\u0019Y\u0003\u0015\u0002\u0005\u0019>tw\rC\u0005\u00040Y\u0002\n\u00111\u0001\u0004(\u0005QQ.\u0019=CY>\u001c7.T:\t\u0011\rMb\u0007%AA\u00029\u000b\u0011\u0003Z3mSZ,'/\u001f+j[\u0016|W\u000f^'t\u0011!\u00199D\u000eI\u0001\u0002\u0004q\u0015\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003\u0015\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004>)\"1q\u0005B|\u0003\u0015\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2fe\u0012\"WMZ1vYR$3'A\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H%N\u0001$[\u0006L(-Z,bSR4uN]!u\u0019\u0016\f7\u000f^(oKN+w-\\3oiV\u0003Hn\\1e)\u0011\tYd!\u0013\t\u000f\r-3\b1\u0001\u0004N\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0002H\u0005%3q\n\t\u0005\u0007#\u001a9&\u0004\u0002\u0004T)\u00191QK=\u0002\r\r|W.\\8o\u0013\u0011\u0019Ifa\u0015\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)b/\u001a:jMfdunZ*uCJ$xJ\u001a4tKR\u001cH\u0003BA\u001e\u0007?Bqa!\u0019=\u0001\u0004\u0019\u0019'A\u000bqCJ$\u0018\u000e^5p]N#\u0018M\u001d;PM\u001a\u001cX\r^:\u0011\u000f\u0005-5QMB(\u001d&!1qMAN\u0005\ri\u0015\r]\u0001 [\u0006L(-\u001a,fe&4\u0017\u0010T8dC2dunZ*uCJ$xJ\u001a4tKR\u001cH\u0003BA\u001e\u0007[Bqa!\u0019>\u0001\u0004\u0019y\u0007\u0005\u0005\u0002\f\u000e\u00154qJB9!\ri61O\u0005\u0004\u0007Wq\u0006&B\u001f\u0004x\r=\u0005#B(\u0004z\ru\u0014bAB>!\n1A\u000f\u001b:poN\u0004Baa \u0004\n:!1\u0011QBC\u001d\u0011\tyia!\n\u0003EK1aa\"Q\u0003\u001d\u0001\u0018mY6bO\u0016LAaa#\u0004\u000e\n!\u0012J\u001c;feJ,\b\u000f^3e\u000bb\u001cW\r\u001d;j_:T1aa\"QG\t\u0019i\b")
public class TransactionsTest
extends IntegrationTestHarness {
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    @Override
    public int brokerCount() {
        return 3;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        props.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        if (this.isNewGroupCoordinatorEnabled()) {
            props.put(KafkaConfig$.MODULE$.TransactionPartitionVerificationEnableProp(), "false");
        }
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    public Properties topicConfig() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        return topicConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable & scala.Serializable)_ -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testBasicTransactions(String quorum) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        TopicPartition tp11 = new TopicPartition(this.topic1(), 1);
        TopicPartition tp22 = new TopicPartition(this.topic2(), 2);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(0L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer.abortTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp11, (List)new .colon.colon((Object)tp22, (List)Nil$.MODULE$)));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "3", "3", true));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.commitTransaction();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(3L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(3L))}))));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testReadCommittedConsumerShouldNotSeeUndecidedData(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        Consumer readCommittedConsumer = (Consumer)this.transactionalConsumers().head();
        Consumer readUncommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testDelayedFetchIncludesAbortedTransaction(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        TopicPartition tp10 = new TopicPartition(this.topic1(), 0);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer1.abortTransaction();
        producer2.commitTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp10, (List)Nil$.MODULE$));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(5L))}))));
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = this.createReadCommittedConsumer$default$1();
        int x$3 = this.createReadCommittedConsumer$default$2();
        Consumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsWithGroupId(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsWithGroupMetadata(String quorum) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.brokers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        ListBuffer partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> sendOffset_partitions.$plus$eq((Object)new TopicPartition(this.topic2(), BoxesRunTime.unboxToInt((Object)partition))));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)partitions.toSeq());
        Consumer verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$5(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString());
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnCommit(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnSendOffsets(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testOffsetMetadataInSendOffsetsToTransaction(String quorum) {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testInitTransactionsTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testSendOffsetsToTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testCommitTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testAbortTransactionTimeout(String quorum) {
        Function1 & Serializable & scala.Serializable testTimeout_timeoutProcess = (Function1 & Serializable & scala.Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        String testTimeout_x$1 = "transactionProducer";
        long testTimeout_x$2 = 3000L;
        long testTimeout_x$3 = this.createTransactionalProducer$default$2();
        int testTimeout_x$4 = this.createTransactionalProducer$default$4();
        int testTimeout_x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer(testTimeout_x$1, testTimeout_x$3, testTimeout_x$2, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        String x$1 = "transactionProducer";
        long x$2 = 3000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> testTimeout_timeoutProcess.apply((Object)testTimeout_producer));
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnSend(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)broker.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnAddPartitions(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)broker.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFencingOnTransactionExpiration(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised a ProducerFencedException since the transaction has expired");
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        Consumer nonTransactionalConsumer = (Consumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        Consumer transactionalConsumer = (Consumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testMultipleMarkersOneLeader(String quorum) {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        this.createTopic(topicWith10Partitions, 10, this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$7 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testConsecutivelyRunInitTransactions(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4(), this.createTransactionalProducer$default$5());
        producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> producer.initTransactions());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testBumpTransactionalEpoch(String quorum) {
        String x$1 = "transactionalProducer";
        int x$2 = 5000;
        int x$3 = 5000;
        long x$4 = this.createTransactionalProducer$default$2();
        long x$5 = this.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$4, x$5, x$2, x$3);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft", "kraft+kip848"})
    public void testFailureToFenceEpoch(String quorum) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        String x$1 = "transactional-producer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        int x$5 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer(x$1, x$3, x$2, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
        Assertions.assertTrue((boolean)activeProducersIter.hasNext());
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        String x$8 = "transactional-producer";
        long x$9 = 5000L;
        long x$10 = this.createTransactionalProducer$default$2();
        int x$11 = this.createTransactionalProducer$default$4();
        int x$12 = this.createTransactionalProducer$default$5();
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer(x$8, x$10, x$9, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable & scala.Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, x$3, x$4, maxPollRecords, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private Consumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$3 = false;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$7 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        int x$8 = TestUtils$.MODULE$.createTransactionalProducer$default$8();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public void maybeWaitForAtLeastOneSegmentUpload(Seq<TopicPartition> topicPartitions) {
    }

    /*
     * WARNING - void declaration
     */
    public void verifyLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionStartOffsets) {
        HashMap offsets = new HashMap();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$verifyLogStartOffsets$1(this, partitionStartOffsets, offsets)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$verifyLogStartOffsets$4(partitionStartOffsets, offsets));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void maybeVerifyLocalLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Long> partitionStartOffsets) throws InterruptedException {
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ int $anonfun$sendOffset$5(ConsumerRecord record) {
        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$7) {
        return Integer.toString(x$7);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$3(KafkaBroker broker$3, HashMap offsets$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            int offset = x0$1._2$mcI$sp();
            long lso = ((UnifiedLog)broker$3.replicaManager().localLog(partition).get()).logStartOffset();
            offsets$1.put(Predef$.MODULE$.int2Integer(broker$3.config().brokerId()), Predef$.MODULE$.long2Long(lso));
            return (long)offset == lso;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$1(TransactionsTest $this, scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)partitionStartOffsets$1.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionsTest.$anonfun$verifyLogStartOffsets$3(broker, offsets$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$verifyLogStartOffsets$4(scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return new StringBuilder(78).append("log start offset doesn't change to the expected position: ").append(partitionStartOffsets$1).append(", current position: ").append(offsets$1).toString();
    }

    public TransactionsTest() {
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$4, Consumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

